# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import Any, List, Optional, Tuple, Union
from typing_extensions import Annotated
from iblai.models.check_document_training_status import CheckDocumentTrainingStatus
from iblai.models.document_from_pool_request import DocumentFromPoolRequest
from iblai.models.document_settings_response import DocumentSettingsResponse
from iblai.models.paginated_retriever_document_embedding_list import PaginatedRetrieverDocumentEmbeddingList
from iblai.models.resource_scrapped_data import ResourceScrappedData
from iblai.models.retreiver_train_view_response import RetreiverTrainViewResponse
from iblai.models.retriever_document_embedding import RetrieverDocumentEmbedding
from iblai.models.retriever_request_search import RetrieverRequestSearch
from iblai.models.retriever_request_search_document import RetrieverRequestSearchDocument
from iblai.models.retriever_response_search import RetrieverResponseSearch
from iblai.models.scan_webhook_request import ScanWebhookRequest
from iblai.models.scan_webhook_response import ScanWebhookResponse
from iblai.models.train_chat_session_document_view import TrainChatSessionDocumentView
from iblai.models.train_document_view_response import TrainDocumentViewResponse

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class AiIndexApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def ai_index_orgs_users_documents_destroy(
        self,
        document_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_destroy

        Delete a specific document embedding.  This endpoint removes a document embedding from the system, including untraining it from any associated pathways.  Args:     request: The HTTP request.     org: Organization key identifier.     document_id: The ID of the document embedding to delete.  Returns:     Response: An empty response with a 204 status code if successful.  Raises:     NotFound: If the specified document embedding does not exist.

        :param document_id: (required)
        :type document_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_destroy_serialize(
            document_id=document_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_destroy_serialize(
        self,
        document_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/{document_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_document_from_pool_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        document_from_pool_request: DocumentFromPoolRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_document_from_pool_create

        Train a document from the document pool  Sample request: ```json {\"document_id\": 3, \"to_pathway\": \"7c43ec09-3d37-489c-a461-8d73df1d91c7\"} ```

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param document_from_pool_request: (required)
        :type document_from_pool_request: DocumentFromPoolRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_document_from_pool_create_serialize(
            org=org,
            user_id=user_id,
            document_from_pool_request=document_from_pool_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TrainDocumentViewResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_document_from_pool_create_serialize(
        self,
        org,
        user_id,
        document_from_pool_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if document_from_pool_request is not None:
            _body_params = document_from_pool_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/document-from-pool/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_pathways_list(
        self,
        org: StrictStr,
        pathway: StrictStr,
        user_id: StrictStr,
        limit: Annotated[Optional[StrictInt], Field(description="limit number")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset number")] = None,
        search: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_pathways_list

        Description: Retrieves a list of document embeddings for a specific pathway with optional search and pagination.  Methods: - GET: Retrieves document embeddings that match the specified search criteria and are paginated according to offset and limit.  Parameters: - search (str): Search query to filter document names or URLs. - offset (int): Offset number for pagination. - limit (int): Limit number for pagination.  Returns: - GET: A paginated list of document embeddings with their details. {     \"count\": 10,     \"next\": \"http://api.example.com/retriever_documents/?offset=10&limit=2\",     \"previous\": \"http://api.example.com/retriever_documents/?offset=0&limit=2\",     \"results\": [     {         \"document_name\": \"Document2\",         \"platform_key\": \"example_platform\",         \"pathway\": \"example_pathway\"     }     ] }  Error Responses: - 400 Bad Request: Invalid query parameters. - 404 Not Found: No document embeddings found for the specified criteria.

        :param org: (required)
        :type org: str
        :param pathway: (required)
        :type pathway: str
        :param user_id: (required)
        :type user_id: str
        :param limit: limit number
        :type limit: int
        :param offset: Offset number
        :type offset: int
        :param search: Search query
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_pathways_list_serialize(
            org=org,
            pathway=pathway,
            user_id=user_id,
            limit=limit,
            offset=offset,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedRetrieverDocumentEmbeddingList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_pathways_list_serialize(
        self,
        org,
        pathway,
        user_id,
        limit,
        offset,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if pathway is not None:
            _path_params['pathway'] = pathway
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/pathways/{pathway}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_retrieve(
        self,
        document_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_retrieve

        Retrieve details of a specific document embedding.  This endpoint returns detailed information about a specific document embedding identified by its ID.  Args:     request: The HTTP request.     org: Organization key identifier.     document_id: The ID of the document embedding to retrieve.  Returns:     Response: Detailed information about the document embedding.  Raises:     NotFound: If the specified document embedding does not exist.

        :param document_id: (required)
        :type document_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_retrieve_serialize(
            document_id=document_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieverDocumentEmbedding",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_retrieve_serialize(
        self,
        document_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/{document_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_search_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        retriever_request_search: RetrieverRequestSearch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_search_create

        Retrieve resource documents similar to the given query.  This endpoint performs a semantic search to find documents that are relevant to the provided query within the specified pathway.  Args:     request: The HTTP request containing the search query.     org: Organization key identifier.  Returns:     Response: A list of documents relevant to the search query.  Raises:     ValidationError: If the request data is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param retriever_request_search: (required)
        :type retriever_request_search: RetrieverRequestSearch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_search_create_serialize(
            org=org,
            user_id=user_id,
            retriever_request_search=retriever_request_search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieverResponseSearch",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_search_create_serialize(
        self,
        org,
        user_id,
        retriever_request_search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if retriever_request_search is not None:
            _body_params = retriever_request_search


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_settings_create(
        self,
        document_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        document_settings_response: Optional[DocumentSettingsResponse] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_settings_create

        Mixin that includes the StudentTokenAuthentication and IsPlatformAdmin

        :param document_id: (required)
        :type document_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param document_settings_response:
        :type document_settings_response: DocumentSettingsResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_settings_create_serialize(
            document_id=document_id,
            org=org,
            user_id=user_id,
            document_settings_response=document_settings_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentSettingsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_settings_create_serialize(
        self,
        document_id,
        org,
        user_id,
        document_settings_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if document_settings_response is not None:
            _body_params = document_settings_response


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/{document_id}/settings/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_settings_retrieve(
        self,
        document_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_settings_retrieve

        Mixin that includes the StudentTokenAuthentication and IsPlatformAdmin

        :param document_id: (required)
        :type document_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_settings_retrieve_serialize(
            document_id=document_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentSettingsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_settings_retrieve_serialize(
        self,
        document_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/{document_id}/settings/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_sources_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        retriever_request_search: RetrieverRequestSearch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_sources_create

        Retrieve document sources related to a given query.  This endpoint performs a semantic search to find document sources that are relevant to the provided query within the specified pathway, and returns them along with confidence levels.  Args:     request: The HTTP request containing the search query.     org: Organization key identifier.  Returns:     Response: A list of document sources with confidence levels.  Raises:     ValidationError: If the request data is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param retriever_request_search: (required)
        :type retriever_request_search: RetrieverRequestSearch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_sources_create_serialize(
            org=org,
            user_id=user_id,
            retriever_request_search=retriever_request_search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RetrieverRequestSearchDocument]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_sources_create_serialize(
        self,
        org,
        user_id,
        retriever_request_search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if retriever_request_search is not None:
            _body_params = retriever_request_search


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/sources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_tasks_retrieve(
        self,
        org: StrictStr,
        task_id: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_tasks_retrieve

        Check the status of a document training task.  This endpoint retrieves the current status of an asynchronous document training task that was previously initiated.  Args:     request: The HTTP request.     org: Organization key identifier.     task_id: The ID of the training task to check.  Returns:     Response: The current status of the document training task,              which can be \"pending\", \"completed\", or \"failed\".

        :param org: (required)
        :type org: str
        :param task_id: (required)
        :type task_id: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_tasks_retrieve_serialize(
            org=org,
            task_id=task_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckDocumentTrainingStatus",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_tasks_retrieve_serialize(
        self,
        org,
        task_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if task_id is not None:
            _path_params['task_id'] = task_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/tasks/{task_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_train_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        type: Annotated[StrictStr, Field(description="Type of document e.g file")],
        pathway: Annotated[Optional[StrictStr], Field(description="Pathway for document to be trained in")] = None,
        url: Annotated[Optional[StrictStr], Field(description="Url of the document to be trained")] = None,
        text: Annotated[Optional[StrictStr], Field(description="Search text for wikipedia")] = None,
        translate: Annotated[Optional[StrictBool], Field(description="If file should be translated")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="File to be trained")] = None,
        access: Annotated[Optional[StrictStr], Field(description="Accessibilityto the file")] = None,
        branch: Annotated[Optional[StrictStr], Field(description="Branch of the repository")] = None,
        google_drive_auth_data: Annotated[Optional[Any], Field(description="Authentication and scoped details of google drive")] = None,
        dropbox_auth_data: Annotated[Optional[Any], Field(description="Authentication and scoped details of dropbox")] = None,
        crawler_max_depth: Annotated[Optional[StrictInt], Field(description="The max depth of the crawler")] = None,
        crawler_max_pages_limit: Annotated[Optional[StrictInt], Field(description="The max pages limit of the crawler")] = None,
        crawler_max_concurrency: Annotated[Optional[StrictInt], Field(description="The max concurrency of the crawler")] = None,
        crawler_match_patterns: Annotated[Optional[List[StrictStr]], Field(description="The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.")] = None,
        crawler_pattern_type: Annotated[Optional[Any], Field(description="Pattern type for the crawler  * `glob` - Glob * `regex` - Regex")] = None,
        custom_metadata: Annotated[Optional[Any], Field(description="Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.")] = None,
        add_to_document_pool: Annotated[Optional[StrictBool], Field(description="Adds document to the pool or not.")] = None,
        document_pool_only: Annotated[Optional[StrictBool], Field(description="Only adds document to document pool. Requires pathway to be empty.")] = None,
        user_image_description: Annotated[Optional[StrictStr], Field(description="Description of an image submitted by the user for RAG.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_train_create

        Train a document through a worker process.  This endpoint queues larger documents for training through a worker process, which is more suitable for handling documents that would take too long to process directly.  Args:     request: The HTTP request containing the document information.     org: Organization key identifier.  Returns:     Response: A confirmation that the document was queued for training,              including a task ID for tracking the progress.  Raises:     ValidationError: If the request data is invalid.     BadRequest: If there was an error processing the document.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param type: Type of document e.g file (required)
        :type type: str
        :param pathway: Pathway for document to be trained in
        :type pathway: str
        :param url: Url of the document to be trained
        :type url: str
        :param text: Search text for wikipedia
        :type text: str
        :param translate: If file should be translated
        :type translate: bool
        :param file: File to be trained
        :type file: bytearray
        :param access: Accessibilityto the file
        :type access: str
        :param branch: Branch of the repository
        :type branch: str
        :param google_drive_auth_data: Authentication and scoped details of google drive
        :type google_drive_auth_data: object
        :param dropbox_auth_data: Authentication and scoped details of dropbox
        :type dropbox_auth_data: object
        :param crawler_max_depth: The max depth of the crawler
        :type crawler_max_depth: int
        :param crawler_max_pages_limit: The max pages limit of the crawler
        :type crawler_max_pages_limit: int
        :param crawler_max_concurrency: The max concurrency of the crawler
        :type crawler_max_concurrency: int
        :param crawler_match_patterns: The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.
        :type crawler_match_patterns: List[str]
        :param crawler_pattern_type: Pattern type for the crawler  * `glob` - Glob * `regex` - Regex
        :type crawler_pattern_type: CrawlerPatternTypeEnum
        :param custom_metadata: Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.
        :type custom_metadata: object
        :param add_to_document_pool: Adds document to the pool or not.
        :type add_to_document_pool: bool
        :param document_pool_only: Only adds document to document pool. Requires pathway to be empty.
        :type document_pool_only: bool
        :param user_image_description: Description of an image submitted by the user for RAG.
        :type user_image_description: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_train_create_serialize(
            org=org,
            user_id=user_id,
            type=type,
            pathway=pathway,
            url=url,
            text=text,
            translate=translate,
            file=file,
            access=access,
            branch=branch,
            google_drive_auth_data=google_drive_auth_data,
            dropbox_auth_data=dropbox_auth_data,
            crawler_max_depth=crawler_max_depth,
            crawler_max_pages_limit=crawler_max_pages_limit,
            crawler_max_concurrency=crawler_max_concurrency,
            crawler_match_patterns=crawler_match_patterns,
            crawler_pattern_type=crawler_pattern_type,
            custom_metadata=custom_metadata,
            add_to_document_pool=add_to_document_pool,
            document_pool_only=document_pool_only,
            user_image_description=user_image_description,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TrainDocumentViewResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_train_create_serialize(
        self,
        org,
        user_id,
        type,
        pathway,
        url,
        text,
        translate,
        file,
        access,
        branch,
        google_drive_auth_data,
        dropbox_auth_data,
        crawler_max_depth,
        crawler_max_pages_limit,
        crawler_max_concurrency,
        crawler_match_patterns,
        crawler_pattern_type,
        custom_metadata,
        add_to_document_pool,
        document_pool_only,
        user_image_description,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'crawler_match_patterns': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if pathway is not None:
            _form_params.append(('pathway', pathway))
        if url is not None:
            _form_params.append(('url', url))
        if text is not None:
            _form_params.append(('text', text))
        if type is not None:
            _form_params.append(('type', type))
        if translate is not None:
            _form_params.append(('translate', translate))
        if file is not None:
            _files['file'] = file
        if access is not None:
            _form_params.append(('access', access))
        if branch is not None:
            _form_params.append(('branch', branch))
        if google_drive_auth_data is not None:
            _form_params.append(('google_drive_auth_data', google_drive_auth_data))
        if dropbox_auth_data is not None:
            _form_params.append(('dropbox_auth_data', dropbox_auth_data))
        if crawler_max_depth is not None:
            _form_params.append(('crawler_max_depth', crawler_max_depth))
        if crawler_max_pages_limit is not None:
            _form_params.append(('crawler_max_pages_limit', crawler_max_pages_limit))
        if crawler_max_concurrency is not None:
            _form_params.append(('crawler_max_concurrency', crawler_max_concurrency))
        if crawler_match_patterns is not None:
            _form_params.append(('crawler_match_patterns', crawler_match_patterns))
        if crawler_pattern_type is not None:
            _form_params.append(('crawler_pattern_type', crawler_pattern_type))
        if custom_metadata is not None:
            _form_params.append(('custom_metadata', custom_metadata))
        if add_to_document_pool is not None:
            _form_params.append(('add_to_document_pool', add_to_document_pool))
        if document_pool_only is not None:
            _form_params.append(('document_pool_only', document_pool_only))
        if user_image_description is not None:
            _form_params.append(('user_image_description', user_image_description))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/train/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_train_retriever_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        pathway: Annotated[StrictStr, Field(description="Pathway for document to be trained in")],
        url: Annotated[StrictStr, Field(description="Url of the document to be trained")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_train_retriever_create

        Train a document directly without using a worker.  This endpoint is designed for training smaller documents directly without queuing them through a worker process. For larger documents, use the TrainDocumentView endpoint instead.  Args:     request: The HTTP request containing the document information.     org: Organization key identifier.  Returns:     Response: A confirmation that the document was trained successfully.  Raises:     ValidationError: If the request data is invalid.     BadRequest: If the document training failed.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param pathway: Pathway for document to be trained in (required)
        :type pathway: str
        :param url: Url of the document to be trained (required)
        :type url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_train_retriever_create_serialize(
            org=org,
            user_id=user_id,
            pathway=pathway,
            url=url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetreiverTrainViewResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_train_retriever_create_serialize(
        self,
        org,
        user_id,
        pathway,
        url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if pathway is not None:
            _form_params.append(('pathway', pathway))
        if url is not None:
            _form_params.append(('url', url))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/train/retriever/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_train_sessions_create(
        self,
        org: StrictStr,
        session_id: StrictStr,
        user_id: StrictStr,
        file: Annotated[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]], Field(description="File to be trained")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_train_sessions_create

        Description: Submit a document file  in a chat session. Checks file type, size, and ensures the session exists, then processes the file. Process  document for use in a specific chat session. which will be processed and made available for the AI to reference when responding to queries in that session.  Methods: - POST: Submits a document or media file for training within a specified chat session.  Parameters: - org (str): - session_id (str): UUID of the chat session for which the document is being submitted. - *args, **kwargs: Additional arguments. - file (file): Multipart file input.  Returns: - POST: Returns a JSON message with the result of the upload process. Response code 200 on success. {     \"message\": \"File processed.\" }  Error Responses: - 400 Bad Request: - \"File field is required\" if the 'file' parameter is missing. - \"invalid file object\" if the file object is not valid. - Specific error message if an exception occurs while saving to Redis. - 404 Not Found: - \"Session not found\" if the provided session_id does not match any existing session. - 413 Request Entity Too Large: - \"file is too large\" including specific limits for document and media files if the file exceeds size limits.  Access Control: Requires authentication with a Bearer token in the Authorization header. The user associated with the session must exist and be authorized for the request.

        :param org: (required)
        :type org: str
        :param session_id: (required)
        :type session_id: str
        :param user_id: (required)
        :type user_id: str
        :param file: File to be trained (required)
        :type file: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_train_sessions_create_serialize(
            org=org,
            session_id=session_id,
            user_id=user_id,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TrainChatSessionDocumentView",
            '400': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_train_sessions_create_serialize(
        self,
        org,
        session_id,
        user_id,
        file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if session_id is not None:
            _path_params['session_id'] = session_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if file is not None:
            _files['file'] = file
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/train/sessions/{session_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_documents_update(
        self,
        document_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        pathway: Annotated[StrictStr, Field(description="The pathway to retrain the document in")],
        document_name: Annotated[Optional[StrictStr], Field(description="The name of the document")] = None,
        document_type: Annotated[Optional[StrictStr], Field(description="The type of the document")] = None,
        url: Annotated[Optional[StrictStr], Field(description="The url of the document")] = None,
        train: Annotated[Optional[StrictBool], Field(description="The type of the document")] = None,
        crawler_max_depth: Annotated[Optional[StrictInt], Field(description="The max depth of the crawler")] = None,
        crawler_max_pages_limit: Annotated[Optional[StrictInt], Field(description="The max pages limit of the crawler")] = None,
        crawler_max_concurrency: Annotated[Optional[StrictInt], Field(description="The max concurrency of the crawler")] = None,
        crawler_match_patterns: Annotated[Optional[List[StrictStr]], Field(description="The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.")] = None,
        crawler_pattern_type: Annotated[Optional[Any], Field(description="Pattern type for the crawler  * `glob` - Glob * `regex` - Regex")] = None,
        access: Annotated[Optional[Any], Field(description="The access of the document.  * `public` - Public * `private` - Private")] = None,
        google_drive_auth_data: Annotated[Optional[Any], Field(description="Authentication and scoped details of google drive.")] = None,
        dropbox_auth_data: Annotated[Optional[Any], Field(description="Authentication and scoped details of dropbox")] = None,
        custom_metadata: Annotated[Optional[Any], Field(description="Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_documents_update

        Update a specific document embedding.  This endpoint allows updating various properties of a document embedding, including its name, type, pathway, and training status.  Args:     request: The HTTP request containing the updated document data.     org: Organization key identifier.     document_id: The ID of the document embedding to update.  Returns:     Response: The updated document embedding information.  Raises:     BadRequest: If the provided data is invalid.     NotFound: If the specified document embedding does not exist.

        :param document_id: (required)
        :type document_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param pathway: The pathway to retrain the document in (required)
        :type pathway: str
        :param document_name: The name of the document
        :type document_name: str
        :param document_type: The type of the document
        :type document_type: str
        :param url: The url of the document
        :type url: str
        :param train: The type of the document
        :type train: bool
        :param crawler_max_depth: The max depth of the crawler
        :type crawler_max_depth: int
        :param crawler_max_pages_limit: The max pages limit of the crawler
        :type crawler_max_pages_limit: int
        :param crawler_max_concurrency: The max concurrency of the crawler
        :type crawler_max_concurrency: int
        :param crawler_match_patterns: The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.
        :type crawler_match_patterns: List[str]
        :param crawler_pattern_type: Pattern type for the crawler  * `glob` - Glob * `regex` - Regex
        :type crawler_pattern_type: CrawlerPatternTypeEnum
        :param access: The access of the document.  * `public` - Public * `private` - Private
        :type access: AccessEnum
        :param google_drive_auth_data: Authentication and scoped details of google drive.
        :type google_drive_auth_data: object
        :param dropbox_auth_data: Authentication and scoped details of dropbox
        :type dropbox_auth_data: object
        :param custom_metadata: Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.
        :type custom_metadata: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_documents_update_serialize(
            document_id=document_id,
            org=org,
            user_id=user_id,
            pathway=pathway,
            document_name=document_name,
            document_type=document_type,
            url=url,
            train=train,
            crawler_max_depth=crawler_max_depth,
            crawler_max_pages_limit=crawler_max_pages_limit,
            crawler_max_concurrency=crawler_max_concurrency,
            crawler_match_patterns=crawler_match_patterns,
            crawler_pattern_type=crawler_pattern_type,
            access=access,
            google_drive_auth_data=google_drive_auth_data,
            dropbox_auth_data=dropbox_auth_data,
            custom_metadata=custom_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RetrieverDocumentEmbedding",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_documents_update_serialize(
        self,
        document_id,
        org,
        user_id,
        pathway,
        document_name,
        document_type,
        url,
        train,
        crawler_max_depth,
        crawler_max_pages_limit,
        crawler_max_concurrency,
        crawler_match_patterns,
        crawler_pattern_type,
        access,
        google_drive_auth_data,
        dropbox_auth_data,
        custom_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'crawler_match_patterns': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if document_id is not None:
            _path_params['document_id'] = document_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if document_name is not None:
            _form_params.append(('document_name', document_name))
        if document_type is not None:
            _form_params.append(('document_type', document_type))
        if pathway is not None:
            _form_params.append(('pathway', pathway))
        if url is not None:
            _form_params.append(('url', url))
        if train is not None:
            _form_params.append(('train', train))
        if crawler_max_depth is not None:
            _form_params.append(('crawler_max_depth', crawler_max_depth))
        if crawler_max_pages_limit is not None:
            _form_params.append(('crawler_max_pages_limit', crawler_max_pages_limit))
        if crawler_max_concurrency is not None:
            _form_params.append(('crawler_max_concurrency', crawler_max_concurrency))
        if crawler_match_patterns is not None:
            _form_params.append(('crawler_match_patterns', crawler_match_patterns))
        if crawler_pattern_type is not None:
            _form_params.append(('crawler_pattern_type', crawler_pattern_type))
        if access is not None:
            _form_params.append(('access', access))
        if google_drive_auth_data is not None:
            _form_params.append(('google_drive_auth_data', google_drive_auth_data))
        if dropbox_auth_data is not None:
            _form_params.append(('dropbox_auth_data', dropbox_auth_data))
        if custom_metadata is not None:
            _form_params.append(('custom_metadata', custom_metadata))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/documents/{document_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_resource_data_scrapped_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        is_archive: Optional[StrictBool] = None,
        is_like: Optional[StrictBool] = None,
        is_video: Optional[StrictBool] = None,
        search_key: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_resource_data_scrapped_list

        Retrieve and filter scraped data from resources.  This endpoint returns a list of scraped data from resources associated with the specified user, with optional filtering based on query parameters.  Args:     request: The HTTP request containing filter query parameters.     org: Organization key identifier.     user_id: The username of the user whose resources to retrieve.  Returns:     Response: A list of scraped resource data matching the filter criteria.  Raises:     BadRequest: If the username is invalid or query parameters are incorrect.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param is_archive:
        :type is_archive: bool
        :param is_like:
        :type is_like: bool
        :param is_video:
        :type is_video: bool
        :param search_key:
        :type search_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_resource_data_scrapped_list_serialize(
            org=org,
            user_id=user_id,
            is_archive=is_archive,
            is_like=is_like,
            is_video=is_video,
            search_key=search_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ResourceScrappedData]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_resource_data_scrapped_list_serialize(
        self,
        org,
        user_id,
        is_archive,
        is_like,
        is_video,
        search_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if is_archive is not None:
            
            _query_params.append(('is_archive', is_archive))
            
        if is_like is not None:
            
            _query_params.append(('is_like', is_like))
            
        if is_video is not None:
            
            _query_params.append(('is_video', is_video))
            
        if search_key is not None:
            
            _query_params.append(('search_key', search_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/resource/data/scrapped/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_orgs_users_resource_data_scrapped_retrieve(
        self,
        org: StrictStr,
        resource_id: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_orgs_users_resource_data_scrapped_retrieve

        Retrieve detailed information about a specific scraped resource.  This endpoint returns the complete scraped data for a specific resource identified by its ID.  Args:     request: The HTTP request.     org: Organization key identifier.     user_id: The username of the user associated with the resource.     resource_id: The ID of the resource to retrieve.  Returns:     Response: The complete scraped data for the specified resource.  Raises:     NotFound: If the specified resource data does not exist.

        :param org: (required)
        :type org: str
        :param resource_id: (required)
        :type resource_id: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_orgs_users_resource_data_scrapped_retrieve_serialize(
            org=org,
            resource_id=resource_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceScrappedData",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_orgs_users_resource_data_scrapped_retrieve_serialize(
        self,
        org,
        resource_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if resource_id is not None:
            _path_params['resource_id'] = resource_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-index/orgs/{org}/users/{user_id}/resource/{resource_id}/data/scrapped/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_index_webhook_scan_create(
        self,
        scan_webhook_request: ScanWebhookRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_index_webhook_scan_create

        Receive and process file scan status from external security scanning services.  This webhook endpoint receives scan results for files that have been submitted for security scanning. It processes the results asynchronously and determines if the files are safe for further processing.  Args:     request: The HTTP request containing scan result data.  Returns:     Response: A confirmation that the scan result was received and is being processed.  Raises:     BadRequest: If the provided scan result data is invalid.

        :param scan_webhook_request: (required)
        :type scan_webhook_request: ScanWebhookRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_index_webhook_scan_create_serialize(
            scan_webhook_request=scan_webhook_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ScanWebhookResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_index_webhook_scan_create_serialize(
        self,
        scan_webhook_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if scan_webhook_request is not None:
            _body_params = scan_webhook_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-index/webhook/scan/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


