# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.ai_generated_image import AIGeneratedImage
from iblai.models.ai_user_profile_memory_relation import AIUserProfileMemoryRelation
from iblai.models.ai_user_profile_request import AIUserProfileRequest
from iblai.models.accessible_mentors_by_email_request import AccessibleMentorsByEmailRequest
from iblai.models.accessible_mentors_by_email_response import AccessibleMentorsByEmailResponse
from iblai.models.add_mentor_to_disclaimer import AddMentorToDisclaimer
from iblai.models.artifact import Artifact
from iblai.models.assumed_knowledge import AssumedKnowledge
from iblai.models.audio_to_text_response import AudioToTextResponse
from iblai.models.auto_memory_prompt import AutoMemoryPrompt
from iblai.models.call_authentication_request import CallAuthenticationRequest
from iblai.models.call_authentication_response import CallAuthenticationResponse
from iblai.models.call_configuration import CallConfiguration
from iblai.models.chat_history_item import ChatHistoryItem
from iblai.models.chat_history_session_id import ChatHistorySessionId
from iblai.models.chat_session_request import ChatSessionRequest
from iblai.models.chat_session_response import ChatSessionResponse
from iblai.models.course_creation_task import CourseCreationTask
from iblai.models.course_creation_task_file import CourseCreationTaskFile
from iblai.models.custom_instruction_response import CustomInstructionResponse
from iblai.models.disclaimer import Disclaimer
from iblai.models.disclaimer_agreement import DisclaimerAgreement
from iblai.models.edx_course import EdxCourse
from iblai.models.elevenlabs_custom_voice_response import ElevenlabsCustomVoiceResponse
from iblai.models.email_prompt_detail import EmailPromptDetail
from iblai.models.email_prompt_summary import EmailPromptSummary
from iblai.models.file_upload_url_request import FileUploadURLRequest
from iblai.models.file_upload_url_response import FileUploadURLResponse
from iblai.models.free_usage_count import FreeUsageCount
from iblai.models.full_course import FullCourse
from iblai.models.greeting_method_enum import GreetingMethodEnum
from iblai.models.human_support_ticket import HumanSupportTicket
from iblai.models.job_run import JobRun
from iblai.models.llm_model_for_tenant import LLMModelForTenant
from iblai.models.llm_response import LLMResponse
from iblai.models.link_course_request import LinkCourseRequest
from iblai.models.link_course_response import LinkCourseResponse
from iblai.models.mcp_server import MCPServer
from iblai.models.memory_component_memory_detail import MemoryComponentMemoryDetail
from iblai.models.memory_component_response import MemoryComponentResponse
from iblai.models.memory_progress import MemoryProgress
from iblai.models.mentor import Mentor
from iblai.models.mentor_audience import MentorAudience
from iblai.models.mentor_category import MentorCategory
from iblai.models.mentor_category_create import MentorCategoryCreate
from iblai.models.mentor_category_group import MentorCategoryGroup
from iblai.models.mentor_category_group_create import MentorCategoryGroupCreate
from iblai.models.mentor_create import MentorCreate
from iblai.models.mentor_custom_voice import MentorCustomVoice
from iblai.models.mentor_custom_voice_response import MentorCustomVoiceResponse
from iblai.models.mentor_eval import MentorEval
from iblai.models.mentor_eval_report import MentorEvalReport
from iblai.models.mentor_eval_request import MentorEvalRequest
from iblai.models.mentor_fork import MentorFork
from iblai.models.mentor_memory_settings_request import MentorMemorySettingsRequest
from iblai.models.mentor_memory_settings_response import MentorMemorySettingsResponse
from iblai.models.mentor_metadata import MentorMetadata
from iblai.models.mentor_scenario import MentorScenario
from iblai.models.mentor_settings import MentorSettings
from iblai.models.mentor_settings_public import MentorSettingsPublic
from iblai.models.mentor_summary import MentorSummary
from iblai.models.mentor_type import MentorType
from iblai.models.mentor_user_setting import MentorUserSetting
from iblai.models.mentor_wizard import MentorWizard
from iblai.models.message_view import MessageView
from iblai.models.message_view_request import MessageViewRequest
from iblai.models.message_view_updat_response import MessageViewUpdatResponse
from iblai.models.moderation_log import ModerationLog
from iblai.models.paginated_ai_generated_image_list import PaginatedAIGeneratedImageList
from iblai.models.paginated_artifact_list_list import PaginatedArtifactListList
from iblai.models.paginated_course_creation_task_file_list import PaginatedCourseCreationTaskFileList
from iblai.models.paginated_course_creation_task_list import PaginatedCourseCreationTaskList
from iblai.models.paginated_disclaimer_agreement_list import PaginatedDisclaimerAgreementList
from iblai.models.paginated_disclaimer_list import PaginatedDisclaimerList
from iblai.models.paginated_edx_course_list import PaginatedEdxCourseList
from iblai.models.paginated_email_prompt_list_list import PaginatedEmailPromptListList
from iblai.models.paginated_human_support_ticket_list import PaginatedHumanSupportTicketList
from iblai.models.paginated_job_run_list import PaginatedJobRunList
from iblai.models.paginated_mcp_server_list import PaginatedMCPServerList
from iblai.models.paginated_mentor_list import PaginatedMentorList
from iblai.models.paginated_moderation_log_list import PaginatedModerationLogList
from iblai.models.paginated_periodic_agent_list import PaginatedPeriodicAgentList
from iblai.models.paginated_periodic_agent_log_list import PaginatedPeriodicAgentLogList
from iblai.models.paginated_play_wright_script_list import PaginatedPlayWrightScriptList
from iblai.models.paginated_project_list import PaginatedProjectList
from iblai.models.paginated_section_list import PaginatedSectionList
from iblai.models.paginated_sub_section_list import PaginatedSubSectionList
from iblai.models.paginated_ticket_message_list import PaginatedTicketMessageList
from iblai.models.paginated_unit_list import PaginatedUnitList
from iblai.models.paginated_user_edx_memory_list import PaginatedUserEdxMemoryList
from iblai.models.paginated_user_memory_list import PaginatedUserMemoryList
from iblai.models.paginated_voice_list import PaginatedVoiceList
from iblai.models.patched_artifact import PatchedArtifact
from iblai.models.patched_call_configuration import PatchedCallConfiguration
from iblai.models.patched_disclaimer import PatchedDisclaimer
from iblai.models.patched_human_support_ticket import PatchedHumanSupportTicket
from iblai.models.patched_mentor_category_group_create import PatchedMentorCategoryGroupCreate
from iblai.models.patched_mentor_create import PatchedMentorCreate
from iblai.models.patched_periodic_agent_create import PatchedPeriodicAgentCreate
from iblai.models.patched_play_wright_script import PatchedPlayWrightScript
from iblai.models.patched_project import PatchedProject
from iblai.models.patched_section import PatchedSection
from iblai.models.patched_sub_section import PatchedSubSection
from iblai.models.patched_ticket_message import PatchedTicketMessage
from iblai.models.patched_unit import PatchedUnit
from iblai.models.periodic_agent import PeriodicAgent
from iblai.models.periodic_agent_create import PeriodicAgentCreate
from iblai.models.periodic_agent_log import PeriodicAgentLog
from iblai.models.periodic_agent_statistics import PeriodicAgentStatistics
from iblai.models.pinned_message_create import PinnedMessageCreate
from iblai.models.pinned_message_get import PinnedMessageGet
from iblai.models.pinned_message_request import PinnedMessageRequest
from iblai.models.play_wright_script import PlayWrightScript
from iblai.models.predictive_analytics_request import PredictiveAnalyticsRequest
from iblai.models.predictive_analytics_response import PredictiveAnalyticsResponse
from iblai.models.project import Project
from iblai.models.question_card_tag import QuestionCardTag
from iblai.models.question_request import QuestionRequest
from iblai.models.question_response import QuestionResponse
from iblai.models.recently_accessed_mentor import RecentlyAccessedMentor
from iblai.models.recommend_course_block import RecommendCourseBlock
from iblai.models.recommend_course_response import RecommendCourseResponse
from iblai.models.related_text import RelatedText
from iblai.models.remove_mentor_from_disclaimer import RemoveMentorFromDisclaimer
from iblai.models.retrieve_task import RetrieveTask
from iblai.models.run_mentor_eval import RunMentorEval
from iblai.models.section import Section
from iblai.models.seed_mentors_view import SeedMentorsView
from iblai.models.session_browser_screenshot import SessionBrowserScreenshot
from iblai.models.session_detail import SessionDetail
from iblai.models.session_memory_attachment import SessionMemoryAttachment
from iblai.models.session_memory_storage import SessionMemoryStorage
from iblai.models.shareable_mentor_link import ShareableMentorLink
from iblai.models.shell_logs import ShellLogs
from iblai.models.spaced_repetition_learning_path import SpacedRepetitionLearningPath
from iblai.models.spaced_repetition_question_stats import SpacedRepetitionQuestionStats
from iblai.models.star_mentor import StarMentor
from iblai.models.sub_section import SubSection
from iblai.models.subject import Subject
from iblai.models.task_view import TaskView
from iblai.models.template_mentor import TemplateMentor
from iblai.models.ticket_message import TicketMessage
from iblai.models.tool_category import ToolCategory
from iblai.models.tool_response import ToolResponse
from iblai.models.transport_enum import TransportEnum
from iblai.models.trigger_request import TriggerRequest
from iblai.models.trigger_response import TriggerResponse
from iblai.models.unit import Unit
from iblai.models.user_chat_feedback import UserChatFeedback
from iblai.models.user_edx_memory import UserEdxMemory
from iblai.models.user_memory import UserMemory
from iblai.models.user_memory_entry import UserMemoryEntry
from iblai.models.user_memory_request import UserMemoryRequest
from iblai.models.vector_result import VectorResult
from iblai.models.voice import Voice
from iblai.models.web_resource import WebResource
from iblai.models.web_resources_query import WebResourcesQuery

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class AiMentorApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def ai_mentor_langfuse_health_retrieve(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_langfuse_health_retrieve

        Proxy endpoint to check for langfuse health status

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_langfuse_health_retrieve_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_langfuse_health_retrieve_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/langfuse/health/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_all_triggers_retrieve(
        self,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_all_triggers_retrieve

        List all triggers for an organization.  Args:     request: The HTTP request.     org: The organization/tenant identifier.  Returns:     Response: A list of trigger slugs for the organization.  Raises:     BadRequest: If the request is invalid.

        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_all_triggers_retrieve_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_all_triggers_retrieve_serialize(
        self,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/all-triggers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_by_email_create(
        self,
        org: StrictStr,
        accessible_mentors_by_email_request: AccessibleMentorsByEmailRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get accessible mentors by email

        Returns a list of mentor unique IDs that a user can access via email in the specified organization.

        :param org: (required)
        :type org: str
        :param accessible_mentors_by_email_request: (required)
        :type accessible_mentors_by_email_request: AccessibleMentorsByEmailRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_by_email_create_serialize(
            org=org,
            accessible_mentors_by_email_request=accessible_mentors_by_email_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AccessibleMentorsByEmailResponse",
            '400': "Dict[str, object]",
            '404': "Dict[str, object]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_by_email_create_serialize(
        self,
        org,
        accessible_mentors_by_email_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if accessible_mentors_by_email_request is not None:
            _body_params = accessible_mentors_by_email_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/by-email/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_email_inbox_list(
        self,
        mentor: StrictStr,
        org: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search term to filter emails by content or subject")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_mentors_email_inbox_list

        Retrieve a list of emails in a mentor's inbox.  The list can be filtered using the 'search' query parameter to search for specific terms in the email content or subject.  Args:     mentor: The unique identifier of the mentor.  Returns:     Response: A paginated list of emails in the mentor's inbox.  Raises:     NotFound: If the specified mentor does not exist.

        :param mentor: (required)
        :type mentor: str
        :param org: (required)
        :type org: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: Search term to filter emails by content or subject
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_email_inbox_list_serialize(
            mentor=mentor,
            org=org,
            page=page,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedEmailPromptListList",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_email_inbox_list_serialize(
        self,
        mentor,
        org,
        page,
        page_size,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor is not None:
            _path_params['mentor'] = mentor
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/{mentor}/email-inbox/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_email_inbox_retrieve(
        self,
        email_prompt_id: StrictInt,
        mentor: StrictStr,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_mentors_email_inbox_retrieve

        Retrieve details of a specific email in a mentor's inbox.  Args:     request: The HTTP request.     email_prompt_id: The ID of the email to retrieve.  Returns:     Response: The detailed information about the email.  Raises:     NotFound: If the specified email does not exist.

        :param email_prompt_id: (required)
        :type email_prompt_id: int
        :param mentor: (required)
        :type mentor: str
        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_email_inbox_retrieve_serialize(
            email_prompt_id=email_prompt_id,
            mentor=mentor,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmailPromptDetail",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_email_inbox_retrieve_serialize(
        self,
        email_prompt_id,
        mentor,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if email_prompt_id is not None:
            _path_params['email_prompt_id'] = email_prompt_id
        if mentor is not None:
            _path_params['mentor'] = mentor
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/{mentor}/email-inbox/{email_prompt_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_email_inbox_summary_retrieve(
        self,
        mentor: StrictStr,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_mentors_email_inbox_summary_retrieve

        Retrieve a summary of a mentor's email inbox.  Args:     request: The HTTP request.     mentor: The unique identifier of the mentor.  Returns:     Response: A summary of the mentor's email inbox statistics.  Raises:     NotFound: If the specified mentor does not exist.

        :param mentor: (required)
        :type mentor: str
        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_email_inbox_summary_retrieve_serialize(
            mentor=mentor,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmailPromptSummary",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_email_inbox_summary_retrieve_serialize(
        self,
        mentor,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor is not None:
            _path_params['mentor'] = mentor
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/{mentor}/email-inbox-summary/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_link_course_create(
        self,
        mentor: StrictStr,
        org: StrictStr,
        link_course_request: LinkCourseRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_mentors_link_course_create

        API endpoint to link mentor with a course and enable guided mode.  Permissions:     - Accessible to tenant admins.

        :param mentor: (required)
        :type mentor: str
        :param org: (required)
        :type org: str
        :param link_course_request: (required)
        :type link_course_request: LinkCourseRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_link_course_create_serialize(
            mentor=mentor,
            org=org,
            link_course_request=link_course_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LinkCourseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_link_course_create_serialize(
        self,
        mentor,
        org,
        link_course_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor is not None:
            _path_params['mentor'] = mentor
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if link_course_request is not None:
            _body_params = link_course_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/{mentor}/link-course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_mentors_link_course_retrieve(
        self,
        mentor: StrictStr,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_mentors_link_course_retrieve

        API endpoint to link mentor with a course and enable guided mode.  Permissions:     - Accessible to tenant admins.

        :param mentor: (required)
        :type mentor: str
        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_mentors_link_course_retrieve_serialize(
            mentor=mentor,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LinkCourseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_mentors_link_course_retrieve_serialize(
        self,
        mentor,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor is not None:
            _path_params['mentor'] = mentor
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/mentors/{mentor}/link-course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_metadata_create(
        self,
        org: StrictStr,
        mentor_metadata: MentorMetadata,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_metadata_create

        Create or update metadata for a mentor.  Args:     request: The HTTP request containing the metadata.     org: The organization/tenant identifier.  Returns:     Response: The created or updated mentor metadata.  Raises:     BadRequest: If the provided data is invalid.

        :param org: (required)
        :type org: str
        :param mentor_metadata: (required)
        :type mentor_metadata: MentorMetadata
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_metadata_create_serialize(
            org=org,
            mentor_metadata=mentor_metadata,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorMetadata",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_metadata_create_serialize(
        self,
        org,
        mentor_metadata,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_metadata is not None:
            _body_params = mentor_metadata


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/metadata/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_create(
        self,
        org: StrictStr,
        project: Project,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new project

        Create a new project with optional mentors.

        :param org: (required)
        :type org: str
        :param project: (required)
        :type project: Project
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_create_serialize(
            org=org,
            project=project,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Project",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_create_serialize(
        self,
        org,
        project,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if project is not None:
            _body_params = project


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/projects/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_destroy(
        self,
        id: StrictInt,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a project

        Delete a project permanently.

        :param id: (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_destroy_serialize(
            id=id,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_destroy_serialize(
        self,
        id,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/projects/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_list(
        self,
        org: StrictStr,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search in project name and description")] = None,
        shared: Annotated[Optional[StrictBool], Field(description="Filter by shared status (true/false)")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Order by field (prefix with - for descending). Example: name or -created_at")] = None,
        username: Annotated[Optional[StrictStr], Field(description="Filter projects by owner's username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List projects

        Retrieve a list of projects with optional filtering and search.

        :param org: (required)
        :type org: str
        :param limit: Number of results to return per page.
        :type limit: int
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param search: Search in project name and description
        :type search: str
        :param shared: Filter by shared status (true/false)
        :type shared: bool
        :param sort: Order by field (prefix with - for descending). Example: name or -created_at
        :type sort: str
        :param username: Filter projects by owner's username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_list_serialize(
            org=org,
            limit=limit,
            offset=offset,
            ordering=ordering,
            search=search,
            shared=shared,
            sort=sort,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProjectList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_list_serialize(
        self,
        org,
        limit,
        offset,
        ordering,
        search,
        shared,
        sort,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if shared is not None:
            
            _query_params.append(('shared', shared))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/projects/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_partial_update(
        self,
        id: StrictInt,
        org: StrictStr,
        patched_project: Optional[PatchedProject] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_projects_partial_update

        API ViewSet for managing projects.  Projects are groups of mentors that can be created by anyone (students and tenant admins). They serve as a way to organize and group related mentors together.  Projects can be: - Personal (shared=False): Only visible to their owners - Shared (shared=True): Visible to platform admins and potentially other users  Projects are accessed through integrated URLs within the mentor router:     /orgs/<org>/projects/ - All accessible projects in a platform (admin access)     /orgs/<org>/projects/<id>/ - Specific project (admin access)     /orgs/<org>/users/<user_id>/projects/ - User's projects (user access)     /orgs/<org>/users/<user_id>/projects/<id>/ - User's specific project  Query Parameters:     - username: Filter projects by owner's username (admin routes only)     - shared: Filter by shared status (true/false)     - search: Search in name and description     - sort: Order by field (prefix with - for descending). Example: sort=name or sort=-created_at  Permissions:     - GET: Accessible to project owners and platform admins (for shared projects)     - POST: Any authenticated user can create projects     - PUT, PATCH, DELETE: Accessible to project owners only

        :param id: (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param patched_project:
        :type patched_project: PatchedProject
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_partial_update_serialize(
            id=id,
            org=org,
            patched_project=patched_project,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Project",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_partial_update_serialize(
        self,
        id,
        org,
        patched_project,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_project is not None:
            _body_params = patched_project


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/projects/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_retrieve(
        self,
        id: StrictInt,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a project

        Get detailed information about a specific project including its mentors.

        :param id: (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_retrieve_serialize(
            id=id,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Project",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_retrieve_serialize(
        self,
        id,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/projects/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_projects_update(
        self,
        id: StrictInt,
        org: StrictStr,
        project: Project,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a project

        Update project information and optionally modify its mentors.

        :param id: (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param project: (required)
        :type project: Project
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_projects_update_serialize(
            id=id,
            org=org,
            project=project,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Project",
            '400': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_projects_update_serialize(
        self,
        id,
        org,
        project,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if project is not None:
            _body_params = project


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/projects/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_quiz_customizer_create(
        self,
        org: StrictStr,
        question_request: QuestionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_quiz_customizer_create

        Generate follow-up questions based on initial questions.  Args:     request: The HTTP request containing the initial questions.  Returns:     Response: The generated follow-up questions.  Raises:     BadRequest: If the provided data is invalid.

        :param org: (required)
        :type org: str
        :param question_request: (required)
        :type question_request: QuestionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_quiz_customizer_create_serialize(
            org=org,
            question_request=question_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QuestionResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_quiz_customizer_create_serialize(
        self,
        org,
        question_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if question_request is not None:
            _body_params = question_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/quiz-customizer/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_quiz_customizer_retrieve(
        self,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_quiz_customizer_retrieve

        Retrieve existing questions.  Args:     request: The HTTP request.  Returns:     Response: The existing questions.

        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_quiz_customizer_retrieve_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_quiz_customizer_retrieve_serialize(
        self,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/quiz-customizer/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_sessions_create(
        self,
        org: StrictStr,
        chat_session_request: ChatSessionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_sessions_create

        Retrieve or create a chat session with a mentor.  Passing `null` as `tools` results in using all tools assigned to the mentor. To specify that no tools be used, pass an empty list.  Args:     request: HTTP request containing mentor details.     org: Organization key identifier.     user_id (optional): Username for authentication (if required by the mentor).  Returns:     Response: JSON object containing the session ID.  Raises:     Http404: If the mentor is not found.     ValidationError: If the username is invalid.     ValidationError: If one or more tool slugs are invalid.

        :param org: (required)
        :type org: str
        :param chat_session_request: (required)
        :type chat_session_request: ChatSessionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_sessions_create_serialize(
            org=org,
            chat_session_request=chat_session_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ChatSessionResponse",
            '400': "Dict[str, object]",
            '404': "Dict[str, object]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_sessions_create_serialize(
        self,
        org,
        chat_session_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if chat_session_request is not None:
            _body_params = chat_session_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/sessions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_trigger_create(
        self,
        org: StrictStr,
        trigger_request: TriggerRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_trigger_create

        Create or modify a trigger.  Args:     request: The HTTP request containing the trigger data.     org: The organization/tenant identifier.  Returns:     Response: The created or updated trigger details.  Raises:     BadRequest: If the provided data is invalid or missing required parameters.

        :param org: (required)
        :type org: str
        :param trigger_request: (required)
        :type trigger_request: TriggerRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_trigger_create_serialize(
            org=org,
            trigger_request=trigger_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TriggerResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_trigger_create_serialize(
        self,
        org,
        trigger_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if trigger_request is not None:
            _body_params = trigger_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/trigger/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_trigger_deletion_create(
        self,
        org: StrictStr,
        slug: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_trigger_deletion_create

        Delete a specific trigger.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     slug: The unique slug identifier of the trigger to delete.  Returns:     Response: A confirmation of the deletion status.  Raises:     BadRequest: If the specified trigger does not exist.

        :param org: (required)
        :type org: str
        :param slug: (required)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_trigger_deletion_create_serialize(
            org=org,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_trigger_deletion_create_serialize(
        self,
        org,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if slug is not None:
            _path_params['slug'] = slug
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/trigger/{slug}/deletion/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_trigger_retrieve(
        self,
        org: StrictStr,
        slug: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_trigger_retrieve

        Retrieve details of a specific trigger.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     slug: The unique slug identifier of the trigger.  Returns:     Response: The details of the specified trigger.  Raises:     Http404: If the specified trigger does not exist.

        :param org: (required)
        :type org: str
        :param slug: (required)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_trigger_retrieve_serialize(
            org=org,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TriggerResponse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_trigger_retrieve_serialize(
        self,
        org,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if slug is not None:
            _path_params['slug'] = slug
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/trigger/{slug}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_trigger_templates_retrieve(
        self,
        org: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_trigger_templates_retrieve

        Retrieve available trigger templates.  Args:     request: The HTTP request.     org: The organization/tenant identifier.  Returns:     Response: A dictionary of available trigger templates and their required parameters.  Raises:     BadRequest: If the request is invalid.

        :param org: (required)
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_trigger_templates_retrieve_serialize(
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_trigger_templates_retrieve_serialize(
        self,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/trigger-templates/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_generated_images_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this ai generated image.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_generated_images_destroy

        Endpoint to view and delete AI generated images for a user.  AI Generated images are images generated during chat with AI. They are cached to allow retrieval and deletion.  optional filtering parameters allowed are - username: The username of the user for which this image was stored. - provider: The provider used to generate the image. eg. openai, nvidia (nim), replicate. - model: the text to image model on the provider used to generate the image.  This endpoint is accessible to both students and platform admins.

        :param id: A unique integer value identifying this ai generated image. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_generated_images_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_generated_images_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-generated-images/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_generated_images_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        model: Optional[StrictStr] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        provider: Optional[StrictStr] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        username: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_generated_images_list

        Endpoint to view and delete AI generated images for a user.  AI Generated images are images generated during chat with AI. They are cached to allow retrieval and deletion.  optional filtering parameters allowed are - username: The username of the user for which this image was stored. - provider: The provider used to generate the image. eg. openai, nvidia (nim), replicate. - model: the text to image model on the provider used to generate the image.  This endpoint is accessible to both students and platform admins.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param model:
        :type model: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param provider:
        :type provider: str
        :param search: A search term.
        :type search: str
        :param username:
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_generated_images_list_serialize(
            org=org,
            user_id=user_id,
            model=model,
            ordering=ordering,
            page=page,
            page_size=page_size,
            provider=provider,
            search=search,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedAIGeneratedImageList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_generated_images_list_serialize(
        self,
        org,
        user_id,
        model,
        ordering,
        page,
        page_size,
        provider,
        search,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if model is not None:
            
            _query_params.append(('model', model))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if provider is not None:
            
            _query_params.append(('provider', provider))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-generated-images/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_generated_images_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this ai generated image.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_generated_images_retrieve

        Endpoint to view and delete AI generated images for a user.  AI Generated images are images generated during chat with AI. They are cached to allow retrieval and deletion.  optional filtering parameters allowed are - username: The username of the user for which this image was stored. - provider: The provider used to generate the image. eg. openai, nvidia (nim), replicate. - model: the text to image model on the provider used to generate the image.  This endpoint is accessible to both students and platform admins.

        :param id: A unique integer value identifying this ai generated image. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_generated_images_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AIGeneratedImage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_generated_images_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-generated-images/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_user_profile_memory_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        ai_user_profile_request: AIUserProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_user_profile_memory_create

        Endpoint to create an AI user profile memory entry.  Sample request: ``` {\"favorite-animal\": \"my favorite animal is cat\"} ``` Sample Response (the same as request data): ``` {\"favorite-animal\": \"my favorite animal is cat\"} ```

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param ai_user_profile_request: (required)
        :type ai_user_profile_request: AIUserProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_user_profile_memory_create_serialize(
            org=org,
            user_id=user_id,
            ai_user_profile_request=ai_user_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AIUserProfileMemoryRelation",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_user_profile_memory_create_serialize(
        self,
        org,
        user_id,
        ai_user_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if ai_user_profile_request is not None:
            _body_params = ai_user_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-user-profile-memory/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_user_profile_memory_destroy(
        self,
        org: StrictStr,
        tag: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_user_profile_memory_destroy

        The endpoint to delete an AI user profile memory entry.  No query parameters or JSON parameters are required.  The response is always empty. Successful request will be responded with status 204, and failed request will be responded with status 404.

        :param org: (required)
        :type org: str
        :param tag: (required)
        :type tag: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_user_profile_memory_destroy_serialize(
            org=org,
            tag=tag,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_user_profile_memory_destroy_serialize(
        self,
        org,
        tag,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if tag is not None:
            _path_params['tag'] = tag
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-user-profile-memory/{tag}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_ai_user_profile_memory_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_ai_user_profile_memory_list

        Endpoint to get a list of AI user profile memory entries or to add an entry.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_ai_user_profile_memory_list_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AIUserProfileMemoryRelation]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_ai_user_profile_memory_list_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/ai-user-profile-memory/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_artifacts_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this artifact.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an artifact

        Delete a specific artifact.

        :param id: A unique integer value identifying this artifact. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_artifacts_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_artifacts_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/artifacts/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_artifacts_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        chat_message_id: Annotated[Optional[UUID], Field(description="Filter by specific chat message UUID")] = None,
        file_extension: Annotated[Optional[StrictStr], Field(description="Filter by file extension (e.g., 'py', 'md', 'html')")] = None,
        llm_name: Annotated[Optional[StrictStr], Field(description="Filter by LLM name (e.g., 'gpt-4', 'claude-3')")] = None,
        llm_provider: Annotated[Optional[StrictStr], Field(description="Filter by LLM provider (e.g., 'openai', 'anthropic')")] = None,
        mentor_id: Annotated[Optional[UUID], Field(description="Filter by mentor UUID")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Order by field (prefix with - for descending). Options: date_created, date_updated, title")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page (max: 100)")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search in title and content")] = None,
        session_id: Annotated[Optional[UUID], Field(description="Filter by session UUID")] = None,
        username: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List artifacts

        Retrieve a paginated list of artifacts for a user, with optional filtering and search.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param chat_message_id: Filter by specific chat message UUID
        :type chat_message_id: str
        :param file_extension: Filter by file extension (e.g., 'py', 'md', 'html')
        :type file_extension: str
        :param llm_name: Filter by LLM name (e.g., 'gpt-4', 'claude-3')
        :type llm_name: str
        :param llm_provider: Filter by LLM provider (e.g., 'openai', 'anthropic')
        :type llm_provider: str
        :param mentor_id: Filter by mentor UUID
        :type mentor_id: str
        :param ordering: Order by field (prefix with - for descending). Options: date_created, date_updated, title
        :type ordering: str
        :param page: Page number
        :type page: int
        :param page_size: Number of items per page (max: 100)
        :type page_size: int
        :param search: Search in title and content
        :type search: str
        :param session_id: Filter by session UUID
        :type session_id: str
        :param username:
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_artifacts_list_serialize(
            org=org,
            user_id=user_id,
            chat_message_id=chat_message_id,
            file_extension=file_extension,
            llm_name=llm_name,
            llm_provider=llm_provider,
            mentor_id=mentor_id,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            session_id=session_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedArtifactListList",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_artifacts_list_serialize(
        self,
        org,
        user_id,
        chat_message_id,
        file_extension,
        llm_name,
        llm_provider,
        mentor_id,
        ordering,
        page,
        page_size,
        search,
        session_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if chat_message_id is not None:
            
            _query_params.append(('chat_message_id', chat_message_id))
            
        if file_extension is not None:
            
            _query_params.append(('file_extension', file_extension))
            
        if llm_name is not None:
            
            _query_params.append(('llm_name', llm_name))
            
        if llm_provider is not None:
            
            _query_params.append(('llm_provider', llm_provider))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if session_id is not None:
            
            _query_params.append(('session_id', session_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/artifacts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_artifacts_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this artifact.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_artifact: Optional[PatchedArtifact] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Partially update an artifact

        Update specific fields of an artifact.

        :param id: A unique integer value identifying this artifact. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_artifact:
        :type patched_artifact: PatchedArtifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_artifacts_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_artifact=patched_artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_artifacts_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_artifact,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_artifact is not None:
            _body_params = patched_artifact


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/artifacts/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_artifacts_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this artifact.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve an artifact

        Get detailed information about a specific artifact including its full content.

        :param id: A unique integer value identifying this artifact. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_artifacts_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_artifacts_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/artifacts/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_artifacts_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this artifact.")],
        org: StrictStr,
        user_id: StrictStr,
        artifact: Artifact,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an artifact

        Update all fields of an artifact (excluding chat_message reference).

        :param id: A unique integer value identifying this artifact. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param artifact: (required)
        :type artifact: Artifact
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_artifacts_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            artifact=artifact,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Artifact",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_artifacts_update_serialize(
        self,
        id,
        org,
        user_id,
        artifact,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if artifact is not None:
            _body_params = artifact


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/artifacts/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_assumed_knowledge_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        assumed_knowledge: AssumedKnowledge,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_assumed_knowledge_create

        Update assumed knowledge levels.  Args:     request: The HTTP request containing the updated knowledge levels.     org: The organization/tenant identifier.     user_id: The ID of the user to update assumed knowledge for.  Returns:     Response: The updated assumed knowledge levels.  Raises:     BadRequest: If the provided data is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param assumed_knowledge: (required)
        :type assumed_knowledge: AssumedKnowledge
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_assumed_knowledge_create_serialize(
            org=org,
            user_id=user_id,
            assumed_knowledge=assumed_knowledge,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AssumedKnowledge",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_assumed_knowledge_create_serialize(
        self,
        org,
        user_id,
        assumed_knowledge,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if assumed_knowledge is not None:
            _body_params = assumed_knowledge


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/assumed-knowledge/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_assumed_knowledge_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_assumed_knowledge_retrieve

        Retrieve assumed knowledge levels.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user to retrieve assumed knowledge for.  Returns:     Response: The assumed knowledge levels for different categories.  Raises:     NotFound: If no assumed knowledge exists for the user.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_assumed_knowledge_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AssumedKnowledge",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_assumed_knowledge_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/assumed-knowledge/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_audio_to_text_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        file: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_audio_to_text_create

        Convert an uploaded audio file to text.  Args:     request: The HTTP request containing the audio file.     org: The organization/tenant identifier.     user_id: The ID of the user uploading the audio.  Returns:     Response: The transcribed text from the audio file.  Raises:     BadRequest: If the audio file is invalid or cannot be processed.     NotFound: If the API key for the tenant is not found.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param file: (required)
        :type file: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_audio_to_text_create_serialize(
            org=org,
            user_id=user_id,
            file=file,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AudioToTextResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_audio_to_text_create_serialize(
        self,
        org,
        user_id,
        file,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if file is not None:
            _form_params.append(('file', file))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/audio-to-text/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_available_template_mentors_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_available_template_mentors_retrieve

        This endpoint list available template mentors for a tenant  Returns:      200 : List of Template Mentors

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_available_template_mentors_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateMentor",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_available_template_mentors_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/available-template-mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_call_configurations_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        call_configuration: CallConfiguration,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_call_configurations_create

        API ViewSet for managing call configurations.  This ViewSet provides endpoints to retrieve, create, and update call configurations for mentors. Call configurations define how voice calls are handled for a mentor.  Permissions:     - Accessible only to platform admins.  Endpoints:     GET /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - List all call configurations for a specific mentor         - Returns paginated list of call configurations      POST /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - Create a new call configuration for a mentor         - Requires call configuration data in request body      PUT /api/org/{org}/mentors/{mentor_pk}/call-configurations/{id}/         - Update an existing call configuration         - Requires call configuration data in request body  Query Parameters:     - mentor: Filter configurations by mentor ID  Returns:     - CallConfigurationSerializer data

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param call_configuration: (required)
        :type call_configuration: CallConfiguration
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_call_configurations_create_serialize(
            org=org,
            user_id=user_id,
            call_configuration=call_configuration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CallConfiguration",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_call_configurations_create_serialize(
        self,
        org,
        user_id,
        call_configuration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_configuration is not None:
            _body_params = call_configuration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/call-configurations/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_call_configurations_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor: Optional[StrictStr] = None,
        mode: Annotated[Optional[StrictStr], Field(description="* `realtime` - Realtime * `inference` - Inference")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_call_configurations_list

        API ViewSet for managing call configurations.  This ViewSet provides endpoints to retrieve, create, and update call configurations for mentors. Call configurations define how voice calls are handled for a mentor.  Permissions:     - Accessible only to platform admins.  Endpoints:     GET /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - List all call configurations for a specific mentor         - Returns paginated list of call configurations      POST /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - Create a new call configuration for a mentor         - Requires call configuration data in request body      PUT /api/org/{org}/mentors/{mentor_pk}/call-configurations/{id}/         - Update an existing call configuration         - Requires call configuration data in request body  Query Parameters:     - mentor: Filter configurations by mentor ID  Returns:     - CallConfigurationSerializer data

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor:
        :type mentor: str
        :param mode: * `realtime` - Realtime * `inference` - Inference
        :type mode: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param search: A search term.
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_call_configurations_list_serialize(
            org=org,
            user_id=user_id,
            mentor=mentor,
            mode=mode,
            ordering=ordering,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CallConfiguration]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_call_configurations_list_serialize(
        self,
        org,
        user_id,
        mentor,
        mode,
        ordering,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if mode is not None:
            
            _query_params.append(('mode', mode))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/call-configurations/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_call_configurations_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this call configuration.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_call_configuration: Optional[PatchedCallConfiguration] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_call_configurations_partial_update

        API ViewSet for managing call configurations.  This ViewSet provides endpoints to retrieve, create, and update call configurations for mentors. Call configurations define how voice calls are handled for a mentor.  Permissions:     - Accessible only to platform admins.  Endpoints:     GET /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - List all call configurations for a specific mentor         - Returns paginated list of call configurations      POST /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - Create a new call configuration for a mentor         - Requires call configuration data in request body      PUT /api/org/{org}/mentors/{mentor_pk}/call-configurations/{id}/         - Update an existing call configuration         - Requires call configuration data in request body  Query Parameters:     - mentor: Filter configurations by mentor ID  Returns:     - CallConfigurationSerializer data

        :param id: A unique integer value identifying this call configuration. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_call_configuration:
        :type patched_call_configuration: PatchedCallConfiguration
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_call_configurations_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_call_configuration=patched_call_configuration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallConfiguration",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_call_configurations_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_call_configuration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_call_configuration is not None:
            _body_params = patched_call_configuration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/call-configurations/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_call_configurations_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this call configuration.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_call_configurations_retrieve

        API ViewSet for managing call configurations.  This ViewSet provides endpoints to retrieve, create, and update call configurations for mentors. Call configurations define how voice calls are handled for a mentor.  Permissions:     - Accessible only to platform admins.  Endpoints:     GET /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - List all call configurations for a specific mentor         - Returns paginated list of call configurations      POST /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - Create a new call configuration for a mentor         - Requires call configuration data in request body      PUT /api/org/{org}/mentors/{mentor_pk}/call-configurations/{id}/         - Update an existing call configuration         - Requires call configuration data in request body  Query Parameters:     - mentor: Filter configurations by mentor ID  Returns:     - CallConfigurationSerializer data

        :param id: A unique integer value identifying this call configuration. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_call_configurations_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallConfiguration",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_call_configurations_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/call-configurations/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_call_configurations_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this call configuration.")],
        org: StrictStr,
        user_id: StrictStr,
        call_configuration: CallConfiguration,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_call_configurations_update

        API ViewSet for managing call configurations.  This ViewSet provides endpoints to retrieve, create, and update call configurations for mentors. Call configurations define how voice calls are handled for a mentor.  Permissions:     - Accessible only to platform admins.  Endpoints:     GET /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - List all call configurations for a specific mentor         - Returns paginated list of call configurations      POST /api/org/{org}/mentors/{mentor_pk}/call-configurations/         - Create a new call configuration for a mentor         - Requires call configuration data in request body      PUT /api/org/{org}/mentors/{mentor_pk}/call-configurations/{id}/         - Update an existing call configuration         - Requires call configuration data in request body  Query Parameters:     - mentor: Filter configurations by mentor ID  Returns:     - CallConfigurationSerializer data

        :param id: A unique integer value identifying this call configuration. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param call_configuration: (required)
        :type call_configuration: CallConfiguration
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_call_configurations_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            call_configuration=call_configuration,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CallConfiguration",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_call_configurations_update_serialize(
        self,
        id,
        org,
        user_id,
        call_configuration,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_configuration is not None:
            _body_params = call_configuration


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/call-configurations/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_category_group_create: MentorCategoryGroupCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_create

        Create a new Mentor Category Group. Only accessible to Platform Admins.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_category_group_create: (required)
        :type mentor_category_group_create: MentorCategoryGroupCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_create_serialize(
            org=org,
            user_id=user_id,
            mentor_category_group_create=mentor_category_group_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MentorCategoryGroup",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_create_serialize(
        self,
        org,
        user_id,
        mentor_category_group_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_category_group_create is not None:
            _body_params = mentor_category_group_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mentor category group.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_destroy

        Mentor Category Groups offer parent grouping for mentor category objects.  The parameter `audience` is deprecated and is currently left behind for backward compatibility.  Permissions:     GET: Accessible to both Platform Admins and Students     POST, DELETE, PATCH, PUT: Accessible to only Platform Admins

        :param id: A unique integer value identifying this mentor category group. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        audience: Optional[StrictInt] = None,
        audience__name: Optional[StrictStr] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_list

        Retrieve a list of Mentor Category Groups.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param audience:
        :type audience: int
        :param audience__name:
        :type audience__name: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param search: A search term.
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_list_serialize(
            org=org,
            user_id=user_id,
            audience=audience,
            audience__name=audience__name,
            ordering=ordering,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MentorCategoryGroup]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_list_serialize(
        self,
        org,
        user_id,
        audience,
        audience__name,
        ordering,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if audience__name is not None:
            
            _query_params.append(('audience__name', audience__name))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mentor category group.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_mentor_category_group_create: Optional[PatchedMentorCategoryGroupCreate] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_partial_update

        Mentor Category Groups offer parent grouping for mentor category objects.  The parameter `audience` is deprecated and is currently left behind for backward compatibility.  Permissions:     GET: Accessible to both Platform Admins and Students     POST, DELETE, PATCH, PUT: Accessible to only Platform Admins

        :param id: A unique integer value identifying this mentor category group. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_mentor_category_group_create:
        :type patched_mentor_category_group_create: PatchedMentorCategoryGroupCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_mentor_category_group_create=patched_mentor_category_group_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorCategoryGroupCreate",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_mentor_category_group_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_mentor_category_group_create is not None:
            _body_params = patched_mentor_category_group_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mentor category group.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_retrieve

        Mentor Category Groups offer parent grouping for mentor category objects.  The parameter `audience` is deprecated and is currently left behind for backward compatibility.  Permissions:     GET: Accessible to both Platform Admins and Students     POST, DELETE, PATCH, PUT: Accessible to only Platform Admins

        :param id: A unique integer value identifying this mentor category group. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorCategoryGroup",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_category_groups_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mentor category group.")],
        org: StrictStr,
        user_id: StrictStr,
        mentor_category_group_create: MentorCategoryGroupCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_category_groups_update

        Mentor Category Groups offer parent grouping for mentor category objects.  The parameter `audience` is deprecated and is currently left behind for backward compatibility.  Permissions:     GET: Accessible to both Platform Admins and Students     POST, DELETE, PATCH, PUT: Accessible to only Platform Admins

        :param id: A unique integer value identifying this mentor category group. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_category_group_create: (required)
        :type mentor_category_group_create: MentorCategoryGroupCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_category_groups_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            mentor_category_group_create=mentor_category_group_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorCategoryGroupCreate",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_category_groups_update_serialize(
        self,
        id,
        org,
        user_id,
        mentor_category_group_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_category_group_create is not None:
            _body_params = mentor_category_group_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/category-groups/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_chat_files_upload_url_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        file_upload_url_request: FileUploadURLRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_chat_files_upload_url_create

        Generate presigned S3 upload URL for chat file

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param file_upload_url_request: (required)
        :type file_upload_url_request: FileUploadURLRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_chat_files_upload_url_create_serialize(
            org=org,
            user_id=user_id,
            file_upload_url_request=file_upload_url_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FileUploadURLResponse",
            '400': "object",
            '401': "object",
            '403': "object",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_chat_files_upload_url_create_serialize(
        self,
        org,
        user_id,
        file_upload_url_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if file_upload_url_request is not None:
            _body_params = file_upload_url_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/chat/files/upload-url/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_clean_vector_results_create(
        self,
        org: StrictStr,
        session_id: StrictStr,
        user_id: StrictStr,
        vector_result: List[VectorResult],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_clean_vector_results_create

        Clean up provided vector results.  This endpoint allows users to submit specific vector results for cleaning, which is useful when there are particular documents that need to be processed.  Args:     request: The HTTP request containing the vector results to clean.     org: The organization/tenant identifier.     user_id: The ID of the user making the request.  Returns:     Response: The cleaned vector results.  Raises:     BadRequest: If the API key for the cleaning provider is not found or the provided data is invalid.

        :param org: (required)
        :type org: str
        :param session_id: (required)
        :type session_id: str
        :param user_id: (required)
        :type user_id: str
        :param vector_result: (required)
        :type vector_result: List[VectorResult]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_clean_vector_results_create_serialize(
            org=org,
            session_id=session_id,
            user_id=user_id,
            vector_result=vector_result,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[VectorResult]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_clean_vector_results_create_serialize(
        self,
        org,
        session_id,
        user_id,
        vector_result,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'VectorResult': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if session_id is not None:
            _path_params['session_id'] = session_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if vector_result is not None:
            _body_params = vector_result


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/clean-vector-results/{session_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_clean_vector_results_list(
        self,
        org: StrictStr,
        session_id: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_clean_vector_results_list

        Retrieve and clean up vector results from a specific session.  This endpoint retrieves the documents last used by the mentor to answer the most recent query from the user in the specified session, and cleans them to remove any inappropriate content.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user making the request.     session_id: The ID of the session to retrieve vector results from.  Returns:     Response: The cleaned vector results.  Raises:     BadRequest: If the API key for the cleaning provider is not found.     NotFound: If no vector results are found for the session.

        :param org: (required)
        :type org: str
        :param session_id: (required)
        :type session_id: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_clean_vector_results_list_serialize(
            org=org,
            session_id=session_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[VectorResult]",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_clean_vector_results_list_serialize(
        self,
        org,
        session_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if session_id is not None:
            _path_params['session_id'] = session_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/clean-vector-results/{session_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_clear_chathistory_destroy(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete User Chat History

        Endpoint to clear a user's chat history.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_clear_chathistory_destroy_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_clear_chathistory_destroy_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/clear-chathistory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_create

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_create_serialize(
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_create_serialize(
        self,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_destroy

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_draft_content_create(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_draft_content_create

        Generate draft content for a specific unit.  This action starts a background task to create draft content for the specified unit using AI.  Args:     request: The HTTP request.     pk: The primary key of the unit to generate content for.  Returns:     Response: A confirmation that the content generation task has been started.  Raises:     NotFound: If the specified unit does not exist.

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_draft_content_create_serialize(
            id=id,
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_draft_content_create_serialize(
        self,
        id,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/draft-content/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_draft_content_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_draft_content_retrieve

        Generate draft content for a specific unit.  This action starts a background task to create draft content for the specified unit using AI.  Args:     request: The HTTP request.     pk: The primary key of the unit to generate content for.  Returns:     Response: A confirmation that the content generation task has been started.  Raises:     NotFound: If the specified unit does not exist.

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_draft_content_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_draft_content_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/draft-content/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course: Optional[StrictInt] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        section: Optional[StrictInt] = None,
        subsection: Optional[StrictInt] = None,
        task: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_list

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course:
        :type course: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param section:
        :type section: int
        :param subsection:
        :type subsection: int
        :param task:
        :type task: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_list_serialize(
            org=org,
            user_id=user_id,
            course=course,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            section=section,
            subsection=subsection,
            task=task,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUnitList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_list_serialize(
        self,
        org,
        user_id,
        course,
        ordering,
        page,
        page_size,
        search,
        section,
        subsection,
        task,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course is not None:
            
            _query_params.append(('course', course))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if section is not None:
            
            _query_params.append(('section', section))
            
        if subsection is not None:
            
            _query_params.append(('subsection', subsection))
            
        if task is not None:
            
            _query_params.append(('task', task))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_unit: Optional[PatchedUnit] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_partial_update

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_unit:
        :type patched_unit: PatchedUnit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_unit=patched_unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_unit is not None:
            _body_params = patched_unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_retrieve

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_component_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_component_update

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_component_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_component_update_serialize(
        self,
        id,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/component/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_destroy

        API viewset for managing EdX courses.  This viewset allows platform administrators to retrieve, delete, and perform various operations on EdX courses that were created through course creation tasks.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_draft_content_for_all_units_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_draft_content_for_all_units_retrieve

        Generate draft content for all units in a course.  This action starts a background task to create draft content for all units in the course using AI.  Args:     request: The HTTP request.     pk: The primary key of the course to generate content for.  Returns:     Response: A confirmation that the content generation task has been started.  Raises:     NotFound: If the specified course does not exist.

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_draft_content_for_all_units_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_draft_content_for_all_units_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/draft-content-for-all-units/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_full_structure_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_full_structure_retrieve

        Retrieve the full structure of a course.  This action returns the complete hierarchical structure of the course, including all sections, subsections, units, and components.  Args:     request: The HTTP request.     pk: The primary key of the course to retrieve.  Returns:     Response: The full structure of the course.  Raises:     NotFound: If the specified course does not exist.

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_full_structure_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FullCourse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_full_structure_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/full-structure/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        task: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_list

        API viewset for managing EdX courses.  This viewset allows platform administrators to retrieve, delete, and perform various operations on EdX courses that were created through course creation tasks.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param task:
        :type task: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_list_serialize(
            org=org,
            user_id=user_id,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            task=task,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedEdxCourseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_list_serialize(
        self,
        org,
        user_id,
        ordering,
        page,
        page_size,
        search,
        task,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if task is not None:
            
            _query_params.append(('task', task))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_load_from_edx_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_load_from_edx_retrieve

        Load existing course structure from OpenEdX.  This action starts a background task to pull the course structure from the EdX platform into the database.  Args:     request: The HTTP request.     pk: The primary key of the course to load.  Returns:     Response: A confirmation that the load task has been started.  Raises:     NotFound: If the specified course does not exist.

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_load_from_edx_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_load_from_edx_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/load-from-edx/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_retrieve

        API viewset for managing EdX courses.  This viewset allows platform administrators to retrieve, delete, and perform various operations on EdX courses that were created through course creation tasks.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EdxCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_course_sync_to_edx_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this edx course.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_course_sync_to_edx_retrieve

        Synchronize the course structure to EdX.  This action starts a background task to push the course structure from the database to the EdX platform.  Args:     request: The HTTP request.     pk: The primary key of the course to synchronize.  Returns:     Response: A confirmation that the sync task has been started.  Raises:     NotFound: If the specified course does not exist.

        :param id: A unique integer value identifying this edx course. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_course_sync_to_edx_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_course_sync_to_edx_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/course/{id}/sync-to-edx/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        id: StrictInt,
        course_creation_task: StrictInt,
        file: StrictStr,
        date_created: datetime,
        last_modified: datetime,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_create

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id: (required)
        :type id: int
        :param course_creation_task: (required)
        :type course_creation_task: int
        :param file: (required)
        :type file: str
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_create_serialize(
            org=org,
            user_id=user_id,
            id=id,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_create_serialize(
        self,
        org,
        user_id,
        id,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id is not None:
            _form_params.append(('id', id))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_destroy

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_list

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_list_serialize(
            org=org,
            user_id=user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseCreationTaskFileList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_list_serialize(
        self,
        org,
        user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: Optional[StrictInt] = None,
        course_creation_task: Optional[StrictInt] = None,
        file: Optional[StrictStr] = None,
        date_created: Optional[datetime] = None,
        last_modified: Optional[datetime] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_partial_update

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2:
        :type id2: int
        :param course_creation_task:
        :type course_creation_task: int
        :param file:
        :type file: str
        :param date_created:
        :type date_created: datetime
        :param last_modified:
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_retrieve

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_files_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: StrictInt,
        course_creation_task: StrictInt,
        file: StrictStr,
        date_created: datetime,
        last_modified: datetime,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_files_update

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2: (required)
        :type id2: int
        :param course_creation_task: (required)
        :type course_creation_task: int
        :param file: (required)
        :type file: str
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_files_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_files_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        section: Section,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_create

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param section: (required)
        :type section: Section
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_create_serialize(
            org=org,
            user_id=user_id,
            section=section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Section",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_create_serialize(
        self,
        org,
        user_id,
        section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if section is not None:
            _body_params = section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this section.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_destroy

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course: Optional[StrictInt] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        task: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_list

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course:
        :type course: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param task:
        :type task: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_list_serialize(
            org=org,
            user_id=user_id,
            course=course,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            task=task,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedSectionList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_list_serialize(
        self,
        org,
        user_id,
        course,
        ordering,
        page,
        page_size,
        search,
        task,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course is not None:
            
            _query_params.append(('course', course))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if task is not None:
            
            _query_params.append(('task', task))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this section.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_section: Optional[PatchedSection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_partial_update

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_section:
        :type patched_section: PatchedSection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_section=patched_section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Section",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_section is not None:
            _body_params = patched_section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this section.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_retrieve

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Section",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_section_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this section.")],
        org: StrictStr,
        user_id: StrictStr,
        section: Section,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_section_update

        API viewset for managing course sections.  This viewset allows platform administrators to retrieve and manage sections within EdX courses.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param section: (required)
        :type section: Section
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_section_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            section=section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Section",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_section_update_serialize(
        self,
        id,
        org,
        user_id,
        section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if section is not None:
            _body_params = section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/section/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        sub_section: SubSection,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_create

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param sub_section: (required)
        :type sub_section: SubSection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_create_serialize(
            org=org,
            user_id=user_id,
            sub_section=sub_section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SubSection",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_create_serialize(
        self,
        org,
        user_id,
        sub_section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sub_section is not None:
            _body_params = sub_section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this sub section.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_destroy

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this sub section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course: Optional[StrictInt] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        section: Optional[StrictInt] = None,
        task: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_list

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course:
        :type course: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param section:
        :type section: int
        :param task:
        :type task: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_list_serialize(
            org=org,
            user_id=user_id,
            course=course,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            section=section,
            task=task,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedSubSectionList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_list_serialize(
        self,
        org,
        user_id,
        course,
        ordering,
        page,
        page_size,
        search,
        section,
        task,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course is not None:
            
            _query_params.append(('course', course))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if section is not None:
            
            _query_params.append(('section', section))
            
        if task is not None:
            
            _query_params.append(('task', task))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this sub section.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_sub_section: Optional[PatchedSubSection] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_partial_update

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this sub section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_sub_section:
        :type patched_sub_section: PatchedSubSection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_sub_section=patched_sub_section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SubSection",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_sub_section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_sub_section is not None:
            _body_params = patched_sub_section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this sub section.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_retrieve

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this sub section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SubSection",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_subsection_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this sub section.")],
        org: StrictStr,
        user_id: StrictStr,
        sub_section: SubSection,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_subsection_update

        API viewset for managing course subsections.  This viewset allows platform administrators to retrieve and manage subsections within course sections.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this sub section. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param sub_section: (required)
        :type sub_section: SubSection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_subsection_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            sub_section=sub_section,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SubSection",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_subsection_update_serialize(
        self,
        id,
        org,
        user_id,
        sub_section,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sub_section is not None:
            _body_params = sub_section


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/subsection/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        id: StrictInt,
        course_creation_task: StrictInt,
        file: StrictStr,
        date_created: datetime,
        last_modified: datetime,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_create

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id: (required)
        :type id: int
        :param course_creation_task: (required)
        :type course_creation_task: int
        :param file: (required)
        :type file: str
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_create_serialize(
            org=org,
            user_id=user_id,
            id=id,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_create_serialize(
        self,
        org,
        user_id,
        id,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id is not None:
            _form_params.append(('id', id))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_destroy

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_list

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_list_serialize(
            org=org,
            user_id=user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseCreationTaskFileList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_list_serialize(
        self,
        org,
        user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: Optional[StrictInt] = None,
        course_creation_task: Optional[StrictInt] = None,
        file: Optional[StrictStr] = None,
        date_created: Optional[datetime] = None,
        last_modified: Optional[datetime] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_partial_update

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2:
        :type id2: int
        :param course_creation_task:
        :type course_creation_task: int
        :param file:
        :type file: str
        :param date_created:
        :type date_created: datetime
        :param last_modified:
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_retrieve

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_task_files_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task file.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: StrictInt,
        course_creation_task: StrictInt,
        file: StrictStr,
        date_created: datetime,
        last_modified: datetime,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_task_files_update

        Endpoint to fetch update and delete files associated with course creation tasks.

        :param id: A unique integer value identifying this course creation task file. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2: (required)
        :type id2: int
        :param course_creation_task: (required)
        :type course_creation_task: int
        :param file: (required)
        :type file: str
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_task_files_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            course_creation_task=course_creation_task,
            file=file,
            date_created=date_created,
            last_modified=last_modified,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTaskFile",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_task_files_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        course_creation_task,
        file,
        date_created,
        last_modified,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if course_creation_task is not None:
            _form_params.append(('course_creation_task', course_creation_task))
        if file is not None:
            _form_params.append(('file', file))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-task-files/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve

        Cancel a course creation task run. ** Conditions Required **: The task must be running or pending. ** Response **: - 200: The course creation task is successfully cancelled. - 400: The course creation task is not in a running or pending state.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/cancel/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve2

        Cancel a course creation task run. ** Conditions Required **: The task must be running or pending. ** Response **: - 200: The course creation task is successfully cancelled. - 400: The course creation task is not in a running or pending state.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_cancel_retrieve2_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/cancel/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        id: StrictInt,
        user_id2: StrictStr,
        student: Annotated[StrictInt, Field(description="edX user ID")],
        name: Annotated[str, Field(strict=True, max_length=200)],
        description: Annotated[StrictStr, Field(description="Description of the course to create and its requirements")],
        target_audience: Annotated[str, Field(strict=True, max_length=200, description="The intended audience for the course. eg. Grade 11 students.")],
        platform: StrictInt,
        platform_key: StrictStr,
        status: Any,
        course_data: Optional[Any],
        logs: StrictStr,
        files: List[CourseCreationTaskFile],
        date_created: datetime,
        last_modified: datetime,
        publish_course: Optional[StrictBool] = None,
        provider: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None,
        model: Optional[Annotated[str, Field(strict=True, max_length=150)]] = None,
        desired_number_of_sections: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id: (required)
        :type id: int
        :param user_id2: (required)
        :type user_id2: str
        :param student: edX user ID (required)
        :type student: int
        :param name: (required)
        :type name: str
        :param description: Description of the course to create and its requirements (required)
        :type description: str
        :param target_audience: The intended audience for the course. eg. Grade 11 students. (required)
        :type target_audience: str
        :param platform: (required)
        :type platform: int
        :param platform_key: (required)
        :type platform_key: str
        :param status: (required)
        :type status: CourseCreationTaskStatusEnum
        :param course_data: (required)
        :type course_data: object
        :param logs: (required)
        :type logs: str
        :param files: (required)
        :type files: List[CourseCreationTaskFile]
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param publish_course:
        :type publish_course: bool
        :param provider:
        :type provider: str
        :param model:
        :type model: str
        :param desired_number_of_sections:
        :type desired_number_of_sections: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create_serialize(
            org=org,
            user_id=user_id,
            id=id,
            user_id2=user_id2,
            student=student,
            name=name,
            description=description,
            target_audience=target_audience,
            platform=platform,
            platform_key=platform_key,
            status=status,
            course_data=course_data,
            logs=logs,
            files=files,
            date_created=date_created,
            last_modified=last_modified,
            publish_course=publish_course,
            provider=provider,
            model=model,
            desired_number_of_sections=desired_number_of_sections,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create_serialize(
        self,
        org,
        user_id,
        id,
        user_id2,
        student,
        name,
        description,
        target_audience,
        platform,
        platform_key,
        status,
        course_data,
        logs,
        files,
        date_created,
        last_modified,
        publish_course,
        provider,
        model,
        desired_number_of_sections,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id is not None:
            _form_params.append(('id', id))
        if user_id2 is not None:
            _form_params.append(('user_id', user_id2))
        if student is not None:
            _form_params.append(('student', student))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if target_audience is not None:
            _form_params.append(('target_audience', target_audience))
        if platform is not None:
            _form_params.append(('platform', platform))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if status is not None:
            _form_params.append(('status', status))
        if publish_course is not None:
            _form_params.append(('publish_course', publish_course))
        if course_data is not None:
            _form_params.append(('course_data', course_data))
        if provider is not None:
            _form_params.append(('provider', provider))
        if model is not None:
            _form_params.append(('model', model))
        if desired_number_of_sections is not None:
            _form_params.append(('desired_number_of_sections', desired_number_of_sections))
        if logs is not None:
            _form_params.append(('logs', logs))
        if files is not None:
            _form_params.append(('files', files))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create2(
        self,
        org: StrictStr,
        user_id: StrictStr,
        id: StrictInt,
        user_id2: StrictStr,
        student: Annotated[StrictInt, Field(description="edX user ID")],
        name: Annotated[str, Field(strict=True, max_length=200)],
        description: Annotated[StrictStr, Field(description="Description of the course to create and its requirements")],
        target_audience: Annotated[str, Field(strict=True, max_length=200, description="The intended audience for the course. eg. Grade 11 students.")],
        platform: StrictInt,
        platform_key: StrictStr,
        status: Any,
        course_data: Optional[Any],
        logs: StrictStr,
        files: List[CourseCreationTaskFile],
        date_created: datetime,
        last_modified: datetime,
        publish_course: Optional[StrictBool] = None,
        provider: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None,
        model: Optional[Annotated[str, Field(strict=True, max_length=150)]] = None,
        desired_number_of_sections: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create2

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id: (required)
        :type id: int
        :param user_id2: (required)
        :type user_id2: str
        :param student: edX user ID (required)
        :type student: int
        :param name: (required)
        :type name: str
        :param description: Description of the course to create and its requirements (required)
        :type description: str
        :param target_audience: The intended audience for the course. eg. Grade 11 students. (required)
        :type target_audience: str
        :param platform: (required)
        :type platform: int
        :param platform_key: (required)
        :type platform_key: str
        :param status: (required)
        :type status: CourseCreationTaskStatusEnum
        :param course_data: (required)
        :type course_data: object
        :param logs: (required)
        :type logs: str
        :param files: (required)
        :type files: List[CourseCreationTaskFile]
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param publish_course:
        :type publish_course: bool
        :param provider:
        :type provider: str
        :param model:
        :type model: str
        :param desired_number_of_sections:
        :type desired_number_of_sections: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create2_serialize(
            org=org,
            user_id=user_id,
            id=id,
            user_id2=user_id2,
            student=student,
            name=name,
            description=description,
            target_audience=target_audience,
            platform=platform,
            platform_key=platform_key,
            status=status,
            course_data=course_data,
            logs=logs,
            files=files,
            date_created=date_created,
            last_modified=last_modified,
            publish_course=publish_course,
            provider=provider,
            model=model,
            desired_number_of_sections=desired_number_of_sections,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create2_serialize(
        self,
        org,
        user_id,
        id,
        user_id2,
        student,
        name,
        description,
        target_audience,
        platform,
        platform_key,
        status,
        course_data,
        logs,
        files,
        date_created,
        last_modified,
        publish_course,
        provider,
        model,
        desired_number_of_sections,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id is not None:
            _form_params.append(('id', id))
        if user_id2 is not None:
            _form_params.append(('user_id', user_id2))
        if student is not None:
            _form_params.append(('student', student))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if target_audience is not None:
            _form_params.append(('target_audience', target_audience))
        if platform is not None:
            _form_params.append(('platform', platform))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if status is not None:
            _form_params.append(('status', status))
        if publish_course is not None:
            _form_params.append(('publish_course', publish_course))
        if course_data is not None:
            _form_params.append(('course_data', course_data))
        if provider is not None:
            _form_params.append(('provider', provider))
        if model is not None:
            _form_params.append(('model', model))
        if desired_number_of_sections is not None:
            _form_params.append(('desired_number_of_sections', desired_number_of_sections))
        if logs is not None:
            _form_params.append(('logs', logs))
        if files is not None:
            _form_params.append(('files', files))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: StrictInt,
        user_id2: StrictStr,
        student: Annotated[StrictInt, Field(description="edX user ID")],
        name: Annotated[str, Field(strict=True, max_length=200)],
        description: Annotated[StrictStr, Field(description="Description of the course to create and its requirements")],
        target_audience: Annotated[str, Field(strict=True, max_length=200, description="The intended audience for the course. eg. Grade 11 students.")],
        platform: StrictInt,
        platform_key: StrictStr,
        status: Any,
        course_data: Optional[Any],
        logs: StrictStr,
        files: List[CourseCreationTaskFile],
        date_created: datetime,
        last_modified: datetime,
        publish_course: Optional[StrictBool] = None,
        provider: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None,
        model: Optional[Annotated[str, Field(strict=True, max_length=150)]] = None,
        desired_number_of_sections: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create

        This is intended for stepwise approach of course creation.  Use this to intiate generating an outline of the course.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2: (required)
        :type id2: int
        :param user_id2: (required)
        :type user_id2: str
        :param student: edX user ID (required)
        :type student: int
        :param name: (required)
        :type name: str
        :param description: Description of the course to create and its requirements (required)
        :type description: str
        :param target_audience: The intended audience for the course. eg. Grade 11 students. (required)
        :type target_audience: str
        :param platform: (required)
        :type platform: int
        :param platform_key: (required)
        :type platform_key: str
        :param status: (required)
        :type status: CourseCreationTaskStatusEnum
        :param course_data: (required)
        :type course_data: object
        :param logs: (required)
        :type logs: str
        :param files: (required)
        :type files: List[CourseCreationTaskFile]
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param publish_course:
        :type publish_course: bool
        :param provider:
        :type provider: str
        :param model:
        :type model: str
        :param desired_number_of_sections:
        :type desired_number_of_sections: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            user_id2=user_id2,
            student=student,
            name=name,
            description=description,
            target_audience=target_audience,
            platform=platform,
            platform_key=platform_key,
            status=status,
            course_data=course_data,
            logs=logs,
            files=files,
            date_created=date_created,
            last_modified=last_modified,
            publish_course=publish_course,
            provider=provider,
            model=model,
            desired_number_of_sections=desired_number_of_sections,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FullCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        user_id2,
        student,
        name,
        description,
        target_audience,
        platform,
        platform_key,
        status,
        course_data,
        logs,
        files,
        date_created,
        last_modified,
        publish_course,
        provider,
        model,
        desired_number_of_sections,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if user_id2 is not None:
            _form_params.append(('user_id', user_id2))
        if student is not None:
            _form_params.append(('student', student))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if target_audience is not None:
            _form_params.append(('target_audience', target_audience))
        if platform is not None:
            _form_params.append(('platform', platform))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if status is not None:
            _form_params.append(('status', status))
        if publish_course is not None:
            _form_params.append(('publish_course', publish_course))
        if course_data is not None:
            _form_params.append(('course_data', course_data))
        if provider is not None:
            _form_params.append(('provider', provider))
        if model is not None:
            _form_params.append(('model', model))
        if desired_number_of_sections is not None:
            _form_params.append(('desired_number_of_sections', desired_number_of_sections))
        if logs is not None:
            _form_params.append(('logs', logs))
        if files is not None:
            _form_params.append(('files', files))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/create-course-outline/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: StrictInt,
        user_id2: StrictStr,
        student: Annotated[StrictInt, Field(description="edX user ID")],
        name: Annotated[str, Field(strict=True, max_length=200)],
        description: Annotated[StrictStr, Field(description="Description of the course to create and its requirements")],
        target_audience: Annotated[str, Field(strict=True, max_length=200, description="The intended audience for the course. eg. Grade 11 students.")],
        platform: StrictInt,
        platform_key: StrictStr,
        status: Any,
        course_data: Optional[Any],
        logs: StrictStr,
        files: List[CourseCreationTaskFile],
        date_created: datetime,
        last_modified: datetime,
        publish_course: Optional[StrictBool] = None,
        provider: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None,
        model: Optional[Annotated[str, Field(strict=True, max_length=150)]] = None,
        desired_number_of_sections: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create2

        This is intended for stepwise approach of course creation.  Use this to intiate generating an outline of the course.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2: (required)
        :type id2: int
        :param user_id2: (required)
        :type user_id2: str
        :param student: edX user ID (required)
        :type student: int
        :param name: (required)
        :type name: str
        :param description: Description of the course to create and its requirements (required)
        :type description: str
        :param target_audience: The intended audience for the course. eg. Grade 11 students. (required)
        :type target_audience: str
        :param platform: (required)
        :type platform: int
        :param platform_key: (required)
        :type platform_key: str
        :param status: (required)
        :type status: CourseCreationTaskStatusEnum
        :param course_data: (required)
        :type course_data: object
        :param logs: (required)
        :type logs: str
        :param files: (required)
        :type files: List[CourseCreationTaskFile]
        :param date_created: (required)
        :type date_created: datetime
        :param last_modified: (required)
        :type last_modified: datetime
        :param publish_course:
        :type publish_course: bool
        :param provider:
        :type provider: str
        :param model:
        :type model: str
        :param desired_number_of_sections:
        :type desired_number_of_sections: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            user_id2=user_id2,
            student=student,
            name=name,
            description=description,
            target_audience=target_audience,
            platform=platform,
            platform_key=platform_key,
            status=status,
            course_data=course_data,
            logs=logs,
            files=files,
            date_created=date_created,
            last_modified=last_modified,
            publish_course=publish_course,
            provider=provider,
            model=model,
            desired_number_of_sections=desired_number_of_sections,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FullCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create_course_outline_create2_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        user_id2,
        student,
        name,
        description,
        target_audience,
        platform,
        platform_key,
        status,
        course_data,
        logs,
        files,
        date_created,
        last_modified,
        publish_course,
        provider,
        model,
        desired_number_of_sections,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if user_id2 is not None:
            _form_params.append(('user_id', user_id2))
        if student is not None:
            _form_params.append(('student', student))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if target_audience is not None:
            _form_params.append(('target_audience', target_audience))
        if platform is not None:
            _form_params.append(('platform', platform))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if status is not None:
            _form_params.append(('status', status))
        if publish_course is not None:
            _form_params.append(('publish_course', publish_course))
        if course_data is not None:
            _form_params.append(('course_data', course_data))
        if provider is not None:
            _form_params.append(('provider', provider))
        if model is not None:
            _form_params.append(('model', model))
        if desired_number_of_sections is not None:
            _form_params.append(('desired_number_of_sections', desired_number_of_sections))
        if logs is not None:
            _form_params.append(('logs', logs))
        if files is not None:
            _form_params.append(('files', files))
        if date_created is not None:
            _form_params.append(('date_created', date_created))
        if last_modified is not None:
            _form_params.append(('last_modified', last_modified))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/create-course-outline/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve

        This is intended for stepwise approach of course creation.  Use this to intiate generating an outline of the course.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FullCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/create-course-outline/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve2

        This is intended for stepwise approach of course creation.  Use this to intiate generating an outline of the course.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FullCourse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_create_course_outline_retrieve2_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/create-course-outline/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_destroy

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_destroy2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_destroy2

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_destroy2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_destroy2_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_list

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_list_serialize(
            org=org,
            user_id=user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseCreationTaskList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_list_serialize(
        self,
        org,
        user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_list2(
        self,
        org: StrictStr,
        user_id: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_list2

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_list2_serialize(
            org=org,
            user_id=user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseCreationTaskList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_list2_serialize(
        self,
        org,
        user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_retrieve

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_retrieve2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_retrieve2

        Create, retrieve and delete course creation tasks  Course creation tasks allow you to schedule the creation of a course on OpenEdx deployment connected to this data manager.  The course is created entirely by an ai model (as specified in your inputs).  The llm decides on the content of the course based on the name, description, target audience and other parameters. Bigger and newer models tend to outperform smaller once.  Clear and unambiguous parameters are more likely to produce better results.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_retrieve2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_retrieve2_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_start_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_start_retrieve

        Kick start the course creation task. This endpoint should be called once the files for a course creation task has been successfully uploaded.  ** Conditions Required **: - The course creation task must be in a pending state or failed state.  ** Response **: - 200: The course creation task is successfully started. - 400: The course creation task is not in a pending state.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_start_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_start_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation-tasks/{id}/start/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_tasks_start_retrieve2(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this course creation task.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_tasks_start_retrieve2

        Kick start the course creation task. This endpoint should be called once the files for a course creation task has been successfully uploaded.  ** Conditions Required **: - The course creation task must be in a pending state or failed state.  ** Response **: - 200: The course creation task is successfully started. - 400: The course creation task is not in a pending state.

        :param id: A unique integer value identifying this course creation task. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_tasks_start_retrieve2_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseCreationTask",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_tasks_start_retrieve2_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/tasks/{id}/start/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_create

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_create_serialize(
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_create_serialize(
        self,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_destroy

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_draft_content_create(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_draft_content_create

        Generate draft content for a specific unit.  This action starts a background task to create draft content for the specified unit using AI.  Args:     request: The HTTP request.     pk: The primary key of the unit to generate content for.  Returns:     Response: A confirmation that the content generation task has been started.  Raises:     NotFound: If the specified unit does not exist.

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_draft_content_create_serialize(
            id=id,
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_draft_content_create_serialize(
        self,
        id,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/draft-content/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_draft_content_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_draft_content_retrieve

        Generate draft content for a specific unit.  This action starts a background task to create draft content for the specified unit using AI.  Args:     request: The HTTP request.     pk: The primary key of the unit to generate content for.  Returns:     Response: A confirmation that the content generation task has been started.  Raises:     NotFound: If the specified unit does not exist.

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_draft_content_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_draft_content_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/draft-content/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course: Optional[StrictInt] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        section: Optional[StrictInt] = None,
        subsection: Optional[StrictInt] = None,
        task: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_list

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course:
        :type course: int
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param section:
        :type section: int
        :param subsection:
        :type subsection: int
        :param task:
        :type task: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_list_serialize(
            org=org,
            user_id=user_id,
            course=course,
            ordering=ordering,
            page=page,
            page_size=page_size,
            search=search,
            section=section,
            subsection=subsection,
            task=task,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUnitList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_list_serialize(
        self,
        org,
        user_id,
        course,
        ordering,
        page,
        page_size,
        search,
        section,
        subsection,
        task,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course is not None:
            
            _query_params.append(('course', course))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if section is not None:
            
            _query_params.append(('section', section))
            
        if subsection is not None:
            
            _query_params.append(('subsection', subsection))
            
        if task is not None:
            
            _query_params.append(('task', task))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_unit: Optional[PatchedUnit] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_partial_update

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_unit:
        :type patched_unit: PatchedUnit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_unit=patched_unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_unit is not None:
            _body_params = patched_unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_retrieve

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_course_creation_unit_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this unit.")],
        org: StrictStr,
        user_id: StrictStr,
        unit: Unit,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_course_creation_unit_update

        API viewset for managing course units.  This viewset allows platform administrators to retrieve and manage units within course subsections, and generate content for them.  Permissions:     - Restricted to platform administrators only

        :param id: A unique integer value identifying this unit. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param unit: (required)
        :type unit: Unit
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_course_creation_unit_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            unit=unit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Unit",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_course_creation_unit_update_serialize(
        self,
        id,
        org,
        user_id,
        unit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if unit is not None:
            _body_params = unit


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/course-creation/unit/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_create: MentorCreate,
        department_id: Annotated[Optional[StrictInt], Field(description="Department to filter by")] = None,
        filter_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter options include, date, name, default is date ")] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Whether the mentor is featured or not")] = None,
        metadata_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata key to be queried with")] = None,
        metadata_value: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata value to be filter for")] = None,
        return_session_information: Annotated[Optional[StrictBool], Field(description="Declares if session information should be included in the mentor data")] = None,
        visibility: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="visibility type  to be queried with")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_create

        Create a new mentor. Body Parameters:     - name: Mentor name.     - unique_id: Unique identifier.     - platform_key: Associated platform.     - metadata: Additional mentor attributes.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_create: (required)
        :type mentor_create: MentorCreate
        :param department_id: Department to filter by
        :type department_id: int
        :param filter_by: Filter options include, date, name, default is date 
        :type filter_by: str
        :param is_featured: Whether the mentor is featured or not
        :type is_featured: bool
        :param metadata_key: Metadata key to be queried with
        :type metadata_key: str
        :param metadata_value: Metadata value to be filter for
        :type metadata_value: str
        :param return_session_information: Declares if session information should be included in the mentor data
        :type return_session_information: bool
        :param visibility: visibility type  to be queried with
        :type visibility: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_create_serialize(
            org=org,
            user_id=user_id,
            mentor_create=mentor_create,
            department_id=department_id,
            filter_by=filter_by,
            is_featured=is_featured,
            metadata_key=metadata_key,
            metadata_value=metadata_value,
            return_session_information=return_session_information,
            visibility=visibility,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Mentor",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_create_serialize(
        self,
        org,
        user_id,
        mentor_create,
        department_id,
        filter_by,
        is_featured,
        metadata_key,
        metadata_value,
        return_session_information,
        visibility,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if filter_by is not None:
            
            _query_params.append(('filter_by', filter_by))
            
        if is_featured is not None:
            
            _query_params.append(('is_featured', is_featured))
            
        if metadata_key is not None:
            
            _query_params.append(('metadata_key', metadata_key))
            
        if metadata_value is not None:
            
            _query_params.append(('metadata_value', metadata_value))
            
        if return_session_information is not None:
            
            _query_params.append(('return_session_information', return_session_information))
            
        if visibility is not None:
            
            _query_params.append(('visibility', visibility))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_create is not None:
            _body_params = mentor_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_create_mentor_wizard_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_wizard: MentorWizard,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_create_mentor_wizard_create

        Create a new mentor using the wizard interface.  Args:     request: The HTTP request containing the mentor data.     org: The organization/tenant identifier.     user_id: The ID of the user creating the mentor.  Returns:     Response: The created mentor.  Raises:     BadRequest: If the provided data is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_wizard: (required)
        :type mentor_wizard: MentorWizard
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_create_mentor_wizard_create_serialize(
            org=org,
            user_id=user_id,
            mentor_wizard=mentor_wizard,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Mentor",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_create_mentor_wizard_create_serialize(
        self,
        org,
        user_id,
        mentor_wizard,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_wizard is not None:
            _body_params = mentor_wizard


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/create-mentor-wizard/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_custom_instruction_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        custom_instruction_response: Optional[CustomInstructionResponse] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_custom_instruction_create

        Create a new custom instruction for a user.  Args:     request: The HTTP request containing the custom instruction data.     org: The organization/tenant identifier.     user_id: The ID of the user to create custom instructions for.  Returns:     Response: The created custom instruction.  Raises:     BadRequest: If the provided data is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param custom_instruction_response:
        :type custom_instruction_response: CustomInstructionResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_custom_instruction_create_serialize(
            org=org,
            user_id=user_id,
            custom_instruction_response=custom_instruction_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CustomInstructionResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_custom_instruction_create_serialize(
        self,
        org,
        user_id,
        custom_instruction_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if custom_instruction_response is not None:
            _body_params = custom_instruction_response


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/custom-instruction/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_custom_instruction_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_custom_instruction_retrieve

        Retrieve custom instructions for a specific user.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user to retrieve custom instructions for.  Returns:     Response: The custom instructions for the user.  Raises:     NotFound: If no custom instructions exist for the user.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_custom_instruction_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomInstructionResponse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_custom_instruction_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/custom-instruction/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_custom_instruction_update(
        self,
        org: StrictStr,
        user_id: StrictStr,
        custom_instruction_response: Optional[CustomInstructionResponse] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_custom_instruction_update

        Update an existing custom instruction for a user.  Args:     request: The HTTP request containing the updated custom instruction data.     org: The organization/tenant identifier.     user_id: The ID of the user to update custom instructions for.  Returns:     Response: The updated custom instruction.  Raises:     BadRequest: If the provided data is invalid.     NotFound: If no custom instruction exists for the user.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param custom_instruction_response:
        :type custom_instruction_response: CustomInstructionResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_custom_instruction_update_serialize(
            org=org,
            user_id=user_id,
            custom_instruction_response=custom_instruction_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomInstructionResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_custom_instruction_update_serialize(
        self,
        org,
        user_id,
        custom_instruction_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if custom_instruction_response is not None:
            _body_params = custom_instruction_response


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/custom-instruction/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_destroy(
        self,
        name: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="Department to filter by")] = None,
        filter_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter options include, date, name, default is date ")] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Whether the mentor is featured or not")] = None,
        metadata_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata key to be queried with")] = None,
        metadata_value: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata value to be filter for")] = None,
        return_session_information: Annotated[Optional[StrictBool], Field(description="Declares if session information should be included in the mentor data")] = None,
        visibility: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="visibility type  to be queried with")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_destroy

        Soft delete a mentor.

        :param name: (required)
        :type name: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: Department to filter by
        :type department_id: int
        :param filter_by: Filter options include, date, name, default is date 
        :type filter_by: str
        :param is_featured: Whether the mentor is featured or not
        :type is_featured: bool
        :param metadata_key: Metadata key to be queried with
        :type metadata_key: str
        :param metadata_value: Metadata value to be filter for
        :type metadata_value: str
        :param return_session_information: Declares if session information should be included in the mentor data
        :type return_session_information: bool
        :param visibility: visibility type  to be queried with
        :type visibility: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_destroy_serialize(
            name=name,
            org=org,
            user_id=user_id,
            department_id=department_id,
            filter_by=filter_by,
            is_featured=is_featured,
            metadata_key=metadata_key,
            metadata_value=metadata_value,
            return_session_information=return_session_information,
            visibility=visibility,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_destroy_serialize(
        self,
        name,
        org,
        user_id,
        department_id,
        filter_by,
        is_featured,
        metadata_key,
        metadata_value,
        return_session_information,
        visibility,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if filter_by is not None:
            
            _query_params.append(('filter_by', filter_by))
            
        if is_featured is not None:
            
            _query_params.append(('is_featured', is_featured))
            
        if metadata_key is not None:
            
            _query_params.append(('metadata_key', metadata_key))
            
        if metadata_value is not None:
            
            _query_params.append(('metadata_value', metadata_value))
            
        if return_session_information is not None:
            
            _query_params.append(('return_session_information', return_session_information))
            
        if visibility is not None:
            
            _query_params.append(('visibility', visibility))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/{name}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimer_agreements_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        disclaimer_agreement: DisclaimerAgreement,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimer_agreements_create

        API view for managing disclaimer agreements.  This viewset provides Create Read and Delete operations for disclaimer agreements with different access levels:  Platform Admins: - Can view all disclaimer agreements for their platform - Have full access to create (for themselves) and delete agreements for themselves and other users. - Results are paginated and can be filtered  Students: - Can only view their own disclaimer agreements - Limited to agreements where they are the user - Results are paginated and can be filtered  List endpoint returns paginated results with disclaimer agreement objects:  ``` {     \"count\": int,     \"next\": str,     \"previous\": str,     \"results\": [         {             \"id\": int,             \"user\": str,             \"disclaimer\": int,             \"agreed_at\": datetime,          },         ...     ] } ```  Detail endpoints return a single disclaimer agreement object with the same structure

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param disclaimer_agreement: (required)
        :type disclaimer_agreement: DisclaimerAgreement
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimer_agreements_create_serialize(
            org=org,
            user_id=user_id,
            disclaimer_agreement=disclaimer_agreement,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DisclaimerAgreement",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimer_agreements_create_serialize(
        self,
        org,
        user_id,
        disclaimer_agreement,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if disclaimer_agreement is not None:
            _body_params = disclaimer_agreement


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimer-agreements/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimer_agreements_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer agreement.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimer_agreements_destroy

        API view for managing disclaimer agreements.  This viewset provides Create Read and Delete operations for disclaimer agreements with different access levels:  Platform Admins: - Can view all disclaimer agreements for their platform - Have full access to create (for themselves) and delete agreements for themselves and other users. - Results are paginated and can be filtered  Students: - Can only view their own disclaimer agreements - Limited to agreements where they are the user - Results are paginated and can be filtered  List endpoint returns paginated results with disclaimer agreement objects:  ``` {     \"count\": int,     \"next\": str,     \"previous\": str,     \"results\": [         {             \"id\": int,             \"user\": str,             \"disclaimer\": int,             \"agreed_at\": datetime,          },         ...     ] } ```  Detail endpoints return a single disclaimer agreement object with the same structure

        :param id: A unique integer value identifying this disclaimer agreement. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimer_agreements_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimer_agreements_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimer-agreements/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimer_agreements_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        disclaimer: Optional[StrictInt] = None,
        mentor_id: Optional[UUID] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        username: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimer_agreements_list

        API view for managing disclaimer agreements.  This viewset provides Create Read and Delete operations for disclaimer agreements with different access levels:  Platform Admins: - Can view all disclaimer agreements for their platform - Have full access to create (for themselves) and delete agreements for themselves and other users. - Results are paginated and can be filtered  Students: - Can only view their own disclaimer agreements - Limited to agreements where they are the user - Results are paginated and can be filtered  List endpoint returns paginated results with disclaimer agreement objects:  ``` {     \"count\": int,     \"next\": str,     \"previous\": str,     \"results\": [         {             \"id\": int,             \"user\": str,             \"disclaimer\": int,             \"agreed_at\": datetime,          },         ...     ] } ```  Detail endpoints return a single disclaimer agreement object with the same structure

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param disclaimer:
        :type disclaimer: int
        :param mentor_id:
        :type mentor_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param username:
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimer_agreements_list_serialize(
            org=org,
            user_id=user_id,
            disclaimer=disclaimer,
            mentor_id=mentor_id,
            page=page,
            page_size=page_size,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedDisclaimerAgreementList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimer_agreements_list_serialize(
        self,
        org,
        user_id,
        disclaimer,
        mentor_id,
        page,
        page_size,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if disclaimer is not None:
            
            _query_params.append(('disclaimer', disclaimer))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimer-agreements/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimer_agreements_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer agreement.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimer_agreements_retrieve

        API view for managing disclaimer agreements.  This viewset provides Create Read and Delete operations for disclaimer agreements with different access levels:  Platform Admins: - Can view all disclaimer agreements for their platform - Have full access to create (for themselves) and delete agreements for themselves and other users. - Results are paginated and can be filtered  Students: - Can only view their own disclaimer agreements - Limited to agreements where they are the user - Results are paginated and can be filtered  List endpoint returns paginated results with disclaimer agreement objects:  ``` {     \"count\": int,     \"next\": str,     \"previous\": str,     \"results\": [         {             \"id\": int,             \"user\": str,             \"disclaimer\": int,             \"agreed_at\": datetime,          },         ...     ] } ```  Detail endpoints return a single disclaimer agreement object with the same structure

        :param id: A unique integer value identifying this disclaimer agreement. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimer_agreements_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DisclaimerAgreement",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimer_agreements_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimer-agreements/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_add_mentor_create(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer.")],
        org: StrictStr,
        user_id: StrictStr,
        add_mentor_to_disclaimer: AddMentorToDisclaimer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add mentor to disclaimer

        Add a mentor to a disclaimer with `mentor` scope. Only platform admins can perform this action.

        :param id: A unique integer value identifying this disclaimer. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param add_mentor_to_disclaimer: (required)
        :type add_mentor_to_disclaimer: AddMentorToDisclaimer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_add_mentor_create_serialize(
            id=id,
            org=org,
            user_id=user_id,
            add_mentor_to_disclaimer=add_mentor_to_disclaimer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Disclaimer",
            '400': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_add_mentor_create_serialize(
        self,
        id,
        org,
        user_id,
        add_mentor_to_disclaimer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if add_mentor_to_disclaimer is not None:
            _body_params = add_mentor_to_disclaimer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/{id}/add-mentor/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        disclaimer: Disclaimer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimers_create

        ViewSet for managing mentor disclaimers.  This viewset provides endpoints for creating and managing mentor disclaimers, which are statements or information that mentors need to share with students.  Permissions:     - Platform administrators have full CRUD access     - Students have read-only access     - Unauthenticated users have no access  Endpoints:     - GET /api/orgs/{org}/users/{user_id}/disclaimers/ - List all disclaimers     - POST /api/orgs/{org}/users/{user_id}/disclaimers/ - Create a new disclaimer     - GET /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Retrieve a specific disclaimer     - PUT/PATCH /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Update a disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/add_mentor/ - Add mentor to disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/remove_mentor/ - Remove mentor from disclaimer  Query Parameters:     - Supports filtering via DjangoFilterBackend     - See DisclaimerFilterSet for available filters  Returns:     List endpoint returns paginated results with disclaimer objects:      ```     {         \"count\": int,         \"next\": str,         \"previous\": str,         \"results\": [             {                 \"id\": int,                 \"title\": str,                 \"content\": str,                 \"mentor\": str,                 \"platform\": str,                 \"created_at\": datetime,                 \"updated_at\": datetime             },             ...         ]     }     ```      Detail endpoints return a single disclaimer object with the same structure

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param disclaimer: (required)
        :type disclaimer: Disclaimer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_create_serialize(
            org=org,
            user_id=user_id,
            disclaimer=disclaimer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Disclaimer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_create_serialize(
        self,
        org,
        user_id,
        disclaimer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if disclaimer is not None:
            _body_params = disclaimer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        active: Optional[StrictBool] = None,
        mentor_id: Optional[UUID] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="* `platform` - Platform * `mentor` - Mentor")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimers_list

        ViewSet for managing mentor disclaimers.  This viewset provides endpoints for creating and managing mentor disclaimers, which are statements or information that mentors need to share with students.  Permissions:     - Platform administrators have full CRUD access     - Students have read-only access     - Unauthenticated users have no access  Endpoints:     - GET /api/orgs/{org}/users/{user_id}/disclaimers/ - List all disclaimers     - POST /api/orgs/{org}/users/{user_id}/disclaimers/ - Create a new disclaimer     - GET /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Retrieve a specific disclaimer     - PUT/PATCH /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Update a disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/add_mentor/ - Add mentor to disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/remove_mentor/ - Remove mentor from disclaimer  Query Parameters:     - Supports filtering via DjangoFilterBackend     - See DisclaimerFilterSet for available filters  Returns:     List endpoint returns paginated results with disclaimer objects:      ```     {         \"count\": int,         \"next\": str,         \"previous\": str,         \"results\": [             {                 \"id\": int,                 \"title\": str,                 \"content\": str,                 \"mentor\": str,                 \"platform\": str,                 \"created_at\": datetime,                 \"updated_at\": datetime             },             ...         ]     }     ```      Detail endpoints return a single disclaimer object with the same structure

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param active:
        :type active: bool
        :param mentor_id:
        :type mentor_id: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param scope: * `platform` - Platform * `mentor` - Mentor
        :type scope: str
        :param search: A search term.
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_list_serialize(
            org=org,
            user_id=user_id,
            active=active,
            mentor_id=mentor_id,
            ordering=ordering,
            page=page,
            page_size=page_size,
            scope=scope,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedDisclaimerList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_list_serialize(
        self,
        org,
        user_id,
        active,
        mentor_id,
        ordering,
        page,
        page_size,
        scope,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if mentor_id is not None:
            
            _query_params.append(('mentor_id', mentor_id))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer.")],
        org: StrictStr,
        user_id: StrictStr,
        patched_disclaimer: Optional[PatchedDisclaimer] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimers_partial_update

        ViewSet for managing mentor disclaimers.  This viewset provides endpoints for creating and managing mentor disclaimers, which are statements or information that mentors need to share with students.  Permissions:     - Platform administrators have full CRUD access     - Students have read-only access     - Unauthenticated users have no access  Endpoints:     - GET /api/orgs/{org}/users/{user_id}/disclaimers/ - List all disclaimers     - POST /api/orgs/{org}/users/{user_id}/disclaimers/ - Create a new disclaimer     - GET /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Retrieve a specific disclaimer     - PUT/PATCH /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Update a disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/add_mentor/ - Add mentor to disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/remove_mentor/ - Remove mentor from disclaimer  Query Parameters:     - Supports filtering via DjangoFilterBackend     - See DisclaimerFilterSet for available filters  Returns:     List endpoint returns paginated results with disclaimer objects:      ```     {         \"count\": int,         \"next\": str,         \"previous\": str,         \"results\": [             {                 \"id\": int,                 \"title\": str,                 \"content\": str,                 \"mentor\": str,                 \"platform\": str,                 \"created_at\": datetime,                 \"updated_at\": datetime             },             ...         ]     }     ```      Detail endpoints return a single disclaimer object with the same structure

        :param id: A unique integer value identifying this disclaimer. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param patched_disclaimer:
        :type patched_disclaimer: PatchedDisclaimer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            patched_disclaimer=patched_disclaimer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Disclaimer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        patched_disclaimer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_disclaimer is not None:
            _body_params = patched_disclaimer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_remove_mentor_create(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer.")],
        org: StrictStr,
        user_id: StrictStr,
        remove_mentor_from_disclaimer: RemoveMentorFromDisclaimer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove mentor from disclaimer

        Remove a mentor from a disclaimer with `mentor` scope. Only platform admins can perform this action. Validates that at least one mentor remains after removal.

        :param id: A unique integer value identifying this disclaimer. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param remove_mentor_from_disclaimer: (required)
        :type remove_mentor_from_disclaimer: RemoveMentorFromDisclaimer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_remove_mentor_create_serialize(
            id=id,
            org=org,
            user_id=user_id,
            remove_mentor_from_disclaimer=remove_mentor_from_disclaimer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Disclaimer",
            '400': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_remove_mentor_create_serialize(
        self,
        id,
        org,
        user_id,
        remove_mentor_from_disclaimer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if remove_mentor_from_disclaimer is not None:
            _body_params = remove_mentor_from_disclaimer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/{id}/remove-mentor/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimers_retrieve

        ViewSet for managing mentor disclaimers.  This viewset provides endpoints for creating and managing mentor disclaimers, which are statements or information that mentors need to share with students.  Permissions:     - Platform administrators have full CRUD access     - Students have read-only access     - Unauthenticated users have no access  Endpoints:     - GET /api/orgs/{org}/users/{user_id}/disclaimers/ - List all disclaimers     - POST /api/orgs/{org}/users/{user_id}/disclaimers/ - Create a new disclaimer     - GET /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Retrieve a specific disclaimer     - PUT/PATCH /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Update a disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/add_mentor/ - Add mentor to disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/remove_mentor/ - Remove mentor from disclaimer  Query Parameters:     - Supports filtering via DjangoFilterBackend     - See DisclaimerFilterSet for available filters  Returns:     List endpoint returns paginated results with disclaimer objects:      ```     {         \"count\": int,         \"next\": str,         \"previous\": str,         \"results\": [             {                 \"id\": int,                 \"title\": str,                 \"content\": str,                 \"mentor\": str,                 \"platform\": str,                 \"created_at\": datetime,                 \"updated_at\": datetime             },             ...         ]     }     ```      Detail endpoints return a single disclaimer object with the same structure

        :param id: A unique integer value identifying this disclaimer. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Disclaimer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_disclaimers_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this disclaimer.")],
        org: StrictStr,
        user_id: StrictStr,
        disclaimer: Disclaimer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_disclaimers_update

        ViewSet for managing mentor disclaimers.  This viewset provides endpoints for creating and managing mentor disclaimers, which are statements or information that mentors need to share with students.  Permissions:     - Platform administrators have full CRUD access     - Students have read-only access     - Unauthenticated users have no access  Endpoints:     - GET /api/orgs/{org}/users/{user_id}/disclaimers/ - List all disclaimers     - POST /api/orgs/{org}/users/{user_id}/disclaimers/ - Create a new disclaimer     - GET /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Retrieve a specific disclaimer     - PUT/PATCH /api/orgs/{org}/users/{user_id}/disclaimers/{id}/ - Update a disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/add_mentor/ - Add mentor to disclaimer     - POST /api/orgs/{org}/users/{user_id}/disclaimers/{id}/remove_mentor/ - Remove mentor from disclaimer  Query Parameters:     - Supports filtering via DjangoFilterBackend     - See DisclaimerFilterSet for available filters  Returns:     List endpoint returns paginated results with disclaimer objects:      ```     {         \"count\": int,         \"next\": str,         \"previous\": str,         \"results\": [             {                 \"id\": int,                 \"title\": str,                 \"content\": str,                 \"mentor\": str,                 \"platform\": str,                 \"created_at\": datetime,                 \"updated_at\": datetime             },             ...         ]     }     ```      Detail endpoints return a single disclaimer object with the same structure

        :param id: A unique integer value identifying this disclaimer. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param disclaimer: (required)
        :type disclaimer: Disclaimer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_disclaimers_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            disclaimer=disclaimer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Disclaimer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_disclaimers_update_serialize(
        self,
        id,
        org,
        user_id,
        disclaimer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if disclaimer is not None:
            _body_params = disclaimer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/disclaimers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_downloads_tasks_retrieve(
        self,
        org: StrictStr,
        task_id: UUID,
        user_id: StrictStr,
        to_csv: Annotated[Optional[StrictBool], Field(description="Choose download in csv or not")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_downloads_tasks_retrieve

        Retrieves the chat history for a user if the export task is ready.  This Endpoint to download user chathistory.  Accessible to tenant admins and students.  Returns:      200: When task is not ready.      200: chat history object      400: When data is not valid.

        :param org: (required)
        :type org: str
        :param task_id: (required)
        :type task_id: str
        :param user_id: (required)
        :type user_id: str
        :param to_csv: Choose download in csv or not
        :type to_csv: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_downloads_tasks_retrieve_serialize(
            org=org,
            task_id=task_id,
            user_id=user_id,
            to_csv=to_csv,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ChatHistoryItem",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_downloads_tasks_retrieve_serialize(
        self,
        org,
        task_id,
        user_id,
        to_csv,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if task_id is not None:
            _path_params['task_id'] = task_id
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if to_csv is not None:
            
            _query_params.append(('to_csv', to_csv))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/downloads/tasks/{task_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_edx_memory_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this user edx memory.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_edx_memory_destroy

        Endpoints to fetch and delete Edx stored Memory information stored for a user and a corresponding edx course they have interracted with. This information is passed to the corresponding mentor so the mentor has context information about the course and unit that the user last interracted with.  There can be only one UserEdxMemory instance per student and course_id.  Url Args:     org (str): The organization's platform key.     user_id (str): The username  identifier of the individual.  Returns:      200: A paginated list of UserEdxMemory objects  Examples:      - List all memories         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/          Request:        None         Response:       {                             \"count\": 0,                             \"next\": null,                             \"previous\": null,                             \"results\": [{                                 \"student\": 1,                                 \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                                 \"data\": {},                                 \"date_created\": \"2024-06-25T15:30:26.257140\",                                 \"last_modified\": \"2024-06-25T15:30:26.257140\"                             }]                         }     - Get a single UserEdxMemory object         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/1/          Request:        None         Response:       {                             \"student\": 1,                             \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                             \"data\": {},                             \"date_created\": \"2024-06-25T15:30:26.257140\",                             \"last_modified\": \"2024-06-25T15:30:26.257140\"                         }

        :param id: A unique integer value identifying this user edx memory. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_edx_memory_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_edx_memory_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/edx-memory/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_edx_memory_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course_id: Optional[StrictStr] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        student: Annotated[Optional[StrictInt], Field(description="edX user ID")] = None,
        username: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_edx_memory_list

        Endpoints to fetch and delete Edx stored Memory information stored for a user and a corresponding edx course they have interracted with. This information is passed to the corresponding mentor so the mentor has context information about the course and unit that the user last interracted with.  There can be only one UserEdxMemory instance per student and course_id.  Url Args:     org (str): The organization's platform key.     user_id (str): The username  identifier of the individual.  Returns:      200: A paginated list of UserEdxMemory objects  Examples:      - List all memories         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/          Request:        None         Response:       {                             \"count\": 0,                             \"next\": null,                             \"previous\": null,                             \"results\": [{                                 \"student\": 1,                                 \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                                 \"data\": {},                                 \"date_created\": \"2024-06-25T15:30:26.257140\",                                 \"last_modified\": \"2024-06-25T15:30:26.257140\"                             }]                         }     - Get a single UserEdxMemory object         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/1/          Request:        None         Response:       {                             \"student\": 1,                             \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                             \"data\": {},                             \"date_created\": \"2024-06-25T15:30:26.257140\",                             \"last_modified\": \"2024-06-25T15:30:26.257140\"                         }

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course_id:
        :type course_id: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param student: edX user ID
        :type student: int
        :param username:
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_edx_memory_list_serialize(
            org=org,
            user_id=user_id,
            course_id=course_id,
            ordering=ordering,
            page=page,
            page_size=page_size,
            student=student,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserEdxMemoryList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_edx_memory_list_serialize(
        self,
        org,
        user_id,
        course_id,
        ordering,
        page,
        page_size,
        student,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if student is not None:
            
            _query_params.append(('student', student))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/edx-memory/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_edx_memory_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this user edx memory.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_edx_memory_retrieve

        Endpoints to fetch and delete Edx stored Memory information stored for a user and a corresponding edx course they have interracted with. This information is passed to the corresponding mentor so the mentor has context information about the course and unit that the user last interracted with.  There can be only one UserEdxMemory instance per student and course_id.  Url Args:     org (str): The organization's platform key.     user_id (str): The username  identifier of the individual.  Returns:      200: A paginated list of UserEdxMemory objects  Examples:      - List all memories         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/          Request:        None         Response:       {                             \"count\": 0,                             \"next\": null,                             \"previous\": null,                             \"results\": [{                                 \"student\": 1,                                 \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                                 \"data\": {},                                 \"date_created\": \"2024-06-25T15:30:26.257140\",                                 \"last_modified\": \"2024-06-25T15:30:26.257140\"                             }]                         }     - Get a single UserEdxMemory object         GET: /api/ai-mentor/orgs/main/users/johndoe/edx-memory/1/          Request:        None         Response:       {                             \"student\": 1,                             \"course_id\": \"course-v1:main+CARBON+2024_Fall\",                             \"data\": {},                             \"date_created\": \"2024-06-25T15:30:26.257140\",                             \"last_modified\": \"2024-06-25T15:30:26.257140\"                         }

        :param id: A unique integer value identifying this user edx memory. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_edx_memory_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserEdxMemory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_edx_memory_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/edx-memory/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_elevenlabs_voice_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        name: StrictStr,
        files: List[StrictStr],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_elevenlabs_voice_create

        Create a new custom Elevenlabs voice.  This endpoint allows users to upload audio files to create a custom voice that can be used with the Elevenlabs text-to-speech service.  Note: The audio files' total length should be longer than 1 minute and the total size should be smaller than 11 MiB.  Args:     request: The HTTP request containing the voice name and audio files.     org: The organization/tenant identifier.     user_id: The ID of the user creating the voice.  Returns:     Response: The created voice configuration.  Raises:     BadRequest: If the provided data is invalid, credentials are not found, or there's an API error.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param name: (required)
        :type name: str
        :param files: (required)
        :type files: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_elevenlabs_voice_create_serialize(
            org=org,
            user_id=user_id,
            name=name,
            files=files,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ElevenlabsCustomVoiceResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_elevenlabs_voice_create_serialize(
        self,
        org,
        user_id,
        name,
        files,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'files': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if name is not None:
            _form_params.append(('name', name))
        if files is not None:
            _form_params.append(('files', files))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/elevenlabs-voice/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_elevenlabs_voice_destroy(
        self,
        org: StrictStr,
        user_id: StrictStr,
        voice_name: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_elevenlabs_voice_destroy

        Delete an existing Elevenlabs voice configuration.  This endpoint removes a custom voice configuration both from the local database and from the Elevenlabs remote API if applicable.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user who owns the voice.     voice_name: The name of the voice to delete.  Returns:     Response: A confirmation of the deletion.  Raises:     BadRequest: If the Elevenlabs credentials are not found or there's an API error.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param voice_name: (required)
        :type voice_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_elevenlabs_voice_destroy_serialize(
            org=org,
            user_id=user_id,
            voice_name=voice_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_elevenlabs_voice_destroy_serialize(
        self,
        org,
        user_id,
        voice_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        if voice_name is not None:
            _path_params['voice_name'] = voice_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/elevenlabs-voice/{voice_name}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_elevenlabs_voice_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_elevenlabs_voice_list

        Retrieve a list of Elevenlabs voices available to a user.  This endpoint returns both custom voices created by the user and premade voices available to all users.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user to retrieve voices for.  Returns:     Response: A list of available Elevenlabs voices.  Raises:     NotFound: If the specified user does not exist.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_elevenlabs_voice_list_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ElevenlabsCustomVoiceResponse]",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_elevenlabs_voice_list_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/elevenlabs-voice/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_export_chathistory_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_export_chathistory_create

        Initiates a background task to export the user's chat history.  Returns:      200: task id.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_export_chathistory_create_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TaskView",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_export_chathistory_create_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/export-chathistory/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_extracted_memories_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_extracted_memories_retrieve

        Returns extracted memory for a user. This is the memory that the user tells the mentor to remember or is inferred from conversations.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_extracted_memories_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserMemory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_extracted_memories_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/extracted-memories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_filtered_memories_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        category: Annotated[Optional[StrictStr], Field(description="a string of category to filter memories")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="ISO date for end date (optional)")] = None,
        mentor: Annotated[Optional[StrictStr], Field(description="the mentor unique id which the memory is linked to")] = None,
        mode: Annotated[Optional[StrictStr], Field(description="mode which the memory applies to. can be `guided`, `regular` or `all`")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        platform: Annotated[Optional[StrictStr], Field(description="the platform which the memory is linked to")] = None,
        session: Annotated[Optional[StrictStr], Field(description="the session id which the memory is linked to")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="ISO date for start date (optional)")] = None,
        username: Annotated[Optional[StrictStr], Field(description="the username of the memories")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_filtered_memories_list

        Retrieve a list of memories based on filter conditions. Only accessible to tenant admins.  Returns:     Response: A paginated list of memories.     Put your queries using the parameters in the query parameters. For example, to search a mentor's regular mode memory, use the following url:     ```     https://base.manager.iblai.app/api/ai-mentor/orgs/your-org/users/your-user/filtered-memories/?mentor=f81fc856-fd8f-4e6b-9d3b-72aa68279c40&mode=regular&username=another-user     ```  Raises:     NotFound: If the query is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param category: a string of category to filter memories
        :type category: str
        :param end_date: ISO date for end date (optional)
        :type end_date: str
        :param mentor: the mentor unique id which the memory is linked to
        :type mentor: str
        :param mode: mode which the memory applies to. can be `guided`, `regular` or `all`
        :type mode: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param platform: the platform which the memory is linked to
        :type platform: str
        :param session: the session id which the memory is linked to
        :type session: str
        :param start_date: ISO date for start date (optional)
        :type start_date: str
        :param username: the username of the memories
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_filtered_memories_list_serialize(
            org=org,
            user_id=user_id,
            category=category,
            end_date=end_date,
            mentor=mentor,
            mode=mode,
            page=page,
            page_size=page_size,
            platform=platform,
            session=session,
            start_date=start_date,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserMemoryList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_filtered_memories_list_serialize(
        self,
        org,
        user_id,
        category,
        end_date,
        mentor,
        mode,
        page,
        page_size,
        platform,
        session,
        start_date,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if category is not None:
            
            _query_params.append(('category', category))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if mode is not None:
            
            _query_params.append(('mode', mode))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform is not None:
            
            _query_params.append(('platform', platform))
            
        if session is not None:
            
            _query_params.append(('session', session))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/filtered-memories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_free_usage_count_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_free_usage_count_retrieve

        Retrieve the count of free usage credits available to a user.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     user_id: The ID of the user to check free usage for.  Returns:     Response: The count of free usage credits available.  Raises:     NotFound: If the specified user does not exist.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_free_usage_count_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FreeUsageCount",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_free_usage_count_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/free-usage-count',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="Department to filter by")] = None,
        filter_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter options include, date, name, default is date ")] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Whether the mentor is featured or not")] = None,
        metadata_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata key to be queried with")] = None,
        metadata_value: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Metadata value to be filter for")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        return_session_information: Annotated[Optional[StrictBool], Field(description="Declares if session information should be included in the mentor data")] = None,
        visibility: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="visibility type  to be queried with")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_list

        Retrieve a list of mentors.  Returns:     - List of mentors matching the filters.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: Department to filter by
        :type department_id: int
        :param filter_by: Filter options include, date, name, default is date 
        :type filter_by: str
        :param is_featured: Whether the mentor is featured or not
        :type is_featured: bool
        :param metadata_key: Metadata key to be queried with
        :type metadata_key: str
        :param metadata_value: Metadata value to be filter for
        :type metadata_value: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param return_session_information: Declares if session information should be included in the mentor data
        :type return_session_information: bool
        :param visibility: visibility type  to be queried with
        :type visibility: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_list_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            filter_by=filter_by,
            is_featured=is_featured,
            metadata_key=metadata_key,
            metadata_value=metadata_value,
            page=page,
            page_size=page_size,
            return_session_information=return_session_information,
            visibility=visibility,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedMentorList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_list_serialize(
        self,
        org,
        user_id,
        department_id,
        filter_by,
        is_featured,
        metadata_key,
        metadata_value,
        page,
        page_size,
        return_session_information,
        visibility,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if filter_by is not None:
            
            _query_params.append(('filter_by', filter_by))
            
        if is_featured is not None:
            
            _query_params.append(('is_featured', is_featured))
            
        if metadata_key is not None:
            
            _query_params.append(('metadata_key', metadata_key))
            
        if metadata_value is not None:
            
            _query_params.append(('metadata_value', metadata_value))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if return_session_information is not None:
            
            _query_params.append(('return_session_information', return_session_information))
            
        if visibility is not None:
            
            _query_params.append(('visibility', visibility))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        id: StrictInt,
        platform: StrictInt,
        name: Annotated[str, Field(strict=True, max_length=255)],
        url: Annotated[str, Field(strict=True, max_length=200, description="The url of the MCP server.")],
        platform_key: StrictStr,
        created_at: datetime,
        updated_at: datetime,
        description: Annotated[Optional[StrictStr], Field(description="A description of the MCP server.")] = None,
        image: Optional[StrictStr] = None,
        transport: Optional[TransportEnum] = None,
        credentials: Annotated[Optional[StrictStr], Field(description="Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`")] = None,
        extra_headers: Annotated[Optional[Any], Field(description="Headers to send to the MCP server. Useful for authentication,")] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Featured mcp servers will be accessible to all other tenants.")] = None,
        auth_type: Annotated[Optional[Any], Field(description="The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2")] = None,
        is_enabled: Annotated[Optional[StrictBool], Field(description="Whether the MCP server is enabled or not.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_create

        ViewSet for MCP Servers.  Allows platform admins to list, create, retrieve, update, and delete MCP servers.  Permissions:     - Accessible to tenant admins.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id: (required)
        :type id: int
        :param platform: (required)
        :type platform: int
        :param name: (required)
        :type name: str
        :param url: The url of the MCP server. (required)
        :type url: str
        :param platform_key: (required)
        :type platform_key: str
        :param created_at: (required)
        :type created_at: datetime
        :param updated_at: (required)
        :type updated_at: datetime
        :param description: A description of the MCP server.
        :type description: str
        :param image:
        :type image: str
        :param transport:
        :type transport: TransportEnum
        :param credentials: Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`
        :type credentials: str
        :param extra_headers: Headers to send to the MCP server. Useful for authentication,
        :type extra_headers: object
        :param is_featured: Featured mcp servers will be accessible to all other tenants.
        :type is_featured: bool
        :param auth_type: The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2
        :type auth_type: AuthTypeEnum
        :param is_enabled: Whether the MCP server is enabled or not.
        :type is_enabled: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_create_serialize(
            org=org,
            user_id=user_id,
            id=id,
            platform=platform,
            name=name,
            url=url,
            platform_key=platform_key,
            created_at=created_at,
            updated_at=updated_at,
            description=description,
            image=image,
            transport=transport,
            credentials=credentials,
            extra_headers=extra_headers,
            is_featured=is_featured,
            auth_type=auth_type,
            is_enabled=is_enabled,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MCPServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_create_serialize(
        self,
        org,
        user_id,
        id,
        platform,
        name,
        url,
        platform_key,
        created_at,
        updated_at,
        description,
        image,
        transport,
        credentials,
        extra_headers,
        is_featured,
        auth_type,
        is_enabled,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id is not None:
            _form_params.append(('id', id))
        if platform is not None:
            _form_params.append(('platform', platform))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if url is not None:
            _form_params.append(('url', url))
        if image is not None:
            _form_params.append(('image', image))
        if transport is not None:
            _form_params.append(('transport', transport))
        if credentials is not None:
            _form_params.append(('credentials', credentials))
        if extra_headers is not None:
            _form_params.append(('extra_headers', extra_headers))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if is_featured is not None:
            _form_params.append(('is_featured', is_featured))
        if auth_type is not None:
            _form_params.append(('auth_type', auth_type))
        if is_enabled is not None:
            _form_params.append(('is_enabled', is_enabled))
        if created_at is not None:
            _form_params.append(('created_at', created_at))
        if updated_at is not None:
            _form_params.append(('updated_at', updated_at))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mcp server.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_destroy

        ViewSet for MCP Servers.  Allows platform admins to list, create, retrieve, update, and delete MCP servers.  Permissions:     - Accessible to tenant admins.

        :param id: A unique integer value identifying this mcp server. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_destroy_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        auth_type: Annotated[Optional[StrictStr], Field(description="The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2")] = None,
        is_enabled: Optional[StrictBool] = None,
        is_featured: Optional[StrictBool] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        transport: Annotated[Optional[StrictStr], Field(description="* `sse` - Sse * `websocket` - Websocket * `streamable_http` - Streamable Http")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_list

        List all MCP servers.  Returns a paginated list of MCP servers that can be filtered by platform and searched by name or URL.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param auth_type: The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2
        :type auth_type: str
        :param is_enabled:
        :type is_enabled: bool
        :param is_featured:
        :type is_featured: bool
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: A search term.
        :type search: str
        :param transport: * `sse` - Sse * `websocket` - Websocket * `streamable_http` - Streamable Http
        :type transport: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_list_serialize(
            org=org,
            user_id=user_id,
            auth_type=auth_type,
            is_enabled=is_enabled,
            is_featured=is_featured,
            page=page,
            page_size=page_size,
            search=search,
            transport=transport,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedMCPServerList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_list_serialize(
        self,
        org,
        user_id,
        auth_type,
        is_enabled,
        is_featured,
        page,
        page_size,
        search,
        transport,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if auth_type is not None:
            
            _query_params.append(('auth_type', auth_type))
            
        if is_enabled is not None:
            
            _query_params.append(('is_enabled', is_enabled))
            
        if is_featured is not None:
            
            _query_params.append(('is_featured', is_featured))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if transport is not None:
            
            _query_params.append(('transport', transport))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mcp server.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: Optional[StrictInt] = None,
        platform: Optional[StrictInt] = None,
        name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None,
        description: Annotated[Optional[StrictStr], Field(description="A description of the MCP server.")] = None,
        url: Annotated[Optional[Annotated[str, Field(strict=True, max_length=200)]], Field(description="The url of the MCP server.")] = None,
        image: Optional[StrictStr] = None,
        transport: Optional[TransportEnum] = None,
        credentials: Annotated[Optional[StrictStr], Field(description="Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`")] = None,
        extra_headers: Annotated[Optional[Any], Field(description="Headers to send to the MCP server. Useful for authentication,")] = None,
        platform_key: Optional[StrictStr] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Featured mcp servers will be accessible to all other tenants.")] = None,
        auth_type: Annotated[Optional[Any], Field(description="The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2")] = None,
        is_enabled: Annotated[Optional[StrictBool], Field(description="Whether the MCP server is enabled or not.")] = None,
        created_at: Optional[datetime] = None,
        updated_at: Optional[datetime] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_partial_update

        ViewSet for MCP Servers.  Allows platform admins to list, create, retrieve, update, and delete MCP servers.  Permissions:     - Accessible to tenant admins.

        :param id: A unique integer value identifying this mcp server. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2:
        :type id2: int
        :param platform:
        :type platform: int
        :param name:
        :type name: str
        :param description: A description of the MCP server.
        :type description: str
        :param url: The url of the MCP server.
        :type url: str
        :param image:
        :type image: str
        :param transport:
        :type transport: TransportEnum
        :param credentials: Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`
        :type credentials: str
        :param extra_headers: Headers to send to the MCP server. Useful for authentication,
        :type extra_headers: object
        :param platform_key:
        :type platform_key: str
        :param is_featured: Featured mcp servers will be accessible to all other tenants.
        :type is_featured: bool
        :param auth_type: The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2
        :type auth_type: AuthTypeEnum
        :param is_enabled: Whether the MCP server is enabled or not.
        :type is_enabled: bool
        :param created_at:
        :type created_at: datetime
        :param updated_at:
        :type updated_at: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            platform=platform,
            name=name,
            description=description,
            url=url,
            image=image,
            transport=transport,
            credentials=credentials,
            extra_headers=extra_headers,
            platform_key=platform_key,
            is_featured=is_featured,
            auth_type=auth_type,
            is_enabled=is_enabled,
            created_at=created_at,
            updated_at=updated_at,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MCPServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        platform,
        name,
        description,
        url,
        image,
        transport,
        credentials,
        extra_headers,
        platform_key,
        is_featured,
        auth_type,
        is_enabled,
        created_at,
        updated_at,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if platform is not None:
            _form_params.append(('platform', platform))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if url is not None:
            _form_params.append(('url', url))
        if image is not None:
            _form_params.append(('image', image))
        if transport is not None:
            _form_params.append(('transport', transport))
        if credentials is not None:
            _form_params.append(('credentials', credentials))
        if extra_headers is not None:
            _form_params.append(('extra_headers', extra_headers))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if is_featured is not None:
            _form_params.append(('is_featured', is_featured))
        if auth_type is not None:
            _form_params.append(('auth_type', auth_type))
        if is_enabled is not None:
            _form_params.append(('is_enabled', is_enabled))
        if created_at is not None:
            _form_params.append(('created_at', created_at))
        if updated_at is not None:
            _form_params.append(('updated_at', updated_at))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mcp server.")],
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_retrieve

        ViewSet for MCP Servers.  Allows platform admins to list, create, retrieve, update, and delete MCP servers.  Permissions:     - Accessible to tenant admins.

        :param id: A unique integer value identifying this mcp server. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MCPServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mcp_servers_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this mcp server.")],
        org: StrictStr,
        user_id: StrictStr,
        id2: StrictInt,
        platform: StrictInt,
        name: Annotated[str, Field(strict=True, max_length=255)],
        url: Annotated[str, Field(strict=True, max_length=200, description="The url of the MCP server.")],
        platform_key: StrictStr,
        created_at: datetime,
        updated_at: datetime,
        description: Annotated[Optional[StrictStr], Field(description="A description of the MCP server.")] = None,
        image: Optional[StrictStr] = None,
        transport: Optional[TransportEnum] = None,
        credentials: Annotated[Optional[StrictStr], Field(description="Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`")] = None,
        extra_headers: Annotated[Optional[Any], Field(description="Headers to send to the MCP server. Useful for authentication,")] = None,
        is_featured: Annotated[Optional[StrictBool], Field(description="Featured mcp servers will be accessible to all other tenants.")] = None,
        auth_type: Annotated[Optional[Any], Field(description="The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2")] = None,
        is_enabled: Annotated[Optional[StrictBool], Field(description="Whether the MCP server is enabled or not.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mcp_servers_update

        ViewSet for MCP Servers.  Allows platform admins to list, create, retrieve, update, and delete MCP servers.  Permissions:     - Accessible to tenant admins.

        :param id: A unique integer value identifying this mcp server. (required)
        :type id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param id2: (required)
        :type id2: int
        :param platform: (required)
        :type platform: int
        :param name: (required)
        :type name: str
        :param url: The url of the MCP server. (required)
        :type url: str
        :param platform_key: (required)
        :type platform_key: str
        :param created_at: (required)
        :type created_at: datetime
        :param updated_at: (required)
        :type updated_at: datetime
        :param description: A description of the MCP server.
        :type description: str
        :param image:
        :type image: str
        :param transport:
        :type transport: TransportEnum
        :param credentials: Authorization credentials to uauthenticate to the mcp server. if provided takes priority over connected service and headers. Token here must be the full authorization value. For example: `<scheme> <credentials>`
        :type credentials: str
        :param extra_headers: Headers to send to the MCP server. Useful for authentication,
        :type extra_headers: object
        :param is_featured: Featured mcp servers will be accessible to all other tenants.
        :type is_featured: bool
        :param auth_type: The type of authentication to use for the MCP server.  * `none` - None * `token` - Token * `oauth2` - Oauth2
        :type auth_type: AuthTypeEnum
        :param is_enabled: Whether the MCP server is enabled or not.
        :type is_enabled: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mcp_servers_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            id2=id2,
            platform=platform,
            name=name,
            url=url,
            platform_key=platform_key,
            created_at=created_at,
            updated_at=updated_at,
            description=description,
            image=image,
            transport=transport,
            credentials=credentials,
            extra_headers=extra_headers,
            is_featured=is_featured,
            auth_type=auth_type,
            is_enabled=is_enabled,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MCPServer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mcp_servers_update_serialize(
        self,
        id,
        org,
        user_id,
        id2,
        platform,
        name,
        url,
        platform_key,
        created_at,
        updated_at,
        description,
        image,
        transport,
        credentials,
        extra_headers,
        is_featured,
        auth_type,
        is_enabled,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if platform is not None:
            _form_params.append(('platform', platform))
        if name is not None:
            _form_params.append(('name', name))
        if description is not None:
            _form_params.append(('description', description))
        if url is not None:
            _form_params.append(('url', url))
        if image is not None:
            _form_params.append(('image', image))
        if transport is not None:
            _form_params.append(('transport', transport))
        if credentials is not None:
            _form_params.append(('credentials', credentials))
        if extra_headers is not None:
            _form_params.append(('extra_headers', extra_headers))
        if platform_key is not None:
            _form_params.append(('platform_key', platform_key))
        if is_featured is not None:
            _form_params.append(('is_featured', is_featured))
        if auth_type is not None:
            _form_params.append(('auth_type', auth_type))
        if is_enabled is not None:
            _form_params.append(('is_enabled', is_enabled))
        if created_at is not None:
            _form_params.append(('created_at', created_at))
        if updated_at is not None:
            _form_params.append(('updated_at', updated_at))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mcp-servers/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memories_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        user_memory_request: UserMemoryRequest,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create memory

        Create memory using the request data

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param user_memory_request: (required)
        :type user_memory_request: UserMemoryRequest
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memories_create_serialize(
            org=org,
            user_id=user_id,
            user_memory_request=user_memory_request,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserMemoryList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memories_create_serialize(
        self,
        org,
        user_id,
        user_memory_request,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_memory_request is not None:
            _body_params = user_memory_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memories_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        category: Annotated[Optional[StrictStr], Field(description="a string of category to filter memories")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="ISO date for end date (optional)")] = None,
        mentor: Annotated[Optional[StrictStr], Field(description="the mentor unique id which the memory is linked to")] = None,
        mode: Annotated[Optional[StrictStr], Field(description="mode which the memory applies to. can be `guided`, `regular` or `all`")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        platform: Annotated[Optional[StrictStr], Field(description="the platform which the memory is linked to")] = None,
        session: Annotated[Optional[StrictStr], Field(description="the session id which the memory is linked to")] = None,
        start_date: Annotated[Optional[StrictStr], Field(description="ISO date for start date (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memories_list

        Retrieve a list of memories based on filter conditions.  Returns:     Response: A paginated list of memories.     Put your queries using the parameters in the query parameters. For example, to search a mentor's regular mode memory, use the following url:     ```     https://base.manager.iblai.app/api/ai-mentor/orgs/your-org/users/your-user/memories/?mentor=f81fc856-fd8f-4e6b-9d3b-72aa68279c40&mode=regular     ```  Raises:     NotFound: If the query is invalid.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param category: a string of category to filter memories
        :type category: str
        :param end_date: ISO date for end date (optional)
        :type end_date: str
        :param mentor: the mentor unique id which the memory is linked to
        :type mentor: str
        :param mode: mode which the memory applies to. can be `guided`, `regular` or `all`
        :type mode: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param platform: the platform which the memory is linked to
        :type platform: str
        :param session: the session id which the memory is linked to
        :type session: str
        :param start_date: ISO date for start date (optional)
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memories_list_serialize(
            org=org,
            user_id=user_id,
            category=category,
            end_date=end_date,
            mentor=mentor,
            mode=mode,
            page=page,
            page_size=page_size,
            platform=platform,
            session=session,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserMemoryList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memories_list_serialize(
        self,
        org,
        user_id,
        category,
        end_date,
        mentor,
        mode,
        page,
        page_size,
        platform,
        session,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if category is not None:
            
            _query_params.append(('category', category))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if mode is not None:
            
            _query_params.append(('mode', mode))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform is not None:
            
            _query_params.append(('platform', platform))
            
        if session is not None:
            
            _query_params.append(('session', session))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_categories_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_categories_retrieve

        Use the this endpoint to get all memory categories: ``` GET /api/ai-mentor/orgs/main/users/your-user/memory-categories/ ``` Sample response ``` {\"categories\": [\"lessons_learned\", \"knowledge_gaps\", \"help_requests\", \"personal_information\"]} ```

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_categories_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_categories_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory-categories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_destroy(
        self,
        memory_unique_id_or_name: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_destroy

        Mixin that includes the StudentTokenAuthentication and IsAdminUserOrStudent

        :param memory_unique_id_or_name: (required)
        :type memory_unique_id_or_name: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_destroy_serialize(
            memory_unique_id_or_name=memory_unique_id_or_name,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_destroy_serialize(
        self,
        memory_unique_id_or_name,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if memory_unique_id_or_name is not None:
            _path_params['memory_unique_id_or_name'] = memory_unique_id_or_name
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory/{memory_unique_id_or_name}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_entries_create(
        self,
        entry_unique_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        user_memory_entry: UserMemoryEntry,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_entries_create

        ``` POST /api/ai-mentor/orgs/main/users/your-user/memory-entries/f03642ce-b7ec-42a2-8604-7aa0c6e7b6d3/ ``` Sample request: ``` {\"value\": \"this is new memory value!\", \"key\": \"new key!\",} ``` Sample response: ``` {   \"unique_id\": \"f03642ce-b7ec-42a2-8604-7aa0c6e7b6d3\",   \"key\": \"new key\",   \"value\": \"this is new memory value!\",   \"inserted_at\": \"2025-09-01T14:43:36.232705+00:00\",   \"updated_at\": \"2025-09-01T14:43:36.232712+00:00\",   \"expires_at\": null,   \"category\": \"lessons_learned\" } ```

        :param entry_unique_id: (required)
        :type entry_unique_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param user_memory_entry: (required)
        :type user_memory_entry: UserMemoryEntry
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_entries_create_serialize(
            entry_unique_id=entry_unique_id,
            org=org,
            user_id=user_id,
            user_memory_entry=user_memory_entry,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserMemoryEntry",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_entries_create_serialize(
        self,
        entry_unique_id,
        org,
        user_id,
        user_memory_entry,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entry_unique_id is not None:
            _path_params['entry_unique_id'] = entry_unique_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_memory_entry is not None:
            _body_params = user_memory_entry


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory-entries/{entry_unique_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_entries_destroy(
        self,
        entry_unique_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_entries_destroy

        Delete a memory entry or a category of memories.  Sample request (memory entry unique id) ``` DELETE /api/ai-mentor/orgs/main/users/your-user/memory-entries/d66e4962-2406-48b1-9b73-14ff30138872/ ``` Sample request (category name) ``` DELETE /api/ai-mentor/orgs/main/users/your-user/memory-entries/lessons_learned/ ```

        :param entry_unique_id: (required)
        :type entry_unique_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_entries_destroy_serialize(
            entry_unique_id=entry_unique_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_entries_destroy_serialize(
        self,
        entry_unique_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entry_unique_id is not None:
            _path_params['entry_unique_id'] = entry_unique_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory-entries/{entry_unique_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_entries_retrieve(
        self,
        entry_unique_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_entries_retrieve

        Get a memory entry's detail by its unique id.  Sample response ``` {   \"unique_id\": \"f03642ce-b7ec-42a2-8604-7aa0c6e7b6d3\",   \"key\": \"new key\",   \"value\": \"this is new memory value!\",   \"inserted_at\": \"2025-09-01T14:43:36.232705+00:00\",   \"updated_at\": \"2025-09-01T14:43:36.232712+00:00\",   \"expires_at\": null,   \"category\": \"lessons_learned\" } ```

        :param entry_unique_id: (required)
        :type entry_unique_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_entries_retrieve_serialize(
            entry_unique_id=entry_unique_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserMemoryEntry",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_entries_retrieve_serialize(
        self,
        entry_unique_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entry_unique_id is not None:
            _path_params['entry_unique_id'] = entry_unique_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory-entries/{entry_unique_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_filter_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_filter_retrieve

        Use the this endpoint to get all memory categories: ``` GET /api/ai-mentor/orgs/main/users/your-user/memory-filter/ ``` Sample response ``` {   \"categories\": [     \"lessons_learned\",     \"knowledge_gaps\",     \"help_requests\",     \"personal_information\"   ],   \"users\": [     {       \"username\": \"animashaun1vie\",       \"email\": \"animashaun1vie@gmail.com\",       \"lti_email\": \"\"     }   ] } ```

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_filter_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_filter_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory-filter/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_memory_retrieve(
        self,
        memory_unique_id_or_name: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_memory_retrieve

        Mixin that includes the StudentTokenAuthentication and IsAdminUserOrStudent

        :param memory_unique_id_or_name: (required)
        :type memory_unique_id_or_name: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_memory_retrieve_serialize(
            memory_unique_id_or_name=memory_unique_id_or_name,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserMemory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_memory_retrieve_serialize(
        self,
        memory_unique_id_or_name,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if memory_unique_id_or_name is not None:
            _path_params['memory_unique_id_or_name'] = memory_unique_id_or_name
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/memory/{memory_unique_id_or_name}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_audience_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_audience: MentorAudience,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_audience_create

        Create a new mentor audience.  Accessible to tenant admins only.  Returns:     - 201: Created mentor audience.     - 401: Unauthorized.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_audience: (required)
        :type mentor_audience: MentorAudience
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_audience_create_serialize(
            org=org,
            user_id=user_id,
            mentor_audience=mentor_audience,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "MentorAudience",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_audience_create_serialize(
        self,
        org,
        user_id,
        mentor_audience,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_audience is not None:
            _body_params = mentor_audience


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/audience/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_audience_destroy(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_audience_destroy

        Delete a mentor audience.  Accessible to tenant admins only.  Returns:     - 204: No content.     - 400: Bad request if audience name is missing.     - 404: Not found if audience does not exist.     - 401: Unauthorized.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_audience_destroy_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '404': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_audience_destroy_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/audience/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_audience_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_audience_list

        Retrieve the list of mentor audiences.  Returns:     - 200: List of mentor audiences.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_audience_list_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MentorAudience]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_audience_list_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/audience/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_categories_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        mentor_category_create: MentorCategoryCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_categories_create

        Create a new mentor category.  Accessible only to tenant admins.  Returns:     200: Details of the created mentor category.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param mentor_category_create: (required)
        :type mentor_category_create: MentorCategoryCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_categories_create_serialize(
            org=org,
            user_id=user_id,
            mentor_category_create=mentor_category_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorCategory",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_categories_create_serialize(
        self,
        org,
        user_id,
        mentor_category_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mentor_category_create is not None:
            _body_params = mentor_category_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/categories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_categories_destroy(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_categories_destroy

        Delete a mentor category.  Accessible only to tenant admins.  Returns:     204: \"No content\" when Delete succeeded.     400: Bad request data received

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_categories_destroy_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_categories_destroy_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/categories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_categories_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_categories_list

        Retrieve a list of mentor categories.  Returns:     200: A list of mentor categories.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_categories_list_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MentorCategory]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_categories_list_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor/categories/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_feedback_create_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        user_chat_feedback: UserChatFeedback,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_feedback_create_create

        Create a new user chat feedback entry.  Args:     request: The HTTP request containing the feedback data.     org: The organization/tenant identifier.  Returns:     Response: The created feedback entry.  Raises:     BadRequest: If the provided data is invalid or the mentor does not exist.

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param user_chat_feedback: (required)
        :type user_chat_feedback: UserChatFeedback
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_feedback_create_create_serialize(
            org=org,
            user_id=user_id,
            user_chat_feedback=user_chat_feedback,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UserChatFeedback",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_mentor_orgs_users_mentor_feedback_create_create_serialize(
        self,
        org,
        user_id,
        user_chat_feedback,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_chat_feedback is not None:
            _body_params = user_chat_feedback


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-mentor/orgs/{org}/users/{user_id}/mentor-feedback/create/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def ai_mentor_orgs_users_mentor_feedback_retrieve(
        self,
        feedback_id: StrictInt,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_mentor_orgs_users_mentor_feedback_retrieve

        Retrieve details of a specific user chat feedback entry.  Args:     request: The HTTP request.     org: The organization/tenant identifier.     feedback_id: The ID of the feedback entry to retrieve.  Returns:     Response: The feedback entry details.  Raises:     NotFound: If the specified feedback entry does not exist.

        :param feedback_id: (required)
        :type feedback_id: int
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_mentor_orgs_users_mentor_feedback_retrieve_serialize(
            feedback_id=feedback_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _h