# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.mentor_search_response import MentorSearchResponse
from iblai.models.platform_prompt import PlatformPrompt
from iblai.models.platform_prompt_response import PlatformPromptResponse
from iblai.models.v2_global_mentor_search_response import V2GlobalMentorSearchResponse
from iblai.models.v2_personalized_mentors_response import V2PersonalizedMentorsResponse
from iblai.models.v2_recommendation_response import V2RecommendationResponse

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class AiSearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def ai_search_orgs_users_my_mentors_retrieve(
        self,
        org: StrictStr,
        username: StrictStr,
        audience: Annotated[Optional[List[StrictStr]], Field(description="Filter by target audience")] = None,
        category: Annotated[Optional[List[StrictStr]], Field(description="Filter by mentor category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter mentors created by specific user")] = None,
        featured: Annotated[Optional[StrictBool], Field(description="Filter by featured status")] = None,
        id: Annotated[Optional[StrictInt], Field(description="Retrieve a specific mentor by ID")] = None,
        include_main_public_mentors: Annotated[Optional[StrictBool], Field(description="Include public mentors from main tenant")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        llm: Annotated[Optional[List[StrictStr]], Field(description="Filter by language model type")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by ('created_at', 'recently_accessed_at')")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter mentors by name or description")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        unique_id: Annotated[Optional[UUID], Field(description="Retrieve a specific mentor by UUID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """ai_search_orgs_users_my_mentors_retrieve

        Handle GET requests for my mentors.

        :param org: (required)
        :type org: str
        :param username: (required)
        :type username: str
        :param audience: Filter by target audience
        :type audience: List[str]
        :param category: Filter by mentor category
        :type category: List[str]
        :param created_by: Filter mentors created by specific user
        :type created_by: str
        :param featured: Filter by featured status
        :type featured: bool
        :param id: Retrieve a specific mentor by ID
        :type id: int
        :param include_main_public_mentors: Include public mentors from main tenant
        :type include_main_public_mentors: bool
        :param limit: Number of results per page
        :type limit: int
        :param llm: Filter by language model type
        :type llm: List[str]
        :param offset: Starting position for pagination
        :type offset: int
        :param order_by: Field to sort results by ('created_at', 'recently_accessed_at')
        :type order_by: str
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param query: Search term to filter mentors by name or description
        :type query: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param unique_id: Retrieve a specific mentor by UUID
        :type unique_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._ai_search_orgs_users_my_mentors_retrieve_serialize(
            org=org,
            username=username,
            audience=audience,
            category=category,
            created_by=created_by,
            featured=featured,
            id=id,
            include_main_public_mentors=include_main_public_mentors,
            limit=limit,
            llm=llm,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            query=query,
            tags=tags,
            tenant=tenant,
            unique_id=unique_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorSearchResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _ai_search_orgs_users_my_mentors_retrieve_serialize(
        self,
        org,
        username,
        audience,
        category,
        created_by,
        featured,
        id,
        include_main_public_mentors,
        limit,
        llm,
        offset,
        order_by,
        order_direction,
        query,
        tags,
        tenant,
        unique_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'audience': 'multi',
            'category': 'multi',
            'llm': 'multi',
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if featured is not None:
            
            _query_params.append(('featured', featured))
            
        if id is not None:
            
            _query_params.append(('id', id))
            
        if include_main_public_mentors is not None:
            
            _query_params.append(('include_main_public_mentors', include_main_public_mentors))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm is not None:
            
            _query_params.append(('llm', llm))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if unique_id is not None:
            
            _query_params.append(('unique_id', unique_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/orgs/{org}/users/{username}/my-mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_platform_prompt(
        self,
        platform_prompt: Optional[PlatformPrompt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new recommendation prompt

        Create a new recommendation prompt for a platform and SPA.

        :param platform_prompt:
        :type platform_prompt: PlatformPrompt
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_platform_prompt_serialize(
            platform_prompt=platform_prompt,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PlatformPromptResponse",
            '400': None,
            '401': None,
            '403': None,
            '409': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_platform_prompt_serialize(
        self,
        platform_prompt,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_prompt is not None:
            _body_params = platform_prompt


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-search/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_platform_prompt2(
        self,
        platform_prompt: Optional[PlatformPrompt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new recommendation prompt

        Create a new recommendation prompt for a platform and SPA.

        :param platform_prompt:
        :type platform_prompt: PlatformPrompt
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_platform_prompt2_serialize(
            platform_prompt=platform_prompt,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PlatformPromptResponse",
            '400': None,
            '401': None,
            '403': None,
            '409': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_platform_prompt2_serialize(
        self,
        platform_prompt,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_prompt is not None:
            _body_params = platform_prompt


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/ai-search/recommendation/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_platform_prompt(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a recommendation prompt

        Delete a recommendation prompt by ID. Must provide platform_key to verify ownership. This permanently removes the prompt.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_platform_prompt_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_platform_prompt_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-search/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_platform_prompt2(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a recommendation prompt

        Delete a recommendation prompt by ID. Must provide platform_key to verify ownership. This permanently removes the prompt.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_platform_prompt2_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_platform_prompt2_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/ai-search/recommendation/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_platform_prompts(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List recommendation prompts for a platform

        Get all recommendation prompts for a specific platform. Optionally filter by SPA URL or recommendation type.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_platform_prompts_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[PlatformPromptResponse]",
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_platform_prompts_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_platform_prompts2(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List recommendation prompts for a platform

        Get all recommendation prompts for a specific platform. Optionally filter by SPA URL or recommendation type.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_platform_prompts2_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[PlatformPromptResponse]",
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_platform_prompts2_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/recommendation/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_platform_prompt(
        self,
        platform_prompt: Optional[PlatformPrompt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an existing recommendation prompt

        Update an existing prompt by ID. Must provide platform_key to verify ownership.

        :param platform_prompt:
        :type platform_prompt: PlatformPrompt
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_platform_prompt_serialize(
            platform_prompt=platform_prompt,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformPromptResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_platform_prompt_serialize(
        self,
        platform_prompt,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_prompt is not None:
            _body_params = platform_prompt


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-search/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_platform_prompt2(
        self,
        platform_prompt: Optional[PlatformPrompt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an existing recommendation prompt

        Update an existing prompt by ID. Must provide platform_key to verify ownership.

        :param platform_prompt:
        :type platform_prompt: PlatformPrompt
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_platform_prompt2_serialize(
            platform_prompt=platform_prompt,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformPromptResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_platform_prompt2_serialize(
        self,
        platform_prompt,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_prompt is not None:
            _body_params = platform_prompt


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/ai-search/recommendation/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v2_course_recommendations(
        self,
        assessment_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Assessment ID if triggered by assessment completion")] = None,
        context_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Context type for recommendation (e.g., 'assessment_completed', 'milestone_reached')")] = None,
        difficulty_levels: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter recommendations to specific difficulty levels (CSV)")] = None,
        domains: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter recommendations to specific domains (CSV)")] = None,
        include_main_catalog: Annotated[Optional[StrictBool], Field(description="Include items from 'main' tenant catalog IN ADDITION TO platform-specific catalog. By default, only platform-specific data is returned (tenant isolation). Set to True to also include shared 'main' tenant resources.")] = None,
        include_user_history: Annotated[Optional[StrictBool], Field(description="Include user's learning history (completed courses, topics) in the RAG search query. Helps find content that builds on their background.")] = None,
        include_user_skills: Annotated[Optional[StrictBool], Field(description="Include user's skills and badges in the RAG search query. Helps personalize results based on what the user already knows.")] = None,
        k: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=5)]], Field(description="Number of similar items to retrieve via RAG per tenant (before filtering). Higher values give more options but may be slower.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=20, strict=True, ge=1)]], Field(description="Number of course recommendations to return (max 20)")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination (starts at 1)")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of recommendations per page (max 100)")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for tenant-scoped recommendations")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform org identifier (optional - avoids database lookup if provided)")] = None,
        ranking_prompt: Annotated[Optional[StrictStr], Field(description="Custom prompt for LLM ranking (only if ranking_strategy='custom'). Define how the LLM should evaluate and order the recommendations.")] = None,
        ranking_strategy: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Strategy for LLM ranking. Only used if use_llm_ranking=True.  * `relevance` - Rank by relevance and value (default) * `difficulty` - Rank by difficulty progression * `personalized` - Personalize to user context and goals * `custom` - Use custom ranking prompt")] = None,
        recommendation_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Type of resource to recommend. Catalog types (courses/programs/resources/pathways) will use the platform's 'catalog' prompt category if configured.  * `mentors` - Mentor Recommendations * `courses` - Course Recommendations * `programs` - Program Recommendations * `resources` - Resource Recommendations * `pathways` - Pathway Recommendations")] = None,
        search_terms: Annotated[Optional[StrictStr], Field(description="Search terms to find similar content (e.g., 'leadership', 'data science'). Used to build the RAG query.")] = None,
        spa_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Frontend/SPA identifier (e.g., 'catalog.example.com', 'mentor-ai.ibl.com'). Used to retrieve the correct prompt for that specific frontend. Auto-detected from HTTP_REFERER if not provided.")] = None,
        trigger_source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="What triggered this recommendation request")] = None,
        use_llm_ranking: Annotated[Optional[StrictBool], Field(description="Use LLM to rank and personalize RAG results. Adds AI-generated reasoning but increases cost and latency. Only applies if use_rag_search=True.")] = None,
        use_rag_search: Annotated[Optional[StrictBool], Field(description="Use RAG similarity search instead of full LLM catalog review. Faster and more cost-effective. Set to False for legacy LLM-only behavior.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generate AI-driven course recommendations

                 Generate personalized course recommendations using AI that considers the user's         learning history, organizational goals, and available courses.          **Authentication Required:**         - User must be authenticated         - Platform key must be provided         - User must have access to the specified platform          **How It Works:**         1. Fetches tenant's custom recommendation prompt (if configured)         2. Analyzes user's course completion history and performance         3. Reviews available course catalog         4. Uses AI to match courses to user's needs and organizational goals         5. Returns 3-5 courses with clear explanations          **Tenant Prompts:**         Each organization can configure custom prompts that guide recommendations.         For example: \"Prioritize leadership for sales roles\" or \"Focus on technical skills.\"          **Use Cases:**         - Manual recommendation requests by users         - Post-assessment recommendations         - Milestone-triggered suggestions         - Learning path planning         

        :param assessment_id: Assessment ID if triggered by assessment completion
        :type assessment_id: str
        :param context_type: Context type for recommendation (e.g., 'assessment_completed', 'milestone_reached')
        :type context_type: str
        :param difficulty_levels: Filter recommendations to specific difficulty levels (CSV)
        :type difficulty_levels: str
        :param domains: Filter recommendations to specific domains (CSV)
        :type domains: str
        :param include_main_catalog: Include items from 'main' tenant catalog IN ADDITION TO platform-specific catalog. By default, only platform-specific data is returned (tenant isolation). Set to True to also include shared 'main' tenant resources.
        :type include_main_catalog: bool
        :param include_user_history: Include user's learning history (completed courses, topics) in the RAG search query. Helps find content that builds on their background.
        :type include_user_history: bool
        :param include_user_skills: Include user's skills and badges in the RAG search query. Helps personalize results based on what the user already knows.
        :type include_user_skills: bool
        :param k: Number of similar items to retrieve via RAG per tenant (before filtering). Higher values give more options but may be slower.
        :type k: int
        :param limit: Number of course recommendations to return (max 20)
        :type limit: int
        :param page: Page number for pagination (starts at 1)
        :type page: int
        :param page_size: Number of recommendations per page (max 100)
        :type page_size: int
        :param platform_key: Platform key for tenant-scoped recommendations
        :type platform_key: str
        :param platform_org: Platform org identifier (optional - avoids database lookup if provided)
        :type platform_org: str
        :param ranking_prompt: Custom prompt for LLM ranking (only if ranking_strategy='custom'). Define how the LLM should evaluate and order the recommendations.
        :type ranking_prompt: str
        :param ranking_strategy: Strategy for LLM ranking. Only used if use_llm_ranking=True.  * `relevance` - Rank by relevance and value (default) * `difficulty` - Rank by difficulty progression * `personalized` - Personalize to user context and goals * `custom` - Use custom ranking prompt
        :type ranking_strategy: str
        :param recommendation_type: Type of resource to recommend. Catalog types (courses/programs/resources/pathways) will use the platform's 'catalog' prompt category if configured.  * `mentors` - Mentor Recommendations * `courses` - Course Recommendations * `programs` - Program Recommendations * `resources` - Resource Recommendations * `pathways` - Pathway Recommendations
        :type recommendation_type: str
        :param search_terms: Search terms to find similar content (e.g., 'leadership', 'data science'). Used to build the RAG query.
        :type search_terms: str
        :param spa_url: Frontend/SPA identifier (e.g., 'catalog.example.com', 'mentor-ai.ibl.com'). Used to retrieve the correct prompt for that specific frontend. Auto-detected from HTTP_REFERER if not provided.
        :type spa_url: str
        :param trigger_source: What triggered this recommendation request
        :type trigger_source: str
        :param use_llm_ranking: Use LLM to rank and personalize RAG results. Adds AI-generated reasoning but increases cost and latency. Only applies if use_rag_search=True.
        :type use_llm_ranking: bool
        :param use_rag_search: Use RAG similarity search instead of full LLM catalog review. Faster and more cost-effective. Set to False for legacy LLM-only behavior.
        :type use_rag_search: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v2_course_recommendations_serialize(
            assessment_id=assessment_id,
            context_type=context_type,
            difficulty_levels=difficulty_levels,
            domains=domains,
            include_main_catalog=include_main_catalog,
            include_user_history=include_user_history,
            include_user_skills=include_user_skills,
            k=k,
            limit=limit,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            ranking_prompt=ranking_prompt,
            ranking_strategy=ranking_strategy,
            recommendation_type=recommendation_type,
            search_terms=search_terms,
            spa_url=spa_url,
            trigger_source=trigger_source,
            use_llm_ranking=use_llm_ranking,
            use_rag_search=use_rag_search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2RecommendationResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_course_recommendations_serialize(
        self,
        assessment_id,
        context_type,
        difficulty_levels,
        domains,
        include_main_catalog,
        include_user_history,
        include_user_skills,
        k,
        limit,
        page,
        page_size,
        platform_key,
        platform_org,
        ranking_prompt,
        ranking_strategy,
        recommendation_type,
        search_terms,
        spa_url,
        trigger_source,
        use_llm_ranking,
        use_rag_search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if assessment_id is not None:
            
            _query_params.append(('assessment_id', assessment_id))
            
        if context_type is not None:
            
            _query_params.append(('context_type', context_type))
            
        if difficulty_levels is not None:
            
            _query_params.append(('difficulty_levels', difficulty_levels))
            
        if domains is not None:
            
            _query_params.append(('domains', domains))
            
        if include_main_catalog is not None:
            
            _query_params.append(('include_main_catalog', include_main_catalog))
            
        if include_user_history is not None:
            
            _query_params.append(('include_user_history', include_user_history))
            
        if include_user_skills is not None:
            
            _query_params.append(('include_user_skills', include_user_skills))
            
        if k is not None:
            
            _query_params.append(('k', k))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if ranking_prompt is not None:
            
            _query_params.append(('ranking_prompt', ranking_prompt))
            
        if ranking_strategy is not None:
            
            _query_params.append(('ranking_strategy', ranking_strategy))
            
        if recommendation_type is not None:
            
            _query_params.append(('recommendation_type', recommendation_type))
            
        if search_terms is not None:
            
            _query_params.append(('search_terms', search_terms))
            
        if spa_url is not None:
            
            _query_params.append(('spa_url', spa_url))
            
        if trigger_source is not None:
            
            _query_params.append(('trigger_source', trigger_source))
            
        if use_llm_ranking is not None:
            
            _query_params.append(('use_llm_ranking', use_llm_ranking))
            
        if use_rag_search is not None:
            
            _query_params.append(('use_rag_search', use_rag_search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/recommendations/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v2_global_mentor_search(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="Platform key for RBAC enforcement")],
        category: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor category filter")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter mentors created by specific user (for personalized search)")] = None,
        include_main_public_mentors: Annotated[Optional[StrictBool], Field(description="Include main tenant public mentors (VIEWABLE_BY_ANYONE) when true")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=1)]], Field(description="Number of results per page")] = None,
        llm: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="LLM provider filter")] = None,
        offset: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of results to skip")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query for mentors")] = None,
        subjects: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor subject filter")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Tenant key(s) (CSV)")] = None,
        types: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor type filter")] = None,
        visibility: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor visibility filter (viewable_by_anyone, viewable_by_tenant_students, viewable_by_tenant_admins)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search and filter AI mentors across the platform

                 Search and filter AI mentors with support for comprehensive filtering, pagination, and detailed mentor information.         This endpoint supports both anonymous and authenticated users with different access levels.          **Anonymous Users:**         - Access to public mentors only (VIEWABLE_BY_ANYONE)         - Limited search capabilities         - No personalization          **Authenticated Users:**         - Full access based on platform permissions (scoped to requested platform)         - Personalized results         - Access to tenant-specific mentors          **Available Filters:**         - `query`: Search term to filter mentors by name or description         - `tenant`: Filter by tenant/organization platform key(s)         - `category`: Filter by mentor category (comma-separated)         - `subjects`: Filter by mentor subject (comma-separated)         - `types`: Filter by mentor type (comma-separated)         - `llm`: Filter by LLM provider (comma-separated, e.g., GPT-4, Claude)         - `visibility`: Filter by visibility level (comma-separated: viewable_by_anyone, viewable_by_tenant_students, viewable_by_tenant_admins)         - `created_by`: Filter mentors created by specific user (for personalized search)         - `include_main_public_mentors`: Include main tenant public mentors          **Facets:**         The response includes facets with aggregated counts for all filterable attributes:         - categories, subjects, types, llm_providers, visibility         All facet values can be used as filter parameters in subsequent requests.          Notes:         - Detail view is removed; use the ibl_ai_mentor app for mentor details         - include_main_public_mentors=true shows only VIEWABLE_BY_ANYONE mentors from the main tenant across tenants         - For authenticated requests, platform_key is required when username is provided         - Frontend uses `llm` parameter name (backend maps to `llm_provider` automatically)         

        :param platform_key: Platform key for RBAC enforcement (required)
        :type platform_key: str
        :param category: Mentor category filter
        :type category: str
        :param created_by: Filter mentors created by specific user (for personalized search)
        :type created_by: str
        :param include_main_public_mentors: Include main tenant public mentors (VIEWABLE_BY_ANYONE) when true
        :type include_main_public_mentors: bool
        :param limit: Number of results per page
        :type limit: int
        :param llm: LLM provider filter
        :type llm: str
        :param offset: Number of results to skip
        :type offset: int
        :param query: Search query for mentors
        :type query: str
        :param subjects: Mentor subject filter
        :type subjects: str
        :param tenant: Tenant key(s) (CSV)
        :type tenant: str
        :param types: Mentor type filter
        :type types: str
        :param visibility: Mentor visibility filter (viewable_by_anyone, viewable_by_tenant_students, viewable_by_tenant_admins)
        :type visibility: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v2_global_mentor_search_serialize(
            platform_key=platform_key,
            category=category,
            created_by=created_by,
            include_main_public_mentors=include_main_public_mentors,
            limit=limit,
            llm=llm,
            offset=offset,
            query=query,
            subjects=subjects,
            tenant=tenant,
            types=types,
            visibility=visibility,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2GlobalMentorSearchResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_global_mentor_search_serialize(
        self,
        platform_key,
        category,
        created_by,
        include_main_public_mentors,
        limit,
        llm,
        offset,
        query,
        subjects,
        tenant,
        types,
        visibility,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if include_main_public_mentors is not None:
            
            _query_params.append(('include_main_public_mentors', include_main_public_mentors))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm is not None:
            
            _query_params.append(('llm', llm))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if subjects is not None:
            
            _query_params.append(('subjects', subjects))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if types is not None:
            
            _query_params.append(('types', types))
            
        if visibility is not None:
            
            _query_params.append(('visibility', visibility))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v2_personalized_mentors(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="Platform key for authentication")],
        audience: Annotated[Optional[List[StrictStr]], Field(description="Filter by audience")] = None,
        category: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Mentor category filter")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        llm_providers: Annotated[Optional[List[StrictStr]], Field(description="Filter by LLM provider")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Number of results to skip")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort by")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction  * `asc` - asc * `desc` - desc")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query for personalized mentors")] = None,
        return_facet: Annotated[Optional[StrictBool], Field(description="Include facet data in response")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for authentication (required for unauthenticated requests)")] = None,
        visibility: Annotated[Optional[List[StrictStr]], Field(description="Filter by visibility")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get mentors created by a specific user

                 Get mentors created by a specific user within a given organization/platform.         This endpoint provides a personalized view of the user's own mentors with         support for filtering, pagination, and detailed mentor information.          **Authentication Required:**         - username: Required for personalized mentor access         - platform_key: Required for tenant-specific content          **Features:**         - User's own mentors only         - Personalization data (access counts, last used)         - Filtering and faceted search         - Pagination support         - Detail and list views         

        :param platform_key: Platform key for authentication (required)
        :type platform_key: str
        :param audience: Filter by audience
        :type audience: List[str]
        :param category: Mentor category filter
        :type category: str
        :param limit: Number of results per page
        :type limit: int
        :param llm_providers: Filter by LLM provider
        :type llm_providers: List[str]
        :param offset: Number of results to skip
        :type offset: int
        :param order_by: Field to sort by
        :type order_by: str
        :param order_direction: Sort direction  * `asc` - asc * `desc` - desc
        :type order_direction: str
        :param query: Search query for personalized mentors
        :type query: str
        :param return_facet: Include facet data in response
        :type return_facet: bool
        :param tags: Filter by tags
        :type tags: List[str]
        :param username: Username for authentication (required for unauthenticated requests)
        :type username: str
        :param visibility: Filter by visibility
        :type visibility: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v2_personalized_mentors_serialize(
            platform_key=platform_key,
            audience=audience,
            category=category,
            limit=limit,
            llm_providers=llm_providers,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            query=query,
            return_facet=return_facet,
            tags=tags,
            username=username,
            visibility=visibility,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2PersonalizedMentorsResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_personalized_mentors_serialize(
        self,
        platform_key,
        audience,
        category,
        limit,
        llm_providers,
        offset,
        order_by,
        order_direction,
        query,
        return_facet,
        tags,
        username,
        visibility,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'audience': 'multi',
            'llm_providers': 'multi',
            'tags': 'multi',
            'visibility': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm_providers is not None:
            
            _query_params.append(('llm_providers', llm_providers))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if return_facet is not None:
            
            _query_params.append(('return_facet', return_facet))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if visibility is not None:
            
            _query_params.append(('visibility', visibility))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/ai-search/personalized-mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


