# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.blank_course_invitation_create import BlankCourseInvitationCreate
from iblai.models.blank_platform_invitation_create import BlankPlatformInvitationCreate
from iblai.models.blank_program_invitation_create import BlankProgramInvitationCreate
from iblai.models.block_skill_point_info_request import BlockSkillPointInfoRequest
from iblai.models.bulk_course_invitation_create import BulkCourseInvitationCreate
from iblai.models.bulk_course_invitation_response import BulkCourseInvitationResponse
from iblai.models.bulk_platform_invitation_create import BulkPlatformInvitationCreate
from iblai.models.bulk_platform_invitation_response import BulkPlatformInvitationResponse
from iblai.models.bulk_program_invitation_create import BulkProgramInvitationCreate
from iblai.models.bulk_program_invitation_response import BulkProgramInvitationResponse
from iblai.models.bulk_suggestion_response import BulkSuggestionResponse
from iblai.models.catalog_auto_increment_response import CatalogAutoIncrementResponse
from iblai.models.catalog_auto_increment_update_request import CatalogAutoIncrementUpdateRequest
from iblai.models.course import Course
from iblai.models.course_access_request_create import CourseAccessRequestCreate
from iblai.models.course_access_request_detail import CourseAccessRequestDetail
from iblai.models.course_access_request_status_response import CourseAccessRequestStatusResponse
from iblai.models.course_access_request_update import CourseAccessRequestUpdate
from iblai.models.course_completion import CourseCompletion
from iblai.models.course_create_update import CourseCreateUpdate
from iblai.models.course_delete_response import CourseDeleteResponse
from iblai.models.course_enrollment_search_response import CourseEnrollmentSearchResponse
from iblai.models.course_group_suggestion_create import CourseGroupSuggestionCreate
from iblai.models.course_group_suggestion_detail import CourseGroupSuggestionDetail
from iblai.models.course_invitation_create import CourseInvitationCreate
from iblai.models.course_invitation_detail import CourseInvitationDetail
from iblai.models.course_invitation_redemption import CourseInvitationRedemption
from iblai.models.course_license_assignment_create import CourseLicenseAssignmentCreate
from iblai.models.course_license_assignment_detail import CourseLicenseAssignmentDetail
from iblai.models.course_license_create import CourseLicenseCreate
from iblai.models.course_license_detail import CourseLicenseDetail
from iblai.models.course_license_group_assignment_create import CourseLicenseGroupAssignmentCreate
from iblai.models.course_license_group_assignment_detail import CourseLicenseGroupAssignmentDetail
from iblai.models.course_license_update import CourseLicenseUpdate
from iblai.models.course_metadata_search_request import CourseMetadataSearchRequest
from iblai.models.course_metadata_update_request import CourseMetadataUpdateRequest
from iblai.models.course_review_info_response import CourseReviewInfoResponse
from iblai.models.course_review_paginated_response import CourseReviewPaginatedResponse
from iblai.models.course_review_request import CourseReviewRequest
from iblai.models.course_review_response import CourseReviewResponse
from iblai.models.course_skill_point_info_request import CourseSkillPointInfoRequest
from iblai.models.course_suggestion_bulk_create import CourseSuggestionBulkCreate
from iblai.models.course_suggestion_create import CourseSuggestionCreate
from iblai.models.course_suggestion_detail import CourseSuggestionDetail
from iblai.models.desired_role import DesiredRole
from iblai.models.desired_role_create_update_request import DesiredRoleCreateUpdateRequest
from iblai.models.desired_skill import DesiredSkill
from iblai.models.desired_skill_create_update_request import DesiredSkillCreateUpdateRequest
from iblai.models.paginated_course_access_request import PaginatedCourseAccessRequest
from iblai.models.paginated_course_group_suggestion import PaginatedCourseGroupSuggestion
from iblai.models.paginated_course_invitation import PaginatedCourseInvitation
from iblai.models.paginated_course_license import PaginatedCourseLicense
from iblai.models.paginated_course_license_assignment import PaginatedCourseLicenseAssignment
from iblai.models.paginated_course_license_group_assignment import PaginatedCourseLicenseGroupAssignment
from iblai.models.paginated_course_suggestion import PaginatedCourseSuggestion
from iblai.models.paginated_pathway_group_suggestion import PaginatedPathwayGroupSuggestion
from iblai.models.paginated_pathway_suggestion import PaginatedPathwaySuggestion
from iblai.models.paginated_platform_invitation import PaginatedPlatformInvitation
from iblai.models.paginated_platform_license import PaginatedPlatformLicense
from iblai.models.paginated_program_group_suggestion import PaginatedProgramGroupSuggestion
from iblai.models.paginated_program_invitation import PaginatedProgramInvitation
from iblai.models.paginated_program_license import PaginatedProgramLicense
from iblai.models.paginated_program_license_assignment import PaginatedProgramLicenseAssignment
from iblai.models.paginated_program_license_group_assignment import PaginatedProgramLicenseGroupAssignment
from iblai.models.paginated_program_suggestion import PaginatedProgramSuggestion
from iblai.models.paginated_skill import PaginatedSkill
from iblai.models.paginated_user_license import PaginatedUserLicense
from iblai.models.paginated_user_license_assignment import PaginatedUserLicenseAssignment
from iblai.models.paginated_user_license_group_assignment import PaginatedUserLicenseGroupAssignment
from iblai.models.pathway import Pathway
from iblai.models.pathway_completion_response import PathwayCompletionResponse
from iblai.models.pathway_create_update_request import PathwayCreateUpdateRequest
from iblai.models.pathway_delete_response import PathwayDeleteResponse
from iblai.models.pathway_enrollment import PathwayEnrollment
from iblai.models.pathway_enrollment_plus import PathwayEnrollmentPlus
from iblai.models.pathway_enrollment_request import PathwayEnrollmentRequest
from iblai.models.pathway_group_suggestion_create import PathwayGroupSuggestionCreate
from iblai.models.pathway_group_suggestion_detail import PathwayGroupSuggestionDetail
from iblai.models.pathway_self_enrollment_request import PathwaySelfEnrollmentRequest
from iblai.models.pathway_suggestion_bulk_create import PathwaySuggestionBulkCreate
from iblai.models.pathway_suggestion_create import PathwaySuggestionCreate
from iblai.models.pathway_suggestion_detail import PathwaySuggestionDetail
from iblai.models.platform_invitation_create import PlatformInvitationCreate
from iblai.models.platform_invitation_detail import PlatformInvitationDetail
from iblai.models.platform_invitation_redemption import PlatformInvitationRedemption
from iblai.models.platform_license_create import PlatformLicenseCreate
from iblai.models.platform_license_detail import PlatformLicenseDetail
from iblai.models.platform_license_update import PlatformLicenseUpdate
from iblai.models.platform_skill_point_bulk_request import PlatformSkillPointBulkRequest
from iblai.models.platform_skill_point_bulk_response import PlatformSkillPointBulkResponse
from iblai.models.platform_skill_point_group_request import PlatformSkillPointGroupRequest
from iblai.models.platform_skill_point_request import PlatformSkillPointRequest
from iblai.models.platform_skill_point_response import PlatformSkillPointResponse
from iblai.models.program import Program
from iblai.models.program_completion_response import ProgramCompletionResponse
from iblai.models.program_create_update_request import ProgramCreateUpdateRequest
from iblai.models.program_delete_response import ProgramDeleteResponse
from iblai.models.program_enrollment import ProgramEnrollment
from iblai.models.program_enrollment_plus import ProgramEnrollmentPlus
from iblai.models.program_enrollment_search_response import ProgramEnrollmentSearchResponse
from iblai.models.program_group_suggestion_create import ProgramGroupSuggestionCreate
from iblai.models.program_group_suggestion_detail import ProgramGroupSuggestionDetail
from iblai.models.program_invitation_create import ProgramInvitationCreate
from iblai.models.program_invitation_detail import ProgramInvitationDetail
from iblai.models.program_invitation_redemption import ProgramInvitationRedemption
from iblai.models.program_license_assignment_create import ProgramLicenseAssignmentCreate
from iblai.models.program_license_assignment_detail import ProgramLicenseAssignmentDetail
from iblai.models.program_license_create_detail import ProgramLicenseCreateDetail
from iblai.models.program_license_detail import ProgramLicenseDetail
from iblai.models.program_license_group_assignment_create import ProgramLicenseGroupAssignmentCreate
from iblai.models.program_license_group_assignment_detail import ProgramLicenseGroupAssignmentDetail
from iblai.models.program_license_update_detail import ProgramLicenseUpdateDetail
from iblai.models.program_metadata_request import ProgramMetadataRequest
from iblai.models.program_metadata_response import ProgramMetadataResponse
from iblai.models.program_review import ProgramReview
from iblai.models.program_review_info_response import ProgramReviewInfoResponse
from iblai.models.program_review_paginated_response import ProgramReviewPaginatedResponse
from iblai.models.program_review_request import ProgramReviewRequest
from iblai.models.program_search import ProgramSearch
from iblai.models.program_suggestion_bulk_create import ProgramSuggestionBulkCreate
from iblai.models.program_suggestion_create import ProgramSuggestionCreate
from iblai.models.program_suggestion_detail import ProgramSuggestionDetail
from iblai.models.reported_role import ReportedRole
from iblai.models.reported_role_create_update_request import ReportedRoleCreateUpdateRequest
from iblai.models.reported_skill import ReportedSkill
from iblai.models.reported_skill_create_update_request import ReportedSkillCreateUpdateRequest
from iblai.models.resource import Resource
from iblai.models.resource_completion import ResourceCompletion
from iblai.models.resource_completion_request import ResourceCompletionRequest
from iblai.models.resource_delete_response import ResourceDeleteResponse
from iblai.models.role import Role
from iblai.models.role_create_update_request import RoleCreateUpdateRequest
from iblai.models.skill import Skill
from iblai.models.skill_create_update_request import SkillCreateUpdateRequest
from iblai.models.user_license_assignment_create import UserLicenseAssignmentCreate
from iblai.models.user_license_assignment_detail import UserLicenseAssignmentDetail
from iblai.models.user_license_create import UserLicenseCreate
from iblai.models.user_license_detail import UserLicenseDetail
from iblai.models.user_license_group_assignment_create import UserLicenseGroupAssignmentCreate
from iblai.models.user_license_group_assignment_detail import UserLicenseGroupAssignmentDetail
from iblai.models.user_license_update import UserLicenseUpdate

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class CatalogApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def catalog_access_requests_course_manage_create(
        self,
        course_access_request_update: CourseAccessRequestUpdate,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        reviewed: Annotated[Optional[StrictBool], Field(description="Filter by reviewed status")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_access_requests_course_manage_create

        Update an existing access request (approve/reject)

        :param course_access_request_update: (required)
        :type course_access_request_update: CourseAccessRequestUpdate
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param reviewed: Filter by reviewed status
        :type reviewed: bool
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_access_requests_course_manage_create_serialize(
            course_access_request_update=course_access_request_update,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            reviewed=reviewed,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseAccessRequestDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_access_requests_course_manage_create_serialize(
        self,
        course_access_request_update,
        page,
        page_size,
        platform_key,
        platform_org,
        reviewed,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if reviewed is not None:
            
            _query_params.append(('reviewed', reviewed))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_access_request_update is not None:
            _body_params = course_access_request_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/access_requests/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_access_requests_course_manage_retrieve(
        self,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        reviewed: Annotated[Optional[StrictBool], Field(description="Filter by reviewed status")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_access_requests_course_manage_retrieve

        Retrieve a paginated list of access requests

        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param reviewed: Filter by reviewed status
        :type reviewed: bool
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_access_requests_course_manage_retrieve_serialize(
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            reviewed=reviewed,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseAccessRequest",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_access_requests_course_manage_retrieve_serialize(
        self,
        page,
        page_size,
        platform_key,
        platform_org,
        reviewed,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if reviewed is not None:
            
            _query_params.append(('reviewed', reviewed))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/access_requests/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_access_requests_course_request_create(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the course")],
        course_access_request_create: CourseAccessRequestCreate,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_access_requests_course_request_create

        Create a new access request for a course

        :param course_id: The unique identifier for the course (required)
        :type course_id: str
        :param course_access_request_create: (required)
        :type course_access_request_create: CourseAccessRequestCreate
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_access_requests_course_request_create_serialize(
            course_id=course_id,
            course_access_request_create=course_access_request_create,
            platform_key=platform_key,
            platform_org=platform_org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseAccessRequestDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_access_requests_course_request_create_serialize(
        self,
        course_id,
        course_access_request_create,
        platform_key,
        platform_org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_access_request_create is not None:
            _body_params = course_access_request_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/access_requests/course/request/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_access_requests_course_request_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the course")],
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_access_requests_course_request_retrieve

        Check if the user has an active access request for a course

        :param course_id: The unique identifier for the course (required)
        :type course_id: str
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_access_requests_course_request_retrieve_serialize(
            course_id=course_id,
            platform_key=platform_key,
            platform_org=platform_org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseAccessRequestStatusResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_access_requests_course_request_retrieve_serialize(
        self,
        course_id,
        platform_key,
        platform_org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/access_requests/course/request/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_conditionals_course_eligibility_retrieve(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_conditionals_course_eligibility_retrieve

        GET Retrieve prerequisite eligibility info for user/course  Params: user_id/username course_id

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_conditionals_course_eligibility_retrieve_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_conditionals_course_eligibility_retrieve_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/conditionals/course/eligibility/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_conditionals_course_prerequisites_manage_bulk_create(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_conditionals_course_prerequisites_manage_bulk_create

        Prerequisite bulk management view  Params: course_id  rules key_only

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_conditionals_course_prerequisites_manage_bulk_create_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_conditionals_course_prerequisites_manage_bulk_create_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/conditionals/course/prerequisites/manage/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_conditionals_course_prerequisites_manage_retrieve(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_conditionals_course_prerequisites_manage_retrieve

        GET Retrieve prerequisite info for course  Params: course_id  key_only

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_conditionals_course_prerequisites_manage_retrieve_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_conditionals_course_prerequisites_manage_retrieve_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/conditionals/course/prerequisites/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_courses_create(
        self,
        course_create_update: CourseCreateUpdate,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their unique identifier")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their associated organization")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their slug (case-insensitive)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_courses_create

        Add or update a course in the database.

        :param course_create_update: (required)
        :type course_create_update: CourseCreateUpdate
        :param course_id: Filter courses by their unique identifier
        :type course_id: str
        :param org: Filter courses by their associated organization
        :type org: str
        :param slug: Filter courses by their slug (case-insensitive)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_courses_create_serialize(
            course_create_update=course_create_update,
            course_id=course_id,
            org=org,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Course",
            '201': "Course",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_courses_create_serialize(
        self,
        course_create_update,
        course_id,
        org,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_create_update is not None:
            _body_params = course_create_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/courses/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_courses_destroy(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the course to be deleted")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their associated organization")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their slug (case-insensitive)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_courses_destroy

        Remove a course from the database.

        :param course_id: The unique identifier for the course to be deleted (required)
        :type course_id: str
        :param org: Filter courses by their associated organization
        :type org: str
        :param slug: Filter courses by their slug (case-insensitive)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_courses_destroy_serialize(
            course_id=course_id,
            org=org,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseDeleteResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_courses_destroy_serialize(
        self,
        course_id,
        org,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/courses/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_courses_list(
        self,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their unique identifier")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their associated organization")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter courses by their slug (case-insensitive)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_courses_list

        Retrieve courses matching specified filters.

        :param course_id: Filter courses by their unique identifier
        :type course_id: str
        :param org: Filter courses by their associated organization
        :type org: str
        :param slug: Filter courses by their slug (case-insensitive)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_courses_list_serialize(
            course_id=course_id,
            org=org,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Course]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_courses_list_serialize(
        self,
        course_id,
        org,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/courses/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_eligibility_courses_check_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="Course ID to check eligibility for")],
        local_only: Annotated[Optional[StrictBool], Field(description="Whether to check eligibility only within the local organization")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization of the course")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID to check eligibility for")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username to check eligibility for")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_eligibility_courses_check_retrieve

        Check whether a user is eligible to enroll in a specific course.

        :param course_id: Course ID to check eligibility for (required)
        :type course_id: str
        :param local_only: Whether to check eligibility only within the local organization
        :type local_only: bool
        :param org: Organization of the course
        :type org: str
        :param user_id: User ID to check eligibility for
        :type user_id: str
        :param username: Username to check eligibility for
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_eligibility_courses_check_retrieve_serialize(
            course_id=course_id,
            local_only=local_only,
            org=org,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_eligibility_courses_check_retrieve_serialize(
        self,
        course_id,
        local_only,
        org,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if local_only is not None:
            
            _query_params.append(('local_only', local_only))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/eligibility/courses/check/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_eligibility_courses_list(
        self,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter eligible courses by organization")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter eligible courses")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID to check eligibility for")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username to check eligibility for")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_eligibility_courses_list

        List courses that a user is eligible for.

        :param org: Filter eligible courses by organization
        :type org: str
        :param query: Search term to filter eligible courses
        :type query: str
        :param user_id: User ID to check eligibility for
        :type user_id: str
        :param username: Username to check eligibility for
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_eligibility_courses_list_serialize(
            org=org,
            query=query,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Course]",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_eligibility_courses_list_serialize(
        self,
        org,
        query,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/eligibility/courses/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_courses_search_retrieve(
        self,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by course ID")] = None,
        course_name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by course name (partial match)")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by user email")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by course slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by user ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_courses_search_retrieve

        API View for searching course enrollments.  This endpoint allows searching for course enrollments based on various filters such as user ID, username, email, course ID, slug, organization, and platform key. Results are paginated and include detailed enrollment information.  Query Parameters:     user_id (str, optional): Filter enrollments by user ID     username (str, optional): Filter enrollments by username     email (str, optional): Filter enrollments by user email     course_id (str, optional): Filter enrollments by course ID     slug (str, optional): Filter enrollments by course slug     org (str, optional): Filter enrollments by organization     platform_key (str, optional): Filter enrollments by platform key     course_name (str, optional): Filter enrollments by course name (partial match)     include_default_platform (bool, optional): Include enrollments from default platform     sort (str, optional): Field to sort results by (default: '-id')     page (int, optional): Page number for pagination     page_size (int, optional): Number of items per page  Methods:     GET: Search for course enrollments with filtering and pagination  Returns:     GET: A paginated JSON response containing course enrollments:         {             \"count\": 42,             \"next\": \"https://api.example.com/api/catalog/enrollment/courses/search/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"user_id\": 123,                     \"username\": \"student1\",                     \"email\": \"student1@example.com\",                     \"course_id\": \"course-v1:org+course+run\",                     \"active\": true,                     \"created\": \"2023-01-15T10:30:00Z\",                     \"started\": \"2023-01-15T10:30:00Z\",                     \"ended\": null,                     \"expired\": null,                     \"metadata\": {},                     \"name\": \"John Doe\",                     \"course_name\": \"Introduction to Data Science\"                 },                 ...             ]         }  Error Responses:     400 Bad Request: If required parameters are missing or if enrollment search fails     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin, IsEdxUserReadOnly, or IsPlatformAdminOfUserReadOnly permission     - Users can view their own enrollments     - Platform admins can view enrollments for users in their platform     - DM admins can view all enrollments

        :param course_id: Filter enrollments by course ID
        :type course_id: str
        :param course_name: Filter enrollments by course name (partial match)
        :type course_name: str
        :param email: Filter enrollments by user email
        :type email: str
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param org: Filter enrollments by organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Filter enrollments by platform key
        :type platform_key: str
        :param slug: Filter enrollments by course slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param user_id: Filter enrollments by user ID
        :type user_id: str
        :param username: Filter enrollments by username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_courses_search_retrieve_serialize(
            course_id=course_id,
            course_name=course_name,
            email=email,
            include_default_platform=include_default_platform,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            slug=slug,
            sort=sort,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseEnrollmentSearchResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_courses_search_retrieve_serialize(
        self,
        course_id,
        course_name,
        email,
        include_default_platform,
        org,
        page,
        page_size,
        platform_key,
        slug,
        sort,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if course_name is not None:
            
            _query_params.append(('course_name', course_name))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/enrollment/courses/search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_create(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the pathway")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID for enrollment")] = None,
        pathway_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway key for enrollment")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID for enrollment")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the pathway")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug for enrollment")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        pathway_enrollment_request: Optional[PathwayEnrollmentRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_create

        Log user enrollment with a pathway.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the pathway
        :type org: str
        :param pathway_id: Pathway ID for enrollment
        :type pathway_id: str
        :param pathway_key: Pathway key for enrollment
        :type pathway_key: str
        :param pathway_uuid: Pathway UUID for enrollment
        :type pathway_uuid: str
        :param platform_key: Platform key for the pathway
        :type platform_key: str
        :param slug: Pathway slug for enrollment
        :type slug: str
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param pathway_enrollment_request:
        :type pathway_enrollment_request: PathwayEnrollmentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_create_serialize(
            active=active,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            pathway_id=pathway_id,
            pathway_key=pathway_key,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            pathway_enrollment_request=pathway_enrollment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_create_serialize(
        self,
        active,
        include_default_platform,
        include_metadata,
        org,
        pathway_id,
        pathway_key,
        pathway_uuid,
        platform_key,
        slug,
        user_id,
        username,
        pathway_enrollment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_key is not None:
            
            _query_params.append(('pathway_key', pathway_key))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pathway_enrollment_request is not None:
            _body_params = pathway_enrollment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/enrollment/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the pathway")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID for enrollment")] = None,
        pathway_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway key for enrollment")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID for enrollment")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the pathway")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug for enrollment")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_destroy

        Unenroll from a pathway. Deactivates enrollment.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the pathway
        :type org: str
        :param pathway_id: Pathway ID for enrollment
        :type pathway_id: str
        :param pathway_key: Pathway key for enrollment
        :type pathway_key: str
        :param pathway_uuid: Pathway UUID for enrollment
        :type pathway_uuid: str
        :param platform_key: Platform key for the pathway
        :type platform_key: str
        :param slug: Pathway slug for enrollment
        :type slug: str
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_destroy_serialize(
            active=active,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            pathway_id=pathway_id,
            pathway_key=pathway_key,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_destroy_serialize(
        self,
        active,
        include_default_platform,
        include_metadata,
        org,
        pathway_id,
        pathway_key,
        pathway_uuid,
        platform_key,
        slug,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_key is not None:
            
            _query_params.append(('pathway_key', pathway_key))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/enrollment/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the pathway")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID for enrollment")] = None,
        pathway_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway key for enrollment")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID for enrollment")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the pathway")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug for enrollment")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_retrieve

        Search pathway enrollments. Requires user_id or username and pathway_id or slug.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the pathway
        :type org: str
        :param pathway_id: Pathway ID for enrollment
        :type pathway_id: str
        :param pathway_key: Pathway key for enrollment
        :type pathway_key: str
        :param pathway_uuid: Pathway UUID for enrollment
        :type pathway_uuid: str
        :param platform_key: Platform key for the pathway
        :type platform_key: str
        :param slug: Pathway slug for enrollment
        :type slug: str
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_retrieve_serialize(
            active=active,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            pathway_id=pathway_id,
            pathway_key=pathway_key,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollmentPlus",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_retrieve_serialize(
        self,
        active,
        include_default_platform,
        include_metadata,
        org,
        pathway_id,
        pathway_key,
        pathway_uuid,
        platform_key,
        slug,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_key is not None:
            
            _query_params.append(('pathway_key', pathway_key))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/enrollment/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_search_retrieve(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_search_retrieve

        Search pathway enrollments based on user or pathway identifiers. Returns paginated enrollment results.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_search_retrieve_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollmentPlus",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_search_retrieve_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/enrollment/pathways/search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_self_create(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the pathway")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID for self-enrollment")] = None,
        pathway_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway key for self-enrollment")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the pathway")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug for self-enrollment")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for self-enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for self-enrollment")] = None,
        pathway_self_enrollment_request: Optional[PathwaySelfEnrollmentRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_self_create

        Log user enrollment with a pathway.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param org: Organization for the pathway
        :type org: str
        :param pathway_id: Pathway ID for self-enrollment
        :type pathway_id: str
        :param pathway_key: Pathway key for self-enrollment
        :type pathway_key: str
        :param platform_key: Platform key for the pathway
        :type platform_key: str
        :param slug: Pathway slug for self-enrollment
        :type slug: str
        :param user_id: User ID for self-enrollment
        :type user_id: str
        :param username: Username for self-enrollment
        :type username: str
        :param pathway_self_enrollment_request:
        :type pathway_self_enrollment_request: PathwaySelfEnrollmentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_self_create_serialize(
            active=active,
            org=org,
            pathway_id=pathway_id,
            pathway_key=pathway_key,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            pathway_self_enrollment_request=pathway_self_enrollment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_self_create_serialize(
        self,
        active,
        org,
        pathway_id,
        pathway_key,
        platform_key,
        slug,
        user_id,
        username,
        pathway_self_enrollment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_key is not None:
            
            _query_params.append(('pathway_key', pathway_key))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pathway_self_enrollment_request is not None:
            _body_params = pathway_self_enrollment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/enrollment/pathways/self/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_pathways_self_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the pathway")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID for self-enrollment")] = None,
        pathway_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway key for self-enrollment")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the pathway")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug for self-enrollment")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for self-enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for self-enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_pathways_self_destroy

        Unenroll from a pathway. Deactivates enrollment.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param org: Organization for the pathway
        :type org: str
        :param pathway_id: Pathway ID for self-enrollment
        :type pathway_id: str
        :param pathway_key: Pathway key for self-enrollment
        :type pathway_key: str
        :param platform_key: Platform key for the pathway
        :type platform_key: str
        :param slug: Pathway slug for self-enrollment
        :type slug: str
        :param user_id: User ID for self-enrollment
        :type user_id: str
        :param username: Username for self-enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_pathways_self_destroy_serialize(
            active=active,
            org=org,
            pathway_id=pathway_id,
            pathway_key=pathway_key,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_pathways_self_destroy_serialize(
        self,
        active,
        org,
        pathway_id,
        pathway_key,
        platform_key,
        slug,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_key is not None:
            
            _query_params.append(('pathway_key', pathway_key))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/enrollment/pathways/self/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_create(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        expired: Annotated[Optional[datetime], Field(description="Date when enrollment expires")] = None,
        ignore_expiration: Annotated[Optional[StrictBool], Field(description="Whether to ignore expiration during unenrollment")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID for enrollment")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key for enrollment")] = None,
        program_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program type (standard, platform, custom)")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug for enrollment")] = None,
        started: Annotated[Optional[datetime], Field(description="Date when enrollment started")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        program_enrollment_plus: Optional[ProgramEnrollmentPlus] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_create

        Log user enrollment with a program.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param expired: Date when enrollment expires
        :type expired: datetime
        :param ignore_expiration: Whether to ignore expiration during unenrollment
        :type ignore_expiration: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the program
        :type org: str
        :param platform_key: Platform key for the program
        :type platform_key: str
        :param program_id: Program ID for enrollment
        :type program_id: str
        :param program_key: Program key for enrollment
        :type program_key: str
        :param program_type: Program type (standard, platform, custom)
        :type program_type: str
        :param slug: Program slug for enrollment
        :type slug: str
        :param started: Date when enrollment started
        :type started: datetime
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param program_enrollment_plus:
        :type program_enrollment_plus: ProgramEnrollmentPlus
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_create_serialize(
            active=active,
            expired=expired,
            ignore_expiration=ignore_expiration,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            platform_key=platform_key,
            program_id=program_id,
            program_key=program_key,
            program_type=program_type,
            slug=slug,
            started=started,
            user_id=user_id,
            username=username,
            program_enrollment_plus=program_enrollment_plus,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_create_serialize(
        self,
        active,
        expired,
        ignore_expiration,
        include_default_platform,
        include_metadata,
        org,
        platform_key,
        program_id,
        program_key,
        program_type,
        slug,
        started,
        user_id,
        username,
        program_enrollment_plus,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if expired is not None:
            if isinstance(expired, datetime):
                _query_params.append(
                    (
                        'expired',
                        expired.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expired', expired))
            
        if ignore_expiration is not None:
            
            _query_params.append(('ignore_expiration', ignore_expiration))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if started is not None:
            if isinstance(started, datetime):
                _query_params.append(
                    (
                        'started',
                        started.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started', started))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_enrollment_plus is not None:
            _body_params = program_enrollment_plus


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/enrollment/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        expired: Annotated[Optional[datetime], Field(description="Date when enrollment expires")] = None,
        ignore_expiration: Annotated[Optional[StrictBool], Field(description="Whether to ignore expiration during unenrollment")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID for enrollment")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key for enrollment")] = None,
        program_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program type (standard, platform, custom)")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug for enrollment")] = None,
        started: Annotated[Optional[datetime], Field(description="Date when enrollment started")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_destroy

        Unenroll from a program. Deactivates enrollment.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param expired: Date when enrollment expires
        :type expired: datetime
        :param ignore_expiration: Whether to ignore expiration during unenrollment
        :type ignore_expiration: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the program
        :type org: str
        :param platform_key: Platform key for the program
        :type platform_key: str
        :param program_id: Program ID for enrollment
        :type program_id: str
        :param program_key: Program key for enrollment
        :type program_key: str
        :param program_type: Program type (standard, platform, custom)
        :type program_type: str
        :param slug: Program slug for enrollment
        :type slug: str
        :param started: Date when enrollment started
        :type started: datetime
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_destroy_serialize(
            active=active,
            expired=expired,
            ignore_expiration=ignore_expiration,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            platform_key=platform_key,
            program_id=program_id,
            program_key=program_key,
            program_type=program_type,
            slug=slug,
            started=started,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_destroy_serialize(
        self,
        active,
        expired,
        ignore_expiration,
        include_default_platform,
        include_metadata,
        org,
        platform_key,
        program_id,
        program_key,
        program_type,
        slug,
        started,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if expired is not None:
            if isinstance(expired, datetime):
                _query_params.append(
                    (
                        'expired',
                        expired.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expired', expired))
            
        if ignore_expiration is not None:
            
            _query_params.append(('ignore_expiration', ignore_expiration))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if started is not None:
            if isinstance(started, datetime):
                _query_params.append(
                    (
                        'started',
                        started.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started', started))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/enrollment/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        expired: Annotated[Optional[datetime], Field(description="Date when enrollment expires")] = None,
        ignore_expiration: Annotated[Optional[StrictBool], Field(description="Whether to ignore expiration during unenrollment")] = None,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="Include metadata in the response")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID for enrollment")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key for enrollment")] = None,
        program_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program type (standard, platform, custom)")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug for enrollment")] = None,
        started: Annotated[Optional[datetime], Field(description="Date when enrollment started")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_retrieve

        Search program enrollments. Requires user_id or username and program_id or slug.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param expired: Date when enrollment expires
        :type expired: datetime
        :param ignore_expiration: Whether to ignore expiration during unenrollment
        :type ignore_expiration: bool
        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param include_metadata: Include metadata in the response
        :type include_metadata: bool
        :param org: Organization for the program
        :type org: str
        :param platform_key: Platform key for the program
        :type platform_key: str
        :param program_id: Program ID for enrollment
        :type program_id: str
        :param program_key: Program key for enrollment
        :type program_key: str
        :param program_type: Program type (standard, platform, custom)
        :type program_type: str
        :param slug: Program slug for enrollment
        :type slug: str
        :param started: Date when enrollment started
        :type started: datetime
        :param user_id: User ID for enrollment
        :type user_id: str
        :param username: Username for enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_retrieve_serialize(
            active=active,
            expired=expired,
            ignore_expiration=ignore_expiration,
            include_default_platform=include_default_platform,
            include_metadata=include_metadata,
            org=org,
            platform_key=platform_key,
            program_id=program_id,
            program_key=program_key,
            program_type=program_type,
            slug=slug,
            started=started,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramEnrollmentPlus",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_retrieve_serialize(
        self,
        active,
        expired,
        ignore_expiration,
        include_default_platform,
        include_metadata,
        org,
        platform_key,
        program_id,
        program_key,
        program_type,
        slug,
        started,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if expired is not None:
            if isinstance(expired, datetime):
                _query_params.append(
                    (
                        'expired',
                        expired.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expired', expired))
            
        if ignore_expiration is not None:
            
            _query_params.append(('ignore_expiration', ignore_expiration))
            
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if include_metadata is not None:
            
            _query_params.append(('include_metadata', include_metadata))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if started is not None:
            if isinstance(started, datetime):
                _query_params.append(
                    (
                        'started',
                        started.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started', started))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/enrollment/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_search_retrieve(
        self,
        include_default_platform: Annotated[Optional[StrictBool], Field(description="Include enrollments from default platform")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by platform key")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by program ID")] = None,
        program_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by program type (standard, platform, custom)")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by program slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by user ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter enrollments by username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_search_retrieve

        Search program enrollments based on user or program identifiers. Returns paginated enrollment results.

        :param include_default_platform: Include enrollments from default platform
        :type include_default_platform: bool
        :param org: Filter enrollments by organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Filter enrollments by platform key
        :type platform_key: str
        :param program_id: Filter enrollments by program ID
        :type program_id: str
        :param program_type: Filter by program type (standard, platform, custom)
        :type program_type: str
        :param slug: Filter enrollments by program slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param user_id: Filter enrollments by user ID
        :type user_id: str
        :param username: Filter enrollments by username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_search_retrieve_serialize(
            include_default_platform=include_default_platform,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            program_id=program_id,
            program_type=program_type,
            slug=slug,
            sort=sort,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramEnrollmentSearchResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_search_retrieve_serialize(
        self,
        include_default_platform,
        org,
        page,
        page_size,
        platform_key,
        program_id,
        program_type,
        slug,
        sort,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include_default_platform is not None:
            
            _query_params.append(('include_default_platform', include_default_platform))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/enrollment/programs/search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_self_create(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        expired: Annotated[Optional[datetime], Field(description="Date when enrollment expires")] = None,
        ignore_expiration: Annotated[Optional[StrictBool], Field(description="Whether to ignore expiration during unenrollment")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID for self-enrollment")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key for self-enrollment")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug for self-enrollment")] = None,
        started: Annotated[Optional[datetime], Field(description="Date when enrollment started")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for self-enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for self-enrollment")] = None,
        program_enrollment: Optional[ProgramEnrollment] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_self_create

        Log user enrollment with a program.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param expired: Date when enrollment expires
        :type expired: datetime
        :param ignore_expiration: Whether to ignore expiration during unenrollment
        :type ignore_expiration: bool
        :param org: Organization for the program
        :type org: str
        :param platform_key: Platform key for the program
        :type platform_key: str
        :param program_id: Program ID for self-enrollment
        :type program_id: str
        :param program_key: Program key for self-enrollment
        :type program_key: str
        :param slug: Program slug for self-enrollment
        :type slug: str
        :param started: Date when enrollment started
        :type started: datetime
        :param user_id: User ID for self-enrollment
        :type user_id: str
        :param username: Username for self-enrollment
        :type username: str
        :param program_enrollment:
        :type program_enrollment: ProgramEnrollment
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_self_create_serialize(
            active=active,
            expired=expired,
            ignore_expiration=ignore_expiration,
            org=org,
            platform_key=platform_key,
            program_id=program_id,
            program_key=program_key,
            slug=slug,
            started=started,
            user_id=user_id,
            username=username,
            program_enrollment=program_enrollment,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramEnrollment",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_self_create_serialize(
        self,
        active,
        expired,
        ignore_expiration,
        org,
        platform_key,
        program_id,
        program_key,
        slug,
        started,
        user_id,
        username,
        program_enrollment,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if expired is not None:
            if isinstance(expired, datetime):
                _query_params.append(
                    (
                        'expired',
                        expired.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expired', expired))
            
        if ignore_expiration is not None:
            
            _query_params.append(('ignore_expiration', ignore_expiration))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if started is not None:
            if isinstance(started, datetime):
                _query_params.append(
                    (
                        'started',
                        started.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started', started))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_enrollment is not None:
            _body_params = program_enrollment


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/enrollment/programs/self/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_enrollment_programs_self_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Whether the enrollment should be active")] = None,
        expired: Annotated[Optional[datetime], Field(description="Date when enrollment expires")] = None,
        ignore_expiration: Annotated[Optional[StrictBool], Field(description="Whether to ignore expiration during unenrollment")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization for the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key for the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID for self-enrollment")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key for self-enrollment")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug for self-enrollment")] = None,
        started: Annotated[Optional[datetime], Field(description="Date when enrollment started")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for self-enrollment")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username for self-enrollment")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_enrollment_programs_self_destroy

        Unenroll from a program. Deactivates enrollment.

        :param active: Whether the enrollment should be active
        :type active: bool
        :param expired: Date when enrollment expires
        :type expired: datetime
        :param ignore_expiration: Whether to ignore expiration during unenrollment
        :type ignore_expiration: bool
        :param org: Organization for the program
        :type org: str
        :param platform_key: Platform key for the program
        :type platform_key: str
        :param program_id: Program ID for self-enrollment
        :type program_id: str
        :param program_key: Program key for self-enrollment
        :type program_key: str
        :param slug: Program slug for self-enrollment
        :type slug: str
        :param started: Date when enrollment started
        :type started: datetime
        :param user_id: User ID for self-enrollment
        :type user_id: str
        :param username: Username for self-enrollment
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_enrollment_programs_self_destroy_serialize(
            active=active,
            expired=expired,
            ignore_expiration=ignore_expiration,
            org=org,
            platform_key=platform_key,
            program_id=program_id,
            program_key=program_key,
            slug=slug,
            started=started,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_enrollment_programs_self_destroy_serialize(
        self,
        active,
        expired,
        ignore_expiration,
        org,
        platform_key,
        program_id,
        program_key,
        slug,
        started,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if expired is not None:
            if isinstance(expired, datetime):
                _query_params.append(
                    (
                        'expired',
                        expired.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('expired', expired))
            
        if ignore_expiration is not None:
            
            _query_params.append(('ignore_expiration', ignore_expiration))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if started is not None:
            if isinstance(started, datetime):
                _query_params.append(
                    (
                        'started',
                        started.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('started', started))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/enrollment/programs/self/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_increment_create(
        self,
        catalog_auto_increment_update_request: CatalogAutoIncrementUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_increment_create

        Update auto increment information and retrieve a new ID for a specific platform.

        :param catalog_auto_increment_update_request: (required)
        :type catalog_auto_increment_update_request: CatalogAutoIncrementUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_increment_create_serialize(
            catalog_auto_increment_update_request=catalog_auto_increment_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "int",
            '400': "Dict[str, object]",
            '500': "Dict[str, object]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_increment_create_serialize(
        self,
        catalog_auto_increment_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if catalog_auto_increment_update_request is not None:
            _body_params = catalog_auto_increment_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/increment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_increment_retrieve(
        self,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization identifier")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_increment_retrieve

        Retrieve auto increment information for a specific platform.

        :param key: Platform key identifier
        :type key: str
        :param org: Platform organization identifier
        :type org: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_increment_retrieve_serialize(
            key=key,
            org=org,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CatalogAutoIncrementResponse",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_increment_retrieve_serialize(
        self,
        key,
        org,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if key is not None:
            
            _query_params.append(('key', key))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/increment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_blank_create(
        self,
        blank_course_invitation_create: BlankCourseInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_blank_create

        Create multiple blank course invitations

        :param blank_course_invitation_create: (required)
        :type blank_course_invitation_create: BlankCourseInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_blank_create_serialize(
            blank_course_invitation_create=blank_course_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkCourseInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_blank_create_serialize(
        self,
        blank_course_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if blank_course_invitation_create is not None:
            _body_params = blank_course_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/course/blank/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_bulk_create(
        self,
        bulk_course_invitation_create: BulkCourseInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_bulk_create

        Create multiple course invitations

        :param bulk_course_invitation_create: (required)
        :type bulk_course_invitation_create: BulkCourseInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_bulk_create_serialize(
            bulk_course_invitation_create=bulk_course_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkCourseInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_bulk_create_serialize(
        self,
        bulk_course_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_course_invitation_create is not None:
            _body_params = bulk_course_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/course/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_create(
        self,
        course_invitation_create: CourseInvitationCreate,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by course ID")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_create

        Create a new course invitation

        :param course_invitation_create: (required)
        :type course_invitation_create: CourseInvitationCreate
        :param active: Filter by active status
        :type active: bool
        :param course_id: Filter by course ID
        :type course_id: str
        :param email: Filter by user email
        :type email: str
        :param key: Alternative filter by platform key
        :type key: str
        :param org: Alternative filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param platform_org: Filter by platform organization
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_create_serialize(
            course_invitation_create=course_invitation_create,
            active=active,
            course_id=course_id,
            email=email,
            key=key,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_create_serialize(
        self,
        course_invitation_create,
        active,
        course_id,
        email,
        key,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_invitation_create is not None:
            _body_params = course_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by course ID")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_destroy

        Remove a course invitation: TBD

        :param active: Filter by active status
        :type active: bool
        :param course_id: Filter by course ID
        :type course_id: str
        :param email: Filter by user email
        :type email: str
        :param key: Alternative filter by platform key
        :type key: str
        :param org: Alternative filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param platform_org: Filter by platform organization
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_destroy_serialize(
            active=active,
            course_id=course_id,
            email=email,
            key=key,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_destroy_serialize(
        self,
        active,
        course_id,
        email,
        key,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/invitations/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_redeem_create(
        self,
        course_invitation_redemption: CourseInvitationRedemption,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_redeem_create

        Redeem a blank course invitation

        :param course_invitation_redemption: (required)
        :type course_invitation_redemption: CourseInvitationRedemption
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_redeem_create_serialize(
            course_invitation_redemption=course_invitation_redemption,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_redeem_create_serialize(
        self,
        course_invitation_redemption,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_invitation_redemption is not None:
            _body_params = course_invitation_redemption


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/course/redeem/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_course_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by course ID")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_course_retrieve

        Retrieve a paginated list of course invitations

        :param active: Filter by active status
        :type active: bool
        :param course_id: Filter by course ID
        :type course_id: str
        :param email: Filter by user email
        :type email: str
        :param key: Alternative filter by platform key
        :type key: str
        :param org: Alternative filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param platform_org: Filter by platform organization
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_course_retrieve_serialize(
            active=active,
            course_id=course_id,
            email=email,
            key=key,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseInvitation",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_course_retrieve_serialize(
        self,
        active,
        course_id,
        email,
        key,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/invitations/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_blank_create(
        self,
        blank_platform_invitation_create: BlankPlatformInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_blank_create

        Create multiple blank platform invitations

        :param blank_platform_invitation_create: (required)
        :type blank_platform_invitation_create: BlankPlatformInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_blank_create_serialize(
            blank_platform_invitation_create=blank_platform_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkPlatformInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_blank_create_serialize(
        self,
        blank_platform_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if blank_platform_invitation_create is not None:
            _body_params = blank_platform_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/platform/blank/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_bulk_create(
        self,
        bulk_platform_invitation_create: BulkPlatformInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_bulk_create

        API View for bulk creating platform invitations.  This endpoint allows creating multiple platform invitations in a single request.  Request Parameters:     invitation_data (list, required): List of invitation data objects, each containing:         platform_key (str, required): The platform to create an invitation for         email (str, required): The email address to invite         active (bool, optional): Whether the invitation is active         metadata fields: Any additional parameters will be added as metadata     platform_key (str, required for platform admins): The platform key for permission validation  Methods:     POST: Create multiple platform invitations  Returns:     POST: A JSON response containing the creation results:         {             \"successes\": 5,             \"error_codes\": []         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs during creation  Access Control:     - Requires IsDMAdmin or IsPlatformAdmin permission     - Available to platform administrators and DM admins

        :param bulk_platform_invitation_create: (required)
        :type bulk_platform_invitation_create: BulkPlatformInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_bulk_create_serialize(
            bulk_platform_invitation_create=bulk_platform_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkPlatformInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_bulk_create_serialize(
        self,
        bulk_platform_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_platform_invitation_create is not None:
            _body_params = bulk_platform_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/platform/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_check_retrieve(
        self,
        email: Annotated[str, Field(min_length=1, strict=True, description="The email address to check for active invitations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_check_retrieve

        Check if a user has an active platform invitation

        :param email: The email address to check for active invitations (required)
        :type email: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_check_retrieve_serialize(
            email=email,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_check_retrieve_serialize(
        self,
        email,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if email is not None:
            
            _query_params.append(('email', email))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/invitations/platform/check/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_create(
        self,
        platform_invitation_create: PlatformInvitationCreate,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_create

        Create a new platform invitation

        :param platform_invitation_create: (required)
        :type platform_invitation_create: PlatformInvitationCreate
        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_create_serialize(
            platform_invitation_create=platform_invitation_create,
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_create_serialize(
        self,
        platform_invitation_create,
        active,
        email,
        org,
        page,
        page_size,
        platform_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_invitation_create is not None:
            _body_params = platform_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_destroy

        Remove a platform invitation: TBD

        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_destroy_serialize(
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_destroy_serialize(
        self,
        active,
        email,
        org,
        page,
        page_size,
        platform_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/invitations/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_redeem_create(
        self,
        platform_invitation_redemption: PlatformInvitationRedemption,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_redeem_create

        Redeem a blank platform invitation

        :param platform_invitation_redemption: (required)
        :type platform_invitation_redemption: PlatformInvitationRedemption
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_redeem_create_serialize(
            platform_invitation_redemption=platform_invitation_redemption,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_redeem_create_serialize(
        self,
        platform_invitation_redemption,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_invitation_redemption is not None:
            _body_params = platform_invitation_redemption


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/platform/redeem/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_platform_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_platform_retrieve

        API View for managing platform invitations.  This endpoint allows querying, creating, and deleting platform invitations for users.  Query/Request Parameters:     For GET:         platform_key (str, optional): Filter by platform key         org (str, optional): Filter by platform organization         email (str, optional): Filter by user email         source (str, optional): Filter by invitation source         active (bool, optional): Filter by active status         sort (str, optional): Field to sort results by (default: '-id')         metadata fields: Any additional parameters will be treated as metadata filters      For POST:         platform_key (str, required): The platform to create an invitation for         email (str, required): The email address to invite         active (bool, optional): Whether the invitation is active         metadata fields: Any additional parameters will be added as metadata      For DELETE:         id (int, required): The ID of the invitation to delete         org (str, required): The platform organization for verification  Methods:     GET: Retrieve a paginated list of platform invitations     POST: Create a new platform invitation     DELETE: Remove a platform invitation  Returns:     GET: A paginated JSON response containing platform invitations:         {             \"count\": 10,             \"next\": \"https://example.com/api/catalog/invitations/platform/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"user_id\": 456,                     \"username\": \"username\",                     \"email\": \"user@example.com\",                     \"created\": \"2023-06-15T14:30:00Z\",                     \"started\": \"2023-06-15T14:30:00Z\",                     \"source\": \"source\",                     \"redirect_to\": \"https://example.com\",                     \"expired\": null,                     \"active\": true,                     \"metadata\": {},                     \"platform_key\": \"platform1\"                 },                 ...             ]         }      POST: A JSON response containing the created invitation:         {             \"id\": 123,             \"user_id\": 456,             \"username\": \"username\",             \"email\": \"user@example.com\",             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"source\": \"source\",             \"redirect_to\": \"https://example.com\",             \"expired\": null,             \"active\": true,             \"metadata\": {},             \"platform_key\": \"platform1\"         }      DELETE: A success response with status 200  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the platform or invitation doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin or IsPlatformAdmin permission     - Available to platform administrators and DM admins

        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_platform_retrieve_serialize(
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedPlatformInvitation",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_platform_retrieve_serialize(
        self,
        active,
        email,
        org,
        page,
        page_size,
        platform_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/invitations/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_blank_create(
        self,
        blank_program_invitation_create: BlankProgramInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_blank_create

        API View for creating blank program invitations.  This endpoint allows creating multiple blank program invitations (without user association) that can be redeemed later.  Request Parameters:     program_key (str, required): The program to create invitations for     source (str, required): The source identifier for the invitations     count (int, required): The number of blank invitations to create     metadata fields: Any additional parameters will be added as metadata  Methods:     POST: Create multiple blank program invitations  Returns:     POST: A JSON response containing the creation results:         {             \"successes\": 10,             \"error_codes\": []         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs during creation  Access Control:     - Requires IsDMAdmin or IsPlatformAdminForProgram permission     - Available to DM admins and platform admins for the specific program

        :param blank_program_invitation_create: (required)
        :type blank_program_invitation_create: BlankProgramInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_blank_create_serialize(
            blank_program_invitation_create=blank_program_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkProgramInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_blank_create_serialize(
        self,
        blank_program_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if blank_program_invitation_create is not None:
            _body_params = blank_program_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/program/blank/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_bulk_create(
        self,
        bulk_program_invitation_create: BulkProgramInvitationCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_bulk_create

        API View for bulk creation of program invitations.  This endpoint allows creating multiple program invitations at once.  Request Parameters:     invitation_data (list, required): List of invitation data objects, each containing:         program_key (str, required): The program to create an invitation for         email (str, required): The email address to invite         active (bool, optional): Whether the invitation is active         metadata fields: Any additional parameters will be added as metadata     platform_key (str, required for platform admins): The platform key for permission validation  Methods:     POST: Create multiple program invitations  Returns:     POST: A JSON response containing the creation results:         {             \"successes\": 5,             \"error_codes\": []         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs during creation  Access Control:     - Requires IsDMAdmin or IsPlatformAdmin permission     - Available to platform administrators and DM admins

        :param bulk_program_invitation_create: (required)
        :type bulk_program_invitation_create: BulkProgramInvitationCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_bulk_create_serialize(
            bulk_program_invitation_create=bulk_program_invitation_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkProgramInvitationResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_bulk_create_serialize(
        self,
        bulk_program_invitation_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_program_invitation_create is not None:
            _body_params = bulk_program_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/program/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_create(
        self,
        program_invitation_create: ProgramInvitationCreate,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by program key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_create

        API View for managing program invitations.  This endpoint allows querying, creating, and deleting program invitations for users.  Query/Request Parameters:     For GET:         program_key (str, optional): Filter by program key         org (str, optional): Filter by platform organization         email (str, optional): Filter by user email         source (str, optional): Filter by invitation source         active (bool, optional): Filter by active status         sort (str, optional): Field to sort results by (default: '-id')         metadata fields: Any additional parameters will be treated as metadata filters      For POST:         program_key (str, required): The program to create an invitation for         email (str, required): The email address to invite         active (bool, optional): Whether the invitation is active         metadata fields: Any additional parameters will be added as metadata      For DELETE:         id (int, required): The ID of the invitation to delete         org (str, required): The platform organization for verification  Methods:     GET: Retrieve a paginated list of program invitations     POST: Create a new program invitation     DELETE: Remove a program invitation  Returns:     GET: A paginated JSON response containing program invitations:         {             \"count\": 10,             \"next\": \"https://example.com/api/catalog/invitations/program/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"user_id\": 456,                     \"username\": \"username\",                     \"email\": \"user@example.com\",                     \"created\": \"2023-06-15T14:30:00Z\",                     \"started\": \"2023-06-15T14:30:00Z\",                     \"source\": \"source\",                     \"redirect_to\": \"https://example.com\",                     \"expired\": null,                     \"active\": true,                     \"metadata\": {},                     \"program_key\": \"org+program1\"                 },                 ...             ]         }      POST: A JSON response containing the created invitation:         {             \"id\": 123,             \"user_id\": 456,             \"username\": \"username\",             \"email\": \"user@example.com\",             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"source\": \"source\",             \"redirect_to\": \"https://example.com\",             \"expired\": null,             \"active\": true,             \"metadata\": {},             \"program_key\": \"org+program1\"         }      DELETE: A success response with status 200  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the program or invitation doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin, IsPlatformAdminReadOnly, or IsPlatformAdminForProgram permission     - Read-only access for platform admins, full access for DM admins and program-specific admins

        :param program_invitation_create: (required)
        :type program_invitation_create: ProgramInvitationCreate
        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param program_key: Filter by program key
        :type program_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_create_serialize(
            program_invitation_create=program_invitation_create,
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            program_key=program_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_create_serialize(
        self,
        program_invitation_create,
        active,
        email,
        org,
        page,
        page_size,
        program_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_invitation_create is not None:
            _body_params = program_invitation_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_destroy(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by program key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_destroy

        Remove a program invitation: TBD

        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param program_key: Filter by program key
        :type program_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_destroy_serialize(
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            program_key=program_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_destroy_serialize(
        self,
        active,
        email,
        org,
        page,
        page_size,
        program_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/invitations/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_redeem_create(
        self,
        program_invitation_redemption: ProgramInvitationRedemption,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_redeem_create

        API View for redeeming blank program invitations.  This endpoint allows redeeming a blank program invitation by associating it with a user.  Request Parameters:     program_key (str, required): The program key for the invitation     source (str, required): The source identifier for the invitation     email (str, optional): The email to associate with the invitation     username (str, optional): The username to associate with the invitation     metadata fields: Any additional parameters will be added as metadata  Methods:     POST: Redeem a blank program invitation  Returns:     POST: A JSON response containing the redeemed invitation:         {             \"id\": 123,             \"user_id\": 456,             \"username\": \"username\",             \"email\": \"user@example.com\",             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"source\": \"source\",             \"redirect_to\": \"https://example.com\",             \"expired\": null,             \"active\": true,             \"metadata\": {},             \"program_key\": \"org+program1\"         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If no blank invitation is available     500 Internal Server Error: If an unexpected error occurs during redemption  Access Control:     - Requires IsDMAdmin or IsPlatformAdminForProgram permission     - Available to DM admins and platform admins for the specific program

        :param program_invitation_redemption: (required)
        :type program_invitation_redemption: ProgramInvitationRedemption
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_redeem_create_serialize(
            program_invitation_redemption=program_invitation_redemption,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramInvitationDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_redeem_create_serialize(
        self,
        program_invitation_redemption,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_invitation_redemption is not None:
            _body_params = program_invitation_redemption


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/invitations/program/redeem/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_invitations_program_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by user email")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by program key")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by invitation source")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by username")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Whether to include verbose output")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_invitations_program_retrieve

        API View for managing program invitations.  This endpoint allows querying, creating, and deleting program invitations for users.  Query/Request Parameters:     For GET:         program_key (str, optional): Filter by program key         org (str, optional): Filter by platform organization         email (str, optional): Filter by user email         source (str, optional): Filter by invitation source         active (bool, optional): Filter by active status         sort (str, optional): Field to sort results by (default: '-id')         metadata fields: Any additional parameters will be treated as metadata filters      For POST:         program_key (str, required): The program to create an invitation for         email (str, required): The email address to invite         active (bool, optional): Whether the invitation is active         metadata fields: Any additional parameters will be added as metadata      For DELETE:         id (int, required): The ID of the invitation to delete         org (str, required): The platform organization for verification  Methods:     GET: Retrieve a paginated list of program invitations     POST: Create a new program invitation     DELETE: Remove a program invitation  Returns:     GET: A paginated JSON response containing program invitations:         {             \"count\": 10,             \"next\": \"https://example.com/api/catalog/invitations/program/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"user_id\": 456,                     \"username\": \"username\",                     \"email\": \"user@example.com\",                     \"created\": \"2023-06-15T14:30:00Z\",                     \"started\": \"2023-06-15T14:30:00Z\",                     \"source\": \"source\",                     \"redirect_to\": \"https://example.com\",                     \"expired\": null,                     \"active\": true,                     \"metadata\": {},                     \"program_key\": \"org+program1\"                 },                 ...             ]         }      POST: A JSON response containing the created invitation:         {             \"id\": 123,             \"user_id\": 456,             \"username\": \"username\",             \"email\": \"user@example.com\",             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"source\": \"source\",             \"redirect_to\": \"https://example.com\",             \"expired\": null,             \"active\": true,             \"metadata\": {},             \"program_key\": \"org+program1\"         }      DELETE: A success response with status 200  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the program or invitation doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin, IsPlatformAdminReadOnly, or IsPlatformAdminForProgram permission     - Read-only access for platform admins, full access for DM admins and program-specific admins

        :param active: Filter by active status
        :type active: bool
        :param email: Filter by user email
        :type email: str
        :param org: Filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param program_key: Filter by program key
        :type program_key: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by invitation source
        :type source: str
        :param username: Filter by username
        :type username: str
        :param verbose: Whether to include verbose output
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_invitations_program_retrieve_serialize(
            active=active,
            email=email,
            org=org,
            page=page,
            page_size=page_size,
            program_key=program_key,
            sort=sort,
            source=source,
            username=username,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProgramInvitation",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_invitations_program_retrieve_serialize(
        self,
        active,
        email,
        org,
        page,
        page_size,
        program_key,
        sort,
        source,
        username,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/invitations/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        course_license_assignment_create: CourseLicenseAssignmentCreate,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_create

        Create or update a course license assignment

        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param course_license_assignment_create: (required)
        :type course_license_assignment_create: CourseLicenseAssignmentCreate
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_create_serialize(
            license_id=license_id,
            course_license_assignment_create=course_license_assignment_create,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseLicenseAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_create_serialize(
        self,
        license_id,
        course_license_assignment_create,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_license_assignment_create is not None:
            _body_params = course_license_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/course/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_destroy

        Remove a course license assignment

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_destroy_serialize(
        self,
        assignment_id,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/course/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_group_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        course_license_group_assignment_create: CourseLicenseGroupAssignmentCreate,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_group_create

        Create or update a course license group assignment

        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param course_license_group_assignment_create: (required)
        :type course_license_group_assignment_create: CourseLicenseGroupAssignmentCreate
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_group_create_serialize(
            license_id=license_id,
            course_license_group_assignment_create=course_license_group_assignment_create,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseLicenseGroupAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_group_create_serialize(
        self,
        license_id,
        course_license_group_assignment_create,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_license_group_assignment_create is not None:
            _body_params = course_license_group_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/course/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_group_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_group_destroy

        Remove a course license group assignment

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_group_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_group_destroy_serialize(
        self,
        assignment_id,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/course/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_group_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_group_retrieve

        Retrieve a paginated list of course license group assignments

        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_group_retrieve_serialize(
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseLicenseGroupAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_group_retrieve_serialize(
        self,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/course/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_assignment_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the course license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_assignment_retrieve

        Retrieve a paginated list of course license assignments

        :param license_id: The ID of the course license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_assignment_retrieve_serialize(
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseLicenseAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_assignment_retrieve_serialize(
        self,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/course/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_create_create(
        self,
        course_license_create: CourseLicenseCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_create_create

        Create a new course license

        :param course_license_create: (required)
        :type course_license_create: CourseLicenseCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_create_create_serialize(
            course_license_create=course_license_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_create_create_serialize(
        self,
        course_license_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_license_create is not None:
            _body_params = course_license_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/course/create/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by course ID")] = None,
        external_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by external identifier")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license name (exact match)")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search license names (contains)")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license source")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Include detailed assignment data in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_retrieve

        Retrieve a paginated list of course licenses

        :param active: Filter by active status
        :type active: bool
        :param course_id: Filter by course ID
        :type course_id: str
        :param external_id: Filter by external identifier
        :type external_id: str
        :param key: Alternative filter by platform key
        :type key: str
        :param name: Filter by license name (exact match)
        :type name: str
        :param org: Alternative filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param query: Search license names (contains)
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by license source
        :type source: str
        :param verbose: Include detailed assignment data in the response
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_retrieve_serialize(
            active=active,
            course_id=course_id,
            external_id=external_id,
            key=key,
            name=name,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            query=query,
            sort=sort,
            source=source,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedCourseLicense",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_retrieve_serialize(
        self,
        active,
        course_id,
        external_id,
        key,
        name,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        query,
        sort,
        source,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_course_update_create(
        self,
        course_license_update: Optional[CourseLicenseUpdate] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_course_update_create

        Update an existing course license

        :param course_license_update:
        :type course_license_update: CourseLicenseUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_course_update_create_serialize(
            course_license_update=course_license_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_course_update_create_serialize(
        self,
        course_license_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_license_update is not None:
            _body_params = course_license_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/course/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_platform_create_create(
        self,
        platform_license_create: PlatformLicenseCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_platform_create_create

        Create a new platform license

        :param platform_license_create: (required)
        :type platform_license_create: PlatformLicenseCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_platform_create_create_serialize(
            platform_license_create=platform_license_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_platform_create_create_serialize(
        self,
        platform_license_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_license_create is not None:
            _body_params = platform_license_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/platform/create/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_platform_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        external_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by external identifier")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license name (exact match)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search license names (contains)")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license source")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Include detailed assignment data in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_platform_retrieve

        Retrieve a paginated list of platform licenses

        :param active: Filter by active status
        :type active: bool
        :param external_id: Filter by external identifier
        :type external_id: str
        :param key: Alternative filter by platform key
        :type key: str
        :param name: Filter by license name (exact match)
        :type name: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param query: Search license names (contains)
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by license source
        :type source: str
        :param verbose: Include detailed assignment data in the response
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_platform_retrieve_serialize(
            active=active,
            external_id=external_id,
            key=key,
            name=name,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            query=query,
            sort=sort,
            source=source,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedPlatformLicense",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_platform_retrieve_serialize(
        self,
        active,
        external_id,
        key,
        name,
        page,
        page_size,
        platform_key,
        query,
        sort,
        source,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_platform_update_create(
        self,
        platform_license_update: Optional[PlatformLicenseUpdate] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_platform_update_create

        Update an existing platform license

        :param platform_license_update:
        :type platform_license_update: PlatformLicenseUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_platform_update_create_serialize(
            platform_license_update=platform_license_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_platform_update_create_serialize(
        self,
        platform_license_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_license_update is not None:
            _body_params = platform_license_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/platform/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        program_license_assignment_create: ProgramLicenseAssignmentCreate,
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of assignments")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter assignments for a specific email")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of assignments")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_create

        Create or update a program license assignment

        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param program_license_assignment_create: (required)
        :type program_license_assignment_create: ProgramLicenseAssignmentCreate
        :param active: Filter by the active status of assignments
        :type active: bool
        :param email: Filter assignments for a specific email
        :type email: str
        :param fulfilled: Filter by the fulfilled status of assignments
        :type fulfilled: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param user_id: Filter assignments for a specific user ID
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_create_serialize(
            license_id=license_id,
            program_license_assignment_create=program_license_assignment_create,
            active=active,
            email=email,
            fulfilled=fulfilled,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramLicenseAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_create_serialize(
        self,
        license_id,
        program_license_assignment_create,
        active,
        email,
        fulfilled,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_license_assignment_create is not None:
            _body_params = program_license_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/program/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of assignments")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter assignments for a specific email")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of assignments")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform (for permission validation)")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform (for permission validation)")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_destroy

        Unassign single user from license

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param active: Filter by the active status of assignments
        :type active: bool
        :param email: Filter assignments for a specific email
        :type email: str
        :param fulfilled: Filter by the fulfilled status of assignments
        :type fulfilled: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform (for permission validation)
        :type platform_key: str
        :param platform_org: The organization identifier for the platform (for permission validation)
        :type platform_org: str
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param user_id: Filter assignments for a specific user ID
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            active=active,
            email=email,
            fulfilled=fulfilled,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_destroy_serialize(
        self,
        assignment_id,
        license_id,
        active,
        email,
        fulfilled,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/program/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_group_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        program_license_group_assignment_create: ProgramLicenseGroupAssignmentCreate,
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of group assignments")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of group assignments")] = None,
        group_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user group ID")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_group_create

        Create or update a program license group assignment

        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param program_license_group_assignment_create: (required)
        :type program_license_group_assignment_create: ProgramLicenseGroupAssignmentCreate
        :param active: Filter by the active status of group assignments
        :type active: bool
        :param fulfilled: Filter by the fulfilled status of group assignments
        :type fulfilled: bool
        :param group_id: Filter assignments for a specific user group ID
        :type group_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_group_create_serialize(
            license_id=license_id,
            program_license_group_assignment_create=program_license_group_assignment_create,
            active=active,
            fulfilled=fulfilled,
            group_id=group_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramLicenseGroupAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_group_create_serialize(
        self,
        license_id,
        program_license_group_assignment_create,
        active,
        fulfilled,
        group_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if group_id is not None:
            
            _query_params.append(('group_id', group_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_license_group_assignment_create is not None:
            _body_params = program_license_group_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/program/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_group_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of group assignments")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of group assignments")] = None,
        group_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user group ID")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform (for permission validation)")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform (for permission validation)")] = None,
        remove_user_assignments: Annotated[Optional[StrictBool], Field(description="Whether to also remove individual user assignments that were created by this group assignment")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_group_destroy

        Remove a program license group assignment

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param active: Filter by the active status of group assignments
        :type active: bool
        :param fulfilled: Filter by the fulfilled status of group assignments
        :type fulfilled: bool
        :param group_id: Filter assignments for a specific user group ID
        :type group_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform (for permission validation)
        :type platform_key: str
        :param platform_org: The organization identifier for the platform (for permission validation)
        :type platform_org: str
        :param remove_user_assignments: Whether to also remove individual user assignments that were created by this group assignment
        :type remove_user_assignments: bool
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_group_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            active=active,
            fulfilled=fulfilled,
            group_id=group_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            remove_user_assignments=remove_user_assignments,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_group_destroy_serialize(
        self,
        assignment_id,
        license_id,
        active,
        fulfilled,
        group_id,
        page,
        page_size,
        platform_key,
        platform_org,
        remove_user_assignments,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if group_id is not None:
            
            _query_params.append(('group_id', group_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if remove_user_assignments is not None:
            
            _query_params.append(('remove_user_assignments', remove_user_assignments))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/program/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_group_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of group assignments")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of group assignments")] = None,
        group_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user group ID")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_group_retrieve

        Retrieve a paginated list of program license group assignments

        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param active: Filter by the active status of group assignments
        :type active: bool
        :param fulfilled: Filter by the fulfilled status of group assignments
        :type fulfilled: bool
        :param group_id: Filter assignments for a specific user group ID
        :type group_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_group_retrieve_serialize(
            license_id=license_id,
            active=active,
            fulfilled=fulfilled,
            group_id=group_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProgramLicenseGroupAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_group_retrieve_serialize(
        self,
        license_id,
        active,
        fulfilled,
        group_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if group_id is not None:
            
            _query_params.append(('group_id', group_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/program/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_assignment_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the program license")],
        active: Annotated[Optional[StrictBool], Field(description="Filter by the active status of assignments")] = None,
        email: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter assignments for a specific email")] = None,
        fulfilled: Annotated[Optional[StrictBool], Field(description="Filter by the fulfilled status of assignments")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., 'id', '-id', 'created', '-created')")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="Filter assignments for a specific user ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_assignment_retrieve

        Retrieve a paginated list of program license assignments

        :param license_id: The ID of the program license (required)
        :type license_id: int
        :param active: Filter by the active status of assignments
        :type active: bool
        :param email: Filter assignments for a specific email
        :type email: str
        :param fulfilled: Filter by the fulfilled status of assignments
        :type fulfilled: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by (e.g., 'id', '-id', 'created', '-created')
        :type sort: str
        :param user_id: Filter assignments for a specific user ID
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_assignment_retrieve_serialize(
            license_id=license_id,
            active=active,
            email=email,
            fulfilled=fulfilled,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProgramLicenseAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_assignment_retrieve_serialize(
        self,
        license_id,
        active,
        email,
        fulfilled,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if fulfilled is not None:
            
            _query_params.append(('fulfilled', fulfilled))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/program/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_create_create(
        self,
        program_license_create_detail: ProgramLicenseCreateDetail,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_create_create

        API View for creating program licenses.  This endpoint allows administrators to create new program licenses with various configurations.  Methods:     POST: Create a new program license  Request Body:     A JSON object containing:     - platform_key (str, required): The platform to create a license for     - program_id (str, required): The program ID to create a license for     - name (str, optional): Display name for the license     - count (int, optional): Number of seats purchased (default: 0)     - started (datetime, optional): Date when license should begin     - expired (datetime, optional): Date when license should expire     - active (bool, optional): Whether the license is active (default: true)     - metadata (dict, optional): Additional license metadata     - enrollment_config (dict, optional): Additional enrollment configuration     - source (str, optional): Source identifier     - external_id (str, optional): External identifier (must be unique)  Returns:     POST: A JSON response containing the created license:         {             \"id\": 123,             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"expired\": null,             \"name\": \"Program License 2023\",             \"count\": 100,             \"active\": true,             \"metadata\": {},             \"source\": \"source\",             \"external_id\": \"ext-123\",             \"platform_key\": \"platform1\",             \"program_id\": \"program-v1:org+program+run\"         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to create licenses     500 Internal Server Error: If an unexpected error occurs during license creation  Access Control:     - Requires IsDMAdmin permission     - Available only to DM administrators

        :param program_license_create_detail: (required)
        :type program_license_create_detail: ProgramLicenseCreateDetail
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_create_create_serialize(
            program_license_create_detail=program_license_create_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_create_create_serialize(
        self,
        program_license_create_detail,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_license_create_detail is not None:
            _body_params = program_license_create_detail


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/program/create/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        external_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by external identifier")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license name (exact match)")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform organization")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by program ID")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search license names (contains)")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (e.g., '-id', 'created', '-created')")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license source")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Include detailed assignment data in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_retrieve

        API View for managing program licenses.  This endpoint allows retrieving program licenses with filtering and pagination support.  Query Parameters:     platform_key (str, optional): The unique identifier for the platform     name (str, optional): Filter by license name (exact match)     source (str, optional): Filter by license source     active (bool, optional): Filter by active status     program_id (str, optional): Filter by program ID     query (str, optional): Search licenses by name (contains)     page (int, optional): Page number for pagination     page_size (int, optional): Number of items per page     verbose (bool, optional): Include additional details in response     sort (str, optional): Field to sort results by (default: '-id')  Methods:     GET: Retrieve a paginated list of program licenses  Returns:     GET: A paginated JSON response containing program licenses:         {             \"count\": 10,             \"next\": \"https://example.com/api/catalog/licenses/program/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"created\": \"2023-06-15T14:30:00Z\",                     \"started\": \"2023-06-15T14:30:00Z\",                     \"expired\": null,                     \"name\": \"Program License 2023\",                     \"count\": 100,                     \"active\": true,                     \"metadata\": {},                     \"source\": \"source\",                     \"external_id\": \"ext-123\",                     \"platform_key\": \"platform1\",                     \"program_id\": \"program-v1:org+program+run\",                     \"assignments\": {                         \"total\": 50,                         \"active\": 45,                         \"pending\": 5                     }                 },                 ...             ]         }  Error Responses:     400 Bad Request: If query parameters are invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin or IsPlatformAdminReadOnly permission     - Available to platform administrators (read-only) and DM admins

        :param active: Filter by active status
        :type active: bool
        :param external_id: Filter by external identifier
        :type external_id: str
        :param key: Alternative filter by platform key
        :type key: str
        :param name: Filter by license name (exact match)
        :type name: str
        :param org: Alternative filter by platform organization
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param program_id: Filter by program ID
        :type program_id: str
        :param query: Search license names (contains)
        :type query: str
        :param sort: Field to sort results by (e.g., '-id', 'created', '-created')
        :type sort: str
        :param source: Filter by license source
        :type source: str
        :param verbose: Include detailed assignment data in the response
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_retrieve_serialize(
            active=active,
            external_id=external_id,
            key=key,
            name=name,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            program_id=program_id,
            query=query,
            sort=sort,
            source=source,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedProgramLicense",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_retrieve_serialize(
        self,
        active,
        external_id,
        key,
        name,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        program_id,
        query,
        sort,
        source,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_program_update_create(
        self,
        program_license_update_detail: Optional[ProgramLicenseUpdateDetail] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_program_update_create

        API View for updating existing program licenses.  This endpoint allows administrators to update the properties of an existing program license.  Methods:     POST: Update an existing program license  Request Body:     A JSON object containing:     - license_id (int, optional): The ID of the license to update (required if external_id not provided)     - external_id (str, optional): External identifier of the license to update (required if license_id not provided)     - name (str, optional): Updated display name for the license     - count (int, optional): Updated number of seats purchased     - started (datetime, optional): Updated date when license should begin     - expired (datetime, optional): Updated date when license should expire     - active (bool, optional): Updated active status     - metadata (dict, optional): Updated additional license metadata     - enrollment_config (dict, optional): Updated enrollment configuration     - source (str, optional): Updated source identifier     - change_type (str, optional): Type of change being made (default: \"update\")  Returns:     POST: A JSON response containing the updated license:         {             \"id\": 123,             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"expired\": \"2024-06-15T14:30:00Z\",             \"name\": \"Updated Program License 2023\",             \"count\": 150,             \"active\": true,             \"metadata\": {\"updated\": true},             \"source\": \"updated-source\",             \"external_id\": \"ext-123\",             \"platform_key\": \"platform1\",             \"program_id\": \"program-v1:org+program+run\"         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to update licenses     404 Not Found: If the specified license doesn't exist     500 Internal Server Error: If an unexpected error occurs during license update  Access Control:     - Requires IsDMAdmin permission     - Available only to DM administrators  Notes:     - Cannot update the platform or program associated with a license     - A license history record is automatically created for each update

        :param program_license_update_detail:
        :type program_license_update_detail: ProgramLicenseUpdateDetail
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_program_update_create_serialize(
            program_license_update_detail=program_license_update_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_program_update_create_serialize(
        self,
        program_license_update_detail,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_license_update_detail is not None:
            _body_params = program_license_update_detail


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/program/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_check_retrieve(
        self,
        email: Annotated[str, Field(min_length=1, strict=True, description="The email address to check for active license assignments")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_check_retrieve

        Check if a user has an active user license assignment

        :param email: The email address to check for active license assignments (required)
        :type email: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_check_retrieve_serialize(
            email=email,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_check_retrieve_serialize(
        self,
        email,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if email is not None:
            
            _query_params.append(('email', email))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/user/assignment/check/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        user_license_assignment_create: UserLicenseAssignmentCreate,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_create

        Create or update a user license assignment

        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param user_license_assignment_create: (required)
        :type user_license_assignment_create: UserLicenseAssignmentCreate
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_create_serialize(
            license_id=license_id,
            user_license_assignment_create=user_license_assignment_create,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserLicenseAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_create_serialize(
        self,
        license_id,
        user_license_assignment_create,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_license_assignment_create is not None:
            _body_params = user_license_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/user/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_destroy

        Remove a user license assignment

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_destroy_serialize(
        self,
        assignment_id,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/user/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_group_create(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        user_license_group_assignment_create: UserLicenseGroupAssignmentCreate,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_group_create

        Create or update a user license group assignment

        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param user_license_group_assignment_create: (required)
        :type user_license_group_assignment_create: UserLicenseGroupAssignmentCreate
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_group_create_serialize(
            license_id=license_id,
            user_license_group_assignment_create=user_license_group_assignment_create,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserLicenseGroupAssignmentDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_group_create_serialize(
        self,
        license_id,
        user_license_group_assignment_create,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_license_group_assignment_create is not None:
            _body_params = user_license_group_assignment_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/user/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_group_destroy(
        self,
        assignment_id: Annotated[StrictInt, Field(description="The ID of the assignment to delete")],
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_group_destroy

        Remove a user license group assignment

        :param assignment_id: The ID of the assignment to delete (required)
        :type assignment_id: int
        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_group_destroy_serialize(
            assignment_id=assignment_id,
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_group_destroy_serialize(
        self,
        assignment_id,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if assignment_id is not None:
            
            _query_params.append(('assignment_id', assignment_id))
            
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/licenses/user/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_group_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_group_retrieve

        Retrieve a paginated list of user license group assignments

        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_group_retrieve_serialize(
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserLicenseGroupAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_group_retrieve_serialize(
        self,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/user/assignment/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_assignment_retrieve(
        self,
        license_id: Annotated[StrictInt, Field(description="The ID of the user license")],
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_assignment_retrieve

        Retrieve a paginated list of user license assignments

        :param license_id: The ID of the user license (required)
        :type license_id: int
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_assignment_retrieve_serialize(
            license_id=license_id,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserLicenseAssignment",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_assignment_retrieve_serialize(
        self,
        license_id,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if license_id is not None:
            
            _query_params.append(('license_id', license_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/user/assignment/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_create_create(
        self,
        user_license_create: UserLicenseCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_create_create

        Create a new user license

        :param user_license_create: (required)
        :type user_license_create: UserLicenseCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_create_create_serialize(
            user_license_create=user_license_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_create_create_serialize(
        self,
        user_license_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_license_create is not None:
            _body_params = user_license_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/user/create/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_retrieve(
        self,
        active: Annotated[Optional[StrictBool], Field(description="Filter by active status")] = None,
        external_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by external identifier")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alternative filter by platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license name (exact match)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The unique identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search license names (contains)")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        source: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by license source")] = None,
        verbose: Annotated[Optional[StrictBool], Field(description="Include detailed assignment data in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_retrieve

        Retrieve a paginated list of user licenses

        :param active: Filter by active status
        :type active: bool
        :param external_id: Filter by external identifier
        :type external_id: str
        :param key: Alternative filter by platform key
        :type key: str
        :param name: Filter by license name (exact match)
        :type name: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param platform_key: The unique identifier for the platform
        :type platform_key: str
        :param query: Search license names (contains)
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param source: Filter by license source
        :type source: str
        :param verbose: Include detailed assignment data in the response
        :type verbose: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_retrieve_serialize(
            active=active,
            external_id=external_id,
            key=key,
            name=name,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            query=query,
            sort=sort,
            source=source,
            verbose=verbose,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedUserLicense",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_retrieve_serialize(
        self,
        active,
        external_id,
        key,
        name,
        page,
        page_size,
        platform_key,
        query,
        sort,
        source,
        verbose,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if active is not None:
            
            _query_params.append(('active', active))
            
        if external_id is not None:
            
            _query_params.append(('external_id', external_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if verbose is not None:
            
            _query_params.append(('verbose', verbose))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/licenses/user/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_licenses_user_update_create(
        self,
        user_license_update: Optional[UserLicenseUpdate] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_licenses_user_update_create

        API View for updating existing user licenses.  This endpoint allows administrators to update the properties of an existing user license.  Methods:     POST: Update an existing user license  Request Body:     A JSON object containing:     - license_id (int, optional): The ID of the license to update (required if external_id not provided)     - external_id (str, optional): External identifier of the license to update (required if license_id not provided)     - name (str, optional): Updated display name for the license     - count (int, optional): Updated number of seats purchased     - started (datetime, optional): Updated date when license should begin     - expired (datetime, optional): Updated date when license should expire     - active (bool, optional): Updated active status     - metadata (dict, optional): Updated additional license metadata     - enrollment_config (dict, optional): Updated enrollment configuration     - source (str, optional): Updated source identifier     - change_type (str, optional): Type of change being made (default: \"update\")  Returns:     POST: A JSON response containing the updated license:         {             \"id\": 123,             \"created\": \"2023-06-15T14:30:00Z\",             \"started\": \"2023-06-15T14:30:00Z\",             \"expired\": \"2024-06-15T14:30:00Z\",             \"name\": \"Updated User License 2023\",             \"count\": 150,             \"active\": true,             \"metadata\": {\"updated\": true},             \"source\": \"updated-source\",             \"external_id\": \"ext-123\",             \"platform_key\": \"platform1\"         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to update licenses     404 Not Found: If the specified license doesn't exist     500 Internal Server Error: If an unexpected error occurs during license update  Access Control:     - Requires IsDMAdmin permission     - Available only to DM administrators  Notes:     - Cannot update the platform associated with a license     - A license history record is automatically created for each update

        :param user_license_update:
        :type user_license_update: UserLicenseUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_licenses_user_update_create_serialize(
            user_license_update=user_license_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserLicenseDetail",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_licenses_user_update_create_serialize(
        self,
        user_license_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if user_license_update is not None:
            _body_params = user_license_update


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/licenses/user/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_choices_retrieve(
        self,
        field_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The key of the field for which choices are being queried")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization context for the metadata choices")] = None,
        scope: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The scope within which to query the metadata choices (course, program, pathway, resource)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_choices_retrieve

        Query metadata choices based on field_key, scope, and org parameters.

        :param field_key: The key of the field for which choices are being queried
        :type field_key: str
        :param org: The organization context for the metadata choices
        :type org: str
        :param scope: The scope within which to query the metadata choices (course, program, pathway, resource)
        :type scope: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_choices_retrieve_serialize(
            field_key=field_key,
            org=org,
            scope=scope,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_choices_retrieve_serialize(
        self,
        field_key,
        org,
        scope,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if field_key is not None:
            
            _query_params.append(('field_key', field_key))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/choices/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_create(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        course_metadata_update_request: CourseMetadataUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_create

        Update metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param course_metadata_update_request: (required)
        :type course_metadata_update_request: CourseMetadataUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_create_serialize(
            course_id=course_id,
            course_metadata_update_request=course_metadata_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_create_serialize(
        self,
        course_id,
        course_metadata_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_metadata_update_request is not None:
            _body_params = course_metadata_update_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/metadata/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_create2(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        var_field: Annotated[str, Field(strict=True)],
        course_metadata_update_request: CourseMetadataUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_create2

        Update metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param var_field: (required)
        :type var_field: str
        :param course_metadata_update_request: (required)
        :type course_metadata_update_request: CourseMetadataUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_create2_serialize(
            course_id=course_id,
            var_field=var_field,
            course_metadata_update_request=course_metadata_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_create2_serialize(
        self,
        course_id,
        var_field,
        course_metadata_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_metadata_update_request is not None:
            _body_params = course_metadata_update_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/metadata/course/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_public_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_public_retrieve

        Retrieve public metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_public_retrieve_serialize(
            course_id=course_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_public_retrieve_serialize(
        self,
        course_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/course-public/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_public_retrieve2(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        var_field: Annotated[str, Field(strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_public_retrieve2

        Retrieve public metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param var_field: (required)
        :type var_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_public_retrieve2_serialize(
            course_id=course_id,
            var_field=var_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_public_retrieve2_serialize(
        self,
        course_id,
        var_field,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/course-public/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_retrieve

        Retrieve metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_retrieve_serialize(
            course_id=course_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_retrieve_serialize(
        self,
        course_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_retrieve2(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get metadata for")],
        var_field: Annotated[str, Field(strict=True)],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_retrieve2

        Retrieve metadata for a course.

        :param course_id: The course ID to get metadata for (required)
        :type course_id: str
        :param var_field: (required)
        :type var_field: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_retrieve2_serialize(
            course_id=course_id,
            var_field=var_field,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_retrieve2_serialize(
        self,
        course_id,
        var_field,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/course/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_course_search_create(
        self,
        course_metadata_search_request: Optional[CourseMetadataSearchRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_course_search_create

        Search for courses matching specified metadata filters.

        :param course_metadata_search_request:
        :type course_metadata_search_request: CourseMetadataSearchRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_course_search_create_serialize(
            course_metadata_search_request=course_metadata_search_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_course_search_create_serialize(
        self,
        course_metadata_search_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_metadata_search_request is not None:
            _body_params = course_metadata_search_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/metadata/course-search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_create(
        self,
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        program_metadata_request: ProgramMetadataRequest,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_create

        Update metadata for a specified program

        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param program_metadata_request: (required)
        :type program_metadata_request: ProgramMetadataRequest
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_create_serialize(
            program_id=program_id,
            program_metadata_request=program_metadata_request,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_create_serialize(
        self,
        program_id,
        program_metadata_request,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_metadata_request is not None:
            _body_params = program_metadata_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/metadata/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_create2(
        self,
        var_field: Annotated[str, Field(strict=True)],
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        program_metadata_request: ProgramMetadataRequest,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_create2

        Update metadata for a specified program

        :param var_field: (required)
        :type var_field: str
        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param program_metadata_request: (required)
        :type program_metadata_request: ProgramMetadataRequest
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_create2_serialize(
            var_field=var_field,
            program_id=program_id,
            program_metadata_request=program_metadata_request,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_create2_serialize(
        self,
        var_field,
        program_id,
        program_metadata_request,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_metadata_request is not None:
            _body_params = program_metadata_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/metadata/program/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_public_retrieve(
        self,
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_public_retrieve

        Retrieve public metadata for a specified program

        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_public_retrieve_serialize(
            program_id=program_id,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_public_retrieve_serialize(
        self,
        program_id,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/program-public/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_public_retrieve2(
        self,
        var_field: Annotated[str, Field(strict=True)],
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_public_retrieve2

        Retrieve public metadata for a specified program

        :param var_field: (required)
        :type var_field: str
        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_public_retrieve2_serialize(
            var_field=var_field,
            program_id=program_id,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_public_retrieve2_serialize(
        self,
        var_field,
        program_id,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/program-public/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_retrieve(
        self,
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_retrieve

        Retrieve metadata for a specified program

        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_retrieve_serialize(
            program_id=program_id,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_retrieve_serialize(
        self,
        program_id,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_metadata_program_retrieve2(
        self,
        var_field: Annotated[str, Field(strict=True)],
        program_id: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization associated with the program")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier (alternative to org)")] = None,
        program_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program key (alternative to program_id + org)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_metadata_program_retrieve2

        Retrieve metadata for a specified program

        :param var_field: (required)
        :type var_field: str
        :param program_id: The unique identifier for the program (required)
        :type program_id: str
        :param org: The organization associated with the program
        :type org: str
        :param platform_key: Platform key identifier (alternative to org)
        :type platform_key: str
        :param program_key: Program key (alternative to program_id + org)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_metadata_program_retrieve2_serialize(
            var_field=var_field,
            program_id=program_id,
            org=org,
            platform_key=platform_key,
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramMetadataResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_metadata_program_retrieve2_serialize(
        self,
        var_field,
        program_id,
        org,
        platform_key,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if var_field is not None:
            _path_params['field'] = var_field
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/metadata/program/{field}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_course_catalog_retrieve(
        self,
        user_id: Annotated[StrictInt, Field(description="The user identifier")],
        field_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Specific field to include in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_course_catalog_retrieve

        Retrieve catalog-compatible completion info for user

        :param user_id: The user identifier (required)
        :type user_id: int
        :param field_key: Specific field to include in the response
        :type field_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_course_catalog_retrieve_serialize(
            user_id=user_id,
            field_key=field_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_course_catalog_retrieve_serialize(
        self,
        user_id,
        field_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if field_key is not None:
            
            _query_params.append(('field_key', field_key))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/completions/course/catalog/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_course_manage_create(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course identifier (e.g., 'course-v1:org+code+run')")],
        user_id: Annotated[StrictInt, Field(description="The user identifier")],
        course_completion: CourseCompletion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_course_manage_create

        Create or update completion information for a specific user and course

        :param course_id: The course identifier (e.g., 'course-v1:org+code+run') (required)
        :type course_id: str
        :param user_id: The user identifier (required)
        :type user_id: int
        :param course_completion: (required)
        :type course_completion: CourseCompletion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_course_manage_create_serialize(
            course_id=course_id,
            user_id=user_id,
            course_completion=course_completion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '201': "Dict[str, object]",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_course_manage_create_serialize(
        self,
        course_id,
        user_id,
        course_completion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_completion is not None:
            _body_params = course_completion


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/completions/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_course_manage_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course identifier (e.g., 'course-v1:org+code+run')")],
        user_id: Annotated[StrictInt, Field(description="The user identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_course_manage_retrieve

        Retrieve completion information for a specific user and course

        :param course_id: The course identifier (e.g., 'course-v1:org+code+run') (required)
        :type course_id: str
        :param user_id: The user identifier (required)
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_course_manage_retrieve_serialize(
            course_id=course_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_course_manage_retrieve_serialize(
        self,
        course_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/completions/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_pathway_query_retrieve(
        self,
        pathway_uuid: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the pathway")],
        user_id: Annotated[Optional[StrictInt], Field(description="The user identifier (either user_id or username required)")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The username (either user_id or username required)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_pathway_query_retrieve

        Retrieve pathway completion information

        :param pathway_uuid: The unique identifier for the pathway (required)
        :type pathway_uuid: str
        :param user_id: The user identifier (either user_id or username required)
        :type user_id: int
        :param username: The username (either user_id or username required)
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_pathway_query_retrieve_serialize(
            pathway_uuid=pathway_uuid,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayCompletionResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_pathway_query_retrieve_serialize(
        self,
        pathway_uuid,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/completions/pathway/query/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_program_query_retrieve(
        self,
        program_key: Annotated[str, Field(min_length=1, strict=True, description="The unique identifier for the program")],
        user_id: Annotated[Optional[StrictInt], Field(description="The user identifier (either user_id or username required)")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The username (either user_id or username required)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_program_query_retrieve

        Retrieve program completion information

        :param program_key: The unique identifier for the program (required)
        :type program_key: str
        :param user_id: The user identifier (either user_id or username required)
        :type user_id: int
        :param username: The username (either user_id or username required)
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_program_query_retrieve_serialize(
            program_key=program_key,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramCompletionResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_program_query_retrieve_serialize(
        self,
        program_key,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/completions/program/query/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_resource_manage_create(
        self,
        resource_id: Annotated[StrictInt, Field(description="The unique identifier for the resource")],
        user_id: Annotated[StrictInt, Field(description="The ID of the user")],
        resource_completion_request: ResourceCompletionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_resource_manage_create

        Create or update completion information for a specific resource and user

        :param resource_id: The unique identifier for the resource (required)
        :type resource_id: int
        :param user_id: The ID of the user (required)
        :type user_id: int
        :param resource_completion_request: (required)
        :type resource_completion_request: ResourceCompletionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_resource_manage_create_serialize(
            resource_id=resource_id,
            user_id=user_id,
            resource_completion_request=resource_completion_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceCompletion",
            '201': "ResourceCompletion",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_resource_manage_create_serialize(
        self,
        resource_id,
        user_id,
        resource_completion_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if resource_id is not None:
            
            _query_params.append(('resource_id', resource_id))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if resource_completion_request is not None:
            _body_params = resource_completion_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/completions/resource/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_completions_resource_manage_retrieve(
        self,
        resource_id: Annotated[StrictInt, Field(description="The unique identifier for the resource")],
        user_id: Annotated[StrictInt, Field(description="The ID of the user")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_completions_resource_manage_retrieve

        Retrieve completion info for resource/user

        :param resource_id: The unique identifier for the resource (required)
        :type resource_id: int
        :param user_id: The ID of the user (required)
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_completions_resource_manage_retrieve_serialize(
            resource_id=resource_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceCompletion",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_completions_resource_manage_retrieve_serialize(
        self,
        resource_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if resource_id is not None:
            
            _query_params.append(('resource_id', resource_id))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/completions/resource/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_block_create(
        self,
        block_id: Annotated[str, Field(min_length=1, strict=True, description="ID of the block to retrieve skill point information for")],
        block_skill_point_info_request: BlockSkillPointInfoRequest,
        get_obj: Annotated[Optional[StrictBool], Field(description="If True, returns skill objects instead of skill names as keys")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_block_create

        Update skill point information for a specific block

        :param block_id: ID of the block to retrieve skill point information for (required)
        :type block_id: str
        :param block_skill_point_info_request: (required)
        :type block_skill_point_info_request: BlockSkillPointInfoRequest
        :param get_obj: If True, returns skill objects instead of skill names as keys
        :type get_obj: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_block_create_serialize(
            block_id=block_id,
            block_skill_point_info_request=block_skill_point_info_request,
            get_obj=get_obj,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_block_create_serialize(
        self,
        block_id,
        block_skill_point_info_request,
        get_obj,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if block_id is not None:
            
            _query_params.append(('block_id', block_id))
            
        if get_obj is not None:
            
            _query_params.append(('get_obj', get_obj))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if block_skill_point_info_request is not None:
            _body_params = block_skill_point_info_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/skill_points/block/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_block_retrieve(
        self,
        block_id: Annotated[str, Field(min_length=1, strict=True, description="ID of the block to retrieve skill point information for")],
        get_obj: Annotated[Optional[StrictBool], Field(description="If True, returns skill objects instead of skill names as keys")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_block_retrieve

        Retrieve skill point information for a specific block

        :param block_id: ID of the block to retrieve skill point information for (required)
        :type block_id: str
        :param get_obj: If True, returns skill objects instead of skill names as keys
        :type get_obj: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_block_retrieve_serialize(
            block_id=block_id,
            get_obj=get_obj,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '404': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_block_retrieve_serialize(
        self,
        block_id,
        get_obj,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if block_id is not None:
            
            _query_params.append(('block_id', block_id))
            
        if get_obj is not None:
            
            _query_params.append(('get_obj', get_obj))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/skill_points/block/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_course_create(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="ID of the course to retrieve skill point information for")],
        course_skill_point_info_request: CourseSkillPointInfoRequest,
        get_obj: Annotated[Optional[StrictBool], Field(description="If True, returns skill objects instead of skill names as keys")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_course_create

        Update skill point information for a specific course

        :param course_id: ID of the course to retrieve skill point information for (required)
        :type course_id: str
        :param course_skill_point_info_request: (required)
        :type course_skill_point_info_request: CourseSkillPointInfoRequest
        :param get_obj: If True, returns skill objects instead of skill names as keys
        :type get_obj: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_course_create_serialize(
            course_id=course_id,
            course_skill_point_info_request=course_skill_point_info_request,
            get_obj=get_obj,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_course_create_serialize(
        self,
        course_id,
        course_skill_point_info_request,
        get_obj,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if get_obj is not None:
            
            _query_params.append(('get_obj', get_obj))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_skill_point_info_request is not None:
            _body_params = course_skill_point_info_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/skill_points/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_course_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="ID of the course to retrieve skill point information for")],
        get_obj: Annotated[Optional[StrictBool], Field(description="If True, returns skill objects instead of skill names as keys")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_course_retrieve

        Retrieve skill point information for a specific course

        :param course_id: ID of the course to retrieve skill point information for (required)
        :type course_id: str
        :param get_obj: If True, returns skill objects instead of skill names as keys
        :type get_obj: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_course_retrieve_serialize(
            course_id=course_id,
            get_obj=get_obj,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_course_retrieve_serialize(
        self,
        course_id,
        get_obj,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if get_obj is not None:
            
            _query_params.append(('get_obj', get_obj))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/skill_points/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_platform_bulk_create(
        self,
        platform_skill_point_bulk_request: PlatformSkillPointBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_platform_bulk_create

        Bulk create/update platform skill points

        :param platform_skill_point_bulk_request: (required)
        :type platform_skill_point_bulk_request: PlatformSkillPointBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_platform_bulk_create_serialize(
            platform_skill_point_bulk_request=platform_skill_point_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformSkillPointBulkResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_platform_bulk_create_serialize(
        self,
        platform_skill_point_bulk_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_skill_point_bulk_request is not None:
            _body_params = platform_skill_point_bulk_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/skill_points/platform/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_platform_create(
        self,
        platform_skill_point_request: PlatformSkillPointRequest,
        department_mode: Annotated[Optional[StrictBool], Field(description="If True, filters results by department user permissions")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization identifier")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query for filtering skill points by user or skill name")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort field for results. Default: '-id'")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_platform_create

        Update platform skill points for a user

        :param platform_skill_point_request: (required)
        :type platform_skill_point_request: PlatformSkillPointRequest
        :param department_mode: If True, filters results by department user permissions
        :type department_mode: bool
        :param platform_key: Platform key identifier
        :type platform_key: str
        :param platform_org: Platform organization identifier
        :type platform_org: str
        :param query: Search query for filtering skill points by user or skill name
        :type query: str
        :param sort: Sort field for results. Default: '-id'
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_platform_create_serialize(
            platform_skill_point_request=platform_skill_point_request,
            department_mode=department_mode,
            platform_key=platform_key,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_platform_create_serialize(
        self,
        platform_skill_point_request,
        department_mode,
        platform_key,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_skill_point_request is not None:
            _body_params = platform_skill_point_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/skill_points/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_platform_destroy(
        self,
        skill_point_id: Annotated[StrictInt, Field(description="ID of the skill point to delete")],
        department_mode: Annotated[Optional[StrictBool], Field(description="If True, filters results by department user permissions")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization identifier")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query for filtering skill points by user or skill name")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort field for results. Default: '-id'")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_platform_destroy

        Delete a platform skill point entry

        :param skill_point_id: ID of the skill point to delete (required)
        :type skill_point_id: int
        :param department_mode: If True, filters results by department user permissions
        :type department_mode: bool
        :param platform_key: Platform key identifier
        :type platform_key: str
        :param platform_org: Platform organization identifier
        :type platform_org: str
        :param query: Search query for filtering skill points by user or skill name
        :type query: str
        :param sort: Sort field for results. Default: '-id'
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_platform_destroy_serialize(
            skill_point_id=skill_point_id,
            department_mode=department_mode,
            platform_key=platform_key,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_platform_destroy_serialize(
        self,
        skill_point_id,
        department_mode,
        platform_key,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if skill_point_id is not None:
            
            _query_params.append(('skill_point_id', skill_point_id))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/milestones/skill_points/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_platform_group_create(
        self,
        platform_skill_point_group_request: PlatformSkillPointGroupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_platform_group_create

        Update skill points for all users in a group

        :param platform_skill_point_group_request: (required)
        :type platform_skill_point_group_request: PlatformSkillPointGroupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_platform_group_create_serialize(
            platform_skill_point_group_request=platform_skill_point_group_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_platform_group_create_serialize(
        self,
        platform_skill_point_group_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if platform_skill_point_group_request is not None:
            _body_params = platform_skill_point_group_request



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/milestones/skill_points/platform/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_platform_retrieve(
        self,
        department_mode: Annotated[Optional[StrictBool], Field(description="If True, filters results by department user permissions")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key identifier")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization identifier")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search query for filtering skill points by user or skill name")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort field for results. Default: '-id'")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_platform_retrieve

        Retrieve paginated list of platform skill points

        :param department_mode: If True, filters results by department user permissions
        :type department_mode: bool
        :param platform_key: Platform key identifier
        :type platform_key: str
        :param platform_org: Platform organization identifier
        :type platform_org: str
        :param query: Search query for filtering skill points by user or skill name
        :type query: str
        :param sort: Sort field for results. Default: '-id'
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_platform_retrieve_serialize(
            department_mode=department_mode,
            platform_key=platform_key,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlatformSkillPointResponse",
            '400': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_platform_retrieve_serialize(
        self,
        department_mode,
        platform_key,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/skill_points/platform/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_milestones_skill_points_user_retrieve(
        self,
        user_id: Annotated[Optional[StrictInt], Field(description="ID of the user to retrieve skill point information for")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username to retrieve skill point information for")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_milestones_skill_points_user_retrieve

        Retrieve skill point information for a specific user

        :param user_id: ID of the user to retrieve skill point information for
        :type user_id: int
        :param username: Username to retrieve skill point information for
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_milestones_skill_points_user_retrieve_serialize(
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
            '404': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_milestones_skill_points_user_retrieve_serialize(
        self,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/milestones/skill_points/user/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_pathways_create(
        self,
        pathway_create_update_request: PathwayCreateUpdateRequest,
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the pathway")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway name")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug (case-insensitive)")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID of the pathway owner")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username of the pathway owner")] = None,
        visible: Annotated[Optional[StrictBool], Field(description="Whether the pathway is visible")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_pathways_create

        Add or update a pathway.

        :param pathway_create_update_request: (required)
        :type pathway_create_update_request: PathwayCreateUpdateRequest
        :param item_id: Item ID associated with the pathway
        :type item_id: str
        :param name: Pathway name
        :type name: str
        :param pathway_id: Pathway ID
        :type pathway_id: str
        :param pathway_uuid: Pathway UUID
        :type pathway_uuid: str
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Pathway slug (case-insensitive)
        :type slug: str
        :param user_id: User ID of the pathway owner
        :type user_id: int
        :param username: Username of the pathway owner
        :type username: str
        :param visible: Whether the pathway is visible
        :type visible: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_pathways_create_serialize(
            pathway_create_update_request=pathway_create_update_request,
            item_id=item_id,
            name=name,
            pathway_id=pathway_id,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            visible=visible,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Pathway",
            '201': "Pathway",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_pathways_create_serialize(
        self,
        pathway_create_update_request,
        item_id,
        name,
        pathway_id,
        pathway_uuid,
        platform_key,
        slug,
        user_id,
        username,
        visible,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if visible is not None:
            
            _query_params.append(('visible', visible))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if pathway_create_update_request is not None:
            _body_params = pathway_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_pathways_destroy(
        self,
        pathway_id: Annotated[str, Field(min_length=1, strict=True, description="Pathway ID to delete")],
        user_id: Annotated[StrictInt, Field(description="User ID of the pathway owner")],
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the pathway")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway name")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug (case-insensitive)")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username of the pathway owner")] = None,
        visible: Annotated[Optional[StrictBool], Field(description="Whether the pathway is visible")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_pathways_destroy

        Remove a pathway from the database.

        :param pathway_id: Pathway ID to delete (required)
        :type pathway_id: str
        :param user_id: User ID of the pathway owner (required)
        :type user_id: int
        :param item_id: Item ID associated with the pathway
        :type item_id: str
        :param name: Pathway name
        :type name: str
        :param pathway_uuid: Pathway UUID
        :type pathway_uuid: str
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Pathway slug (case-insensitive)
        :type slug: str
        :param username: Username of the pathway owner
        :type username: str
        :param visible: Whether the pathway is visible
        :type visible: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_pathways_destroy_serialize(
            pathway_id=pathway_id,
            user_id=user_id,
            item_id=item_id,
            name=name,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            username=username,
            visible=visible,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PathwayDeleteResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_pathways_destroy_serialize(
        self,
        pathway_id,
        user_id,
        item_id,
        name,
        pathway_uuid,
        platform_key,
        slug,
        username,
        visible,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if visible is not None:
            
            _query_params.append(('visible', visible))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_pathways_list(
        self,
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the pathway")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway name")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway ID")] = None,
        pathway_uuid: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway UUID")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Pathway slug (case-insensitive)")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID of the pathway owner")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username of the pathway owner")] = None,
        visible: Annotated[Optional[StrictBool], Field(description="Whether the pathway is visible")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_pathways_list

        Retrieve pathways matching query. Limited parameters.

        :param item_id: Item ID associated with the pathway
        :type item_id: str
        :param name: Pathway name
        :type name: str
        :param pathway_id: Pathway ID
        :type pathway_id: str
        :param pathway_uuid: Pathway UUID
        :type pathway_uuid: str
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Pathway slug (case-insensitive)
        :type slug: str
        :param user_id: User ID of the pathway owner
        :type user_id: int
        :param username: Username of the pathway owner
        :type username: str
        :param visible: Whether the pathway is visible
        :type visible: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_pathways_list_serialize(
            item_id=item_id,
            name=name,
            pathway_id=pathway_id,
            pathway_uuid=pathway_uuid,
            platform_key=platform_key,
            slug=slug,
            user_id=user_id,
            username=username,
            visible=visible,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Pathway]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_pathways_list_serialize(
        self,
        item_id,
        name,
        pathway_id,
        pathway_uuid,
        platform_key,
        slug,
        user_id,
        username,
        visible,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if pathway_uuid is not None:
            
            _query_params.append(('pathway_uuid', pathway_uuid))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        if visible is not None:
            
            _query_params.append(('visible', visible))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/pathways/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_programs_create(
        self,
        program_create_update_request: ProgramCreateUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_programs_create

        Add or update a program. Accepts a list of courses and updates or creates a program.

        :param program_create_update_request: (required)
        :type program_create_update_request: ProgramCreateUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_programs_create_serialize(
            program_create_update_request=program_create_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Program",
            '201': "Program",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_programs_create_serialize(
        self,
        program_create_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_create_update_request is not None:
            _body_params = program_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_programs_destroy(
        self,
        org: Annotated[str, Field(min_length=1, strict=True, description="Organization of the program")],
        program_id: Annotated[str, Field(min_length=1, strict=True, description="Program ID to delete")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_programs_destroy

        Remove a program from the database. Requires program_id and org as parameters.

        :param org: Organization of the program (required)
        :type org: str
        :param program_id: Program ID to delete (required)
        :type program_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_programs_destroy_serialize(
            org=org,
            program_id=program_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramDeleteResponse",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_programs_destroy_serialize(
        self,
        org,
        program_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_programs_list(
        self,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Course ID contained in the program")] = None,
        enabled: Annotated[Optional[StrictBool], Field(description="Whether the program is enabled")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program name")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization of the program")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program ID")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Program slug (case-insensitive)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_programs_list

        Retrieve programs matching query parameters. Limited parameters include program_id, name, slug, enabled, and org.

        :param course_id: Course ID contained in the program
        :type course_id: str
        :param enabled: Whether the program is enabled
        :type enabled: bool
        :param name: Program name
        :type name: str
        :param org: Organization of the program
        :type org: str
        :param program_id: Program ID
        :type program_id: str
        :param slug: Program slug (case-insensitive)
        :type slug: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_programs_list_serialize(
            course_id=course_id,
            enabled=enabled,
            name=name,
            org=org,
            program_id=program_id,
            slug=slug,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Program]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_programs_list_serialize(
        self,
        course_id,
        enabled,
        name,
        org,
        program_id,
        slug,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if enabled is not None:
            
            _query_params.append(('enabled', enabled))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_recommendation_courses_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="Current course ID")],
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Organization to filter recommendations")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="User ID for personalized recommendations")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_recommendation_courses_retrieve

        GET Get a 'next' course  This method retrieves the next recommended course for a user based on the provided parameters. It expects the following parameters in the request query: - user_id: The ID of the user for whom the next course is being recommended. - course_id: The ID of the current course. - org: The organization associated with the course.  Returns: - A serialized representation of the next course if found, with a status code of 200. - A status code of 400 if the course_id is not provided. - A status code of 200 with a None response if no next course is found.  Error Conditions: - Returns a 400 status code if the course_id is missing from the request parameters.  Side Effects: - None

        :param course_id: Current course ID (required)
        :type course_id: str
        :param org: Organization to filter recommendations
        :type org: str
        :param user_id: User ID for personalized recommendations
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_recommendation_courses_retrieve_serialize(
            course_id=course_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Course",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_recommendation_courses_retrieve_serialize(
        self,
        course_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/recommendation/courses/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_resources_create(
        self,
        resource_type2: Annotated[StrictStr, Field(description="Type of resource (e.g., video, document)")],
        url: Annotated[StrictStr, Field(description="URL of the resource")],
        name2: Annotated[StrictStr, Field(description="Name of the resource")],
        id: Annotated[Optional[StrictInt], Field(description="Resource ID")] = None,
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the resource")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Resource name")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key (alternative to key)")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization (alternative to org)")] = None,
        resource_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Type of resource")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID who owns the resource")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username who owns the resource")] = None,
        id2: Annotated[Optional[StrictInt], Field(description="Resource ID for updates")] = None,
        user_id2: Annotated[Optional[StrictInt], Field(description="User ID of the resource owner")] = None,
        username2: Annotated[Optional[StrictStr], Field(description="Username of the resource owner")] = None,
        description: Annotated[Optional[StrictStr], Field(description="Description of the resource")] = None,
        skills: Annotated[Optional[List[StrictStr]], Field(description="List of skill names associated with the resource")] = None,
        image: Annotated[Optional[StrictStr], Field(description="Image file")] = None,
        data: Annotated[Optional[Any], Field(description="Additional metadata for the resource")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create or update a resource with optional image upload

        Create or update a resource. For updates, include the resource ID.

        :param resource_type2: Type of resource (e.g., video, document) (required)
        :type resource_type2: str
        :param url: URL of the resource (required)
        :type url: str
        :param name2: Name of the resource (required)
        :type name2: str
        :param id: Resource ID
        :type id: int
        :param item_id: Item ID associated with the resource
        :type item_id: str
        :param key: Platform key
        :type key: str
        :param name: Resource name
        :type name: str
        :param org: Platform organization
        :type org: str
        :param platform_key: Platform key (alternative to key)
        :type platform_key: str
        :param platform_org: Platform organization (alternative to org)
        :type platform_org: str
        :param resource_type: Type of resource
        :type resource_type: str
        :param user_id: User ID who owns the resource
        :type user_id: int
        :param username: Username who owns the resource
        :type username: str
        :param id2: Resource ID for updates
        :type id2: int
        :param user_id2: User ID of the resource owner
        :type user_id2: int
        :param username2: Username of the resource owner
        :type username2: str
        :param description: Description of the resource
        :type description: str
        :param skills: List of skill names associated with the resource
        :type skills: List[str]
        :param image: Image file
        :type image: str
        :param data: Additional metadata for the resource
        :type data: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_resources_create_serialize(
            resource_type2=resource_type2,
            url=url,
            name2=name2,
            id=id,
            item_id=item_id,
            key=key,
            name=name,
            org=org,
            platform_key=platform_key,
            platform_org=platform_org,
            resource_type=resource_type,
            user_id=user_id,
            username=username,
            id2=id2,
            user_id2=user_id2,
            username2=username2,
            description=description,
            skills=skills,
            image=image,
            data=data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Resource",
            '400': "Dict[str, object]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_resources_create_serialize(
        self,
        resource_type2,
        url,
        name2,
        id,
        item_id,
        key,
        name,
        org,
        platform_key,
        platform_org,
        resource_type,
        user_id,
        username,
        id2,
        user_id2,
        username2,
        description,
        skills,
        image,
        data,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'skills': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        if id2 is not None:
            _form_params.append(('id', id2))
        if user_id2 is not None:
            _form_params.append(('user_id', user_id2))
        if username2 is not None:
            _form_params.append(('username', username2))
        if resource_type2 is not None:
            _form_params.append(('resource_type', resource_type2))
        if url is not None:
            _form_params.append(('url', url))
        if name2 is not None:
            _form_params.append(('name', name2))
        if description is not None:
            _form_params.append(('description', description))
        if skills is not None:
            _form_params.append(('skills', skills))
        if image is not None:
            _form_params.append(('image', image))
        if data is not None:
            _form_params.append(('data', data))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded', 
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/resources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_resources_destroy(
        self,
        id: Annotated[StrictInt, Field(description="Resource ID to delete")],
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the resource")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Resource name")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization (alternative to org)")] = None,
        resource_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Type of resource")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID who owns the resource")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username who owns the resource")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_resources_destroy

        Remove a resource from the database.

        :param id: Resource ID to delete (required)
        :type id: int
        :param item_id: Item ID associated with the resource
        :type item_id: str
        :param key: Platform key
        :type key: str
        :param name: Resource name
        :type name: str
        :param org: Platform organization
        :type org: str
        :param platform_key: Platform key
        :type platform_key: str
        :param platform_org: Platform organization (alternative to org)
        :type platform_org: str
        :param resource_type: Type of resource
        :type resource_type: str
        :param user_id: User ID who owns the resource
        :type user_id: int
        :param username: Username who owns the resource
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_resources_destroy_serialize(
            id=id,
            item_id=item_id,
            key=key,
            name=name,
            org=org,
            platform_key=platform_key,
            platform_org=platform_org,
            resource_type=resource_type,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResourceDeleteResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_resources_destroy_serialize(
        self,
        id,
        item_id,
        key,
        name,
        org,
        platform_key,
        platform_org,
        resource_type,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/resources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_resources_list(
        self,
        id: Annotated[Optional[StrictInt], Field(description="Resource ID")] = None,
        item_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Item ID associated with the resource")] = None,
        key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Resource name")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key (alternative to key)")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform organization (alternative to org)")] = None,
        resource_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Type of resource")] = None,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID who owns the resource")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username who owns the resource")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_resources_list

        Retrieve resources matching query. Limited parameters.

        :param id: Resource ID
        :type id: int
        :param item_id: Item ID associated with the resource
        :type item_id: str
        :param key: Platform key
        :type key: str
        :param name: Resource name
        :type name: str
        :param org: Platform organization
        :type org: str
        :param platform_key: Platform key (alternative to key)
        :type platform_key: str
        :param platform_org: Platform organization (alternative to org)
        :type platform_org: str
        :param resource_type: Type of resource
        :type resource_type: str
        :param user_id: User ID who owns the resource
        :type user_id: int
        :param username: Username who owns the resource
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_resources_list_serialize(
            id=id,
            item_id=item_id,
            key=key,
            name=name,
            org=org,
            platform_key=platform_key,
            platform_org=platform_org,
            resource_type=resource_type,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Resource]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_resources_list_serialize(
        self,
        id,
        item_id,
        key,
        name,
        org,
        platform_key,
        platform_org,
        resource_type,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if key is not None:
            
            _query_params.append(('key', key))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/resources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_course_info_retrieve(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID to get review information for")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_course_info_retrieve

        Retrieve aggregate review information for a course.

        :param course_id: The course ID to get review information for (required)
        :type course_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_course_info_retrieve_serialize(
            course_id=course_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseReviewInfoResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_course_info_retrieve_serialize(
        self,
        course_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/reviews/course/info/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_course_retrieve(
        self,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by course ID")] = None,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alias for platform_org")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by platform organization")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (default: '-id')")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by user ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_course_retrieve

        Retrieve a paginated list of course reviews with filtering options

        :param course_id: Filter reviews by course ID
        :type course_id: str
        :param org: Alias for platform_org
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Filter reviews by platform key
        :type platform_key: str
        :param platform_org: Filter reviews by platform organization
        :type platform_org: str
        :param sort: Field to sort results by (default: '-id')
        :type sort: str
        :param user_id: Filter reviews by user ID
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_course_retrieve_serialize(
            course_id=course_id,
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            sort=sort,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseReviewPaginatedResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_course_retrieve_serialize(
        self,
        course_id,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        sort,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/reviews/course/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_course_update_create(
        self,
        course_review_request: CourseReviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_course_update_create

        Create or update a course review

        :param course_review_request: (required)
        :type course_review_request: CourseReviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_course_update_create_serialize(
            course_review_request=course_review_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseReviewResponse",
            '201': "CourseReviewResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_course_update_create_serialize(
        self,
        course_review_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_review_request is not None:
            _body_params = course_review_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/reviews/course/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_course_update_destroy(
        self,
        course_id: Annotated[str, Field(min_length=1, strict=True, description="The course ID of the review to delete")],
        username: Annotated[str, Field(min_length=1, strict=True, description="The username of the reviewer")],
        user_id: Annotated[Optional[StrictInt], Field(description="The user ID of the reviewer (alternative to username)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_course_update_destroy

        Delete a course review

        :param course_id: The course ID of the review to delete (required)
        :type course_id: str
        :param username: The username of the reviewer (required)
        :type username: str
        :param user_id: The user ID of the reviewer (alternative to username)
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_course_update_destroy_serialize(
            course_id=course_id,
            username=username,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_course_update_destroy_serialize(
        self,
        course_id,
        username,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/reviews/course/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_program_info_retrieve(
        self,
        program_key: Annotated[str, Field(min_length=1, strict=True, description="The program key to get review information for")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_program_info_retrieve

        Retrieve aggregate review information for a program.

        :param program_key: The program key to get review information for (required)
        :type program_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_program_info_retrieve_serialize(
            program_key=program_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramReviewInfoResponse",
            '400': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_program_info_retrieve_serialize(
        self,
        program_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/reviews/program/info/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_program_retrieve(
        self,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Alias for platform_org")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by platform key")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by platform organization")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by program ID")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by (default: '-id')")] = None,
        user_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter reviews by user ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_program_retrieve

        Retrieve a paginated list of program reviews with filtering options

        :param org: Alias for platform_org
        :type org: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Filter reviews by platform key
        :type platform_key: str
        :param platform_org: Filter reviews by platform organization
        :type platform_org: str
        :param program_id: Filter reviews by program ID
        :type program_id: str
        :param sort: Field to sort results by (default: '-id')
        :type sort: str
        :param user_id: Filter reviews by user ID
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_program_retrieve_serialize(
            org=org,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            platform_org=platform_org,
            program_id=program_id,
            sort=sort,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramReviewPaginatedResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_program_retrieve_serialize(
        self,
        org,
        page,
        page_size,
        platform_key,
        platform_org,
        program_id,
        sort,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/reviews/program/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_program_update_create(
        self,
        program_review_request: ProgramReviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_program_update_create

        Create or update a program review

        :param program_review_request: (required)
        :type program_review_request: ProgramReviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_program_update_create_serialize(
            program_review_request=program_review_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramReview",
            '201': "ProgramReview",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_program_update_create_serialize(
        self,
        program_review_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_review_request is not None:
            _body_params = program_review_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/reviews/program/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_reviews_program_update_destroy(
        self,
        program_key: Annotated[str, Field(min_length=1, strict=True, description="The program key of the review to delete")],
        username: Annotated[str, Field(min_length=1, strict=True, description="The username of the reviewer")],
        user_id: Annotated[Optional[StrictInt], Field(description="The user ID of the reviewer (alternative to username)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_reviews_program_update_destroy

        Delete a program review

        :param program_key: The program key of the review to delete (required)
        :type program_key: str
        :param username: The username of the reviewer (required)
        :type username: str
        :param user_id: The user ID of the reviewer (alternative to username)
        :type user_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_reviews_program_update_destroy_serialize(
            program_key=program_key,
            username=username,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_reviews_program_update_destroy_serialize(
        self,
        program_key,
        username,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if program_key is not None:
            
            _query_params.append(('program_key', program_key))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/reviews/program/update/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_create(
        self,
        role_create_update_request: RoleCreateUpdateRequest,
        id: Annotated[Optional[StrictInt], Field(description="Role ID")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Role name")] = None,
        name__iexact: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Exact match for role name (case insensitive)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Role slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_create

        Add a new role or update an existing role based on provided data.

        :param role_create_update_request: (required)
        :type role_create_update_request: RoleCreateUpdateRequest
        :param id: Role ID
        :type id: int
        :param name: Role name
        :type name: str
        :param name__iexact: Exact match for role name (case insensitive)
        :type name__iexact: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Role slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_create_serialize(
            role_create_update_request=role_create_update_request,
            id=id,
            name=name,
            name__iexact=name__iexact,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            slug=slug,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Role",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_create_serialize(
        self,
        role_create_update_request,
        id,
        name,
        name__iexact,
        page,
        page_size,
        platform_key,
        slug,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__iexact is not None:
            
            _query_params.append(('name__iexact', name__iexact))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if role_create_update_request is not None:
            _body_params = role_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/roles/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_desired_create(
        self,
        desired_role_create_update_request: DesiredRoleCreateUpdateRequest,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_desired_create

        Add or update desired roles for a user.

        :param desired_role_create_update_request: (required)
        :type desired_role_create_update_request: DesiredRoleCreateUpdateRequest
        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_desired_create_serialize(
            desired_role_create_update_request=desired_role_create_update_request,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DesiredRole",
            '201': "DesiredRole",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_desired_create_serialize(
        self,
        desired_role_create_update_request,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if desired_role_create_update_request is not None:
            _body_params = desired_role_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/roles/desired/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_desired_retrieve(
        self,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_desired_retrieve

        Retrieve desired roles for a user.

        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_desired_retrieve_serialize(
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DesiredRole",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_desired_retrieve_serialize(
        self,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/roles/desired/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_public_create(
        self,
        role_create_update_request: RoleCreateUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_public_create

        Add or update a role through the public API (when enabled).

        :param role_create_update_request: (required)
        :type role_create_update_request: RoleCreateUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_public_create_serialize(
            role_create_update_request=role_create_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Role",
            '201': "Role",
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_public_create_serialize(
        self,
        role_create_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if role_create_update_request is not None:
            _body_params = role_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/roles/public/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_reported_create(
        self,
        reported_role_create_update_request: ReportedRoleCreateUpdateRequest,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_reported_create

        Add or update reported roles for a user.

        :param reported_role_create_update_request: (required)
        :type reported_role_create_update_request: ReportedRoleCreateUpdateRequest
        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_reported_create_serialize(
            reported_role_create_update_request=reported_role_create_update_request,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReportedRole",
            '201': "ReportedRole",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_reported_create_serialize(
        self,
        reported_role_create_update_request,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if reported_role_create_update_request is not None:
            _body_params = reported_role_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/roles/reported/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_reported_retrieve(
        self,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_reported_retrieve

        Retrieve reported roles for a user.

        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_reported_retrieve_serialize(
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReportedRole",
            '400': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_reported_retrieve_serialize(
        self,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/roles/reported/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_roles_retrieve(
        self,
        id: Annotated[Optional[StrictInt], Field(description="Role ID")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Role name")] = None,
        name__iexact: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Exact match for role name (case insensitive)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Role slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_roles_retrieve

        Retrieve roles matching query parameters. Supports filtering by name, id, and slug.

        :param id: Role ID
        :type id: int
        :param name: Role name
        :type name: str
        :param name__iexact: Exact match for role name (case insensitive)
        :type name__iexact: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Role slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_roles_retrieve_serialize(
            id=id,
            name=name,
            name__iexact=name__iexact,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            slug=slug,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Role",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_roles_retrieve_serialize(
        self,
        id,
        name,
        name__iexact,
        page,
        page_size,
        platform_key,
        slug,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__iexact is not None:
            
            _query_params.append(('name__iexact', name__iexact))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/roles/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_search_programs_create(
        self,
        program_search: ProgramSearch,
        org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization to which the programs belong")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The search term used to filter programs")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_search_programs_create

        POST Retrieve programs matching query.  Params: query: The search term used to filter programs. org: The organization to which the programs belong.  Returns: A JSON response containing a list of programs that match the search criteria.  Error Conditions: - If the request data is malformed or missing required fields, a 400 Bad Request may be returned. - If there is an issue with the database query, a 500 Internal Server Error may be returned.  Side Effects: - None  Special Return Codes: - A 200 status code indicates successful retrieval of programs matching the query.

        :param program_search: (required)
        :type program_search: ProgramSearch
        :param org: The organization to which the programs belong
        :type org: str
        :param query: The search term used to filter programs
        :type query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_search_programs_create_serialize(
            program_search=program_search,
            org=org,
            query=query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ProgramSearch",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_search_programs_create_serialize(
        self,
        program_search,
        org,
        query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if org is not None:
            
            _query_params.append(('org', org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if program_search is not None:
            _body_params = program_search


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/search/programs/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_create(
        self,
        paginated_skill: PaginatedSkill,
        id: Annotated[Optional[StrictInt], Field(description="Skill ID")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Skill name")] = None,
        name__iexact: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Exact match for skill name (case insensitive)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Skill slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_create

        Add or update a skill.

        :param paginated_skill: (required)
        :type paginated_skill: PaginatedSkill
        :param id: Skill ID
        :type id: int
        :param name: Skill name
        :type name: str
        :param name__iexact: Exact match for skill name (case insensitive)
        :type name__iexact: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Skill slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_create_serialize(
            paginated_skill=paginated_skill,
            id=id,
            name=name,
            name__iexact=name__iexact,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            slug=slug,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_create_serialize(
        self,
        paginated_skill,
        id,
        name,
        name__iexact,
        page,
        page_size,
        platform_key,
        slug,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__iexact is not None:
            
            _query_params.append(('name__iexact', name__iexact))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if paginated_skill is not None:
            _body_params = paginated_skill


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/skills/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_desired_create(
        self,
        desired_skill_create_update_request: DesiredSkillCreateUpdateRequest,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_desired_create

        Add or update desired skills for a user.

        :param desired_skill_create_update_request: (required)
        :type desired_skill_create_update_request: DesiredSkillCreateUpdateRequest
        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_desired_create_serialize(
            desired_skill_create_update_request=desired_skill_create_update_request,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DesiredSkill",
            '201': "DesiredSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_desired_create_serialize(
        self,
        desired_skill_create_update_request,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if desired_skill_create_update_request is not None:
            _body_params = desired_skill_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/skills/desired/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_desired_retrieve(
        self,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_desired_retrieve

        Retrieve desired skills for a user.

        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_desired_retrieve_serialize(
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DesiredSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_desired_retrieve_serialize(
        self,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/skills/desired/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_public_create(
        self,
        skill_create_update_request: SkillCreateUpdateRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_public_create

        Add or update a skill.

        :param skill_create_update_request: (required)
        :type skill_create_update_request: SkillCreateUpdateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_public_create_serialize(
            skill_create_update_request=skill_create_update_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Skill",
            '201': "Skill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_public_create_serialize(
        self,
        skill_create_update_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if skill_create_update_request is not None:
            _body_params = skill_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/skills/public/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_reported_create(
        self,
        reported_skill_create_update_request: ReportedSkillCreateUpdateRequest,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_reported_create

        Add or update reported skills for a user.

        :param reported_skill_create_update_request: (required)
        :type reported_skill_create_update_request: ReportedSkillCreateUpdateRequest
        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_reported_create_serialize(
            reported_skill_create_update_request=reported_skill_create_update_request,
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReportedSkill",
            '201': "ReportedSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_reported_create_serialize(
        self,
        reported_skill_create_update_request,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if reported_skill_create_update_request is not None:
            _body_params = reported_skill_create_update_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/skills/reported/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_reported_retrieve(
        self,
        user_id: Annotated[Optional[StrictInt], Field(description="User ID")] = None,
        username: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Username")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_reported_retrieve

        Retrieve reported skills for a user.

        :param user_id: User ID
        :type user_id: int
        :param username: Username
        :type username: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_reported_retrieve_serialize(
            user_id=user_id,
            username=username,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReportedSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_reported_retrieve_serialize(
        self,
        user_id,
        username,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if username is not None:
            
            _query_params.append(('username', username))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/skills/reported/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_skills_retrieve(
        self,
        id: Annotated[Optional[StrictInt], Field(description="Skill ID")] = None,
        name: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Skill name")] = None,
        name__iexact: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Exact match for skill name (case insensitive)")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Platform key")] = None,
        slug: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Skill slug")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_skills_retrieve

        Retrieve skills matching query. Limited parameters.

        :param id: Skill ID
        :type id: int
        :param name: Skill name
        :type name: str
        :param name__iexact: Exact match for skill name (case insensitive)
        :type name__iexact: str
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_key: Platform key
        :type platform_key: str
        :param slug: Skill slug
        :type slug: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_skills_retrieve_serialize(
            id=id,
            name=name,
            name__iexact=name__iexact,
            page=page,
            page_size=page_size,
            platform_key=platform_key,
            slug=slug,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedSkill",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_skills_retrieve_serialize(
        self,
        id,
        name,
        name__iexact,
        page,
        page_size,
        platform_key,
        slug,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__iexact is not None:
            
            _query_params.append(('name__iexact', name__iexact))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if slug is not None:
            
            _query_params.append(('slug', slug))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/catalog/skills/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_suggestions_course_manage_bulk_create(
        self,
        course_suggestion_bulk_create: CourseSuggestionBulkCreate,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_suggestions_course_manage_bulk_create

        API View for bulk management of course suggestions.  This endpoint allows administrators to create multiple course suggestions at once.  Methods:     POST: Create multiple course suggestions in bulk  Request Body:     A JSON object containing:     - platform_key (str, required): The platform for the suggestions     - suggestion_data (list, required): List of suggestion objects, each containing:       - course_id (str, required): The course ID to suggest       - user_id (str/int, required): The user to suggest the course to       - accepted (bool, optional): Whether the suggestion is accepted       - visible (bool, optional): Whether the suggestion is visible       - metadata (dict, optional): Additional suggestion metadata  Returns:     POST: A JSON response containing the operation results:         {             \"successes\": 15,             \"error_codes\": []         }  Error Responses:     400 Bad Request: If required parameters are missing or invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to manage suggestions     500 Internal Server Error: If an unexpected error occurs during bulk creation  Access Control:     - Requires IsDMAdmin, IsPlatformAdmin, or IsDepartmentModeAdminInPlatform permission     - Platform admins can create suggestions for their platform     - Department admins can create suggestions for their departments     - DM admins can create suggestions for any platform

        :param course_suggestion_bulk_create: (required)
        :type course_suggestion_bulk_create: CourseSuggestionBulkCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_suggestions_course_manage_bulk_create_serialize(
            course_suggestion_bulk_create=course_suggestion_bulk_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSuggestionResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_suggestions_course_manage_bulk_create_serialize(
        self,
        course_suggestion_bulk_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_suggestion_bulk_create is not None:
            _body_params = course_suggestion_bulk_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/suggestions/course/manage/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_suggestions_course_manage_create(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="The platform to retrieve suggestions for")],
        course_suggestion_create: CourseSuggestionCreate,
        department_mode: Annotated[Optional[StrictBool], Field(description="Filter suggestions by department admin access")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter suggestions")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_suggestions_course_manage_create

        API View for managing course suggestions.  This endpoint allows administrators to view, create, update, and delete course suggestions for users within a platform.  Query Parameters (GET):     platform_key (str, required): The platform to retrieve suggestions for     platform_org (str, optional): The organization identifier for the platform     query (str, optional): Search term to filter suggestions     sort (str, optional): Field to sort results by (default: '-id')     department_mode (bool, optional): Filter suggestions by department admin access     page (int, optional): Page number for pagination     page_size (int, optional): Number of items per page  Methods:     GET: Retrieve a paginated list of course suggestions for a platform     POST: Create or update a course suggestion     DELETE: Remove a course suggestion  Request Body (POST):     A JSON object containing:     - platform_key (str, required): The platform for the suggestion     - course_id (str, required): The course ID to suggest     - user_id (str/int, required): The user to suggest the course to     - accepted (bool, optional): Whether the suggestion is accepted     - visible (bool, optional): Whether the suggestion is visible     - metadata (dict, optional): Additional suggestion metadata  Query Parameters (DELETE):     suggestion_id (int, required): The ID of the suggestion to delete  Returns:     GET: A paginated JSON response containing course suggestions:         {             \"count\": 10,             \"next\": \"https://example.com/api/catalog/suggestions/course/manage/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"user_id\": 456,                     \"username\": \"student1\",                     \"name\": \"Student Name\",                     \"platform_key\": \"platform1\",                     \"accepted\": false,                     \"visible\": true,                     \"created\": \"2023-06-15T14:30:00Z\",                     \"modified\": \"2023-06-15T14:30:00Z\",                     \"metadata\": {},                     \"course_id\": \"course-v1:org+course+run\",                     \"course_name\": \"Introduction to Programming\"                 },                 ...             ]         }      POST: A JSON response containing the created/updated suggestion:         {             \"id\": 123,             \"user_id\": 456,             \"username\": \"student1\",             \"name\": \"Student Name\",             \"platform_key\": \"platform1\",             \"accepted\": false,             \"visible\": true,             \"created\": \"2023-06-15T14:30:00Z\",             \"modified\": \"2023-06-15T14:30:00Z\",             \"metadata\": {},             \"course_id\": \"course-v1:org+course+run\",             \"course_name\": \"Introduction to Programming\"         }      DELETE: A success response with status 200  Error Responses:     400 Bad Request: If required parameters are missing or invalid, or if suggestion operations fail     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to manage suggestions     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin, IsPlatformAdmin, or IsDepartmentModeAdminInPlatform permission     - Platform admins can manage suggestions for their platform     - Department admins can manage suggestions for their departments     - DM admins can manage all suggestions

        :param platform_key: The platform to retrieve suggestions for (required)
        :type platform_key: str
        :param course_suggestion_create: (required)
        :type course_suggestion_create: CourseSuggestionCreate
        :param department_mode: Filter suggestions by department admin access
        :type department_mode: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param query: Search term to filter suggestions
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_suggestions_course_manage_create_serialize(
            platform_key=platform_key,
            course_suggestion_create=course_suggestion_create,
            department_mode=department_mode,
            page=page,
            page_size=page_size,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseSuggestionDetail",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_suggestions_course_manage_create_serialize(
        self,
        platform_key,
        course_suggestion_create,
        department_mode,
        page,
        page_size,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_suggestion_create is not None:
            _body_params = course_suggestion_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/suggestions/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_suggestions_course_manage_destroy(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="The platform to retrieve suggestions for")],
        suggestion_id: Annotated[StrictInt, Field(description="The ID of the suggestion to delete")],
        department_mode: Annotated[Optional[StrictBool], Field(description="Flag to ensure department admins can call the API")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter suggestions")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_suggestions_course_manage_destroy

        Delete single suggestion

        :param platform_key: The platform to retrieve suggestions for (required)
        :type platform_key: str
        :param suggestion_id: The ID of the suggestion to delete (required)
        :type suggestion_id: int
        :param department_mode: Flag to ensure department admins can call the API
        :type department_mode: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param query: Search term to filter suggestions
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_suggestions_course_manage_destroy_serialize(
            platform_key=platform_key,
            suggestion_id=suggestion_id,
            department_mode=department_mode,
            page=page,
            page_size=page_size,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_suggestions_course_manage_destroy_serialize(
        self,
        platform_key,
        suggestion_id,
        department_mode,
        page,
        page_size,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if suggestion_id is not None:
            
            _query_params.append(('suggestion_id', suggestion_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/catalog/suggestions/course/manage/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_suggestions_course_manage_group_create(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="The platform to retrieve group suggestions for")],
        course_group_suggestion_create: CourseGroupSuggestionCreate,
        department_mode: Annotated[Optional[StrictBool], Field(description="Filter suggestions by department admin access")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter group suggestions")] = None,
        sort: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """catalog_suggestions_course_manage_group_create

        API View for managing course group suggestions.  This endpoint allows administrators to view, create, and delete course suggestions for groups of users within a platform.  Query Parameters (GET):     platform_key (str, required): The platform to retrieve group suggestions for     platform_org (str, optional): The organization identifier for the platform     query (str, optional): Search term to filter group suggestions     sort (str, optional): Field to sort results by (default: 'id')     department_mode (bool, optional): Filter suggestions by department admin access     page (int, optional): Page number for pagination     page_size (int, optional): Number of items per page  Methods:     GET: Retrieve a paginated list of course group suggestions for a platform     POST: Create or update a course group suggestion     DELETE: Remove a course group suggestion  Request Body (POST):     A JSON object containing:     - platform_key (str, required): The platform for the group suggestion     - course_id (str, required): The course ID to suggest     - group_id (str/int, required): The group to suggest the course to     - accepted (bool, optional): Whether the suggestion is accepted     - visible (bool, optional): Whether the suggestion is visible     - metadata (dict, optional): Additional suggestion metadata  Query Parameters (DELETE):     suggestion_id (int, required): The ID of the group suggestion to delete  Returns:     GET: A paginated JSON response containing course group suggestions:         {             \"count\": 5,             \"next\": \"https://example.com/api/catalog/suggestions/course/group/?page=2\",             \"previous\": null,             \"results\": [                 {                     \"id\": 123,                     \"group_id\": 789,                     \"group_name\": \"Engineering Team\",                     \"platform_key\": \"platform1\",                     \"accepted\": false,                     \"visible\": true,                     \"created\": \"2023-06-15T14:30:00Z\",                     \"modified\": \"2023-06-15T14:30:00Z\",                     \"metadata\": {},                     \"course_id\": \"course-v1:org+course+run\",                     \"course_name\": \"Introduction to Programming\",                     \"user_count\": 25                 },                 ...             ]         }      POST: A JSON response containing the created/updated group suggestion:         {             \"id\": 123,             \"group_id\": 789,             \"group_name\": \"Engineering Team\",             \"platform_key\": \"platform1\",             \"accepted\": false,             \"visible\": true,             \"created\": \"2023-06-15T14:30:00Z\",             \"modified\": \"2023-06-15T14:30:00Z\",             \"metadata\": {},             \"course_id\": \"course-v1:org+course+run\",             \"course_name\": \"Introduction to Programming\",             \"user_count\": 25         }      DELETE: A success response with status 200  Error Responses:     400 Bad Request: If required parameters are missing or invalid, or if group suggestion operations fail     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to manage group suggestions     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsDMAdmin, IsPlatformAdmin, or IsDepartmentModeAdminInPlatform permission     - Platform admins can manage group suggestions for their platform     - Department admins can manage group suggestions for their departments     - DM admins can manage all group suggestions

        :param platform_key: The platform to retrieve group suggestions for (required)
        :type platform_key: str
        :param course_group_suggestion_create: (required)
        :type course_group_suggestion_create: CourseGroupSuggestionCreate
        :param department_mode: Filter suggestions by department admin access
        :type department_mode: bool
        :param page: Page number for pagination
        :type page: int
        :param page_size: Number of items per page
        :type page_size: int
        :param platform_org: The organization identifier for the platform
        :type platform_org: str
        :param query: Search term to filter group suggestions
        :type query: str
        :param sort: Field to sort results by
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._catalog_suggestions_course_manage_group_create_serialize(
            platform_key=platform_key,
            course_group_suggestion_create=course_group_suggestion_create,
            department_mode=department_mode,
            page=page,
            page_size=page_size,
            platform_org=platform_org,
            query=query,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CourseGroupSuggestionDetail",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _catalog_suggestions_course_manage_group_create_serialize(
        self,
        platform_key,
        course_group_suggestion_create,
        department_mode,
        page,
        page_size,
        platform_org,
        query,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if department_mode is not None:
            
            _query_params.append(('department_mode', department_mode))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if platform_org is not None:
            
            _query_params.append(('platform_org', platform_org))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if course_group_suggestion_create is not None:
            _body_params = course_group_suggestion_create


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/catalog/suggestions/course/manage/group/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def catalog_suggestions_course_manage_group_destroy(
        self,
        platform_key: Annotated[str, Field(min_length=1, strict=True, description="The platform to retrieve group suggestions for")],
        suggestion_id: Annotated[StrictInt, Field(description="The ID of the group suggestion to delete")],
        department_mode: Annotated[Optional[StrictBool], Field(description="Flag to ensure department admins can call the API")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number for pagination")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of items per page")] = None,
        platform_org: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The organization identifier for the platform")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], F