# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from iblai.models.assertion import Assertion
from iblai.models.bulk_create_assertion import BulkCreateAssertion
from iblai.models.credential import Credential
from iblai.models.issuer import Issuer
from iblai.models.issuer_authority import IssuerAuthority
from iblai.models.over_time import OverTime
from iblai.models.overtime_with_change_info import OvertimeWithChangeInfo
from iblai.models.paginated_assertions_response import PaginatedAssertionsResponse
from iblai.models.uploaded_image import UploadedImage

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class CredentialsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def credentials_exim_credentials_course_export_retrieve(
        self,
        course_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_exim_credentials_course_export_retrieve

        Export credential information for a specific course.  Args:     request: The HTTP request object     course_id: Course ID to export credentials for  Returns:     Response: JSON response with credential data

        :param course_id: (required)
        :type course_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_exim_credentials_course_export_retrieve_serialize(
            course_id=course_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_exim_credentials_course_export_retrieve_serialize(
        self,
        course_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/exim/credentials/course/{course_id}/export/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_exim_credentials_course_import_create(
        self,
        course_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_exim_credentials_course_import_create

        Import credential information for a specific course.  Args:     request: The HTTP request object     course_id: Course ID to import credentials for  Returns:     Response: JSON response with import results

        :param course_id: (required)
        :type course_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_exim_credentials_course_import_create_serialize(
            course_id=course_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_exim_credentials_course_import_create_serialize(
        self,
        course_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if course_id is not None:
            _path_params['course_id'] = course_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/exim/credentials/course/{course_id}/import/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_bulk_create(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        bulk_create_assertion: BulkCreateAssertion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_bulk_create

        Endpoint to issue credential assertions in bulk for a specific credential.  This endpoint allows issuing credential assertions to multiple users at once.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  POST Request Body:     A JSON object containing:     - users (list): List of usernames to issue the credential to     - Additional metadata required for issuing the credential  Returns:     A JSON response containing:     {         \"skipped\": [\"username1\", \"username3\"],  // Users that were skipped (e.g., already have the credential)         \"issued\": [\"username2\", \"username4\"]    // Users that were successfully issued the credential     }  Error Responses:     400 Bad Request: If the request data is invalid or missing required fields     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param bulk_create_assertion: (required)
        :type bulk_create_assertion: BulkCreateAssertion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_bulk_create_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            bulk_create_assertion=bulk_create_assertion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkCreateAssertion",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_bulk_create_serialize(
        self,
        entity_id,
        org,
        user_id,
        bulk_create_assertion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_create_assertion is not None:
            _body_params = bulk_create_assertion


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}/assertions/bulk/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_create(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        assertion: Assertion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_create

        Endpoint to issue and retrieve credential assertions for a specific credential.  This endpoint allows issuing new credential assertions and retrieving existing assertions for a specific credential.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  Methods:     POST: Issue a new credential assertion     GET: Retrieve assertions for a specific credential  POST Request Body:     A JSON object containing recipient information and any additional metadata     required for issuing the credential.  Returns:     POST: A JSON response containing the created assertion using the AssertionSerializer format     GET: A paginated list of assertions using the AssertionSerializer format  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param assertion: (required)
        :type assertion: Assertion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_create_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            assertion=assertion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Assertion",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_create_serialize(
        self,
        entity_id,
        org,
        user_id,
        assertion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if assertion is not None:
            _body_params = assertion


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}/assertions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_over_time_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_over_time_retrieve

        Get all credentials of a given tenant

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_over_time_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OvertimeWithChangeInfo",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_over_time_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assertions-over-time/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        course: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None,
        exclude_main_tenant_assertions: Optional[StrictBool] = None,
        include_expired: Optional[StrictBool] = None,
        include_revoked: Optional[StrictBool] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_retrieve

        Endpoint to retrieve all credential assertions for a user within an organization.  This endpoint provides access to all credential assertions (issued credentials) for a specific user within an organization, with support for filtering.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID to retrieve assertions for  Query Parameters:     course (str, optional): Filter by course ID     include_revoked (bool, optional): Include revoked assertions (default: false)     include_expired (bool, optional): Include expired assertions (default: false)     exclude_main_tenant_assertions (bool, optional): Exclude assertions from the main tenant (default: false)  Returns:     A paginated response using the AssertionSerializer format  Error Responses:     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the user or organization doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param course:
        :type course: str
        :param exclude_main_tenant_assertions:
        :type exclude_main_tenant_assertions: bool
        :param include_expired:
        :type include_expired: bool
        :param include_revoked:
        :type include_revoked: bool
        :param page:
        :type page: int
        :param page_size:
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_retrieve_serialize(
            org=org,
            user_id=user_id,
            course=course,
            exclude_main_tenant_assertions=exclude_main_tenant_assertions,
            include_expired=include_expired,
            include_revoked=include_revoked,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedAssertionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_retrieve_serialize(
        self,
        org,
        user_id,
        course,
        exclude_main_tenant_assertions,
        include_expired,
        include_revoked,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course is not None:
            
            _query_params.append(('course', course))
            
        if exclude_main_tenant_assertions is not None:
            
            _query_params.append(('exclude_main_tenant_assertions', exclude_main_tenant_assertions))
            
        if include_expired is not None:
            
            _query_params.append(('include_expired', include_expired))
            
        if include_revoked is not None:
            
            _query_params.append(('include_revoked', include_revoked))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assertions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_retrieve2(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_retrieve2

        Endpoint to retrieve and update a specific credential assertion.  This endpoint allows retrieving details of a specific credential assertion and updating its status (e.g., revoking it).  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The assertion entity ID  Methods:     GET: Retrieve assertion details     PUT: Update assertion status (e.g., revoke)  PUT Request Body:     A JSON object containing:     - revoked (bool): Set to true to revoke the assertion     - revocationReason (str): Reason for revocation (required when revoking)  Returns:     GET: A JSON response containing the assertion details using the AssertionSerializer format     PUT: A JSON response containing the updated assertion using the AssertionSerializer format  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the assertion doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_retrieve2_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Assertion",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_retrieve2_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assertions/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_retrieve3(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_retrieve3

        Endpoint to issue and retrieve credential assertions for a specific credential.  This endpoint allows issuing new credential assertions and retrieving existing assertions for a specific credential.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  Methods:     POST: Issue a new credential assertion     GET: Retrieve assertions for a specific credential  POST Request Body:     A JSON object containing recipient information and any additional metadata     required for issuing the credential.  Returns:     POST: A JSON response containing the created assertion using the AssertionSerializer format     GET: A paginated list of assertions using the AssertionSerializer format  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_retrieve3_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedAssertionsResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_retrieve3_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}/assertions/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assertions_update(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        assertion: Assertion,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assertions_update

        Endpoint to retrieve and update a specific credential assertion.  This endpoint allows retrieving details of a specific credential assertion and updating its status (e.g., revoking it).  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The assertion entity ID  Methods:     GET: Retrieve assertion details     PUT: Update assertion status (e.g., revoke)  PUT Request Body:     A JSON object containing:     - revoked (bool): Set to true to revoke the assertion     - revocationReason (str): Reason for revocation (required when revoking)  Returns:     GET: A JSON response containing the assertion details using the AssertionSerializer format     PUT: A JSON response containing the updated assertion using the AssertionSerializer format  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the assertion doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param assertion: (required)
        :type assertion: Assertion
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assertions_update_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            assertion=assertion,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Assertion",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assertions_update_serialize(
        self,
        entity_id,
        org,
        user_id,
        assertion,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if assertion is not None:
            _body_params = assertion


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assertions/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assignments_destroy(
        self,
        assignment_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assignments_destroy

        Delete a credential assignment using its entity_id. Only platform admins and department admins can delete assignments.

        :param assignment_id: (required)
        :type assignment_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assignments_destroy_serialize(
            assignment_id=assignment_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assignments_destroy_serialize(
        self,
        assignment_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if assignment_id is not None:
            _path_params['assignment_id'] = assignment_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assignments/{assignment_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assignments_groups_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assignments_groups_create

        Create group assignment with department access validation

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assignments_groups_create_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assignments_groups_create_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assignments/groups/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assignments_groups_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assignments_groups_retrieve

        Get group assignments with department-aware filtering

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assignments_groups_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assignments_groups_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assignments/groups/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assignments_users_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assignments_users_create

        Create assignments with department access validation

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assignments_users_create_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assignments_users_create_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assignments/users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_assignments_users_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_assignments_users_retrieve

        Get assignments and their corresponding assertions based on user role: - Regular users: get only their own assignments - Platform admins: get assignments for all users in their platform - Department admins: get assignments for users in their department groups

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_assignments_users_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_assignments_users_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/assignments/users/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_course_assertions_over_time_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_course_assertions_over_time_retrieve

        Get all credentials of a given tenant

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_course_assertions_over_time_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_course_assertions_over_time_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/course-assertions-over-time/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_course_credentials_list(
        self,
        org: StrictStr,
        user_id: StrictStr,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_course_credentials_list

        Endpoint to retrieve the credentials of a given tenant grouped by course.  This endpoint provides access to credential data grouped by course for a specific organization/tenant, with support for pagination and filtering.  Path Parameters:     org (str): The organization/tenant identifier  Query Parameters:     limit (int, optional): Number of results per page (default: 10)     offset (int, optional): Starting position for pagination     search (str, optional): Search term e.g course_id  Returns:     A paginated response using the CourseCredentialSerializer format.  Error Responses:     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this data     404 Not Found: If the organization doesn't exist     500 Internal Server Error: If an unexpected error occurs

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_course_credentials_list_serialize(
            org=org,
            user_id=user_id,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_course_credentials_list_serialize(
        self,
        org,
        user_id,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/course-credentials/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        credential: Credential,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_create

        API View for managing credentials across a platform.  This endpoint allows creating and retrieving credentials for a specific organization/tenant, with support for filtering, searching, and pagination.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Query Parameters:     # Platform identification     platform_org (str, optional): Alternative platform identifier (takes precedence over URL org)      # Pagination     page (int, optional): Page number (default: 1)     page_size (int, optional): Items per page (default: 10, max: 100)      # Filtering and search     search (str, optional): Search term to filter credentials by name or description     course (str, optional): Course ID to filter credentials associated with a specific course     program (str, optional): Program ID to filter credentials associated with a specific program  Methods:     GET: Retrieve credentials with filtering and pagination     POST: Create a new credential  POST Request Body:     A JSON object containing credential details:     - name (str): Credential name     - description (str, optional): Credential description     - issuer (str): Issuer entity ID     - credential_type (str, optional): Type of credential     - html_template (str, optional): HTML template for credential rendering     - css_template (str, optional): CSS template for credential styling     - icon_image (str, optional): URL to credential icon     - background_image (str, optional): URL to credential background     - thumbnail_image (str, optional): URL to credential thumbnail     - criteria_url (str, optional): URL to credential criteria     - criteria_text (str, optional): Text description of credential criteria     - issuing_signal (str, optional): Signal that triggers credential issuance  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {                 \"next\": \"URL to next page\",                 \"previous\": \"URL to previous page\",                 \"count\": 42,                 \"data\": [                     {credential object},                     {credential object},                     ...                 ],                 \"num_pages\": 5,                 \"page_number\": 1,                 \"max_page_size\": 100             }         }      POST: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Created\"},             \"result\": {credential object}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the platform doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires CredentialAssignmentPermission     - Only public credentials are returned by default

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param credential: (required)
        :type credential: Credential
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_create_serialize(
            org=org,
            user_id=user_id,
            credential=credential,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Credential",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_create_serialize(
        self,
        org,
        user_id,
        credential,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if credential is not None:
            _body_params = credential


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_credentials_over_time_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        department_id: Annotated[Optional[StrictInt], Field(description="When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department ")] = None,
        end_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="end date. ISO 8601")] = None,
        format: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Format  * `json` - json")] = None,
        include_main_platform: Annotated[Optional[StrictBool], Field(description="Include main platform data")] = None,
        start_date: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="start date. ISO 8601")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_credentials_over_time_retrieve

        Get all credentials of a given tenant

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param department_id: When `department_mode=1` is passed, it allows to filter data for only user content groups for the specified department 
        :type department_id: int
        :param end_date: end date. ISO 8601
        :type end_date: str
        :param format: Format  * `json` - json
        :type format: str
        :param include_main_platform: Include main platform data
        :type include_main_platform: bool
        :param start_date: start date. ISO 8601
        :type start_date: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_credentials_over_time_retrieve_serialize(
            org=org,
            user_id=user_id,
            department_id=department_id,
            end_date=end_date,
            format=format,
            include_main_platform=include_main_platform,
            start_date=start_date,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OverTime",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_credentials_over_time_retrieve_serialize(
        self,
        org,
        user_id,
        department_id,
        end_date,
        format,
        include_main_platform,
        start_date,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if department_id is not None:
            
            _query_params.append(('department_id', department_id))
            
        if end_date is not None:
            
            _query_params.append(('end_date', end_date))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if include_main_platform is not None:
            
            _query_params.append(('include_main_platform', include_main_platform))
            
        if start_date is not None:
            
            _query_params.append(('start_date', start_date))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/credentials-over-time/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_destroy(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_destroy

        API View for managing individual credentials.  This endpoint allows retrieving, updating, and deleting specific credentials identified by their entity_id.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  Methods:     GET: Retrieve a specific credential     PUT: Update a specific credential     DELETE: Delete a specific credential  PUT Request Body:     A JSON object containing credential details to update:     - name (str, optional): Credential name     - description (str, optional): Credential description     - credential_type (str, optional): Type of credential     - html_template (str, optional): HTML template for credential rendering     - css_template (str, optional): CSS template for credential styling     - icon_image (str, optional): URL to credential icon     - background_image (str, optional): URL to credential background     - thumbnail_image (str, optional): URL to credential thumbnail     - criteria_url (str, optional): URL to credential criteria     - criteria_text (str, optional): Text description of credential criteria     - issuing_signal (str, optional): Signal that triggers credential issuance  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {credential object}         }      PUT: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Updated\"},             \"result\": {credential object}         }      DELETE: No content (204)  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires CredentialAssignmentPermission     - Users can only manage credentials they have permission to access

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_destroy_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_destroy_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_images_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        uploaded_image: Optional[UploadedImage] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_images_create

        API View for managing uploaded images for credentials.  This endpoint allows uploading new images and retrieving existing images for use with credentials (icons, backgrounds, thumbnails, etc.).  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Query Parameters:     query (str, required for GET): Search term to filter images by name  Methods:     GET: Retrieve images matching a search query     POST: Upload a new image  POST Request Body:     Multipart form data containing:     - image (file, required): The image file to upload     - name (str, optional): A descriptive name for the image  Returns:     GET: A JSON array of image objects:         [             {                 \"id\": 123,                 \"name\": \"Logo\",                 \"image\": \"https://example.com/media/uploaded_images/logo.png\"             },             {                 \"id\": 124,                 \"name\": \"Background\",                 \"image\": \"https://example.com/media/uploaded_images/background.jpg\"             },             ...         ]      POST: A JSON object containing the uploaded image details:         {             \"id\": 125,             \"name\": \"Certificate Icon\",             \"image\": \"https://example.com/media/uploaded_images/certificate-icon.png\"         }  Error Responses:     400 Bad Request: If the request data is invalid or missing required parameters     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can upload and retrieve images

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param uploaded_image:
        :type uploaded_image: UploadedImage
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_images_create_serialize(
            org=org,
            user_id=user_id,
            uploaded_image=uploaded_image,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadedImage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_images_create_serialize(
        self,
        org,
        user_id,
        uploaded_image,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if uploaded_image is not None:
            _body_params = uploaded_image


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/images/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_images_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_images_retrieve

        API View for managing uploaded images for credentials.  This endpoint allows uploading new images and retrieving existing images for use with credentials (icons, backgrounds, thumbnails, etc.).  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Query Parameters:     query (str, required for GET): Search term to filter images by name  Methods:     GET: Retrieve images matching a search query     POST: Upload a new image  POST Request Body:     Multipart form data containing:     - image (file, required): The image file to upload     - name (str, optional): A descriptive name for the image  Returns:     GET: A JSON array of image objects:         [             {                 \"id\": 123,                 \"name\": \"Logo\",                 \"image\": \"https://example.com/media/uploaded_images/logo.png\"             },             {                 \"id\": 124,                 \"name\": \"Background\",                 \"image\": \"https://example.com/media/uploaded_images/background.jpg\"             },             ...         ]      POST: A JSON object containing the uploaded image details:         {             \"id\": 125,             \"name\": \"Certificate Icon\",             \"image\": \"https://example.com/media/uploaded_images/certificate-icon.png\"         }  Error Responses:     400 Bad Request: If the request data is invalid or missing required parameters     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can upload and retrieve images

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_images_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UploadedImage",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_images_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/images/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_authority_create(
        self,
        org: StrictStr,
        user_id: StrictStr,
        issuer_authority: IssuerAuthority,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_authority_create

        API View for managing issuer authorities (signatories).  This endpoint allows creating authorities/signatories that can be associated with issuers or specific credentials.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Methods:     POST: Create a new issuer authority  POST Request Body:     A JSON object containing authority details:     - name (str, required): Name of the signatory     - title (str, required): Title of the signatory     - signature (str, required): URL to the signature image     - org (str, optional): Organization identifier to associate with an issuer     - entityId (str, optional): Issuer entity ID to associate with     - credential (str, optional): Credential entity ID to associate with  Returns:     POST: A JSON response containing the created authority:         {             \"data\": {                 \"name\": \"John Smith\",                 \"title\": \"President\",                 \"signature\": \"https://example.com/signatures/john-smith.png\"             }         }  Error Responses:     400 Bad Request: If the request data is invalid or missing required fields     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the issuer or credential doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage authorities

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param issuer_authority: (required)
        :type issuer_authority: IssuerAuthority
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_authority_create_serialize(
            org=org,
            user_id=user_id,
            issuer_authority=issuer_authority,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "IssuerAuthority",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_authority_create_serialize(
        self,
        org,
        user_id,
        issuer_authority,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if issuer_authority is not None:
            _body_params = issuer_authority


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/authority/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_create(
        self,
        org: StrictStr,
        q: Annotated[str, Field(min_length=1, strict=True)],
        user_id: StrictStr,
        issuer: Issuer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_create

        API View for managing credential issuers.  This endpoint allows creating and retrieving issuers for a specific organization/tenant, with support for filtering and pagination.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Query Parameters:     q (str, optional): Search term to filter issuers by name     limit (int, optional): Number of results per page (default: 50)     offset (int, optional): Starting position for pagination  Methods:     GET: Retrieve issuers with filtering and pagination     POST: Create a new issuer  POST Request Body:     A JSON object containing issuer details:     - name (str): Issuer name     - iconImage (str, optional): URL to issuer icon     - email (str, optional): Contact email for the issuer     - url (str, optional): Website URL for the issuer     - allowed_template_tags (array, optional): List of allowed template tags  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {                 \"next\": \"URL to next page\",                 \"previous\": \"URL to previous page\",                 \"count\": 10,                 \"data\": [                     {issuer object},                     {issuer object},                     ...                 ],                 \"num_pages\": 1,                 \"page_number\": 1,                 \"max_page_size\": 1000             }         }      POST: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Created\"},             \"result\": {issuer object}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the platform doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage issuers

        :param org: (required)
        :type org: str
        :param q: (required)
        :type q: str
        :param user_id: (required)
        :type user_id: str
        :param issuer: (required)
        :type issuer: Issuer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_create_serialize(
            org=org,
            q=q,
            user_id=user_id,
            issuer=issuer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Issuer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_create_serialize(
        self,
        org,
        q,
        user_id,
        issuer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if q is not None:
            
            _query_params.append(('q', q))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if issuer is not None:
            _body_params = issuer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_destroy(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_destroy

        API View for managing individual issuers.  This endpoint allows retrieving, updating, and deleting specific issuers identified by their entity_id or org identifier.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The issuer entity ID or org identifier  Methods:     GET: Retrieve a specific issuer     PUT: Update a specific issuer     DELETE: Delete a specific issuer  PUT Request Body:     A JSON object containing issuer details to update:     - name (str, optional): Issuer name     - iconImage (str, optional): URL to issuer icon     - email (str, optional): Contact email for the issuer     - url (str, optional): Website URL for the issuer     - allowed_template_tags (array, optional): List of allowed template tags  Returns:     GET: A JSON response containing the issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/logo.png\",                 \"allowed_template_tags\": [...]             }         ]      PUT: A JSON response containing the updated issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/new-logo.png\",                 \"allowed_template_tags\": [...]             }         ]      DELETE: A JSON response indicating success:         {             \"status\": {\"success\": true, \"description\": \"Deleted\"}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the issuer doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage issuers

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_destroy_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_destroy_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_retrieve(
        self,
        org: StrictStr,
        q: Annotated[str, Field(min_length=1, strict=True)],
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_retrieve

        API View for managing credential issuers.  This endpoint allows creating and retrieving issuers for a specific organization/tenant, with support for filtering and pagination.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request  Query Parameters:     q (str, optional): Search term to filter issuers by name     limit (int, optional): Number of results per page (default: 50)     offset (int, optional): Starting position for pagination  Methods:     GET: Retrieve issuers with filtering and pagination     POST: Create a new issuer  POST Request Body:     A JSON object containing issuer details:     - name (str): Issuer name     - iconImage (str, optional): URL to issuer icon     - email (str, optional): Contact email for the issuer     - url (str, optional): Website URL for the issuer     - allowed_template_tags (array, optional): List of allowed template tags  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {                 \"next\": \"URL to next page\",                 \"previous\": \"URL to previous page\",                 \"count\": 10,                 \"data\": [                     {issuer object},                     {issuer object},                     ...                 ],                 \"num_pages\": 1,                 \"page_number\": 1,                 \"max_page_size\": 1000             }         }      POST: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Created\"},             \"result\": {issuer object}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the platform doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage issuers

        :param org: (required)
        :type org: str
        :param q: (required)
        :type q: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_retrieve_serialize(
            org=org,
            q=q,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Issuer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_retrieve_serialize(
        self,
        org,
        q,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if q is not None:
            
            _query_params.append(('q', q))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_retrieve2(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_retrieve2

        API View for managing individual issuers.  This endpoint allows retrieving, updating, and deleting specific issuers identified by their entity_id or org identifier.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The issuer entity ID or org identifier  Methods:     GET: Retrieve a specific issuer     PUT: Update a specific issuer     DELETE: Delete a specific issuer  PUT Request Body:     A JSON object containing issuer details to update:     - name (str, optional): Issuer name     - iconImage (str, optional): URL to issuer icon     - email (str, optional): Contact email for the issuer     - url (str, optional): Website URL for the issuer     - allowed_template_tags (array, optional): List of allowed template tags  Returns:     GET: A JSON response containing the issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/logo.png\",                 \"allowed_template_tags\": [...]             }         ]      PUT: A JSON response containing the updated issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/new-logo.png\",                 \"allowed_template_tags\": [...]             }         ]      DELETE: A JSON response indicating success:         {             \"status\": {\"success\": true, \"description\": \"Deleted\"}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the issuer doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage issuers

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_retrieve2_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Issuer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_retrieve2_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_issuers_update(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        issuer: Issuer,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_issuers_update

        API View for managing individual issuers.  This endpoint allows retrieving, updating, and deleting specific issuers identified by their entity_id or org identifier.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The issuer entity ID or org identifier  Methods:     GET: Retrieve a specific issuer     PUT: Update a specific issuer     DELETE: Delete a specific issuer  PUT Request Body:     A JSON object containing issuer details to update:     - name (str, optional): Issuer name     - iconImage (str, optional): URL to issuer icon     - email (str, optional): Contact email for the issuer     - url (str, optional): Website URL for the issuer     - allowed_template_tags (array, optional): List of allowed template tags  Returns:     GET: A JSON response containing the issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/logo.png\",                 \"allowed_template_tags\": [...]             }         ]      PUT: A JSON response containing the updated issuer details:         [             {                 \"name\": \"Example University\",                 \"org\": \"example-university\",                 \"entityId\": \"abc123\",                 \"signatories\": [...],                 \"url\": \"https://example.com\",                 \"iconImage\": \"https://example.com/new-logo.png\",                 \"allowed_template_tags\": [...]             }         ]      DELETE: A JSON response indicating success:         {             \"status\": {\"success\": true, \"description\": \"Deleted\"}         }  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the issuer doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires IsAdminUserOrStudentDRFMixin     - Only authenticated users with appropriate permissions can manage issuers

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param issuer: (required)
        :type issuer: Issuer
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_issuers_update_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            issuer=issuer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Issuer",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_issuers_update_serialize(
        self,
        entity_id,
        org,
        user_id,
        issuer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if issuer is not None:
            _body_params = issuer


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/issuers/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_retrieve(
        self,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_retrieve

        Get all credentials for a platform with search and pagination support.  Query Parameters: - platform_org: Platform org ID (takes precedence over URL org) - page: Page number (default: 1) - page_size: Items per page (default: 10, max: 100) - search: Search term to filter credentials - course: Course ID to filter credentials - program: Program ID to filter credentials

        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_retrieve_serialize(
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Credential",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_retrieve_serialize(
        self,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_retrieve2(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_retrieve2

        API View for managing individual credentials.  This endpoint allows retrieving, updating, and deleting specific credentials identified by their entity_id.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  Methods:     GET: Retrieve a specific credential     PUT: Update a specific credential     DELETE: Delete a specific credential  PUT Request Body:     A JSON object containing credential details to update:     - name (str, optional): Credential name     - description (str, optional): Credential description     - credential_type (str, optional): Type of credential     - html_template (str, optional): HTML template for credential rendering     - css_template (str, optional): CSS template for credential styling     - icon_image (str, optional): URL to credential icon     - background_image (str, optional): URL to credential background     - thumbnail_image (str, optional): URL to credential thumbnail     - criteria_url (str, optional): URL to credential criteria     - criteria_text (str, optional): Text description of credential criteria     - issuing_signal (str, optional): Signal that triggers credential issuance  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {credential object}         }      PUT: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Updated\"},             \"result\": {credential object}         }      DELETE: No content (204)  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires CredentialAssignmentPermission     - Users can only manage credentials they have permission to access

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_retrieve2_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Credential",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_retrieve2_serialize(
        self,
        entity_id,
        org,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_orgs_users_update(
        self,
        entity_id: StrictStr,
        org: StrictStr,
        user_id: StrictStr,
        credential: Credential,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_orgs_users_update

        API View for managing individual credentials.  This endpoint allows retrieving, updating, and deleting specific credentials identified by their entity_id.  Path Parameters:     org (str): The organization/tenant identifier     user_id (str): The user ID making the request     entity_id (str): The credential entity ID  Methods:     GET: Retrieve a specific credential     PUT: Update a specific credential     DELETE: Delete a specific credential  PUT Request Body:     A JSON object containing credential details to update:     - name (str, optional): Credential name     - description (str, optional): Credential description     - credential_type (str, optional): Type of credential     - html_template (str, optional): HTML template for credential rendering     - css_template (str, optional): CSS template for credential styling     - icon_image (str, optional): URL to credential icon     - background_image (str, optional): URL to credential background     - thumbnail_image (str, optional): URL to credential thumbnail     - criteria_url (str, optional): URL to credential criteria     - criteria_text (str, optional): Text description of credential criteria     - issuing_signal (str, optional): Signal that triggers credential issuance  Returns:     GET: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Ok\"},             \"result\": {credential object}         }      PUT: A JSON response containing:         {             \"status\": {\"success\": true, \"description\": \"Updated\"},             \"result\": {credential object}         }      DELETE: No content (204)  Error Responses:     400 Bad Request: If the request data is invalid     401 Unauthorized: If the user is not authenticated     403 Forbidden: If the user does not have permission to access this resource     404 Not Found: If the credential doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Requires CredentialAssignmentPermission     - Users can only manage credentials they have permission to access

        :param entity_id: (required)
        :type entity_id: str
        :param org: (required)
        :type org: str
        :param user_id: (required)
        :type user_id: str
        :param credential: (required)
        :type credential: Credential
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_orgs_users_update_serialize(
            entity_id=entity_id,
            org=org,
            user_id=user_id,
            credential=credential,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Credential",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_orgs_users_update_serialize(
        self,
        entity_id,
        org,
        user_id,
        credential,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if credential is not None:
            _body_params = credential


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/credentials/orgs/{org}/users/{user_id}/{entity_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def credentials_public_assertions_retrieve(
        self,
        entity_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """credentials_public_assertions_retrieve

        Public endpoint to retrieve a specific credential assertion by its entity ID.  This endpoint allows public access to view a specific credential assertion without authentication.  Path Parameters:     entity_id (str): The assertion entity ID  Returns:     A JSON response containing the assertion details using the AssertionSerializer format  Error Responses:     404 Not Found:         - If the assertion doesn't exist: Empty response with 404 status         - If the assertion has been revoked: JSON with error detail and revocation reason     500 Internal Server Error: If an unexpected error occurs

        :param entity_id: (required)
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._credentials_public_assertions_retrieve_serialize(
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Assertion",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _credentials_public_assertions_retrieve_serialize(
        self,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if entity_id is not None:
            _path_params['entity_id'] = entity_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/credentials/public/assertions/{entity_id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


