# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from iblai.models.media_resource import MediaResource
from iblai.models.patched_media_resource import PatchedMediaResource

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class MediaApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def media_orgs_users_media_media_resources_by_item_retrieve(
        self,
        item_id: Annotated[StrictStr, Field(description="ID of the item")],
        item_type: Annotated[StrictStr, Field(description="Type of item. Valid values: course, unit, resource, course_unit, course_resource, unit_resource, all")],
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_by_item_retrieve

        Get media resources for a specific item. The item_type determines which resources are returned based on the provided item_id.

        :param item_id: ID of the item (required)
        :type item_id: str
        :param item_type: Type of item. Valid values: course, unit, resource, course_unit, course_resource, unit_resource, all (required)
        :type item_type: str
        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_by_item_retrieve_serialize(
            item_id=item_id,
            item_type=item_type,
            org=org,
            user_id=user_id,
            course_id=course_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_by_item_retrieve_serialize(
        self,
        item_id,
        item_type,
        org,
        user_id,
        course_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if item_type is not None:
            
            _query_params.append(('item_type', item_type))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/by_item/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_create(
        self,
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        media_resource: MediaResource,
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_create

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param media_resource: (required)
        :type media_resource: MediaResource
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_create_serialize(
            org=org,
            user_id=user_id,
            media_resource=media_resource,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_create_serialize(
        self,
        org,
        user_id,
        media_resource,
        course_id,
        item_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if media_resource is not None:
            _body_params = media_resource



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_destroy(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this Media Resource.")],
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_destroy

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param id: A unique integer value identifying this Media Resource. (required)
        :type id: int
        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_destroy_serialize(
            id=id,
            org=org,
            user_id=user_id,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_destroy_serialize(
        self,
        id,
        org,
        user_id,
        course_id,
        item_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_list(
        self,
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_list

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_list_serialize(
            org=org,
            user_id=user_id,
            course_id=course_id,
            item_id=item_id,
            page=page,
            page_size=page_size,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_list_serialize(
        self,
        org,
        user_id,
        course_id,
        item_id,
        page,
        page_size,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_partial_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this Media Resource.")],
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        patched_media_resource: Optional[PatchedMediaResource] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_partial_update

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param id: A unique integer value identifying this Media Resource. (required)
        :type id: int
        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param patched_media_resource:
        :type patched_media_resource: PatchedMediaResource
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_partial_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            patched_media_resource=patched_media_resource,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_partial_update_serialize(
        self,
        id,
        org,
        user_id,
        course_id,
        item_id,
        search,
        unit_id,
        patched_media_resource,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if patched_media_resource is not None:
            _body_params = patched_media_resource



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this Media Resource.")],
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_retrieve

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param id: A unique integer value identifying this Media Resource. (required)
        :type id: int
        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_retrieve_serialize(
            id=id,
            org=org,
            user_id=user_id,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_retrieve_serialize(
        self,
        id,
        org,
        user_id,
        course_id,
        item_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_search_retrieve(
        self,
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        q: Annotated[StrictStr, Field(description="Search query string")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        course_id: Annotated[Optional[StrictStr], Field(description="Filter results by course ID")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter results by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter results by unit ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_search_retrieve

        Search media resources by title, description, or IDs. Supports filtering results by course_id, unit_id, and item_id.

        :param org: Organization identifier (required)
        :type org: str
        :param q: Search query string (required)
        :type q: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param course_id: Filter results by course ID
        :type course_id: str
        :param item_id: Filter results by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter results by unit ID
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_search_retrieve_serialize(
            org=org,
            q=q,
            user_id=user_id,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_search_retrieve_serialize(
        self,
        org,
        q,
        user_id,
        course_id,
        item_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def media_orgs_users_media_media_resources_update(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this Media Resource.")],
        org: Annotated[StrictStr, Field(description="Organization identifier")],
        user_id: Annotated[StrictStr, Field(description="User identifier")],
        media_resource: MediaResource,
        course_id: Annotated[Optional[StrictStr], Field(description="Filter by course ID (e.g., course-v1:main+NB101+2025-T1)")] = None,
        item_id: Annotated[Optional[StrictStr], Field(description="Filter by item ID")] = None,
        search: Annotated[Optional[StrictStr], Field(description="Search across title, description, course_id, unit_id, item_id, and file_url")] = None,
        unit_id: Annotated[Optional[StrictStr], Field(description="Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """media_orgs_users_media_media_resources_update

        List and filter media resources. Supports filtering by course_id, unit_id, item_id and searching across multiple fields.

        :param id: A unique integer value identifying this Media Resource. (required)
        :type id: int
        :param org: Organization identifier (required)
        :type org: str
        :param user_id: User identifier (required)
        :type user_id: str
        :param media_resource: (required)
        :type media_resource: MediaResource
        :param course_id: Filter by course ID (e.g., course-v1:main+NB101+2025-T1)
        :type course_id: str
        :param item_id: Filter by item ID
        :type item_id: str
        :param search: Search across title, description, course_id, unit_id, item_id, and file_url
        :type search: str
        :param unit_id: Filter by unit ID (e.g., block-v1:main+NB101+2025-T1+type@vertical+block@12345)
        :type unit_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._media_orgs_users_media_media_resources_update_serialize(
            id=id,
            org=org,
            user_id=user_id,
            media_resource=media_resource,
            course_id=course_id,
            item_id=item_id,
            search=search,
            unit_id=unit_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _media_orgs_users_media_media_resources_update_serialize(
        self,
        id,
        org,
        user_id,
        media_resource,
        course_id,
        item_id,
        search,
        unit_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if org is not None:
            _path_params['org'] = org
        if user_id is not None:
            _path_params['user_id'] = user_id
        # process the query parameters
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if item_id is not None:
            
            _query_params.append(('item_id', item_id))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if unit_id is not None:
            
            _query_params.append(('unit_id', unit_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if media_resource is not None:
            _body_params = media_resource



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/scim+json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/media/orgs/{org}/users/{user_id}/media/media-resources/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


