# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.document_search_response import DocumentSearchResponse
from iblai.models.global_catalog_search_response import GlobalCatalogSearchResponse
from iblai.models.mentor_search_response import MentorSearchResponse
from iblai.models.prompt_search_response import PromptSearchResponse
from iblai.models.recommended_courses_response import RecommendedCoursesResponse
from iblai.models.user_search_response import UserSearchResponse

from iblai.api_client import ApiClient, RequestSerialized
from iblai.api_response import ApiResponse
from iblai.rest import RESTResponseType


class SearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def search_ai_search_retrieve(
        self,
        audience: Annotated[Optional[List[StrictStr]], Field(description="Filter by target audience")] = None,
        category: Annotated[Optional[List[StrictStr]], Field(description="Filter by mentor category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter mentors created by specific user")] = None,
        filter_facet: Annotated[Optional[StrictBool], Field(description="If present, return only facets without results")] = None,
        id: Annotated[Optional[StrictInt], Field(description="Retrieve a specific mentor by ID")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        llm: Annotated[Optional[List[StrictStr]], Field(description="Filter by language model type")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by ('created_at', 'recently_accessed_at')")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        page: Annotated[Optional[StrictInt], Field(description="Page number (1-based, used with page_size)")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter mentors by name or description")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        unique_id: Annotated[Optional[UUID], Field(description="Retrieve a specific mentor by UUID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_ai_search_retrieve

        Legacy endpoint for backward compatible mentor search

        :param audience: Filter by target audience
        :type audience: List[str]
        :param category: Filter by mentor category
        :type category: List[str]
        :param created_by: Filter mentors created by specific user
        :type created_by: str
        :param filter_facet: If present, return only facets without results
        :type filter_facet: bool
        :param id: Retrieve a specific mentor by ID
        :type id: int
        :param limit: Number of results per page
        :type limit: int
        :param llm: Filter by language model type
        :type llm: List[str]
        :param offset: Starting position for pagination
        :type offset: int
        :param order_by: Field to sort results by ('created_at', 'recently_accessed_at')
        :type order_by: str
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param page: Page number (1-based, used with page_size)
        :type page: int
        :param page_size: Number of results per page
        :type page_size: int
        :param query: Search term to filter mentors by name or description
        :type query: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param unique_id: Retrieve a specific mentor by UUID
        :type unique_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_ai_search_retrieve_serialize(
            audience=audience,
            category=category,
            created_by=created_by,
            filter_facet=filter_facet,
            id=id,
            limit=limit,
            llm=llm,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            page=page,
            page_size=page_size,
            query=query,
            tags=tags,
            tenant=tenant,
            unique_id=unique_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorSearchResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_ai_search_retrieve_serialize(
        self,
        audience,
        category,
        created_by,
        filter_facet,
        id,
        limit,
        llm,
        offset,
        order_by,
        order_direction,
        page,
        page_size,
        query,
        tags,
        tenant,
        unique_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'audience': 'multi',
            'category': 'multi',
            'llm': 'multi',
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if filter_facet is not None:
            
            _query_params.append(('filter_facet', filter_facet))
            
        if id is not None:
            
            _query_params.append(('id', id))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm is not None:
            
            _query_params.append(('llm', llm))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if unique_id is not None:
            
            _query_params.append(('unique_id', unique_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/ai-search/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_catalog_retrieve(
        self,
        allow_skill_search: Annotated[Optional[StrictBool], Field(description="Enable skill-based search")] = None,
        alphabetical: Annotated[Optional[StrictBool], Field(description="Sort alphabetically by name")] = None,
        certificate: Annotated[Optional[List[StrictStr]], Field(description="Filter by certificate type")] = None,
        content: Annotated[Optional[List[StrictStr]], Field(description="Content types to include in results")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific course ID")] = None,
        duration: Annotated[Optional[List[StrictStr]], Field(description="Filter by course duration range")] = None,
        language: Annotated[Optional[List[StrictStr]], Field(description="Filter by content language")] = None,
        level: Annotated[Optional[List[StrictStr]], Field(description="Filter by difficulty level")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_ascending: Annotated[Optional[StrictBool], Field(description="Sort direction")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific pathway ID")] = None,
        price: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by price/audit status")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific program ID")] = None,
        program_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by program type")] = None,
        promotion: Annotated[Optional[List[StrictStr]], Field(description="Filter by promotion status")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter content by name or description")] = None,
        resource_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by resource type")] = None,
        return_facet: Annotated[Optional[StrictBool], Field(description="Include facet data in response")] = None,
        return_items: Annotated[Optional[StrictBool], Field(description="Include items in programs/pathways")] = None,
        self_paced: Annotated[Optional[List[StrictStr]], Field(description="Filter by course format")] = None,
        skill_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by specific skill ID")] = None,
        skills: Annotated[Optional[List[StrictStr]], Field(description="Filter by skills")] = None,
        subject: Annotated[Optional[List[StrictStr]], Field(description="Filter by subject areas")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        topics: Annotated[Optional[List[StrictStr]], Field(description="Filter by topic areas")] = None,
        update_facet: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Force facet update")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_catalog_retrieve

        Search and filter content across the learning catalog.  This endpoint provides a powerful search interface for discovering content across multiple content types (courses, programs, pathways, skills, roles, resources). It supports full-text search, faceted filtering, and pagination.  Query Parameters:     query (str, optional): Search term to filter content by name or description     content (list, optional): Content types to include in results                              (courses, programs, pathways, skills, roles, resources)                              Default: [\"programs\", \"courses\", \"pathways\", \"skills\"]      # Filtering parameters     course_id (str, optional): Filter by specific course ID     program_id (str, optional): Filter by specific program ID     pathway_id (str, optional): Filter by specific pathway ID     skill_id (str, optional): Filter by specific skill ID     subject (list, optional): Filter by subject areas     tenant (list, optional): Filter by tenant/organization     topics (list, optional): Filter by topic areas     tags (list, optional): Filter by tags     level (list, optional): Filter by difficulty level     self_paced (list, optional): Filter by course format (self-paced, instructor-led)     promotion (list, optional): Filter by promotion status     language (list, optional): Filter by content language     certificate (list, optional): Filter by certificate type     program_type (list, optional): Filter by program type     duration (list, optional): Filter by course duration range     price (str, optional): Filter by price/audit status     resource_type (list, optional): Filter by resource type     skills (list, optional): Filter by skills      # Sorting and pagination     order_by (str, optional): Field to sort results by     order_ascending (bool, optional): Sort direction (default: false)     alphabetical (bool, optional): Sort alphabetically by name (default: false)     limit (int, optional): Number of results per page (default: 12, max: 100)     offset (int, optional): Starting position for pagination      # Response options     return_facet (bool, optional): Include facet data in response (default: true)     return_items (bool, optional): Include items in programs/pathways (default: false)     allow_skill_search (bool, optional): Enable skill-based search (default: false)     update_facet (str, optional): Force facet update  Returns:     A JSON response containing:     - results: List of content items with metadata     - count: Total number of matching items     - next: URL for the next page of results (if available)     - previous: URL for the previous page of results (if available)     - current_page: Current page number     - total_pages: Total number of pages     - facets: Aggregated counts for each filter category (if requested)  Each content item contains type-specific fields:     - Courses:         {             \"id\": 123,             \"type\": \"course\",             \"course_id\": \"CS101\",             \"name\": \"Introduction to Computer Science\",             \"description\": \"Learn the fundamentals of computer science\",             \"short_description\": \"CS fundamentals\",             \"image_url\": \"https://example.com/images/cs101.jpg\",             \"level\": \"Beginner\",             \"subject\": \"Computer Science\",             \"topics\": [\"Programming\", \"Algorithms\"],             \"tags\": [\"python\", \"coding\"],             \"language\": \"English\",             \"tenant\": \"example-university\",             \"self_paced\": true,             \"duration\": \"6 weeks\",             \"certificate\": \"Professional Certificate\",             \"price\": \"Free\",             \"skills\": [                 {\"id\": 1, \"name\": \"Python Programming\"},                 {\"id\": 2, \"name\": \"Algorithms\"}             ],             \"url\": \"https://example.com/courses/cs101\"         }      - Programs:         {             \"id\": 456,             \"type\": \"program\",             \"program_id\": \"PROG123\",             \"name\": \"Data Science Program\",             \"description\": \"Comprehensive data science curriculum\",             \"short_description\": \"Learn data science\",             \"image_url\": \"https://example.com/images/datascience.jpg\",             \"level\": \"Intermediate\",             \"subject\": \"Data Science\",             \"topics\": [\"Machine Learning\", \"Statistics\"],             \"program_type\": \"Professional Certificate\",             \"courses\": [                 {\"id\": 123, \"name\": \"Introduction to Python\"},                 {\"id\": 124, \"name\": \"Statistics for Data Science\"}             ],             \"url\": \"https://example.com/programs/prog123\"         }      - Pathways:         {             \"id\": 789,             \"type\": \"pathway\",             \"pathway_id\": \"PATH456\",             \"name\": \"Software Engineering Career Path\",             \"description\": \"Complete pathway to become a software engineer\",             \"image_url\": \"https://example.com/images/swe-path.jpg\",             \"programs\": [                 {\"id\": 456, \"name\": \"Programming Fundamentals\"},                 {\"id\": 457, \"name\": \"Web Development\"}             ],             \"url\": \"https://example.com/pathways/path456\"         }      - Skills:         {             \"id\": 321,             \"type\": \"skill\",             \"name\": \"Machine Learning\",             \"description\": \"Building systems that learn from data\",             \"courses\": [                 {\"id\": 125, \"name\": \"Machine Learning Fundamentals\"}             ],             \"related_skills\": [                 {\"id\": 322, \"name\": \"Deep Learning\"}             ]         }      - Roles:         {             \"id\": 654,             \"type\": \"role\",             \"name\": \"Data Scientist\",             \"description\": \"Professional who analyzes and interprets complex data\",             \"skills\": [                 {\"id\": 321, \"name\": \"Machine Learning\"},                 {\"id\": 323, \"name\": \"Data Analysis\"}             ],             \"recommended_courses\": [                 {\"id\": 125, \"name\": \"Machine Learning Fundamentals\"}             ]         }      - Resources:         {             \"id\": 987,             \"type\": \"resource\",             \"name\": \"Python Cheat Sheet\",             \"description\": \"Quick reference guide for Python\",             \"resource_type\": \"PDF\",             \"url\": \"https://example.com/resources/python-cheatsheet.pdf\",             \"topics\": [\"Programming\", \"Python\"]         }  Error Responses:     500 Internal Server Error: If an unexpected error occurs during processing  Notes:     - Results are cached for performance     - The 'resources' content type is only included by default if IBL_ENABLE_RESOURCES_IN_FACET is true     - For debugging, add ?debug=true to see detailed information about skill matching

        :param allow_skill_search: Enable skill-based search
        :type allow_skill_search: bool
        :param alphabetical: Sort alphabetically by name
        :type alphabetical: bool
        :param certificate: Filter by certificate type
        :type certificate: List[str]
        :param content: Content types to include in results
        :type content: List[str]
        :param course_id: Filter by specific course ID
        :type course_id: str
        :param duration: Filter by course duration range
        :type duration: List[str]
        :param language: Filter by content language
        :type language: List[str]
        :param level: Filter by difficulty level
        :type level: List[str]
        :param limit: Number of results per page
        :type limit: int
        :param offset: Starting position for pagination
        :type offset: int
        :param order_ascending: Sort direction
        :type order_ascending: bool
        :param order_by: Field to sort results by
        :type order_by: str
        :param pathway_id: Filter by specific pathway ID
        :type pathway_id: str
        :param price: Filter by price/audit status
        :type price: str
        :param program_id: Filter by specific program ID
        :type program_id: str
        :param program_type: Filter by program type
        :type program_type: List[str]
        :param promotion: Filter by promotion status
        :type promotion: List[str]
        :param query: Search term to filter content by name or description
        :type query: str
        :param resource_type: Filter by resource type
        :type resource_type: List[str]
        :param return_facet: Include facet data in response
        :type return_facet: bool
        :param return_items: Include items in programs/pathways
        :type return_items: bool
        :param self_paced: Filter by course format
        :type self_paced: List[str]
        :param skill_id: Filter by specific skill ID
        :type skill_id: str
        :param skills: Filter by skills
        :type skills: List[str]
        :param subject: Filter by subject areas
        :type subject: List[str]
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param topics: Filter by topic areas
        :type topics: List[str]
        :param update_facet: Force facet update
        :type update_facet: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_catalog_retrieve_serialize(
            allow_skill_search=allow_skill_search,
            alphabetical=alphabetical,
            certificate=certificate,
            content=content,
            course_id=course_id,
            duration=duration,
            language=language,
            level=level,
            limit=limit,
            offset=offset,
            order_ascending=order_ascending,
            order_by=order_by,
            pathway_id=pathway_id,
            price=price,
            program_id=program_id,
            program_type=program_type,
            promotion=promotion,
            query=query,
            resource_type=resource_type,
            return_facet=return_facet,
            return_items=return_items,
            self_paced=self_paced,
            skill_id=skill_id,
            skills=skills,
            subject=subject,
            tags=tags,
            tenant=tenant,
            topics=topics,
            update_facet=update_facet,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GlobalCatalogSearchResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_catalog_retrieve_serialize(
        self,
        allow_skill_search,
        alphabetical,
        certificate,
        content,
        course_id,
        duration,
        language,
        level,
        limit,
        offset,
        order_ascending,
        order_by,
        pathway_id,
        price,
        program_id,
        program_type,
        promotion,
        query,
        resource_type,
        return_facet,
        return_items,
        self_paced,
        skill_id,
        skills,
        subject,
        tags,
        tenant,
        topics,
        update_facet,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'certificate': 'multi',
            'content': 'multi',
            'duration': 'multi',
            'language': 'multi',
            'level': 'multi',
            'program_type': 'multi',
            'promotion': 'multi',
            'resource_type': 'multi',
            'self_paced': 'multi',
            'skills': 'multi',
            'subject': 'multi',
            'tags': 'multi',
            'topics': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if allow_skill_search is not None:
            
            _query_params.append(('allow_skill_search', allow_skill_search))
            
        if alphabetical is not None:
            
            _query_params.append(('alphabetical', alphabetical))
            
        if certificate is not None:
            
            _query_params.append(('certificate', certificate))
            
        if content is not None:
            
            _query_params.append(('content', content))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if duration is not None:
            
            _query_params.append(('duration', duration))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_ascending is not None:
            
            _query_params.append(('order_ascending', order_ascending))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if price is not None:
            
            _query_params.append(('price', price))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if promotion is not None:
            
            _query_params.append(('promotion', promotion))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if return_facet is not None:
            
            _query_params.append(('return_facet', return_facet))
            
        if return_items is not None:
            
            _query_params.append(('return_items', return_items))
            
        if self_paced is not None:
            
            _query_params.append(('self_paced', self_paced))
            
        if skill_id is not None:
            
            _query_params.append(('skill_id', skill_id))
            
        if skills is not None:
            
            _query_params.append(('skills', skills))
            
        if subject is not None:
            
            _query_params.append(('subject', subject))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        if update_facet is not None:
            
            _query_params.append(('update_facet', update_facet))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/catalog/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_mentors_documents_retrieve(
        self,
        mentor_unique_id: UUID,
        access: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by access level (e.g., 'public', 'private')")] = None,
        document_type: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by document type (e.g., 'pdf', 'text')")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by ('date_created', 'last_modified', 'document_name')")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        platform_key: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by platform key")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter documents by name or content")] = None,
        training_status: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by training status (e.g., 'trained', 'pending')")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_mentors_documents_retrieve

        Search and filter documents associated with a specific mentor

        :param mentor_unique_id: (required)
        :type mentor_unique_id: str
        :param access: Filter by access level (e.g., 'public', 'private')
        :type access: str
        :param document_type: Filter by document type (e.g., 'pdf', 'text')
        :type document_type: str
        :param limit: Number of results per page
        :type limit: int
        :param offset: Starting position for pagination
        :type offset: int
        :param order_by: Field to sort results by ('date_created', 'last_modified', 'document_name')
        :type order_by: str
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param platform_key: Filter by platform key
        :type platform_key: str
        :param query: Search term to filter documents by name or content
        :type query: str
        :param training_status: Filter by training status (e.g., 'trained', 'pending')
        :type training_status: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_mentors_documents_retrieve_serialize(
            mentor_unique_id=mentor_unique_id,
            access=access,
            document_type=document_type,
            limit=limit,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            platform_key=platform_key,
            query=query,
            training_status=training_status,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentSearchResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_mentors_documents_retrieve_serialize(
        self,
        mentor_unique_id,
        access,
        document_type,
        limit,
        offset,
        order_by,
        order_direction,
        platform_key,
        query,
        training_status,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if mentor_unique_id is not None:
            _path_params['mentor_unique_id'] = mentor_unique_id
        # process the query parameters
        if access is not None:
            
            _query_params.append(('access', access))
            
        if document_type is not None:
            
            _query_params.append(('document_type', document_type))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if platform_key is not None:
            
            _query_params.append(('platform_key', platform_key))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if training_status is not None:
            
            _query_params.append(('training_status', training_status))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/mentors/{mentor_unique_id}/documents/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_mentors_retrieve(
        self,
        audience: Annotated[Optional[List[StrictStr]], Field(description="Filter by target audience")] = None,
        category: Annotated[Optional[List[StrictStr]], Field(description="Filter by mentor category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter mentors created by specific user")] = None,
        featured: Annotated[Optional[StrictBool], Field(description="Filter by featured status")] = None,
        id: Annotated[Optional[StrictInt], Field(description="Retrieve a specific mentor by ID")] = None,
        include_main_public_mentors: Annotated[Optional[StrictBool], Field(description="Include public mentors from main tenant")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        llm: Annotated[Optional[List[StrictStr]], Field(description="Filter by language model type")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by ('created_at', 'recently_accessed_at')")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter mentors by name or description")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        unique_id: Annotated[Optional[UUID], Field(description="Retrieve a specific mentor by UUID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_mentors_retrieve

        Search and filter AI mentors across the platform.  This endpoint provides a powerful search interface for discovering AI mentors with support for filtering, pagination, and detailed mentor information.  Query Parameters:     # Identification parameters (for detail view)     id (int, optional): Retrieve a specific mentor by ID     unique_id (uuid, optional): Retrieve a specific mentor by UUID      # Search and filtering parameters     query (str, optional): Search term to filter mentors by name or description     tenant (str, optional): Filter by tenant/organization     llm (list, optional): Filter by language model type     audience (list, optional): Filter by target audience     category (list, optional): Filter by mentor category     tags (list, optional): Filter by tags     created_by (str, optional): Filter mentors created by specific user      # Sorting and pagination     order_by (str, optional): Field to sort results by ('created_at', 'recently_accessed_at')     order_direction (str, optional): Sort direction ('asc' or 'desc', default: 'desc')     limit (int, optional): Number of results per page (default: 12, max: 100)     offset (int, optional): Starting position for pagination  Returns:     For detail view (when id or unique_id is provided):         A JSON response containing a single mentor's details:         {             \"id\": 123,             \"unique_id\": \"550e8400-e29b-41d4-a716-446655440000\",             \"name\": \"Professor Smith\",             \"description\": \"AI mentor specializing in computer science\",             \"image_url\": \"https://example.com/images/prof-smith.jpg\",             \"llm\": {                 \"id\": 1,                 \"name\": \"GPT-4\",                 \"description\": \"Advanced language model\"             },             \"audience\": {                 \"id\": 2,                 \"name\": \"College Students\",                 \"description\": \"For university-level learners\"             },             \"category\": \"Computer Science\",             \"tags\": [\"programming\", \"algorithms\", \"data structures\"],             \"created_at\": \"2023-01-15T12:00:00Z\",             \"recently_accessed_at\": \"2023-06-20T15:30:00Z\",             \"platform\": {                 \"id\": 1,                 \"name\": \"Example University\",                 \"key\": \"example-university\"             },             \"visibility\": \"public\",             \"settings\": {                 \"temperature\": 0.7,                 \"max_tokens\": 1024,                 \"system_prompt\": \"You are Professor Smith, an expert in computer science...\"             }         }      For list view:         A JSON response containing:         {             \"results\": [                 {                     \"id\": 123,                     \"unique_id\": \"550e8400-e29b-41d4-a716-446655440000\",                     \"name\": \"Professor Smith\",                     \"description\": \"AI mentor specializing in computer science\",                     \"image_url\": \"https://example.com/images/prof-smith.jpg\",                     \"llm\": {\"id\": 1, \"name\": \"GPT-4\"},                     \"audience\": {\"id\": 2, \"name\": \"College Students\"},                     \"category\": \"Computer Science\",                     \"tags\": [\"programming\", \"algorithms\"],                     \"created_at\": \"2023-01-15T12:00:00Z\",                     \"recently_accessed_at\": \"2023-06-20T15:30:00Z\"                 },                 // Additional mentor objects...             ],             \"count\": 50,             \"next\": \"https://api.example.com/api/search/mentors/?limit=12&offset=12\",             \"previous\": null,             \"current_page\": 1,             \"num_pages\": 5,             \"facets\": {                 \"llm\": [                     {\"key\": \"GPT-4\", \"doc_count\": 30},                     {\"key\": \"Claude\", \"doc_count\": 20}                 ],                 \"audience\": [                     {\"key\": \"College Students\", \"doc_count\": 35},                     {\"key\": \"Professionals\", \"doc_count\": 15}                 ],                 \"category\": [                     {\"key\": \"Computer Science\", \"doc_count\": 25},                     {\"key\": \"Mathematics\", \"doc_count\": 15},                     {\"key\": \"Business\", \"doc_count\": 10}                 ]             }         }  Error Responses:     400 Bad Request: If the request parameters are invalid     404 Not Found: If the requested mentor doesn't exist     500 Internal Server Error: If an unexpected error occurs  Notes:     - Results are cached for performance     - Public mentors are visible to all users     - Private mentors are only visible to authorized users

        :param audience: Filter by target audience
        :type audience: List[str]
        :param category: Filter by mentor category
        :type category: List[str]
        :param created_by: Filter mentors created by specific user
        :type created_by: str
        :param featured: Filter by featured status
        :type featured: bool
        :param id: Retrieve a specific mentor by ID
        :type id: int
        :param include_main_public_mentors: Include public mentors from main tenant
        :type include_main_public_mentors: bool
        :param limit: Number of results per page
        :type limit: int
        :param llm: Filter by language model type
        :type llm: List[str]
        :param offset: Starting position for pagination
        :type offset: int
        :param order_by: Field to sort results by ('created_at', 'recently_accessed_at')
        :type order_by: str
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param query: Search term to filter mentors by name or description
        :type query: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param unique_id: Retrieve a specific mentor by UUID
        :type unique_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_mentors_retrieve_serialize(
            audience=audience,
            category=category,
            created_by=created_by,
            featured=featured,
            id=id,
            include_main_public_mentors=include_main_public_mentors,
            limit=limit,
            llm=llm,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            query=query,
            tags=tags,
            tenant=tenant,
            unique_id=unique_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorSearchResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_mentors_retrieve_serialize(
        self,
        audience,
        category,
        created_by,
        featured,
        id,
        include_main_public_mentors,
        limit,
        llm,
        offset,
        order_by,
        order_direction,
        query,
        tags,
        tenant,
        unique_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'audience': 'multi',
            'category': 'multi',
            'llm': 'multi',
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if featured is not None:
            
            _query_params.append(('featured', featured))
            
        if id is not None:
            
            _query_params.append(('id', id))
            
        if include_main_public_mentors is not None:
            
            _query_params.append(('include_main_public_mentors', include_main_public_mentors))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm is not None:
            
            _query_params.append(('llm', llm))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if unique_id is not None:
            
            _query_params.append(('unique_id', unique_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_orgs_users_mentors_retrieve(
        self,
        org: StrictStr,
        username: StrictStr,
        audience: Annotated[Optional[List[StrictStr]], Field(description="Filter by target audience")] = None,
        category: Annotated[Optional[List[StrictStr]], Field(description="Filter by mentor category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter mentors created by specific user")] = None,
        featured: Annotated[Optional[StrictBool], Field(description="Filter by featured status")] = None,
        id: Annotated[Optional[StrictInt], Field(description="Retrieve a specific mentor by ID")] = None,
        include_main_public_mentors: Annotated[Optional[StrictBool], Field(description="Include public mentors from main tenant")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        llm: Annotated[Optional[List[StrictStr]], Field(description="Filter by language model type")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by ('created_at', 'recently_accessed_at')")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter mentors by name or description")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        unique_id: Annotated[Optional[UUID], Field(description="Retrieve a specific mentor by UUID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_orgs_users_mentors_retrieve

        Handle GET requests for tenant-specific mentor search.  Args:     request: HTTP request object     org: Tenant/organization key     username: Username of the user making the request  Returns:     Response: DRF Response object with search results

        :param org: (required)
        :type org: str
        :param username: (required)
        :type username: str
        :param audience: Filter by target audience
        :type audience: List[str]
        :param category: Filter by mentor category
        :type category: List[str]
        :param created_by: Filter mentors created by specific user
        :type created_by: str
        :param featured: Filter by featured status
        :type featured: bool
        :param id: Retrieve a specific mentor by ID
        :type id: int
        :param include_main_public_mentors: Include public mentors from main tenant
        :type include_main_public_mentors: bool
        :param limit: Number of results per page
        :type limit: int
        :param llm: Filter by language model type
        :type llm: List[str]
        :param offset: Starting position for pagination
        :type offset: int
        :param order_by: Field to sort results by ('created_at', 'recently_accessed_at')
        :type order_by: str
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param query: Search term to filter mentors by name or description
        :type query: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param unique_id: Retrieve a specific mentor by UUID
        :type unique_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_orgs_users_mentors_retrieve_serialize(
            org=org,
            username=username,
            audience=audience,
            category=category,
            created_by=created_by,
            featured=featured,
            id=id,
            include_main_public_mentors=include_main_public_mentors,
            limit=limit,
            llm=llm,
            offset=offset,
            order_by=order_by,
            order_direction=order_direction,
            query=query,
            tags=tags,
            tenant=tenant,
            unique_id=unique_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MentorSearchResponse",
            '400': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_orgs_users_mentors_retrieve_serialize(
        self,
        org,
        username,
        audience,
        category,
        created_by,
        featured,
        id,
        include_main_public_mentors,
        limit,
        llm,
        offset,
        order_by,
        order_direction,
        query,
        tags,
        tenant,
        unique_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'audience': 'multi',
            'category': 'multi',
            'llm': 'multi',
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if audience is not None:
            
            _query_params.append(('audience', audience))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if featured is not None:
            
            _query_params.append(('featured', featured))
            
        if id is not None:
            
            _query_params.append(('id', id))
            
        if include_main_public_mentors is not None:
            
            _query_params.append(('include_main_public_mentors', include_main_public_mentors))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if llm is not None:
            
            _query_params.append(('llm', llm))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if unique_id is not None:
            
            _query_params.append(('unique_id', unique_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/orgs/{org}/users/{username}/mentors/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_orgs_users_prompts_retrieve(
        self,
        org: StrictStr,
        username: StrictStr,
        alphabetical: Annotated[Optional[StrictBool], Field(description="Sort alphabetically")] = None,
        category: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter prompts created by specific user")] = None,
        filter_facet: Annotated[Optional[StrictBool], Field(description="If true, return only facets without results")] = None,
        language: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt language")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        mentor: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by mentor UUID")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter prompts by name or content")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        style: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt style")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        tone: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt tone")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_orgs_users_prompts_retrieve

        Search and filter AI prompts for a specific user within a tenant.  This endpoint extends the base prompt search functionality but filters results to only show prompts that are available to a specific user within a specific organization/tenant.  Path Parameters:     org (str): The organization/tenant identifier     username (str): The username to filter prompts for  Query Parameters:     Same as PromptSearchView, plus:      # Identification parameters (for detail view)     id (int, optional): Retrieve a specific prompt by ID  Returns:     Same format as PromptSearchView, but filtered to only include prompts     that the specified user has access to within the specified organization.  Error Responses:     400 Bad Request: If the request parameters are invalid     403 Forbidden: If the requested prompt exists but the user doesn't have access     404 Not Found: If the requested prompt doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - Results are filtered based on user's permissions within the organization     - Private prompts are only visible to authorized users

        :param org: (required)
        :type org: str
        :param username: (required)
        :type username: str
        :param alphabetical: Sort alphabetically
        :type alphabetical: bool
        :param category: Filter by prompt category
        :type category: str
        :param created_by: Filter prompts created by specific user
        :type created_by: str
        :param filter_facet: If true, return only facets without results
        :type filter_facet: bool
        :param language: Filter by prompt language
        :type language: str
        :param limit: Number of results per page
        :type limit: int
        :param mentor: Filter by mentor UUID
        :type mentor: str
        :param offset: Starting position for pagination
        :type offset: int
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param query: Search term to filter prompts by name or content
        :type query: str
        :param sort_by: Field to sort results by
        :type sort_by: str
        :param style: Filter by prompt style
        :type style: str
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param tone: Filter by prompt tone
        :type tone: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_orgs_users_prompts_retrieve_serialize(
            org=org,
            username=username,
            alphabetical=alphabetical,
            category=category,
            created_by=created_by,
            filter_facet=filter_facet,
            language=language,
            limit=limit,
            mentor=mentor,
            offset=offset,
            order_direction=order_direction,
            query=query,
            sort_by=sort_by,
            style=style,
            tenant=tenant,
            tone=tone,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PromptSearchResponse",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_orgs_users_prompts_retrieve_serialize(
        self,
        org,
        username,
        alphabetical,
        category,
        created_by,
        filter_facet,
        language,
        limit,
        mentor,
        offset,
        order_direction,
        query,
        sort_by,
        style,
        tenant,
        tone,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if alphabetical is not None:
            
            _query_params.append(('alphabetical', alphabetical))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if filter_facet is not None:
            
            _query_params.append(('filter_facet', filter_facet))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if style is not None:
            
            _query_params.append(('style', style))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if tone is not None:
            
            _query_params.append(('tone', tone))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/orgs/{org}/users/{username}/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_orgs_users_recommended_retrieve(
        self,
        org: StrictStr,
        username: StrictStr,
        certificate: Annotated[Optional[List[StrictStr]], Field(description="Filter by certificate type")] = None,
        content: Annotated[Optional[List[StrictStr]], Field(description="Content types to include in recommendations (courses, programs, pathways, skills, roles, resources)")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific course by ID")] = None,
        duration: Annotated[Optional[List[StrictStr]], Field(description="Filter by course duration range")] = None,
        language: Annotated[Optional[List[StrictStr]], Field(description="Filter by content language")] = None,
        level: Annotated[Optional[List[StrictStr]], Field(description="Filter by difficulty level")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific pathway by ID")] = None,
        price: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by price/audit status")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific program by ID")] = None,
        program_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by program type")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter content by name or description")] = None,
        resource_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific resource by ID")] = None,
        resource_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by resource type")] = None,
        role_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific role by ID")] = None,
        self_paced: Annotated[Optional[List[StrictStr]], Field(description="Filter by course format (self-paced, instructor-led)")] = None,
        skill_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific skill by ID")] = None,
        skills: Annotated[Optional[List[StrictStr]], Field(description="Filter by skills")] = None,
        subject: Annotated[Optional[List[StrictStr]], Field(description="Filter by subject areas")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        topics: Annotated[Optional[List[StrictStr]], Field(description="Filter by topic areas")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_orgs_users_recommended_retrieve

        Determine whether to serve a detail view or a list view.

        :param org: (required)
        :type org: str
        :param username: (required)
        :type username: str
        :param certificate: Filter by certificate type
        :type certificate: List[str]
        :param content: Content types to include in recommendations (courses, programs, pathways, skills, roles, resources)
        :type content: List[str]
        :param course_id: Retrieve a specific course by ID
        :type course_id: str
        :param duration: Filter by course duration range
        :type duration: List[str]
        :param language: Filter by content language
        :type language: List[str]
        :param level: Filter by difficulty level
        :type level: List[str]
        :param limit: Number of results per page
        :type limit: int
        :param offset: Starting position for pagination
        :type offset: int
        :param pathway_id: Retrieve a specific pathway by ID
        :type pathway_id: str
        :param price: Filter by price/audit status
        :type price: str
        :param program_id: Retrieve a specific program by ID
        :type program_id: str
        :param program_type: Filter by program type
        :type program_type: List[str]
        :param query: Search term to filter content by name or description
        :type query: str
        :param resource_id: Retrieve a specific resource by ID
        :type resource_id: str
        :param resource_type: Filter by resource type
        :type resource_type: List[str]
        :param role_id: Retrieve a specific role by ID
        :type role_id: str
        :param self_paced: Filter by course format (self-paced, instructor-led)
        :type self_paced: List[str]
        :param skill_id: Retrieve a specific skill by ID
        :type skill_id: str
        :param skills: Filter by skills
        :type skills: List[str]
        :param subject: Filter by subject areas
        :type subject: List[str]
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param topics: Filter by topic areas
        :type topics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_orgs_users_recommended_retrieve_serialize(
            org=org,
            username=username,
            certificate=certificate,
            content=content,
            course_id=course_id,
            duration=duration,
            language=language,
            level=level,
            limit=limit,
            offset=offset,
            pathway_id=pathway_id,
            price=price,
            program_id=program_id,
            program_type=program_type,
            query=query,
            resource_id=resource_id,
            resource_type=resource_type,
            role_id=role_id,
            self_paced=self_paced,
            skill_id=skill_id,
            skills=skills,
            subject=subject,
            tags=tags,
            tenant=tenant,
            topics=topics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RecommendedCoursesResponse",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_orgs_users_recommended_retrieve_serialize(
        self,
        org,
        username,
        certificate,
        content,
        course_id,
        duration,
        language,
        level,
        limit,
        offset,
        pathway_id,
        price,
        program_id,
        program_type,
        query,
        resource_id,
        resource_type,
        role_id,
        self_paced,
        skill_id,
        skills,
        subject,
        tags,
        tenant,
        topics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'certificate': 'multi',
            'content': 'multi',
            'duration': 'multi',
            'language': 'multi',
            'level': 'multi',
            'program_type': 'multi',
            'resource_type': 'multi',
            'self_paced': 'multi',
            'skills': 'multi',
            'subject': 'multi',
            'tags': 'multi',
            'topics': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if certificate is not None:
            
            _query_params.append(('certificate', certificate))
            
        if content is not None:
            
            _query_params.append(('content', content))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if duration is not None:
            
            _query_params.append(('duration', duration))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if price is not None:
            
            _query_params.append(('price', price))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if resource_id is not None:
            
            _query_params.append(('resource_id', resource_id))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if role_id is not None:
            
            _query_params.append(('role_id', role_id))
            
        if self_paced is not None:
            
            _query_params.append(('self_paced', self_paced))
            
        if skill_id is not None:
            
            _query_params.append(('skill_id', skill_id))
            
        if skills is not None:
            
            _query_params.append(('skills', skills))
            
        if subject is not None:
            
            _query_params.append(('subject', subject))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/orgs/{org}/users/{username}/recommended/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_personalized_catalog_retrieve(
        self,
        username: StrictStr,
        allow_skill_search: Annotated[Optional[StrictBool], Field(description="Enable skill-based search")] = None,
        alphabetical: Annotated[Optional[StrictBool], Field(description="Sort alphabetically by name")] = None,
        certificate: Annotated[Optional[List[StrictStr]], Field(description="Filter by certificate type")] = None,
        content: Annotated[Optional[List[StrictStr]], Field(description="Content types to include in results")] = None,
        course_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific course by ID")] = None,
        duration: Annotated[Optional[List[StrictStr]], Field(description="Filter by course duration range")] = None,
        language: Annotated[Optional[List[StrictStr]], Field(description="Filter by content language")] = None,
        level: Annotated[Optional[List[StrictStr]], Field(description="Filter by difficulty level")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_ascending: Annotated[Optional[StrictBool], Field(description="Sort direction")] = None,
        order_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        pathway_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific pathway by ID")] = None,
        price: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by price/audit status")] = None,
        program_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific program by ID")] = None,
        program_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by program type")] = None,
        promotion: Annotated[Optional[List[StrictStr]], Field(description="Filter by promotion status")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter content by name or description")] = None,
        recommended: Annotated[Optional[StrictBool], Field(description="Show only recommended content")] = None,
        resource_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific resource by ID")] = None,
        resource_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by resource type")] = None,
        return_facet: Annotated[Optional[StrictBool], Field(description="Include facet data in response")] = None,
        return_items: Annotated[Optional[StrictBool], Field(description="Include items in programs/pathways")] = None,
        role_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific role by ID")] = None,
        self_paced: Annotated[Optional[List[StrictStr]], Field(description="Filter by course format")] = None,
        skill_id: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Retrieve a specific skill by ID")] = None,
        skills: Annotated[Optional[List[StrictStr]], Field(description="Filter by skills")] = None,
        subject: Annotated[Optional[List[StrictStr]], Field(description="Filter by subject areas")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        topics: Annotated[Optional[List[StrictStr]], Field(description="Filter by topic areas")] = None,
        update_facet: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Force facet update")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_personalized_catalog_retrieve

        Determine whether to serve a detail view or a list view. If any detail-identifying parameters are present (course_id, program_id, etc.) the detail view is returned; otherwise the aggregated list view is returned.

        :param username: (required)
        :type username: str
        :param allow_skill_search: Enable skill-based search
        :type allow_skill_search: bool
        :param alphabetical: Sort alphabetically by name
        :type alphabetical: bool
        :param certificate: Filter by certificate type
        :type certificate: List[str]
        :param content: Content types to include in results
        :type content: List[str]
        :param course_id: Retrieve a specific course by ID
        :type course_id: str
        :param duration: Filter by course duration range
        :type duration: List[str]
        :param language: Filter by content language
        :type language: List[str]
        :param level: Filter by difficulty level
        :type level: List[str]
        :param limit: Number of results per page
        :type limit: int
        :param offset: Starting position for pagination
        :type offset: int
        :param order_ascending: Sort direction
        :type order_ascending: bool
        :param order_by: Field to sort results by
        :type order_by: str
        :param pathway_id: Retrieve a specific pathway by ID
        :type pathway_id: str
        :param price: Filter by price/audit status
        :type price: str
        :param program_id: Retrieve a specific program by ID
        :type program_id: str
        :param program_type: Filter by program type
        :type program_type: List[str]
        :param promotion: Filter by promotion status
        :type promotion: List[str]
        :param query: Search term to filter content by name or description
        :type query: str
        :param recommended: Show only recommended content
        :type recommended: bool
        :param resource_id: Retrieve a specific resource by ID
        :type resource_id: str
        :param resource_type: Filter by resource type
        :type resource_type: List[str]
        :param return_facet: Include facet data in response
        :type return_facet: bool
        :param return_items: Include items in programs/pathways
        :type return_items: bool
        :param role_id: Retrieve a specific role by ID
        :type role_id: str
        :param self_paced: Filter by course format
        :type self_paced: List[str]
        :param skill_id: Retrieve a specific skill by ID
        :type skill_id: str
        :param skills: Filter by skills
        :type skills: List[str]
        :param subject: Filter by subject areas
        :type subject: List[str]
        :param tags: Filter by tags
        :type tags: List[str]
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param topics: Filter by topic areas
        :type topics: List[str]
        :param update_facet: Force facet update
        :type update_facet: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_personalized_catalog_retrieve_serialize(
            username=username,
            allow_skill_search=allow_skill_search,
            alphabetical=alphabetical,
            certificate=certificate,
            content=content,
            course_id=course_id,
            duration=duration,
            language=language,
            level=level,
            limit=limit,
            offset=offset,
            order_ascending=order_ascending,
            order_by=order_by,
            pathway_id=pathway_id,
            price=price,
            program_id=program_id,
            program_type=program_type,
            promotion=promotion,
            query=query,
            recommended=recommended,
            resource_id=resource_id,
            resource_type=resource_type,
            return_facet=return_facet,
            return_items=return_items,
            role_id=role_id,
            self_paced=self_paced,
            skill_id=skill_id,
            skills=skills,
            subject=subject,
            tags=tags,
            tenant=tenant,
            topics=topics,
            update_facet=update_facet,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Dict[str, object]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_personalized_catalog_retrieve_serialize(
        self,
        username,
        allow_skill_search,
        alphabetical,
        certificate,
        content,
        course_id,
        duration,
        language,
        level,
        limit,
        offset,
        order_ascending,
        order_by,
        pathway_id,
        price,
        program_id,
        program_type,
        promotion,
        query,
        recommended,
        resource_id,
        resource_type,
        return_facet,
        return_items,
        role_id,
        self_paced,
        skill_id,
        skills,
        subject,
        tags,
        tenant,
        topics,
        update_facet,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'certificate': 'multi',
            'content': 'multi',
            'duration': 'multi',
            'language': 'multi',
            'level': 'multi',
            'program_type': 'multi',
            'promotion': 'multi',
            'resource_type': 'multi',
            'self_paced': 'multi',
            'skills': 'multi',
            'subject': 'multi',
            'tags': 'multi',
            'topics': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if allow_skill_search is not None:
            
            _query_params.append(('allow_skill_search', allow_skill_search))
            
        if alphabetical is not None:
            
            _query_params.append(('alphabetical', alphabetical))
            
        if certificate is not None:
            
            _query_params.append(('certificate', certificate))
            
        if content is not None:
            
            _query_params.append(('content', content))
            
        if course_id is not None:
            
            _query_params.append(('course_id', course_id))
            
        if duration is not None:
            
            _query_params.append(('duration', duration))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_ascending is not None:
            
            _query_params.append(('order_ascending', order_ascending))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by))
            
        if pathway_id is not None:
            
            _query_params.append(('pathway_id', pathway_id))
            
        if price is not None:
            
            _query_params.append(('price', price))
            
        if program_id is not None:
            
            _query_params.append(('program_id', program_id))
            
        if program_type is not None:
            
            _query_params.append(('program_type', program_type))
            
        if promotion is not None:
            
            _query_params.append(('promotion', promotion))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if recommended is not None:
            
            _query_params.append(('recommended', recommended))
            
        if resource_id is not None:
            
            _query_params.append(('resource_id', resource_id))
            
        if resource_type is not None:
            
            _query_params.append(('resource_type', resource_type))
            
        if return_facet is not None:
            
            _query_params.append(('return_facet', return_facet))
            
        if return_items is not None:
            
            _query_params.append(('return_items', return_items))
            
        if role_id is not None:
            
            _query_params.append(('role_id', role_id))
            
        if self_paced is not None:
            
            _query_params.append(('self_paced', self_paced))
            
        if skill_id is not None:
            
            _query_params.append(('skill_id', skill_id))
            
        if skills is not None:
            
            _query_params.append(('skills', skills))
            
        if subject is not None:
            
            _query_params.append(('subject', subject))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if topics is not None:
            
            _query_params.append(('topics', topics))
            
        if update_facet is not None:
            
            _query_params.append(('update_facet', update_facet))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/personalized-catalog/{username}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_prompts_retrieve(
        self,
        alphabetical: Annotated[Optional[StrictBool], Field(description="Sort alphabetically")] = None,
        category: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt category")] = None,
        created_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter prompts created by specific user")] = None,
        filter_facet: Annotated[Optional[StrictBool], Field(description="If true, return only facets without results")] = None,
        language: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt language")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        mentor: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by mentor UUID")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        order_direction: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Sort direction ('asc' or 'desc')")] = None,
        query: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter prompts by name or content")] = None,
        sort_by: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Field to sort results by")] = None,
        style: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt style")] = None,
        tenant: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by tenant/organization")] = None,
        tone: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by prompt tone")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_prompts_retrieve

        Search and filter AI prompts across the platform.  This endpoint provides a search interface for discovering AI prompts with support for filtering, pagination, and detailed prompt information.  Query Parameters:     # Identification parameters (for detail view)     id (int, optional): Retrieve a specific prompt by ID      # Search and filtering parameters     query (str, optional): Search term to filter prompts by name or content     category (str, optional): Filter by prompt category     language (str, optional): Filter by prompt language     style (str, optional): Filter by writing style     tone (str, optional): Filter by tone     tenant (str, optional): Filter by tenant/organization     mentor (str, optional): Filter by associated mentor (UUID)      # Sorting and pagination     sort_by (str, optional): Field to sort results by     order_direction (str, optional): Sort direction ('asc' or 'desc', default: 'desc')     alphabetical (bool, optional): Sort alphabetically by name (default: false)     limit (int, optional): Number of results per page (default: 10)     offset (int, optional): Starting position for pagination      # Special parameters     filter_facet (any, optional): If present, return only facets without results  Returns:     For detail view (when id is provided):         A JSON response containing a single prompt's details:         {             \"id\": 456,             \"name\": \"Essay Writing Guide\",             \"content\": \"Write a well-structured essay on the following topic: {{topic}}...\",             \"category\": \"Academic Writing\",             \"language\": \"English\",             \"style\": \"Formal\",             \"tone\": \"Professional\",             \"mentor\": {                 \"id\": 123,                 \"unique_id\": \"550e8400-e29b-41d4-a716-446655440000\",                 \"name\": \"Professor Smith\"             },             \"platform\": {                 \"id\": 1,                 \"name\": \"Example University\",                 \"key\": \"example-university\"             },             \"created_at\": \"2023-02-10T09:15:00Z\",             \"updated_at\": \"2023-05-05T14:20:00Z\",             \"visibility\": \"public\",             \"variables\": [\"topic\", \"length\", \"style\"]         }      For list view:         A JSON response containing:         {             \"results\": [                 {                     \"id\": 456,                     \"name\": \"Essay Writing Guide\",                     \"content\": \"Write a well-structured essay on the following topic: {{topic}}...\",                     \"category\": \"Academic Writing\",                     \"language\": \"English\",                     \"style\": \"Formal\",                     \"tone\": \"Professional\",                     \"mentor\": {\"id\": 123, \"name\": \"Professor Smith\"},                     \"created_at\": \"2023-02-10T09:15:00Z\",                     \"updated_at\": \"2023-05-05T14:20:00Z\"                 },                 // Additional prompt objects...             ],             \"count\": 30,             \"next\": \"?limit=10&offset=10\",             \"previous\": null,             \"current_page\": 1,             \"num_pages\": 3,             \"facets\": {                 \"category\": [                     {\"key\": \"Academic Writing\", \"doc_count\": 15},                     {\"key\": \"Creative Writing\", \"doc_count\": 10},                     {\"key\": \"Technical Documentation\", \"doc_count\": 5}                 ],                 \"language\": [                     {\"key\": \"English\", \"doc_count\": 25},                     {\"key\": \"Spanish\", \"doc_count\": 5}                 ],                 \"style\": [                     {\"key\": \"Formal\", \"doc_count\": 20},                     {\"key\": \"Casual\", \"doc_count\": 10}                 ],                 \"tone\": [                     {\"key\": \"Professional\", \"doc_count\": 15},                     {\"key\": \"Friendly\", \"doc_count\": 10},                     {\"key\": \"Technical\", \"doc_count\": 5}                 ]             }         }  Error Responses:     400 Bad Request: If the request parameters are invalid     403 Forbidden: If the requested prompt exists but is not publicly available     404 Not Found: If the requested prompt doesn't exist     500 Internal Server Error: If an unexpected error occurs  Notes:     - Only publicly available prompts are returned by default     - When filtering by mentor, the mentor ID must be a valid UUID

        :param alphabetical: Sort alphabetically
        :type alphabetical: bool
        :param category: Filter by prompt category
        :type category: str
        :param created_by: Filter prompts created by specific user
        :type created_by: str
        :param filter_facet: If true, return only facets without results
        :type filter_facet: bool
        :param language: Filter by prompt language
        :type language: str
        :param limit: Number of results per page
        :type limit: int
        :param mentor: Filter by mentor UUID
        :type mentor: str
        :param offset: Starting position for pagination
        :type offset: int
        :param order_direction: Sort direction ('asc' or 'desc')
        :type order_direction: str
        :param query: Search term to filter prompts by name or content
        :type query: str
        :param sort_by: Field to sort results by
        :type sort_by: str
        :param style: Filter by prompt style
        :type style: str
        :param tenant: Filter by tenant/organization
        :type tenant: str
        :param tone: Filter by prompt tone
        :type tone: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_prompts_retrieve_serialize(
            alphabetical=alphabetical,
            category=category,
            created_by=created_by,
            filter_facet=filter_facet,
            language=language,
            limit=limit,
            mentor=mentor,
            offset=offset,
            order_direction=order_direction,
            query=query,
            sort_by=sort_by,
            style=style,
            tenant=tenant,
            tone=tone,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PromptSearchResponse",
            '400': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_prompts_retrieve_serialize(
        self,
        alphabetical,
        category,
        created_by,
        filter_facet,
        language,
        limit,
        mentor,
        offset,
        order_direction,
        query,
        sort_by,
        style,
        tenant,
        tone,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if alphabetical is not None:
            
            _query_params.append(('alphabetical', alphabetical))
            
        if category is not None:
            
            _query_params.append(('category', category))
            
        if created_by is not None:
            
            _query_params.append(('created_by', created_by))
            
        if filter_facet is not None:
            
            _query_params.append(('filter_facet', filter_facet))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if mentor is not None:
            
            _query_params.append(('mentor', mentor))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if order_direction is not None:
            
            _query_params.append(('order_direction', order_direction))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if sort_by is not None:
            
            _query_params.append(('sort_by', sort_by))
            
        if style is not None:
            
            _query_params.append(('style', style))
            
        if tenant is not None:
            
            _query_params.append(('tenant', tenant))
            
        if tone is not None:
            
            _query_params.append(('tone', tone))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/prompts/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_users_orgs_users_retrieve(
        self,
        org: StrictStr,
        username: StrictStr,
        department: Annotated[Optional[List[StrictStr]], Field(description="Filter by department names")] = None,
        education__degree: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by degree")] = None,
        education__field_of_study: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by field of study")] = None,
        education__institution: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by institution")] = None,
        include_membership_data: Annotated[Optional[StrictBool], Field(description="Include user group membership data in results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results per page")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Starting position for pagination")] = None,
        q: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Search term to filter users by name, email, or other attributes")] = None,
        user_resume__company: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by company")] = None,
        user_resume__industry: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by industry")] = None,
        user_resume__job_title: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by job title")] = None,
        user_resume__location: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by location")] = None,
        user_resume__skills: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="Filter by skills")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """search_users_orgs_users_retrieve

        Search and filter users within a specific organization/tenant.  This endpoint provides a search interface for discovering users within an organization, with support for filtering by departments, pagination, and faceted filtering.  Path Parameters:     org (str): The organization/tenant identifier     username (str): The username of the user making the request  Query Parameters:     # Search parameters     query (str, optional): Search term to filter users by name, username, or email      # Department filtering     department_mode (bool, optional): Enable department-based filtering (default: false)     user_department (bool, optional): Legacy parameter for department_mode (default: false)     department (list, optional): Filter by specific departments      # Additional filters     role (list, optional): Filter by user role     status (list, optional): Filter by user status (active, inactive)     joined_date (list, optional): Filter by join date range     last_login (list, optional): Filter by last login date range      # Pagination     limit (int, optional): Number of results per page (default: 10)     offset (int, optional): Starting position for pagination  Returns:     A JSON response containing:     ```     {         \"results\": [             {                 \"id\": 123,                 \"username\": \"john.doe\",                 \"email\": \"john.doe@example.com\",                 \"first_name\": \"John\",                 \"last_name\": \"Doe\",                 \"full_name\": \"John Doe\",                 \"profile_image\": \"https://example.com/profiles/john-doe.jpg\",                 \"role\": \"Student\",                 \"departments\": [\"Computer Science\", \"Data Science\"],                 \"status\": \"active\",                 \"joined_date\": \"2023-01-15T12:00:00Z\",                 \"last_login\": \"2023-06-20T15:30:00Z\",                 \"metadata\": {                     \"location\": \"New York\",                     \"title\": \"Software Engineer\",                     \"bio\": \"Experienced software engineer with a passion for education\"                 }             },             // Additional user objects...         ],         \"count\": 50,         \"next\": \"https://api.example.com/api/search/users/example-org/admin/?limit=10&offset=10\",         \"previous\": null,         \"current_page\": 1,         \"total_pages\": 5,         \"facets\": {             \"role\": [                 {\"key\": \"Student\", \"doc_count\": 30},                 {\"key\": \"Instructor\", \"doc_count\": 15},                 {\"key\": \"Admin\", \"doc_count\": 5}             ],             \"department\": [                 {\"key\": \"Computer Science\", \"doc_count\": 20},                 {\"key\": \"Data Science\", \"doc_count\": 15},                 {\"key\": \"Business\", \"doc_count\": 10},                 {\"key\": \"Engineering\", \"doc_count\": 5}             ],             \"status\": [                 {\"key\": \"active\", \"doc_count\": 45},                 {\"key\": \"inactive\", \"doc_count\": 5}             ]         }     }     ``` Error Responses:     400 Bad Request: If the request parameters are invalid     403 Forbidden: If the user doesn't have department admin privileges (when using department_mode)     404 Not Found: If the user or organization doesn't exist     500 Internal Server Error: If an unexpected error occurs  Access Control:     - The requesting user must have an active account in the specified organization     - When department_mode is enabled, the user must be an admin of at least one department     - Department filtering restricts results to users in departments where the requesting user is an admin

        :param org: (required)
        :type org: str
        :param username: (required)
        :type username: str
        :param department: Filter by department names
        :type department: List[str]
        :param education__degree: Filter by degree
        :type education__degree: str
        :param education__field_of_study: Filter by field of study
        :type education__field_of_study: str
        :param education__institution: Filter by institution
        :type education__institution: str
        :param include_membership_data: Include user group membership data in results
        :type include_membership_data: bool
        :param limit: Number of results per page
        :type limit: int
        :param offset: Starting position for pagination
        :type offset: int
        :param q: Search term to filter users by name, email, or other attributes
        :type q: str
        :param user_resume__company: Filter by company
        :type user_resume__company: str
        :param user_resume__industry: Filter by industry
        :type user_resume__industry: str
        :param user_resume__job_title: Filter by job title
        :type user_resume__job_title: str
        :param user_resume__location: Filter by location
        :type user_resume__location: str
        :param user_resume__skills: Filter by skills
        :type user_resume__skills: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_users_orgs_users_retrieve_serialize(
            org=org,
            username=username,
            department=department,
            education__degree=education__degree,
            education__field_of_study=education__field_of_study,
            education__institution=education__institution,
            include_membership_data=include_membership_data,
            limit=limit,
            offset=offset,
            q=q,
            user_resume__company=user_resume__company,
            user_resume__industry=user_resume__industry,
            user_resume__job_title=user_resume__job_title,
            user_resume__location=user_resume__location,
            user_resume__skills=user_resume__skills,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UserSearchResponse",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_users_orgs_users_retrieve_serialize(
        self,
        org,
        username,
        department,
        education__degree,
        education__field_of_study,
        education__institution,
        include_membership_data,
        limit,
        offset,
        q,
        user_resume__company,
        user_resume__industry,
        user_resume__job_title,
        user_resume__location,
        user_resume__skills,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'department': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if org is not None:
            _path_params['org'] = org
        if username is not None:
            _path_params['username'] = username
        # process the query parameters
        if department is not None:
            
            _query_params.append(('department', department))
            
        if education__degree is not None:
            
            _query_params.append(('education__degree', education__degree))
            
        if education__field_of_study is not None:
            
            _query_params.append(('education__field_of_study', education__field_of_study))
            
        if education__institution is not None:
            
            _query_params.append(('education__institution', education__institution))
            
        if include_membership_data is not None:
            
            _query_params.append(('include_membership_data', include_membership_data))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if user_resume__company is not None:
            
            _query_params.append(('user_resume__company', user_resume__company))
            
        if user_resume__industry is not None:
            
            _query_params.append(('user_resume__industry', user_resume__industry))
            
        if user_resume__job_title is not None:
            
            _query_params.append(('user_resume__job_title', user_resume__job_title))
            
        if user_resume__location is not None:
            
            _query_params.append(('user_resume__location', user_resume__location))
            
        if user_resume__skills is not None:
            
            _query_params.append(('user_resume__skills', user_resume__skills))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'PlatformApiKeyAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/search/users/orgs/{org}/users/{username}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


