# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class ActivityData(BaseModel):
    """
    ActivityData
    """ # noqa: E501
    course_id: StrictStr = Field(description="edx Course Id")
    name: StrictStr = Field(description="Course name")
    course_start: StrictStr = Field(description="Course start date")
    course_end: StrictStr = Field(description="Course end date")
    average_time_invested: Union[StrictFloat, StrictInt] = Field(description="Overall course average time invested (other students inclusive)")
    time_invested: StrictInt = Field(description="Total time spent")
    days_away: StrictStr = Field(description="Days from today the course has been accessed")
    last_access_date: StrictStr = Field(description="When course was last accessed")
    days_accessed: StrictInt = Field(description="Unique days course was accessed")
    __properties: ClassVar[List[str]] = ["course_id", "name", "course_start", "course_end", "average_time_invested", "time_invested", "days_away", "last_access_date", "days_accessed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActivityData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActivityData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_id": obj.get("course_id"),
            "name": obj.get("name"),
            "course_start": obj.get("course_start"),
            "course_end": obj.get("course_end"),
            "average_time_invested": obj.get("average_time_invested"),
            "time_invested": obj.get("time_invested"),
            "days_away": obj.get("days_away"),
            "last_access_date": obj.get("last_access_date"),
            "days_accessed": obj.get("days_accessed")
        })
        return _obj


