# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class ArtifactList(BaseModel):
    """
    Lightweight serializer for listing artifacts.  This serializer is optimized for list views, excluding the potentially large content field and including useful computed fields.  Fields:     - id: Unique identifier for the artifact     - title: Title or identifier for the artifact     - file_extension: The extension of the file     - llm_name: Name of the LLM that generated the artifact     - llm_provider: Provider of the LLM     - date_created: Timestamp when the artifact was created     - date_updated: Timestamp when the artifact was last updated     - username: Username of the student who owns the artifact     - session_id: UUID of the session that generated the artifact     - content_length: Length of the content in characters
    """ # noqa: E501
    id: StrictInt
    title: StrictStr = Field(description="Title or identifier for the artifact")
    file_extension: StrictStr = Field(description="The extension of the file for the artifact. eg. `py`, `md`, `html`, `json`, `csv`, etc")
    llm_name: StrictStr
    llm_provider: StrictStr
    date_created: datetime
    date_updated: datetime
    username: StrictStr = Field(description="Username of the student who owns this artifact")
    session_id: UUID = Field(description="UUID of the session that generated this artifact")
    content_length: StrictInt = Field(description="Length of the artifact content in characters")
    __properties: ClassVar[List[str]] = ["id", "title", "file_extension", "llm_name", "llm_provider", "date_created", "date_updated", "username", "session_id", "content_length"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArtifactList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "title",
            "file_extension",
            "llm_name",
            "llm_provider",
            "date_created",
            "date_updated",
            "username",
            "session_id",
            "content_length",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArtifactList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "file_extension": obj.get("file_extension"),
            "llm_name": obj.get("llm_name"),
            "llm_provider": obj.get("llm_provider"),
            "date_created": obj.get("date_created"),
            "date_updated": obj.get("date_updated"),
            "username": obj.get("username"),
            "session_id": obj.get("session_id"),
            "content_length": obj.get("content_length")
        })
        return _obj


