# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from iblai.models.comparison_info import ComparisonInfo
from iblai.models.finance_filters import FinanceFilters
from iblai.models.overtime_data import OvertimeData
from iblai.models.period_info import PeriodInfo
from typing import Optional, Set
from typing_extensions import Self

class BaseFinanceResponse(BaseModel):
    """
    Base response for all finance metrics.
    """ # noqa: E501
    metric: StrictStr = Field(description="The metric type that was requested")
    filters: FinanceFilters = Field(description="Applied filters for this query")
    value: Annotated[str, Field(strict=True)] = Field(description="Primary metric value (cost in USD)")
    percentage_change: Optional[Union[StrictFloat, StrictInt]] = Field(description="Percentage change vs comparison period (null if no comparison)")
    overtime: List[OvertimeData] = Field(description="Time series data for overtime visualization")
    period_info: PeriodInfo = Field(description="Information about the analysis period")
    comparison_info: ComparisonInfo = Field(description="Information about comparison period (empty if no comparison)")
    __properties: ClassVar[List[str]] = ["metric", "filters", "value", "percentage_change", "overtime", "period_info", "comparison_info"]

    @field_validator('value')
    def value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^-?\d{0,15}(?:\.\d{0,5})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,15}(?:\.\d{0,5})?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseFinanceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of filters
        if self.filters:
            _dict['filters'] = self.filters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in overtime (list)
        _items = []
        if self.overtime:
            for _item_overtime in self.overtime:
                if _item_overtime:
                    _items.append(_item_overtime.to_dict())
            _dict['overtime'] = _items
        # override the default output from pydantic by calling `to_dict()` of period_info
        if self.period_info:
            _dict['period_info'] = self.period_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of comparison_info
        if self.comparison_info:
            _dict['comparison_info'] = self.comparison_info.to_dict()
        # set to None if percentage_change (nullable) is None
        # and model_fields_set contains the field
        if self.percentage_change is None and "percentage_change" in self.model_fields_set:
            _dict['percentage_change'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseFinanceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metric": obj.get("metric"),
            "filters": FinanceFilters.from_dict(obj["filters"]) if obj.get("filters") is not None else None,
            "value": obj.get("value"),
            "percentage_change": obj.get("percentage_change"),
            "overtime": [OvertimeData.from_dict(_item) for _item in obj["overtime"]] if obj.get("overtime") is not None else None,
            "period_info": PeriodInfo.from_dict(obj["period_info"]) if obj.get("period_info") is not None else None,
            "comparison_info": ComparisonInfo.from_dict(obj["comparison_info"]) if obj.get("comparison_info") is not None else None
        })
        return _obj


