# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from iblai.models.provider05c_enum import Provider05cEnum
from typing import Optional, Set
from typing_extensions import Self

class Bot(BaseModel):
    """
    Bot
    """ # noqa: E501
    id: StrictInt
    platform: StrictInt
    tenant: StrictStr
    name: Annotated[str, Field(strict=True, max_length=255)]
    provider: Provider05cEnum
    is_configured: StrictBool
    slack_config: StrictInt
    discord_config: StrictInt
    webex_config: StrictInt
    whatsapp_config: StrictInt
    teams_config: StrictInt
    webhook_url: StrictStr
    __properties: ClassVar[List[str]] = ["id", "platform", "tenant", "name", "provider", "is_configured", "slack_config", "discord_config", "webex_config", "whatsapp_config", "teams_config", "webhook_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Bot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "tenant",
            "is_configured",
            "discord_config",
            "webex_config",
            "whatsapp_config",
            "teams_config",
            "webhook_url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Bot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "platform": obj.get("platform"),
            "tenant": obj.get("tenant"),
            "name": obj.get("name"),
            "provider": obj.get("provider"),
            "is_configured": obj.get("is_configured"),
            "slack_config": obj.get("slack_config"),
            "discord_config": obj.get("discord_config"),
            "webex_config": obj.get("webex_config"),
            "whatsapp_config": obj.get("whatsapp_config"),
            "teams_config": obj.get("teams_config"),
            "webhook_url": obj.get("webhook_url")
        })
        return _obj


