# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.action_breakdown import ActionBreakdown
from iblai.models.mentor_breakdown import MentorBreakdown
from iblai.models.provider_breakdown import ProviderBreakdown
from typing import Optional, Set
from typing_extensions import Self

class Breakdown(BaseModel):
    """
    Detailed breakdown of costs.
    """ # noqa: E501
    by_provider: Optional[List[ProviderBreakdown]] = None
    by_mentor: Optional[List[MentorBreakdown]] = None
    by_action: Optional[List[ActionBreakdown]] = None
    __properties: ClassVar[List[str]] = ["by_provider", "by_mentor", "by_action"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Breakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in by_provider (list)
        _items = []
        if self.by_provider:
            for _item_by_provider in self.by_provider:
                if _item_by_provider:
                    _items.append(_item_by_provider.to_dict())
            _dict['by_provider'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in by_mentor (list)
        _items = []
        if self.by_mentor:
            for _item_by_mentor in self.by_mentor:
                if _item_by_mentor:
                    _items.append(_item_by_mentor.to_dict())
            _dict['by_mentor'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in by_action (list)
        _items = []
        if self.by_action:
            for _item_by_action in self.by_action:
                if _item_by_action:
                    _items.append(_item_by_action.to_dict())
            _dict['by_action'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Breakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "by_provider": [ProviderBreakdown.from_dict(_item) for _item in obj["by_provider"]] if obj.get("by_provider") is not None else None,
            "by_mentor": [MentorBreakdown.from_dict(_item) for _item in obj["by_mentor"]] if obj.get("by_mentor") is not None else None,
            "by_action": [ActionBreakdown.from_dict(_item) for _item in obj["by_action"]] if obj.get("by_action") is not None else None
        })
        return _obj


