# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ComparisonInfo(BaseModel):
    """
    Comparison period information.
    """ # noqa: E501
    previous_period_count: Optional[StrictInt] = Field(default=None, description="Number of days in comparison period")
    previous_period_value: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Cost value for comparison period")
    comparison_start: Optional[StrictStr] = Field(default=None, description="Start date of comparison period")
    comparison_end: Optional[StrictStr] = Field(default=None, description="End date of comparison period")
    comparison_days: Optional[StrictInt] = Field(default=None, description="Number of comparison days")
    recent_period_value: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Cost value for current period")
    __properties: ClassVar[List[str]] = ["previous_period_count", "previous_period_value", "comparison_start", "comparison_end", "comparison_days", "recent_period_value"]

    @field_validator('previous_period_value')
    def previous_period_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?\d{0,15}(?:\.\d{0,5})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,15}(?:\.\d{0,5})?$/")
        return value

    @field_validator('recent_period_value')
    def recent_period_value_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?\d{0,15}(?:\.\d{0,5})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,15}(?:\.\d{0,5})?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ComparisonInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ComparisonInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "previous_period_count": obj.get("previous_period_count"),
            "previous_period_value": obj.get("previous_period_value"),
            "comparison_start": obj.get("comparison_start"),
            "comparison_end": obj.get("comparison_end"),
            "comparison_days": obj.get("comparison_days"),
            "recent_period_value": obj.get("recent_period_value")
        })
        return _obj


