# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ContentAverages(BaseModel):
    """
    Serializer for content summary averages.
    """ # noqa: E501
    completion_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average completion rate percentage")
    average_rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average rating")
    enrollments_per_course: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average enrollments per course")
    enrollments_per_program: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average enrollments per program")
    enrollments_per_pathway: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average enrollments per pathway")
    courses_per_skill: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average courses per skill")
    time_per_learner: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Average time spent per learner in seconds (courses only)")
    __properties: ClassVar[List[str]] = ["completion_rate", "average_rating", "enrollments_per_course", "enrollments_per_program", "enrollments_per_pathway", "courses_per_skill", "time_per_learner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentAverages from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentAverages from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "completion_rate": obj.get("completion_rate"),
            "average_rating": obj.get("average_rating"),
            "enrollments_per_course": obj.get("enrollments_per_course"),
            "enrollments_per_program": obj.get("enrollments_per_program"),
            "enrollments_per_pathway": obj.get("enrollments_per_pathway"),
            "courses_per_skill": obj.get("courses_per_skill"),
            "time_per_learner": obj.get("time_per_learner")
        })
        return _obj


