# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ContentDetailsLearner(BaseModel):
    """
    Serializer for individual learner entries in content details.
    """ # noqa: E501
    user_id: StrictInt = Field(description="Learner identifier")
    username: Optional[StrictStr] = Field(description="Learner username")
    email: Optional[StrictStr] = Field(description="Learner email")
    name: Optional[StrictStr] = Field(description="Learner display name")
    enrollment_date: Optional[datetime] = Field(description="Date the learner enrolled in the content")
    completion_status: StrictStr = Field(description="Completion status for the learner")
    completion_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(description="Learner completion percentage")
    last_activity: Optional[datetime] = Field(description="Last activity timestamp for the learner")
    rating: Optional[Union[StrictFloat, StrictInt]] = Field(description="Learner rating for the content, if available")
    review: Optional[StrictStr] = Field(description="Learner review content, if available")
    details: Optional[Dict[str, Any]] = Field(default=None, description="Additional learner-specific metadata")
    __properties: ClassVar[List[str]] = ["user_id", "username", "email", "name", "enrollment_date", "completion_status", "completion_percentage", "last_activity", "rating", "review", "details"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentDetailsLearner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if enrollment_date (nullable) is None
        # and model_fields_set contains the field
        if self.enrollment_date is None and "enrollment_date" in self.model_fields_set:
            _dict['enrollment_date'] = None

        # set to None if completion_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.completion_percentage is None and "completion_percentage" in self.model_fields_set:
            _dict['completion_percentage'] = None

        # set to None if last_activity (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity is None and "last_activity" in self.model_fields_set:
            _dict['last_activity'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if review (nullable) is None
        # and model_fields_set contains the field
        if self.review is None and "review" in self.model_fields_set:
            _dict['review'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentDetailsLearner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "name": obj.get("name"),
            "enrollment_date": obj.get("enrollment_date"),
            "completion_status": obj.get("completion_status"),
            "completion_percentage": obj.get("completion_percentage"),
            "last_activity": obj.get("last_activity"),
            "rating": obj.get("rating"),
            "review": obj.get("review"),
            "details": obj.get("details")
        })
        return _obj


