# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from iblai.models.content_details_content_info import ContentDetailsContentInfo
from iblai.models.content_details_learner import ContentDetailsLearner
from iblai.models.content_details_pagination import ContentDetailsPagination
from iblai.models.content_details_summary import ContentDetailsSummary
from typing import Optional, Set
from typing_extensions import Self

class ContentDetailsResponse(BaseModel):
    """
    Serializer for the content details API response.
    """ # noqa: E501
    content_info: ContentDetailsContentInfo
    summary: ContentDetailsSummary
    pagination: ContentDetailsPagination
    learners: List[ContentDetailsLearner]
    __properties: ClassVar[List[str]] = ["content_info", "summary", "pagination", "learners"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content_info
        if self.content_info:
            _dict['content_info'] = self.content_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in learners (list)
        _items = []
        if self.learners:
            for _item_learners in self.learners:
                if _item_learners:
                    _items.append(_item_learners.to_dict())
            _dict['learners'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_info": ContentDetailsContentInfo.from_dict(obj["content_info"]) if obj.get("content_info") is not None else None,
            "summary": ContentDetailsSummary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
            "pagination": ContentDetailsPagination.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None,
            "learners": [ContentDetailsLearner.from_dict(_item) for _item in obj["learners"]] if obj.get("learners") is not None else None
        })
        return _obj


