# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from iblai.models.content_details_time_series import ContentDetailsTimeSeries
from typing import Optional, Set
from typing_extensions import Self

class ContentDetailsSummary(BaseModel):
    """
    Serializer for summary data in the content details endpoint.
    """ # noqa: E501
    totals: Dict[str, Union[StrictFloat, StrictInt]] = Field(description="Total counts related to the content item")
    averages: Dict[str, Optional[Union[StrictFloat, StrictInt]]] = Field(description="Average values related to the content item")
    time_series: Optional[ContentDetailsTimeSeries] = Field(default=None, description="Optional time series data for the requested metric")
    __properties: ClassVar[List[str]] = ["totals", "averages", "time_series"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentDetailsSummary from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_series
        if self.time_series:
            _dict['time_series'] = self.time_series.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentDetailsSummary from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totals": obj.get("totals"),
            "averages": obj.get("averages"),
            "time_series": ContentDetailsTimeSeries.from_dict(obj["time_series"]) if obj.get("time_series") is not None else None
        })
        return _obj


