# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.content_analytics import ContentAnalytics
from typing import Optional, Set
from typing_extensions import Self

class ContentItem(BaseModel):
    """
    Serializer for individual content items.
    """ # noqa: E501
    id: StrictStr = Field(description="Content identifier")
    name: StrictStr = Field(description="Content name")
    slug: StrictStr = Field(description="Content slug")
    platform: Optional[StrictStr] = Field(description="Platform key")
    external: StrictBool = Field(description="Whether content is external to the platform")
    analytics: ContentAnalytics
    instructor: Optional[StrictStr] = Field(default=None, description="Instructor name")
    category: Optional[StrictStr] = Field(default=None, description="Content category")
    duration: Optional[StrictStr] = Field(default=None, description="Content duration")
    enabled: Optional[StrictBool] = Field(default=None, description="Whether content is enabled")
    created: Optional[StrictStr] = Field(default=None, description="Creation date")
    updated: Optional[StrictStr] = Field(default=None, description="Last update date")
    metadata: Optional[Any] = None
    __properties: ClassVar[List[str]] = ["id", "name", "slug", "platform", "external", "analytics", "instructor", "category", "duration", "enabled", "created", "updated", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of analytics
        if self.analytics:
            _dict['analytics'] = self.analytics.to_dict()
        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if instructor (nullable) is None
        # and model_fields_set contains the field
        if self.instructor is None and "instructor" in self.model_fields_set:
            _dict['instructor'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if duration (nullable) is None
        # and model_fields_set contains the field
        if self.duration is None and "duration" in self.model_fields_set:
            _dict['duration'] = None

        # set to None if created (nullable) is None
        # and model_fields_set contains the field
        if self.created is None and "created" in self.model_fields_set:
            _dict['created'] = None

        # set to None if updated (nullable) is None
        # and model_fields_set contains the field
        if self.updated is None and "updated" in self.model_fields_set:
            _dict['updated'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "slug": obj.get("slug"),
            "platform": obj.get("platform"),
            "external": obj.get("external"),
            "analytics": ContentAnalytics.from_dict(obj["analytics"]) if obj.get("analytics") is not None else None,
            "instructor": obj.get("instructor"),
            "category": obj.get("category"),
            "duration": obj.get("duration"),
            "enabled": obj.get("enabled"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "metadata": obj.get("metadata")
        })
        return _obj


