# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ContentTotals(BaseModel):
    """
    Serializer for content summary totals.
    """ # noqa: E501
    total_learners: StrictInt = Field(description="Total number of learners")
    total_enrollments: StrictInt = Field(description="Total number of enrollments")
    total_time_spent: Optional[StrictInt] = Field(default=None, description="Total time spent in seconds (courses only)")
    courses: Optional[StrictInt] = Field(default=None, description="Total number of courses")
    active_courses: Optional[StrictInt] = Field(default=None, description="Number of active courses")
    platform_courses: Optional[StrictInt] = Field(default=None, description="Number of platform-owned courses")
    external_courses: Optional[StrictInt] = Field(default=None, description="Number of external courses")
    programs: Optional[StrictInt] = Field(default=None, description="Total number of programs")
    active_programs: Optional[StrictInt] = Field(default=None, description="Number of active programs")
    platform_programs: Optional[StrictInt] = Field(default=None, description="Number of platform-owned programs")
    external_programs: Optional[StrictInt] = Field(default=None, description="Number of external programs")
    pathways: Optional[StrictInt] = Field(default=None, description="Total number of pathways")
    active_pathways: Optional[StrictInt] = Field(default=None, description="Number of active pathways")
    platform_pathways: Optional[StrictInt] = Field(default=None, description="Number of platform-owned pathways")
    external_pathways: Optional[StrictInt] = Field(default=None, description="Number of external pathways")
    skills: Optional[StrictInt] = Field(default=None, description="Total number of skills")
    active_skills: Optional[StrictInt] = Field(default=None, description="Number of active skills")
    platform_skills: Optional[StrictInt] = Field(default=None, description="Number of platform-owned skills")
    external_skills: Optional[StrictInt] = Field(default=None, description="Number of external skills")
    associated_courses: Optional[StrictInt] = Field(default=None, description="Number of courses associated with skills")
    learners_with_skills: Optional[StrictInt] = Field(default=None, description="Number of learners with skills")
    __properties: ClassVar[List[str]] = ["total_learners", "total_enrollments", "total_time_spent", "courses", "active_courses", "platform_courses", "external_courses", "programs", "active_programs", "platform_programs", "external_programs", "pathways", "active_pathways", "platform_pathways", "external_pathways", "skills", "active_skills", "platform_skills", "external_skills", "associated_courses", "learners_with_skills"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentTotals from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentTotals from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "total_learners": obj.get("total_learners"),
            "total_enrollments": obj.get("total_enrollments"),
            "total_time_spent": obj.get("total_time_spent"),
            "courses": obj.get("courses"),
            "active_courses": obj.get("active_courses"),
            "platform_courses": obj.get("platform_courses"),
            "external_courses": obj.get("external_courses"),
            "programs": obj.get("programs"),
            "active_programs": obj.get("active_programs"),
            "platform_programs": obj.get("platform_programs"),
            "external_programs": obj.get("external_programs"),
            "pathways": obj.get("pathways"),
            "active_pathways": obj.get("active_pathways"),
            "platform_pathways": obj.get("platform_pathways"),
            "external_pathways": obj.get("external_pathways"),
            "skills": obj.get("skills"),
            "active_skills": obj.get("active_skills"),
            "platform_skills": obj.get("platform_skills"),
            "external_skills": obj.get("external_skills"),
            "associated_courses": obj.get("associated_courses"),
            "learners_with_skills": obj.get("learners_with_skills")
        })
        return _obj


