# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class ConversationListItem(BaseModel):
    """
    ConversationListItem
    """ # noqa: E501
    platform_name: StrictStr
    platform_key: StrictStr
    mentor: StrictStr
    mentor_unique_id: StrictStr
    model: StrictStr
    cost: StrictStr
    username: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    name: Annotated[str, Field(strict=True, max_length=255)]
    first_user_message: Optional[StrictStr] = None
    topics: Optional[Any]
    message_count: StrictInt
    user_queries: Optional[StrictInt] = None
    assistant_responses: Optional[StrictInt] = None
    average_sentiment: Optional[Union[StrictFloat, StrictInt]] = None
    sentiment: Optional[Annotated[str, Field(strict=True, max_length=16)]] = None
    created_at: datetime
    platform: StrictInt
    session: UUID
    user: Optional[StrictInt] = Field(default=None, description="edX user ID")
    __properties: ClassVar[List[str]] = ["platform_name", "platform_key", "mentor", "mentor_unique_id", "model", "cost", "username", "name", "first_user_message", "topics", "message_count", "user_queries", "assistant_responses", "average_sentiment", "sentiment", "created_at", "platform", "session", "user"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConversationListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "cost",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if first_user_message (nullable) is None
        # and model_fields_set contains the field
        if self.first_user_message is None and "first_user_message" in self.model_fields_set:
            _dict['first_user_message'] = None

        # set to None if topics (nullable) is None
        # and model_fields_set contains the field
        if self.topics is None and "topics" in self.model_fields_set:
            _dict['topics'] = None

        # set to None if user_queries (nullable) is None
        # and model_fields_set contains the field
        if self.user_queries is None and "user_queries" in self.model_fields_set:
            _dict['user_queries'] = None

        # set to None if assistant_responses (nullable) is None
        # and model_fields_set contains the field
        if self.assistant_responses is None and "assistant_responses" in self.model_fields_set:
            _dict['assistant_responses'] = None

        # set to None if average_sentiment (nullable) is None
        # and model_fields_set contains the field
        if self.average_sentiment is None and "average_sentiment" in self.model_fields_set:
            _dict['average_sentiment'] = None

        # set to None if sentiment (nullable) is None
        # and model_fields_set contains the field
        if self.sentiment is None and "sentiment" in self.model_fields_set:
            _dict['sentiment'] = None

        # set to None if user (nullable) is None
        # and model_fields_set contains the field
        if self.user is None and "user" in self.model_fields_set:
            _dict['user'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConversationListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_name": obj.get("platform_name"),
            "platform_key": obj.get("platform_key"),
            "mentor": obj.get("mentor"),
            "mentor_unique_id": obj.get("mentor_unique_id"),
            "model": obj.get("model"),
            "cost": obj.get("cost"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "first_user_message": obj.get("first_user_message"),
            "topics": obj.get("topics"),
            "message_count": obj.get("message_count"),
            "user_queries": obj.get("user_queries"),
            "assistant_responses": obj.get("assistant_responses"),
            "average_sentiment": obj.get("average_sentiment"),
            "sentiment": obj.get("sentiment"),
            "created_at": obj.get("created_at"),
            "platform": obj.get("platform"),
            "session": obj.get("session"),
            "user": obj.get("user")
        })
        return _obj


