# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.topic_model import TopicModel
from typing import Optional, Set
from typing_extensions import Self

class Conversations(BaseModel):
    """
    Conversations
    """ # noqa: E501
    id: UUID
    messages: StrictStr
    topics: List[TopicModel]
    sentiment: StrictStr
    mentor: UUID
    student: StrictStr
    email: StrictStr
    model: StrictStr
    rating: StrictInt
    platform: StrictStr
    lti_email: StrictStr = Field(description="Email claim from LTI1.3 JWT if an LTI user and available")
    lti_username: StrictStr = Field(description="Username claim from LTI1.3 JWT if an LTI user and available")
    inserted_at: datetime
    has_document: Optional[StrictBool] = None
    memory_tracked: Optional[StrictBool] = None
    enable_artifacts: Optional[StrictBool] = None
    llm_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    llm_provider: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    metadata: Optional[Any] = None
    is_conversation: Optional[StrictBool] = Field(default=None, description="True if the session has both user and AI messages")
    tools: Optional[List[StrictInt]] = None
    __properties: ClassVar[List[str]] = ["id", "messages", "topics", "sentiment", "mentor", "student", "email", "model", "rating", "platform", "lti_email", "lti_username", "inserted_at", "has_document", "memory_tracked", "enable_artifacts", "llm_name", "llm_provider", "metadata", "is_conversation", "tools"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Conversations from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "messages",
            "sentiment",
            "student",
            "email",
            "rating",
            "lti_email",
            "lti_username",
            "inserted_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in topics (list)
        _items = []
        if self.topics:
            for _item_topics in self.topics:
                if _item_topics:
                    _items.append(_item_topics.to_dict())
            _dict['topics'] = _items
        # set to None if llm_name (nullable) is None
        # and model_fields_set contains the field
        if self.llm_name is None and "llm_name" in self.model_fields_set:
            _dict['llm_name'] = None

        # set to None if llm_provider (nullable) is None
        # and model_fields_set contains the field
        if self.llm_provider is None and "llm_provider" in self.model_fields_set:
            _dict['llm_provider'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Conversations from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "messages": obj.get("messages"),
            "topics": [TopicModel.from_dict(_item) for _item in obj["topics"]] if obj.get("topics") is not None else None,
            "sentiment": obj.get("sentiment"),
            "mentor": obj.get("mentor"),
            "student": obj.get("student"),
            "email": obj.get("email"),
            "model": obj.get("model"),
            "rating": obj.get("rating"),
            "platform": obj.get("platform"),
            "lti_email": obj.get("lti_email"),
            "lti_username": obj.get("lti_username"),
            "inserted_at": obj.get("inserted_at"),
            "has_document": obj.get("has_document"),
            "memory_tracked": obj.get("memory_tracked"),
            "enable_artifacts": obj.get("enable_artifacts"),
            "llm_name": obj.get("llm_name"),
            "llm_provider": obj.get("llm_provider"),
            "metadata": obj.get("metadata"),
            "is_conversation": obj.get("is_conversation"),
            "tools": obj.get("tools")
        })
        return _obj


