# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CourseAccessRequestDetail(BaseModel):
    """
    Response serializer for access request details
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the access request")
    user_id: StrictInt = Field(description="The ID of the user who made the request")
    username: StrictStr = Field(description="The username of the user who made the request")
    name: StrictStr = Field(description="The full name of the user who made the request")
    approved: Optional[StrictBool] = Field(description="Whether the request has been approved (null if not reviewed)")
    reviewed: StrictBool = Field(description="Whether the request has been reviewed")
    created: datetime = Field(description="When the request was created")
    modified: datetime = Field(description="When the request was last modified")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata for the request")
    platform_key: StrictStr = Field(description="The platform key associated with the request")
    course_id: StrictStr = Field(description="The course ID associated with the request")
    __properties: ClassVar[List[str]] = ["id", "user_id", "username", "name", "approved", "reviewed", "created", "modified", "metadata", "platform_key", "course_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseAccessRequestDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if approved (nullable) is None
        # and model_fields_set contains the field
        if self.approved is None and "approved" in self.model_fields_set:
            _dict['approved'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseAccessRequestDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "approved": obj.get("approved"),
            "reviewed": obj.get("reviewed"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "metadata": obj.get("metadata"),
            "platform_key": obj.get("platform_key"),
            "course_id": obj.get("course_id")
        })
        return _obj


