# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.course_creation_task_file import CourseCreationTaskFile
from iblai.models.course_creation_task_status_enum import CourseCreationTaskStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class CourseCreationTask(BaseModel):
    """
    CourseCreationTask
    """ # noqa: E501
    id: StrictInt
    user_id: StrictStr
    student: StrictInt = Field(description="edX user ID")
    name: Annotated[str, Field(strict=True, max_length=200)]
    description: StrictStr = Field(description="Description of the course to create and its requirements")
    target_audience: Annotated[str, Field(strict=True, max_length=200)] = Field(description="The intended audience for the course. eg. Grade 11 students.")
    platform: StrictInt
    platform_key: StrictStr
    status: CourseCreationTaskStatusEnum
    publish_course: Optional[StrictBool] = None
    course_data: Optional[Any]
    provider: Optional[Annotated[str, Field(strict=True, max_length=20)]] = None
    model: Optional[Annotated[str, Field(strict=True, max_length=150)]] = None
    desired_number_of_sections: Optional[StrictInt] = None
    logs: StrictStr
    files: List[CourseCreationTaskFile]
    date_created: datetime
    last_modified: datetime
    __properties: ClassVar[List[str]] = ["id", "user_id", "student", "name", "description", "target_audience", "platform", "platform_key", "status", "publish_course", "course_data", "provider", "model", "desired_number_of_sections", "logs", "files", "date_created", "last_modified"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseCreationTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "user_id",
            "student",
            "platform",
            "platform_key",
            "status",
            "course_data",
            "logs",
            "files",
            "date_created",
            "last_modified",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        # set to None if course_data (nullable) is None
        # and model_fields_set contains the field
        if self.course_data is None and "course_data" in self.model_fields_set:
            _dict['course_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseCreationTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "user_id": obj.get("user_id"),
            "student": obj.get("student"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "target_audience": obj.get("target_audience"),
            "platform": obj.get("platform"),
            "platform_key": obj.get("platform_key"),
            "status": obj.get("status"),
            "publish_course": obj.get("publish_course"),
            "course_data": obj.get("course_data"),
            "provider": obj.get("provider"),
            "model": obj.get("model"),
            "desired_number_of_sections": obj.get("desired_number_of_sections"),
            "logs": obj.get("logs"),
            "files": [CourseCreationTaskFile.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "date_created": obj.get("date_created"),
            "last_modified": obj.get("last_modified")
        })
        return _obj


