# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.course_completion import CourseCompletion
from iblai.models.enrollment_info import EnrollmentInfo
from typing import Optional, Set
from typing_extensions import Self

class CourseDetail(BaseModel):
    """
    CourseDetail
    """ # noqa: E501
    course_id: StrictStr
    name: Optional[StrictStr] = None
    platform: Optional[StrictStr] = None
    enrollment: EnrollmentInfo
    completion: Optional[CourseCompletion] = None
    time_spent: Optional[StrictStr] = Field(default=None, description="Total time spent on this course in human-readable format (e.g., '1h 30m')")
    time_spent_secs: Optional[StrictInt] = Field(default=None, description="Total time spent on this course in seconds")
    __properties: ClassVar[List[str]] = ["course_id", "name", "platform", "enrollment", "completion", "time_spent", "time_spent_secs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of enrollment
        if self.enrollment:
            _dict['enrollment'] = self.enrollment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of completion
        if self.completion:
            _dict['completion'] = self.completion.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if completion (nullable) is None
        # and model_fields_set contains the field
        if self.completion is None and "completion" in self.model_fields_set:
            _dict['completion'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_id": obj.get("course_id"),
            "name": obj.get("name"),
            "platform": obj.get("platform"),
            "enrollment": EnrollmentInfo.from_dict(obj["enrollment"]) if obj.get("enrollment") is not None else None,
            "completion": CourseCompletion.from_dict(obj["completion"]) if obj.get("completion") is not None else None,
            "time_spent": obj.get("time_spent"),
            "time_spent_secs": obj.get("time_spent_secs")
        })
        return _obj


