# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CourseGroupSuggestionDetail(BaseModel):
    """
    Response serializer for course group suggestion details
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the group suggestion")
    group_id: StrictInt = Field(description="The ID of the group receiving the suggestion")
    group_name: StrictStr = Field(description="The name of the group receiving the suggestion")
    platform_key: StrictStr = Field(description="The platform key associated with the suggestion")
    accepted: Optional[StrictBool] = Field(default=None, description="Whether the suggestion has been accepted")
    visible: StrictBool = Field(description="Whether the suggestion is visible")
    created: datetime = Field(description="When the suggestion was created")
    modified: datetime = Field(description="When the suggestion was last modified")
    metadata: Dict[str, Any] = Field(description="Additional metadata for the suggestion")
    course_id: StrictStr = Field(description="The course ID being suggested")
    course_name: StrictStr = Field(description="The name of the course being suggested")
    user_count: Optional[StrictInt] = Field(default=None, description="Number of users in the group")
    __properties: ClassVar[List[str]] = ["id", "group_id", "group_name", "platform_key", "accepted", "visible", "created", "modified", "metadata", "course_id", "course_name", "user_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseGroupSuggestionDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseGroupSuggestionDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "group_id": obj.get("group_id"),
            "group_name": obj.get("group_name"),
            "platform_key": obj.get("platform_key"),
            "accepted": obj.get("accepted"),
            "visible": obj.get("visible"),
            "created": obj.get("created"),
            "modified": obj.get("modified"),
            "metadata": obj.get("metadata"),
            "course_id": obj.get("course_id"),
            "course_name": obj.get("course_name"),
            "user_count": obj.get("user_count")
        })
        return _obj


