# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CourseInvitationCreate(BaseModel):
    """
    Request serializer for CourseInvitationView POST endpoint
    """ # noqa: E501
    course_id: StrictStr = Field(description="The course to create an invitation for")
    email: Optional[StrictStr] = Field(default=None, description="The email address to invite")
    username: Optional[StrictStr] = Field(default=None, description="The username to invite")
    active: Optional[StrictBool] = Field(default=True, description="Whether the invitation is active")
    source: Optional[StrictStr] = Field(default=None, description="The source of the invitation")
    redirect_to: Optional[StrictStr] = Field(default=None, description="URL to redirect to after accepting the invitation")
    created: Optional[datetime] = Field(default=None, description="When the invitation was created")
    expired: Optional[datetime] = Field(default=None, description="When the invitation expires")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata for the invitation")
    __properties: ClassVar[List[str]] = ["course_id", "email", "username", "active", "source", "redirect_to", "created", "expired", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseInvitationCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseInvitationCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_id": obj.get("course_id"),
            "email": obj.get("email"),
            "username": obj.get("username"),
            "active": obj.get("active") if obj.get("active") is not None else True,
            "source": obj.get("source"),
            "redirect_to": obj.get("redirect_to"),
            "created": obj.get("created"),
            "expired": obj.get("expired"),
            "metadata": obj.get("metadata")
        })
        return _obj


