# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CourseLicenseGroupAssignmentDetail(BaseModel):
    """
    Response serializer for course license group assignment details
    """ # noqa: E501
    id: StrictInt = Field(description="The unique identifier for the assignment")
    group_id: StrictInt = Field(description="The ID of the group assigned the license")
    group_name: StrictStr = Field(description="The name of the group assigned the license")
    active: StrictBool = Field(description="Whether the assignment is active")
    fulfilled: Optional[StrictBool] = Field(default=None, description="Whether the assignment has been fulfilled")
    redirect_to: Optional[StrictStr] = Field(default=None, description="URL to redirect to after fulfillment")
    metadata: Dict[str, Any] = Field(description="Additional metadata for the assignment")
    license_id: StrictInt = Field(description="The ID of the course license")
    license_name: StrictStr = Field(description="The name of the course license")
    course_id: StrictStr = Field(description="The course ID associated with the license")
    __properties: ClassVar[List[str]] = ["id", "group_id", "group_name", "active", "fulfilled", "redirect_to", "metadata", "license_id", "license_name", "course_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseLicenseGroupAssignmentDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if redirect_to (nullable) is None
        # and model_fields_set contains the field
        if self.redirect_to is None and "redirect_to" in self.model_fields_set:
            _dict['redirect_to'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseLicenseGroupAssignmentDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "group_id": obj.get("group_id"),
            "group_name": obj.get("group_name"),
            "active": obj.get("active"),
            "fulfilled": obj.get("fulfilled"),
            "redirect_to": obj.get("redirect_to"),
            "metadata": obj.get("metadata"),
            "license_id": obj.get("license_id"),
            "license_name": obj.get("license_name"),
            "course_id": obj.get("course_id")
        })
        return _obj


