# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CourseRecommendation(BaseModel):
    """
    Individual course recommendation with reasoning.
    """ # noqa: E501
    course_id: StrictStr = Field(description="The ID of the recommended course")
    course_title: StrictStr = Field(description="The title of the recommended course")
    reason: StrictStr = Field(description="AI-generated explanation for why this course is recommended")
    domain: Optional[StrictStr] = Field(default=None, description="Course domain/subject area")
    difficulty_level: Optional[StrictStr] = Field(default=None, description="Course difficulty level")
    estimated_hours: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Estimated hours to complete")
    confidence_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="AI confidence in this recommendation (0-1)")
    platform_key: Optional[StrictStr] = Field(default=None, description="Platform/tenant key this course belongs to (extracted from course_id or metadata)")
    description: Optional[StrictStr] = Field(default=None, description="Course description (priority: description > short_description > overview with HTML stripped)")
    short_description: Optional[StrictStr] = Field(default=None, description="Course short description from edx_data")
    __properties: ClassVar[List[str]] = ["course_id", "course_title", "reason", "domain", "difficulty_level", "estimated_hours", "confidence_score", "platform_key", "description", "short_description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CourseRecommendation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if difficulty_level (nullable) is None
        # and model_fields_set contains the field
        if self.difficulty_level is None and "difficulty_level" in self.model_fields_set:
            _dict['difficulty_level'] = None

        # set to None if estimated_hours (nullable) is None
        # and model_fields_set contains the field
        if self.estimated_hours is None and "estimated_hours" in self.model_fields_set:
            _dict['estimated_hours'] = None

        # set to None if confidence_score (nullable) is None
        # and model_fields_set contains the field
        if self.confidence_score is None and "confidence_score" in self.model_fields_set:
            _dict['confidence_score'] = None

        # set to None if platform_key (nullable) is None
        # and model_fields_set contains the field
        if self.platform_key is None and "platform_key" in self.model_fields_set:
            _dict['platform_key'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if short_description (nullable) is None
        # and model_fields_set contains the field
        if self.short_description is None and "short_description" in self.model_fields_set:
            _dict['short_description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CourseRecommendation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "course_id": obj.get("course_id"),
            "course_title": obj.get("course_title"),
            "reason": obj.get("reason"),
            "domain": obj.get("domain"),
            "difficulty_level": obj.get("difficulty_level"),
            "estimated_hours": obj.get("estimated_hours"),
            "confidence_score": obj.get("confidence_score"),
            "platform_key": obj.get("platform_key"),
            "description": obj.get("description"),
            "short_description": obj.get("short_description")
        })
        return _obj


