# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Credential(BaseModel):
    """
    Credential
    """ # noqa: E501
    credential_id: StrictStr
    credential_url: StrictStr
    name: StrictStr
    credential_type: Optional[StrictStr] = None
    issuer: Optional[StrictStr] = None
    issued_on: Optional[datetime] = None
    expires_at: Optional[datetime] = None
    revoked: StrictBool
    __properties: ClassVar[List[str]] = ["credential_id", "credential_url", "name", "credential_type", "issuer", "issued_on", "expires_at", "revoked"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Credential from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if credential_type (nullable) is None
        # and model_fields_set contains the field
        if self.credential_type is None and "credential_type" in self.model_fields_set:
            _dict['credential_type'] = None

        # set to None if issuer (nullable) is None
        # and model_fields_set contains the field
        if self.issuer is None and "issuer" in self.model_fields_set:
            _dict['issuer'] = None

        # set to None if issued_on (nullable) is None
        # and model_fields_set contains the field
        if self.issued_on is None and "issued_on" in self.model_fields_set:
            _dict['issued_on'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Credential from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "credential_id": obj.get("credential_id"),
            "credential_url": obj.get("credential_url"),
            "name": obj.get("name"),
            "credential_type": obj.get("credential_type"),
            "issuer": obj.get("issuer"),
            "issued_on": obj.get("issued_on"),
            "expires_at": obj.get("expires_at"),
            "revoked": obj.get("revoked")
        })
        return _obj


