# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.data_set_platform_value import DataSetPlatformValue
from iblai.models.data_set_status_enum import DataSetStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class DataSet(BaseModel):
    """
    DataSet
    """ # noqa: E501
    id: UUID
    platform: Optional[Dict[str, DataSetPlatformValue]]
    name: Annotated[str, Field(strict=True, max_length=255)]
    prompt: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="(if any) Special instructions for generating the dataset. This could be requirements on tone, language, style, etc.")
    source_url: Optional[Annotated[str, Field(strict=True, max_length=400)]] = None
    source_file: Optional[StrictStr] = None
    status: Optional[DataSetStatusEnum] = None
    num_data_points: Optional[StrictInt] = None
    train_split: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = None
    train_file: Optional[StrictStr] = None
    test_file: Optional[StrictStr] = None
    retry_attempts: Optional[StrictInt] = None
    error_log: Optional[StrictStr] = None
    date_created: datetime
    last_modified: datetime
    __properties: ClassVar[List[str]] = ["id", "platform", "name", "prompt", "source_url", "source_file", "status", "num_data_points", "train_split", "train_file", "test_file", "retry_attempts", "error_log", "date_created", "last_modified"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataSet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "date_created",
            "last_modified",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in platform (dict)
        _field_dict = {}
        if self.platform:
            for _key_platform in self.platform:
                if self.platform[_key_platform]:
                    _field_dict[_key_platform] = self.platform[_key_platform].to_dict()
            _dict['platform'] = _field_dict
        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataSet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "platform": dict(
                (_k, DataSetPlatformValue.from_dict(_v))
                for _k, _v in obj["platform"].items()
            )
            if obj.get("platform") is not None
            else None,
            "name": obj.get("name"),
            "prompt": obj.get("prompt"),
            "source_url": obj.get("source_url"),
            "source_file": obj.get("source_file"),
            "status": obj.get("status"),
            "num_data_points": obj.get("num_data_points"),
            "train_split": obj.get("train_split"),
            "train_file": obj.get("train_file"),
            "test_file": obj.get("test_file"),
            "retry_attempts": obj.get("retry_attempts"),
            "error_log": obj.get("error_log"),
            "date_created": obj.get("date_created"),
            "last_modified": obj.get("last_modified")
        })
        return _obj


