# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ElevenlabsCustomVoiceResponse(BaseModel):
    """
    ElevenlabsCustomVoiceResponse
    """ # noqa: E501
    name: Annotated[str, Field(strict=True, max_length=255)]
    owner_student: Optional[StrictStr]
    language: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    is_premade: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    sample_audio_url: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["name", "owner_student", "language", "is_premade", "description", "sample_audio_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ElevenlabsCustomVoiceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "owner_student",
            "sample_audio_url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if owner_student (nullable) is None
        # and model_fields_set contains the field
        if self.owner_student is None and "owner_student" in self.model_fields_set:
            _dict['owner_student'] = None

        # set to None if sample_audio_url (nullable) is None
        # and model_fields_set contains the field
        if self.sample_audio_url is None and "sample_audio_url" in self.model_fields_set:
            _dict['sample_audio_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ElevenlabsCustomVoiceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "owner_student": obj.get("owner_student"),
            "language": obj.get("language"),
            "is_premade": obj.get("is_premade"),
            "description": obj.get("description"),
            "sample_audio_url": obj.get("sample_audio_url")
        })
        return _obj


