# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class EmailPromptList(BaseModel):
    """
    EmailPromptList
    """ # noqa: E501
    id: StrictInt
    sender_email: Annotated[str, Field(strict=True, max_length=254)]
    sender_name: Optional[StrictStr] = None
    subject: Optional[StrictStr] = None
    content_summary: Optional[StrictStr]
    mentor_name: Optional[StrictStr] = None
    mentor_email: Annotated[str, Field(strict=True, max_length=254)]
    is_processed: Optional[StrictBool] = None
    inserted_at: StrictStr
    __properties: ClassVar[List[str]] = ["id", "sender_email", "sender_name", "subject", "content_summary", "mentor_name", "mentor_email", "is_processed", "inserted_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailPromptList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "content_summary",
            "inserted_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sender_name (nullable) is None
        # and model_fields_set contains the field
        if self.sender_name is None and "sender_name" in self.model_fields_set:
            _dict['sender_name'] = None

        # set to None if subject (nullable) is None
        # and model_fields_set contains the field
        if self.subject is None and "subject" in self.model_fields_set:
            _dict['subject'] = None

        # set to None if content_summary (nullable) is None
        # and model_fields_set contains the field
        if self.content_summary is None and "content_summary" in self.model_fields_set:
            _dict['content_summary'] = None

        # set to None if mentor_name (nullable) is None
        # and model_fields_set contains the field
        if self.mentor_name is None and "mentor_name" in self.model_fields_set:
            _dict['mentor_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailPromptList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "sender_email": obj.get("sender_email"),
            "sender_name": obj.get("sender_name"),
            "subject": obj.get("subject"),
            "content_summary": obj.get("content_summary"),
            "mentor_name": obj.get("mentor_name"),
            "mentor_email": obj.get("mentor_email"),
            "is_processed": obj.get("is_processed"),
            "inserted_at": obj.get("inserted_at")
        })
        return _obj


