# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class FileUploadURLResponse(BaseModel):
    """
    Response serializer for presigned upload URL
    """ # noqa: E501
    upload_url: StrictStr = Field(description="Presigned S3 upload URL")
    file_key: StrictStr = Field(description="S3 object key for the uploaded file")
    file_id: UUID = Field(description="Unique identifier for the ChatFile record")
    expires_in: StrictInt = Field(description="URL expiration time in seconds")
    upload_method: Optional[StrictStr] = Field(default='PUT', description="HTTP method to use for upload (PUT or POST)")
    __properties: ClassVar[List[str]] = ["upload_url", "file_key", "file_id", "expires_in", "upload_method"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FileUploadURLResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FileUploadURLResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "upload_url": obj.get("upload_url"),
            "file_key": obj.get("file_key"),
            "file_id": obj.get("file_id"),
            "expires_in": obj.get("expires_in"),
            "upload_method": obj.get("upload_method") if obj.get("upload_method") is not None else 'PUT'
        })
        return _obj


