# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.metric_info import MetricInfo
from typing import Optional, Set
from typing_extensions import Self

class FinanceDetailsResponse(BaseModel):
    """
    Serializer for /financial/details responses.
    """ # noqa: E501
    page: StrictInt
    limit: StrictInt
    total_pages: StrictInt
    total_records: StrictInt
    rows: Optional[Any] = None
    total_cost: Optional[Annotated[str, Field(strict=True)]] = None
    metrics: Optional[List[MetricInfo]] = None
    __properties: ClassVar[List[str]] = ["page", "limit", "total_pages", "total_records", "rows", "total_cost", "metrics"]

    @field_validator('total_cost')
    def total_cost_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^-?\d{0,15}(?:\.\d{0,5})?$", value):
            raise ValueError(r"must validate the regular expression /^-?\d{0,15}(?:\.\d{0,5})?$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FinanceDetailsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metrics (list)
        _items = []
        if self.metrics:
            for _item_metrics in self.metrics:
                if _item_metrics:
                    _items.append(_item_metrics.to_dict())
            _dict['metrics'] = _items
        # set to None if rows (nullable) is None
        # and model_fields_set contains the field
        if self.rows is None and "rows" in self.model_fields_set:
            _dict['rows'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FinanceDetailsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page": obj.get("page"),
            "limit": obj.get("limit"),
            "total_pages": obj.get("total_pages"),
            "total_records": obj.get("total_records"),
            "rows": obj.get("rows"),
            "total_cost": obj.get("total_cost"),
            "metrics": [MetricInfo.from_dict(_item) for _item in obj["metrics"]] if obj.get("metrics") is not None else None
        })
        return _obj


