# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GCPTenantLaunchRequest(BaseModel):
    """
    GCPTenantLaunchRequest
    """ # noqa: E501
    username: StrictStr
    email: StrictStr
    firstname: Optional[StrictStr] = ''
    lastname: Optional[StrictStr] = ''
    password: Optional[StrictStr] = None
    name: StrictStr = Field(description="Organization name")
    key: StrictStr = Field(description="Unique key for the organization")
    ignore_user_exists: Optional[StrictBool] = False
    is_advertising: Optional[StrictBool] = Field(default=False, description="Advertising mode allows a platform to set custom usd balance to allocate for its members")
    x_gcp_marketplace_token: StrictStr = Field(description="GCP Marketplace token")
    product_id: Optional[StrictStr] = Field(default='', description="GCP product to subscribe to")
    __properties: ClassVar[List[str]] = ["username", "email", "firstname", "lastname", "password", "name", "key", "ignore_user_exists", "is_advertising", "x_gcp_marketplace_token", "product_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GCPTenantLaunchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GCPTenantLaunchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "username": obj.get("username"),
            "email": obj.get("email"),
            "firstname": obj.get("firstname") if obj.get("firstname") is not None else '',
            "lastname": obj.get("lastname") if obj.get("lastname") is not None else '',
            "password": obj.get("password"),
            "name": obj.get("name"),
            "key": obj.get("key"),
            "ignore_user_exists": obj.get("ignore_user_exists") if obj.get("ignore_user_exists") is not None else False,
            "is_advertising": obj.get("is_advertising") if obj.get("is_advertising") is not None else False,
            "x_gcp_marketplace_token": obj.get("x_gcp_marketplace_token"),
            "product_id": obj.get("product_id") if obj.get("product_id") is not None else ''
        })
        return _obj


