# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class GroupListData(BaseModel):
    """
    Serializer for department list endpoint
    """ # noqa: E501
    id: StrictInt
    name: StrictStr
    platform: StrictStr
    courses_enrolled: StrictInt
    courses_completed: StrictInt
    completion_rate: Union[StrictFloat, StrictInt]
    pathways_completed: StrictInt
    certificates_earned: StrictInt
    skills_points: StrictInt
    skills_earned: StrictInt
    time_spent: StrictStr
    __properties: ClassVar[List[str]] = ["id", "name", "platform", "courses_enrolled", "courses_completed", "completion_rate", "pathways_completed", "certificates_earned", "skills_points", "skills_earned", "time_spent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GroupListData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GroupListData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "platform": obj.get("platform"),
            "courses_enrolled": obj.get("courses_enrolled"),
            "courses_completed": obj.get("courses_completed"),
            "completion_rate": obj.get("completion_rate"),
            "pathways_completed": obj.get("pathways_completed"),
            "certificates_earned": obj.get("certificates_earned"),
            "skills_points": obj.get("skills_points"),
            "skills_earned": obj.get("skills_earned"),
            "time_spent": obj.get("time_spent")
        })
        return _obj


