# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from iblai.models.human_support_ticket_status_enum import HumanSupportTicketStatusEnum
from typing import Optional, Set
from typing_extensions import Self

class HumanSupportTicket(BaseModel):
    """
    serializer interface intended for students/ non-admin users. This limits students to only update the subject and description of a ticket.
    """ # noqa: E501
    id: StrictInt
    username: StrictStr
    email: StrictStr
    full_name: StrictStr
    user: StrictInt = Field(description="edX user ID")
    session: UUID
    subject: Annotated[str, Field(strict=True, max_length=255)]
    description: StrictStr
    status: Optional[HumanSupportTicketStatusEnum] = None
    mentor_id: StrictStr
    created_at: datetime
    updated_at: datetime
    resolved_at: Optional[datetime]
    __properties: ClassVar[List[str]] = ["id", "username", "email", "full_name", "user", "session", "subject", "description", "status", "mentor_id", "created_at", "updated_at", "resolved_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HumanSupportTicket from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "username",
            "email",
            "full_name",
            "user",
            "session",
            "mentor_id",
            "created_at",
            "updated_at",
            "resolved_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if resolved_at (nullable) is None
        # and model_fields_set contains the field
        if self.resolved_at is None and "resolved_at" in self.model_fields_set:
            _dict['resolved_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HumanSupportTicket from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "full_name": obj.get("full_name"),
            "user": obj.get("user"),
            "session": obj.get("session"),
            "subject": obj.get("subject"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "mentor_id": obj.get("mentor_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "resolved_at": obj.get("resolved_at")
        })
        return _obj


