# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.institution_type_enum import InstitutionTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class Institution(BaseModel):
    """
    Institution
    """ # noqa: E501
    id: StrictInt
    name: Annotated[str, Field(strict=True, max_length=100)]
    institution_type: Optional[InstitutionTypeEnum] = None
    location: Optional[Annotated[str, Field(strict=True, max_length=100)]] = None
    website: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    accreditation: Optional[Annotated[str, Field(strict=True, max_length=100)]] = None
    established_year: Optional[StrictInt] = None
    data: Optional[Any] = Field(default=None, description="Metadata")
    metadata: Optional[Any] = Field(default=None, description="Metadata")
    created_at: Optional[datetime] = None
    updated_at: datetime
    __properties: ClassVar[List[str]] = ["id", "name", "institution_type", "location", "website", "accreditation", "established_year", "data", "metadata", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Institution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if website (nullable) is None
        # and model_fields_set contains the field
        if self.website is None and "website" in self.model_fields_set:
            _dict['website'] = None

        # set to None if accreditation (nullable) is None
        # and model_fields_set contains the field
        if self.accreditation is None and "accreditation" in self.model_fields_set:
            _dict['accreditation'] = None

        # set to None if established_year (nullable) is None
        # and model_fields_set contains the field
        if self.established_year is None and "established_year" in self.model_fields_set:
            _dict['established_year'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Institution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "institution_type": obj.get("institution_type"),
            "location": obj.get("location"),
            "website": obj.get("website"),
            "accreditation": obj.get("accreditation"),
            "established_year": obj.get("established_year"),
            "data": obj.get("data"),
            "metadata": obj.get("metadata"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


