# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.billing_period import BillingPeriod
from iblai.models.breakdown import Breakdown
from iblai.models.entity import Entity
from iblai.models.summary import Summary
from typing import Optional, Set
from typing_extensions import Self

class InvoiceReportResponse(BaseModel):
    """
    Complete invoice report response.
    """ # noqa: E501
    entity: Entity
    billing_period: BillingPeriod
    summary: Summary
    breakdown: Optional[Breakdown] = None
    __properties: ClassVar[List[str]] = ["entity", "billing_period", "summary", "breakdown"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvoiceReportResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict['entity'] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing_period
        if self.billing_period:
            _dict['billing_period'] = self.billing_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of breakdown
        if self.breakdown:
            _dict['breakdown'] = self.breakdown.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvoiceReportResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entity": Entity.from_dict(obj["entity"]) if obj.get("entity") is not None else None,
            "billing_period": BillingPeriod.from_dict(obj["billing_period"]) if obj.get("billing_period") is not None else None,
            "summary": Summary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
            "breakdown": Breakdown.from_dict(obj["breakdown"]) if obj.get("breakdown") is not None else None
        })
        return _obj


