# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.activity_info import ActivityInfo
from iblai.models.platform_metrics import PlatformMetrics
from iblai.models.platform_summary import PlatformSummary
from typing import Optional, Set
from typing_extensions import Self

class LearnerAnalyticsResult(BaseModel):
    """
    Unified serializer for learner analytics results - handles both cross-platform and platform-specific data.
    """ # noqa: E501
    platform_id: StrictInt
    platform_name: StrictStr
    platform_key: Optional[StrictStr]
    summary: Optional[PlatformSummary] = None
    metrics: Optional[PlatformMetrics] = None
    activity: Optional[ActivityInfo] = None
    last_updated: Optional[datetime] = None
    user_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["platform_id", "platform_name", "platform_key", "summary", "metrics", "activity", "last_updated", "user_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerAnalyticsResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of activity
        if self.activity:
            _dict['activity'] = self.activity.to_dict()
        # set to None if platform_key (nullable) is None
        # and model_fields_set contains the field
        if self.platform_key is None and "platform_key" in self.model_fields_set:
            _dict['platform_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerAnalyticsResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_id": obj.get("platform_id"),
            "platform_name": obj.get("platform_name"),
            "platform_key": obj.get("platform_key"),
            "summary": PlatformSummary.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
            "metrics": PlatformMetrics.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "activity": ActivityInfo.from_dict(obj["activity"]) if obj.get("activity") is not None else None,
            "last_updated": obj.get("last_updated"),
            "user_id": obj.get("user_id")
        })
        return _obj


