# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.course_detail import CourseDetail
from iblai.models.credential import Credential
from iblai.models.mentor_detail import MentorDetail
from iblai.models.pathway_detail import PathwayDetail
from iblai.models.program_detail import ProgramDetail
from iblai.models.skills_detail import SkillsDetail
from iblai.models.time_spent_detail import TimeSpentDetail
from typing import Optional, Set
from typing_extensions import Self

class LearnerData(BaseModel):
    """
    LearnerData
    """ # noqa: E501
    courses: Optional[List[CourseDetail]] = None
    programs: Optional[List[ProgramDetail]] = None
    pathways: Optional[List[PathwayDetail]] = None
    mentors: Optional[List[MentorDetail]] = None
    skills: Optional[SkillsDetail] = None
    credentials: Optional[List[Credential]] = None
    time_spent: Optional[TimeSpentDetail] = None
    __properties: ClassVar[List[str]] = ["courses", "programs", "pathways", "mentors", "skills", "credentials", "time_spent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in courses (list)
        _items = []
        if self.courses:
            for _item_courses in self.courses:
                if _item_courses:
                    _items.append(_item_courses.to_dict())
            _dict['courses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in programs (list)
        _items = []
        if self.programs:
            for _item_programs in self.programs:
                if _item_programs:
                    _items.append(_item_programs.to_dict())
            _dict['programs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pathways (list)
        _items = []
        if self.pathways:
            for _item_pathways in self.pathways:
                if _item_pathways:
                    _items.append(_item_pathways.to_dict())
            _dict['pathways'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mentors (list)
        _items = []
        if self.mentors:
            for _item_mentors in self.mentors:
                if _item_mentors:
                    _items.append(_item_mentors.to_dict())
            _dict['mentors'] = _items
        # override the default output from pydantic by calling `to_dict()` of skills
        if self.skills:
            _dict['skills'] = self.skills.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in credentials (list)
        _items = []
        if self.credentials:
            for _item_credentials in self.credentials:
                if _item_credentials:
                    _items.append(_item_credentials.to_dict())
            _dict['credentials'] = _items
        # override the default output from pydantic by calling `to_dict()` of time_spent
        if self.time_spent:
            _dict['time_spent'] = self.time_spent.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "courses": [CourseDetail.from_dict(_item) for _item in obj["courses"]] if obj.get("courses") is not None else None,
            "programs": [ProgramDetail.from_dict(_item) for _item in obj["programs"]] if obj.get("programs") is not None else None,
            "pathways": [PathwayDetail.from_dict(_item) for _item in obj["pathways"]] if obj.get("pathways") is not None else None,
            "mentors": [MentorDetail.from_dict(_item) for _item in obj["mentors"]] if obj.get("mentors") is not None else None,
            "skills": SkillsDetail.from_dict(obj["skills"]) if obj.get("skills") is not None else None,
            "credentials": [Credential.from_dict(_item) for _item in obj["credentials"]] if obj.get("credentials") is not None else None,
            "time_spent": TimeSpentDetail.from_dict(obj["time_spent"]) if obj.get("time_spent") is not None else None
        })
        return _obj


