# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.learner_metrics import LearnerMetrics
from typing import Optional, Set
from typing_extensions import Self

class LearnerListItem(BaseModel):
    """
    Serializer for individual learner in the list.
    """ # noqa: E501
    user_id: StrictInt = Field(description="User ID")
    username: Optional[StrictStr] = Field(description="Username")
    email: Optional[StrictStr] = Field(description="Email address")
    name: Optional[StrictStr] = Field(description="Display name")
    is_active: StrictBool = Field(description="Whether user is active")
    platform_id: StrictInt = Field(description="Platform ID")
    platform_name: Optional[StrictStr] = Field(description="Platform name")
    platform_key: Optional[StrictStr] = Field(description="Platform key")
    metrics: LearnerMetrics = Field(description="Learner metrics")
    first_activity: Optional[datetime] = Field(description="First activity date")
    last_activity: Optional[datetime] = Field(description="Last activity date")
    __properties: ClassVar[List[str]] = ["user_id", "username", "email", "name", "is_active", "platform_id", "platform_name", "platform_key", "metrics", "first_activity", "last_activity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if platform_name (nullable) is None
        # and model_fields_set contains the field
        if self.platform_name is None and "platform_name" in self.model_fields_set:
            _dict['platform_name'] = None

        # set to None if platform_key (nullable) is None
        # and model_fields_set contains the field
        if self.platform_key is None and "platform_key" in self.model_fields_set:
            _dict['platform_key'] = None

        # set to None if first_activity (nullable) is None
        # and model_fields_set contains the field
        if self.first_activity is None and "first_activity" in self.model_fields_set:
            _dict['first_activity'] = None

        # set to None if last_activity (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity is None and "last_activity" in self.model_fields_set:
            _dict['last_activity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "name": obj.get("name"),
            "is_active": obj.get("is_active"),
            "platform_id": obj.get("platform_id"),
            "platform_name": obj.get("platform_name"),
            "platform_key": obj.get("platform_key"),
            "metrics": LearnerMetrics.from_dict(obj["metrics"]) if obj.get("metrics") is not None else None,
            "first_activity": obj.get("first_activity"),
            "last_activity": obj.get("last_activity")
        })
        return _obj


