# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LearnerListPagination(BaseModel):
    """
    Serializer for learner list pagination.
    """ # noqa: E501
    page: StrictInt = Field(description="Current page number")
    limit: StrictInt = Field(description="Records per page")
    total_pages: StrictInt = Field(description="Total number of pages")
    total_records: StrictInt = Field(description="Total number of records")
    has_next: StrictBool = Field(description="Whether there is a next page")
    has_previous: StrictBool = Field(description="Whether there is a previous page")
    next_page: Optional[StrictInt] = Field(description="Next page number")
    previous_page: Optional[StrictInt] = Field(description="Previous page number")
    __properties: ClassVar[List[str]] = ["page", "limit", "total_pages", "total_records", "has_next", "has_previous", "next_page", "previous_page"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerListPagination from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if next_page (nullable) is None
        # and model_fields_set contains the field
        if self.next_page is None and "next_page" in self.model_fields_set:
            _dict['next_page'] = None

        # set to None if previous_page (nullable) is None
        # and model_fields_set contains the field
        if self.previous_page is None and "previous_page" in self.model_fields_set:
            _dict['previous_page'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerListPagination from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "page": obj.get("page"),
            "limit": obj.get("limit"),
            "total_pages": obj.get("total_pages"),
            "total_records": obj.get("total_records"),
            "has_next": obj.get("has_next"),
            "has_previous": obj.get("has_previous"),
            "next_page": obj.get("next_page"),
            "previous_page": obj.get("previous_page")
        })
        return _obj


