# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from iblai.models.learner_list_item import LearnerListItem
from iblai.models.learner_list_pagination import LearnerListPagination
from iblai.models.platform_info import PlatformInfo
from typing import Optional, Set
from typing_extensions import Self

class LearnerListResponse(BaseModel):
    """
    Serializer for learner list API response.
    """ # noqa: E501
    platform: PlatformInfo = Field(description="Platform information")
    learners: List[LearnerListItem] = Field(description="List of learners")
    pagination: LearnerListPagination = Field(description="Pagination metadata")
    generated_at: datetime = Field(description="Response generation timestamp")
    __properties: ClassVar[List[str]] = ["platform", "learners", "pagination", "generated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerListResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in learners (list)
        _items = []
        if self.learners:
            for _item_learners in self.learners:
                if _item_learners:
                    _items.append(_item_learners.to_dict())
            _dict['learners'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerListResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform": PlatformInfo.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "learners": [LearnerListItem.from_dict(_item) for _item in obj["learners"]] if obj.get("learners") is not None else None,
            "pagination": LearnerListPagination.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None,
            "generated_at": obj.get("generated_at")
        })
        return _obj


