# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
from iblai.models.top_content import TopContent
from typing import Optional, Set
from typing_extensions import Self

class LearnerMetrics(BaseModel):
    """
    Serializer for learner metrics from UserPlatformSummary.
    """ # noqa: E501
    enrollments: StrictInt = Field(description="Total enrollments")
    programs: StrictInt = Field(description="Total programs")
    pathways: StrictInt = Field(description="Total pathways")
    resources: StrictInt = Field(description="Total resources")
    reported_skills: StrictInt = Field(description="Reported skills count")
    desired_skills: StrictInt = Field(description="Desired skills count")
    assigned_skills: StrictInt = Field(description="Assigned skills count")
    total_skills: StrictInt = Field(description="Total skills count")
    credentials: StrictInt = Field(description="Credentials earned")
    points: Union[StrictFloat, StrictInt] = Field(description="Total points")
    total_time_spent_seconds: StrictInt = Field(description="Total time spent in seconds")
    top_content: TopContent = Field(description="Course with most time spent")
    __properties: ClassVar[List[str]] = ["enrollments", "programs", "pathways", "resources", "reported_skills", "desired_skills", "assigned_skills", "total_skills", "credentials", "points", "total_time_spent_seconds", "top_content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LearnerMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of top_content
        if self.top_content:
            _dict['top_content'] = self.top_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LearnerMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enrollments": obj.get("enrollments"),
            "programs": obj.get("programs"),
            "pathways": obj.get("pathways"),
            "resources": obj.get("resources"),
            "reported_skills": obj.get("reported_skills"),
            "desired_skills": obj.get("desired_skills"),
            "assigned_skills": obj.get("assigned_skills"),
            "total_skills": obj.get("total_skills"),
            "credentials": obj.get("credentials"),
            "points": obj.get("points"),
            "total_time_spent_seconds": obj.get("total_time_spent_seconds"),
            "top_content": TopContent.from_dict(obj["top_content"]) if obj.get("top_content") is not None else None
        })
        return _obj


