# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class LLMResponse(BaseModel):
    """
    LLMResponse
    """ # noqa: E501
    id: StrictInt
    name: Annotated[str, Field(strict=True, max_length=255)]
    description: Optional[StrictStr] = None
    metadata: Optional[Any] = None
    resource_ids: Optional[Any] = None
    tags: Optional[Any] = None
    overview: Optional[StrictStr] = None
    use_cases: Optional[StrictStr] = None
    documentation: Optional[StrictStr] = None
    sdk_samples: Optional[StrictStr] = None
    chat_models: Optional[Any] = None
    disabled_models: Optional[Any] = Field(default=None, description="List of disabled models. If empty, all models are enabled.")
    logo: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "metadata", "resource_ids", "tags", "overview", "use_cases", "documentation", "sdk_samples", "chat_models", "disabled_models", "logo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LLMResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if resource_ids (nullable) is None
        # and model_fields_set contains the field
        if self.resource_ids is None and "resource_ids" in self.model_fields_set:
            _dict['resource_ids'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if overview (nullable) is None
        # and model_fields_set contains the field
        if self.overview is None and "overview" in self.model_fields_set:
            _dict['overview'] = None

        # set to None if use_cases (nullable) is None
        # and model_fields_set contains the field
        if self.use_cases is None and "use_cases" in self.model_fields_set:
            _dict['use_cases'] = None

        # set to None if documentation (nullable) is None
        # and model_fields_set contains the field
        if self.documentation is None and "documentation" in self.model_fields_set:
            _dict['documentation'] = None

        # set to None if sdk_samples (nullable) is None
        # and model_fields_set contains the field
        if self.sdk_samples is None and "sdk_samples" in self.model_fields_set:
            _dict['sdk_samples'] = None

        # set to None if chat_models (nullable) is None
        # and model_fields_set contains the field
        if self.chat_models is None and "chat_models" in self.model_fields_set:
            _dict['chat_models'] = None

        # set to None if disabled_models (nullable) is None
        # and model_fields_set contains the field
        if self.disabled_models is None and "disabled_models" in self.model_fields_set:
            _dict['disabled_models'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LLMResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "metadata": obj.get("metadata"),
            "resource_ids": obj.get("resource_ids"),
            "tags": obj.get("tags"),
            "overview": obj.get("overview"),
            "use_cases": obj.get("use_cases"),
            "documentation": obj.get("documentation"),
            "sdk_samples": obj.get("sdk_samples"),
            "chat_models": obj.get("chat_models"),
            "disabled_models": obj.get("disabled_models"),
            "logo": obj.get("logo")
        })
        return _obj


