# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from iblai.models.conversation_rating import ConversationRating
from typing import Optional, Set
from typing_extensions import Self

class MentorEvalReport(BaseModel):
    """
    MentorEvalReport
    """ # noqa: E501
    id: StrictInt
    mentor_eval: StrictStr
    mentor: StrictStr
    conversation_ratings: List[ConversationRating]
    overall_score: Union[StrictFloat, StrictInt]
    is_passed: StrictBool
    generated_at: datetime
    __properties: ClassVar[List[str]] = ["id", "mentor_eval", "mentor", "conversation_ratings", "overall_score", "is_passed", "generated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MentorEvalReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "mentor_eval",
            "mentor",
            "conversation_ratings",
            "overall_score",
            "is_passed",
            "generated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conversation_ratings (list)
        _items = []
        if self.conversation_ratings:
            for _item_conversation_ratings in self.conversation_ratings:
                if _item_conversation_ratings:
                    _items.append(_item_conversation_ratings.to_dict())
            _dict['conversation_ratings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MentorEvalReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "mentor_eval": obj.get("mentor_eval"),
            "mentor": obj.get("mentor"),
            "conversation_ratings": [ConversationRating.from_dict(_item) for _item in obj["conversation_ratings"]] if obj.get("conversation_ratings") is not None else None,
            "overall_score": obj.get("overall_score"),
            "is_passed": obj.get("is_passed"),
            "generated_at": obj.get("generated_at")
        })
        return _obj


