# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.mentor_eval_question_request import MentorEvalQuestionRequest
from typing import Optional, Set
from typing_extensions import Self

class MentorEvalRequest(BaseModel):
    """
    MentorEvalRequest
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    passing_score: Optional[StrictInt] = None
    questions: Optional[List[MentorEvalQuestionRequest]] = None
    evaluation_prompt: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "passing_score", "questions", "evaluation_prompt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MentorEvalRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in questions (list)
        _items = []
        if self.questions:
            for _item_questions in self.questions:
                if _item_questions:
                    _items.append(_item_questions.to_dict())
            _dict['questions'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if passing_score (nullable) is None
        # and model_fields_set contains the field
        if self.passing_score is None and "passing_score" in self.model_fields_set:
            _dict['passing_score'] = None

        # set to None if questions (nullable) is None
        # and model_fields_set contains the field
        if self.questions is None and "questions" in self.model_fields_set:
            _dict['questions'] = None

        # set to None if evaluation_prompt (nullable) is None
        # and model_fields_set contains the field
        if self.evaluation_prompt is None and "evaluation_prompt" in self.model_fields_set:
            _dict['evaluation_prompt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MentorEvalRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "passing_score": obj.get("passing_score"),
            "questions": [MentorEvalQuestionRequest.from_dict(_item) for _item in obj["questions"]] if obj.get("questions") is not None else None,
            "evaluation_prompt": obj.get("evaluation_prompt")
        })
        return _obj


