# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.rbac_policy_group import RbacPolicyGroup
from iblai.models.rbac_user import RbacUser
from typing import Optional, Set
from typing_extensions import Self

class MentorPolicy(BaseModel):
    """
    Serializer for mentor-specific RBAC policies using ModelSerializer pattern. Accepts mentor_id and role, generates resources and role internally.
    """ # noqa: E501
    id: StrictInt
    name: StrictStr = Field(description="Policy name. If not supplied, defaults to a UUID4")
    platform_key: StrictStr = Field(description="Platform key where the mentor belongs")
    mentor_id: StrictInt = Field(description="ID of the mentor to manage access for")
    role: StrictStr = Field(description="Role for accessing this mentor (viewer or editor)")
    resources: Optional[Any] = Field(description="List of resources this policy applies to")
    users: List[RbacUser]
    groups: List[RbacPolicyGroup]
    groups_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to grant access to this mentor")
    groups_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to revoke access from this mentor")
    users_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to grant access to this mentor")
    users_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of user IDs to revoke access from this mentor")
    __properties: ClassVar[List[str]] = ["id", "name", "platform_key", "mentor_id", "role", "resources", "users", "groups", "groups_to_add", "groups_to_remove", "users_to_add", "users_to_remove"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MentorPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "name",
            "resources",
            "users",
            "groups",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in users (list)
        _items = []
        if self.users:
            for _item_users in self.users:
                if _item_users:
                    _items.append(_item_users.to_dict())
            _dict['users'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in groups (list)
        _items = []
        if self.groups:
            for _item_groups in self.groups:
                if _item_groups:
                    _items.append(_item_groups.to_dict())
            _dict['groups'] = _items
        # set to None if resources (nullable) is None
        # and model_fields_set contains the field
        if self.resources is None and "resources" in self.model_fields_set:
            _dict['resources'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MentorPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "platform_key": obj.get("platform_key"),
            "mentor_id": obj.get("mentor_id"),
            "role": obj.get("role"),
            "resources": obj.get("resources"),
            "users": [RbacUser.from_dict(_item) for _item in obj["users"]] if obj.get("users") is not None else None,
            "groups": [RbacPolicyGroup.from_dict(_item) for _item in obj["groups"]] if obj.get("groups") is not None else None,
            "groups_to_add": obj.get("groups_to_add"),
            "groups_to_remove": obj.get("groups_to_remove"),
            "users_to_add": obj.get("users_to_add"),
            "users_to_remove": obj.get("users_to_remove")
        })
        return _obj


