# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.align_mentor_bubble_enum import AlignMentorBubbleEnum
from iblai.models.mentor_category import MentorCategory
from iblai.models.mentor_type import MentorType
from iblai.models.subject import Subject
from iblai.models.theme_enum import ThemeEnum
from typing import Optional, Set
from typing_extensions import Self

class MentorSettingsPublic(BaseModel):
    """
    MentorSettingsPublic
    """ # noqa: E501
    id: StrictInt
    display_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    profile_image: Optional[StrictStr] = None
    initial_message: Optional[StrictStr] = None
    suggested_message: Optional[StrictStr] = None
    theme: Optional[ThemeEnum] = None
    user_message_color: Optional[Annotated[str, Field(strict=True, max_length=7)]] = None
    mentor_bubble_color: Optional[Annotated[str, Field(strict=True, max_length=7)]] = None
    align_mentor_bubble: Optional[AlignMentorBubbleEnum] = None
    mentor: StrictStr
    mentor_slug: StrictStr
    mentor_unique_id: StrictStr
    mentor_id: StrictInt
    metadata: Optional[Any]
    mentor_visibility: Optional[StrictStr] = None
    enable_image_generation: Optional[StrictBool] = None
    enable_web_browsing: Optional[StrictBool] = None
    enable_code_interpreter: Optional[StrictBool] = None
    enable_memory_component: StrictBool
    custom_css: Optional[StrictStr] = None
    allow_anonymous: StrictBool
    mentor_description: StrictStr
    suggested_prompts: Optional[Any]
    proactive_response: StrictStr
    greeting_method: StrictStr
    mentor_tools: Optional[Any]
    can_use_tools: StrictBool
    llm_name: StrictStr
    proactive_prompt: StrictStr
    disclaimer: StrictStr
    enable_disclaimer: StrictBool
    embed_is_context_aware: StrictBool
    embed_open_by_default: StrictBool
    embed_show_attachment: StrictBool
    embed_show_voice_call: StrictBool
    embed_show_voice_record: StrictBool
    placeholder_prompt: StrictStr
    enable_email_chat: StrictBool
    enable_spaced_repetition: StrictBool
    enable_instruction_mode: StrictBool
    enable_socratic_mode: StrictBool
    is_guided_mentor: StrictBool
    is_featured: StrictBool
    enable_guided_prompts: StrictBool
    enable_moderation: StrictBool
    enable_multi_query_rag: StrictBool
    enable_post_processing_system: StrictBool
    enable_safety_system: StrictBool
    forkable: StrictBool
    forkable_with_training_data: StrictBool
    mentor_name: StrictStr
    categories: List[MentorCategory]
    types: List[MentorType]
    subjects: List[Subject]
    recently_accessed_at: datetime
    created_by: StrictStr
    created_at: datetime
    updated_at: datetime
    platform_key: StrictStr
    llm_config: Optional[Any]
    llm_provider: StrictStr
    __properties: ClassVar[List[str]] = ["id", "display_name", "profile_image", "initial_message", "suggested_message", "theme", "user_message_color", "mentor_bubble_color", "align_mentor_bubble", "mentor", "mentor_slug", "mentor_unique_id", "mentor_id", "metadata", "mentor_visibility", "enable_image_generation", "enable_web_browsing", "enable_code_interpreter", "enable_memory_component", "custom_css", "allow_anonymous", "mentor_description", "suggested_prompts", "proactive_response", "greeting_method", "mentor_tools", "can_use_tools", "llm_name", "proactive_prompt", "disclaimer", "enable_disclaimer", "embed_is_context_aware", "embed_open_by_default", "embed_show_attachment", "embed_show_voice_call", "embed_show_voice_record", "placeholder_prompt", "enable_email_chat", "enable_spaced_repetition", "enable_instruction_mode", "enable_socratic_mode", "is_guided_mentor", "is_featured", "enable_guided_prompts", "enable_moderation", "enable_multi_query_rag", "enable_post_processing_system", "enable_safety_system", "forkable", "forkable_with_training_data", "mentor_name", "categories", "types", "subjects", "recently_accessed_at", "created_by", "created_at", "updated_at", "platform_key", "llm_config", "llm_provider"]

    @field_validator('mentor_visibility')
    def mentor_visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['viewable_by_tenant_admins', 'viewable_by_tenant_students', 'viewable_by_anyone', '']):
            raise ValueError("must be one of enum values ('viewable_by_tenant_admins', 'viewable_by_tenant_students', 'viewable_by_anyone', '')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MentorSettingsPublic from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "mentor",
            "mentor_slug",
            "mentor_unique_id",
            "mentor_id",
            "metadata",
            "enable_memory_component",
            "allow_anonymous",
            "mentor_description",
            "suggested_prompts",
            "proactive_response",
            "greeting_method",
            "mentor_tools",
            "can_use_tools",
            "llm_name",
            "proactive_prompt",
            "disclaimer",
            "enable_disclaimer",
            "embed_is_context_aware",
            "embed_open_by_default",
            "embed_show_attachment",
            "embed_show_voice_call",
            "embed_show_voice_record",
            "placeholder_prompt",
            "enable_email_chat",
            "enable_spaced_repetition",
            "enable_instruction_mode",
            "enable_socratic_mode",
            "is_guided_mentor",
            "is_featured",
            "enable_guided_prompts",
            "enable_moderation",
            "enable_multi_query_rag",
            "enable_post_processing_system",
            "enable_safety_system",
            "forkable",
            "forkable_with_training_data",
            "mentor_name",
            "categories",
            "types",
            "subjects",
            "recently_accessed_at",
            "created_by",
            "created_at",
            "updated_at",
            "platform_key",
            "llm_config",
            "llm_provider",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in types (list)
        _items = []
        if self.types:
            for _item_types in self.types:
                if _item_types:
                    _items.append(_item_types.to_dict())
            _dict['types'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subjects (list)
        _items = []
        if self.subjects:
            for _item_subjects in self.subjects:
                if _item_subjects:
                    _items.append(_item_subjects.to_dict())
            _dict['subjects'] = _items
        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['display_name'] = None

        # set to None if profile_image (nullable) is None
        # and model_fields_set contains the field
        if self.profile_image is None and "profile_image" in self.model_fields_set:
            _dict['profile_image'] = None

        # set to None if initial_message (nullable) is None
        # and model_fields_set contains the field
        if self.initial_message is None and "initial_message" in self.model_fields_set:
            _dict['initial_message'] = None

        # set to None if suggested_message (nullable) is None
        # and model_fields_set contains the field
        if self.suggested_message is None and "suggested_message" in self.model_fields_set:
            _dict['suggested_message'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if mentor_visibility (nullable) is None
        # and model_fields_set contains the field
        if self.mentor_visibility is None and "mentor_visibility" in self.model_fields_set:
            _dict['mentor_visibility'] = None

        # set to None if enable_image_generation (nullable) is None
        # and model_fields_set contains the field
        if self.enable_image_generation is None and "enable_image_generation" in self.model_fields_set:
            _dict['enable_image_generation'] = None

        # set to None if enable_web_browsing (nullable) is None
        # and model_fields_set contains the field
        if self.enable_web_browsing is None and "enable_web_browsing" in self.model_fields_set:
            _dict['enable_web_browsing'] = None

        # set to None if enable_code_interpreter (nullable) is None
        # and model_fields_set contains the field
        if self.enable_code_interpreter is None and "enable_code_interpreter" in self.model_fields_set:
            _dict['enable_code_interpreter'] = None

        # set to None if custom_css (nullable) is None
        # and model_fields_set contains the field
        if self.custom_css is None and "custom_css" in self.model_fields_set:
            _dict['custom_css'] = None

        # set to None if suggested_prompts (nullable) is None
        # and model_fields_set contains the field
        if self.suggested_prompts is None and "suggested_prompts" in self.model_fields_set:
            _dict['suggested_prompts'] = None

        # set to None if mentor_tools (nullable) is None
        # and model_fields_set contains the field
        if self.mentor_tools is None and "mentor_tools" in self.model_fields_set:
            _dict['mentor_tools'] = None

        # set to None if llm_config (nullable) is None
        # and model_fields_set contains the field
        if self.llm_config is None and "llm_config" in self.model_fields_set:
            _dict['llm_config'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MentorSettingsPublic from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "display_name": obj.get("display_name"),
            "profile_image": obj.get("profile_image"),
            "initial_message": obj.get("initial_message"),
            "suggested_message": obj.get("suggested_message"),
            "theme": obj.get("theme"),
            "user_message_color": obj.get("user_message_color"),
            "mentor_bubble_color": obj.get("mentor_bubble_color"),
            "align_mentor_bubble": obj.get("align_mentor_bubble"),
            "mentor": obj.get("mentor"),
            "mentor_slug": obj.get("mentor_slug"),
            "mentor_unique_id": obj.get("mentor_unique_id"),
            "mentor_id": obj.get("mentor_id"),
            "metadata": obj.get("metadata"),
            "mentor_visibility": obj.get("mentor_visibility"),
            "enable_image_generation": obj.get("enable_image_generation"),
            "enable_web_browsing": obj.get("enable_web_browsing"),
            "enable_code_interpreter": obj.get("enable_code_interpreter"),
            "enable_memory_component": obj.get("enable_memory_component"),
            "custom_css": obj.get("custom_css"),
            "allow_anonymous": obj.get("allow_anonymous"),
            "mentor_description": obj.get("mentor_description"),
            "suggested_prompts": obj.get("suggested_prompts"),
            "proactive_response": obj.get("proactive_response"),
            "greeting_method": obj.get("greeting_method"),
            "mentor_tools": obj.get("mentor_tools"),
            "can_use_tools": obj.get("can_use_tools"),
            "llm_name": obj.get("llm_name"),
            "proactive_prompt": obj.get("proactive_prompt"),
            "disclaimer": obj.get("disclaimer"),
            "enable_disclaimer": obj.get("enable_disclaimer"),
            "embed_is_context_aware": obj.get("embed_is_context_aware"),
            "embed_open_by_default": obj.get("embed_open_by_default"),
            "embed_show_attachment": obj.get("embed_show_attachment"),
            "embed_show_voice_call": obj.get("embed_show_voice_call"),
            "embed_show_voice_record": obj.get("embed_show_voice_record"),
            "placeholder_prompt": obj.get("placeholder_prompt"),
            "enable_email_chat": obj.get("enable_email_chat"),
            "enable_spaced_repetition": obj.get("enable_spaced_repetition"),
            "enable_instruction_mode": obj.get("enable_instruction_mode"),
            "enable_socratic_mode": obj.get("enable_socratic_mode"),
            "is_guided_mentor": obj.get("is_guided_mentor"),
            "is_featured": obj.get("is_featured"),
            "enable_guided_prompts": obj.get("enable_guided_prompts"),
            "enable_moderation": obj.get("enable_moderation"),
            "enable_multi_query_rag": obj.get("enable_multi_query_rag"),
            "enable_post_processing_system": obj.get("enable_post_processing_system"),
            "enable_safety_system": obj.get("enable_safety_system"),
            "forkable": obj.get("forkable"),
            "forkable_with_training_data": obj.get("forkable_with_training_data"),
            "mentor_name": obj.get("mentor_name"),
            "categories": [MentorCategory.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "types": [MentorType.from_dict(_item) for _item in obj["types"]] if obj.get("types") is not None else None,
            "subjects": [Subject.from_dict(_item) for _item in obj["subjects"]] if obj.get("subjects") is not None else None,
            "recently_accessed_at": obj.get("recently_accessed_at"),
            "created_by": obj.get("created_by"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "platform_key": obj.get("platform_key"),
            "llm_config": obj.get("llm_config"),
            "llm_provider": obj.get("llm_provider")
        })
        return _obj


